/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.ui;

import com.intellij.rml.dfa.impl.DfaOperationsLimitExceededException;
import com.intellij.rml.dfa.impl.providers.RMLInstancesProvider;
import com.intellij.rml.dfa.impl.summaries.DfaBddOperationCountMeasurement;
import com.intellij.rml.dfa.impl.ui.BddOperationCntProvider;
import com.intellij.rml.dfa.impl.ui.ThreadCallback;
import com.intellij.rml.dfa.utils.measurements.DfaMeasurementKind;
import com.intellij.rml.dfa.utils.measurements.DfaSingleMeasurementResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\t\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\nB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u000b\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\fJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/rml/dfa/impl/ui/ThreadCallbackWithOperationsLimitWrapper;", "Lcom/intellij/rml/dfa/impl/ui/ThreadCallback;", "callback", "provider", "Lcom/intellij/rml/dfa/impl/ui/BddOperationCntProvider;", "operationsCountLimit", "", "<init>", "(Lcom/intellij/rml/dfa/impl/ui/ThreadCallback;Lcom/intellij/rml/dfa/impl/ui/BddOperationCntProvider;J)V", "Lcom/intellij/rml/dfa/impl/providers/RMLInstancesProvider;", "(Lcom/intellij/rml/dfa/impl/ui/ThreadCallback;Lcom/intellij/rml/dfa/impl/providers/RMLInstancesProvider;J)V", "Lcom/intellij/rml/dfa/impl/summaries/DfaBddOperationCountMeasurement;", "(Lcom/intellij/rml/dfa/impl/ui/ThreadCallback;Lcom/intellij/rml/dfa/impl/summaries/DfaBddOperationCountMeasurement;J)V", "informProgress", "", "completed", "", "total", "message", "", "checkCancelled", "intellij.rml.dfa.impl"})
public final class ThreadCallbackWithOperationsLimitWrapper
implements ThreadCallback {
    @NotNull
    private final ThreadCallback callback;
    @NotNull
    private final BddOperationCntProvider provider;
    private final long operationsCountLimit;

    private ThreadCallbackWithOperationsLimitWrapper(ThreadCallback callback2, BddOperationCntProvider provider, long operationsCountLimit) {
        this.callback = callback2;
        this.provider = provider;
        this.operationsCountLimit = operationsCountLimit;
    }

    public ThreadCallbackWithOperationsLimitWrapper(@NotNull ThreadCallback callback2, final @NotNull RMLInstancesProvider provider, long operationsCountLimit) {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this(callback2, new BddOperationCntProvider(){

            @Override
            public long getBddOperationsCnt() {
                return provider.getBddOperationsCnt();
            }
        }, operationsCountLimit);
    }

    public ThreadCallbackWithOperationsLimitWrapper(@NotNull ThreadCallback callback2, final @NotNull DfaBddOperationCountMeasurement provider, long operationsCountLimit) {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this(callback2, new BddOperationCntProvider(){

            @Override
            public long getBddOperationsCnt() {
                Object object = (DfaSingleMeasurementResult.Numeric)provider.getMetrics().get(DfaMeasurementKind.BddOperationCount.Companion.getBDD_OP_COUNT());
                return object != null && (object = object.getValue()) != null ? ((Number)object).longValue() : -1L;
            }
        }, operationsCountLimit);
    }

    @Override
    public void informProgress(int completed, int total, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.callback.informProgress(completed, total, message);
    }

    @Override
    public void informProgress(@Nullable String message) {
        this.callback.informProgress(message);
    }

    @Override
    public void checkCancelled() {
        this.callback.checkCancelled();
        if (this.provider.getBddOperationsCnt() >= this.operationsCountLimit) {
            throw new DfaOperationsLimitExceededException(this.provider.getBddOperationsCnt());
        }
    }
}

