/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.utils.graph;

import com.intellij.rml.dfa.impl.utils.graph.GraphAlgorithmsImpl;
import com.intellij.rml.dfa.impl.utils.graph.GraphAlgorithmsImplKt;
import com.intellij.rml.dfa.utils.graph.Graph;
import com.intellij.rml.dfa.utils.graph.GraphAlgorithms;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0017\u0010\u001e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0015\u0010#\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u001c\u0010(\u001a\u00020)2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000+H\u0016J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eH\u0014J\b\u00100\u001a\u000201H\u0004J,\u00105\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\f\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\u0006\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020\u0011H\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\n\u0010\bR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00110\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00110\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\f\u001a\u0004\b\u0018\u0010\u0019R!\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u000e8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\f\u001a\u0004\b!\u0010\u0019R'\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u00168DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\f\u001a\u0004\b%\u0010&R!\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\f\u001a\u0004\b-\u0010\u0019R'\u00102\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\u000e8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u0010\f\u001a\u0004\b3\u0010\u0019\u00a8\u00068"}, d2={"Lcom/intellij/rml/dfa/impl/utils/graph/GraphAlgorithmsImpl;", "T", "Lcom/intellij/rml/dfa/utils/graph/GraphAlgorithms;", "graph", "Lcom/intellij/rml/dfa/utils/graph/Graph;", "<init>", "(Lcom/intellij/rml/dfa/utils/graph/Graph;)V", "getGraph", "()Lcom/intellij/rml/dfa/utils/graph/Graph;", "invertedGraph", "getInvertedGraph", "invertedGraph$delegate", "Lkotlin/Lazy;", "_dfsOrder", "", "_dfsIndex", "", "", "_dfsParent", "_topologicalOrder", "_topologicalIndex", "_backEdges", "Lcom/intellij/util/containers/MultiMap;", "dfsOrder", "getDfsOrder", "()Ljava/util/List;", "dfsOrder$delegate", "dfsIndex", "node", "(Ljava/lang/Object;)I", "getDfsParent", "(Ljava/lang/Object;)Ljava/lang/Object;", "topologicalOrder", "getTopologicalOrder", "topologicalOrder$delegate", "topologicalIndex", "backEdges", "getBackEdges", "()Lcom/intellij/util/containers/MultiMap;", "backEdges$delegate", "isBackEdge", "", "edge", "Lkotlin/Pair;", "startNodes", "getStartNodes", "startNodes$delegate", "findStartNodes", "traverse", "", "stronglyConnectedComponents", "getStronglyConnectedComponents", "stronglyConnectedComponents$delegate", "traverseBfs", "isForward", "maxDist", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nGraphAlgorithmsImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphAlgorithmsImpl.kt\ncom/intellij/rml/dfa/impl/utils/graph/GraphAlgorithmsImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,285:1\n774#2:286\n865#2,2:287\n1863#2,2:289\n1863#2,2:291\n1863#2,2:293\n1053#2:295\n1863#2,2:296\n*S KotlinDebug\n*F\n+ 1 GraphAlgorithmsImpl.kt\ncom/intellij/rml/dfa/impl/utils/graph/GraphAlgorithmsImpl\n*L\n107#1:286\n107#1:287,2\n108#1:289,2\n133#1:291,2\n146#1:293,2\n164#1:295\n103#1:296,2\n*E\n"})
public class GraphAlgorithmsImpl<T>
implements GraphAlgorithms<T> {
    @NotNull
    private final Graph<T> graph;
    @NotNull
    private final Lazy invertedGraph$delegate;
    private List<? extends T> _dfsOrder;
    private Map<T, Integer> _dfsIndex;
    private Map<T, T> _dfsParent;
    private List<? extends T> _topologicalOrder;
    private Map<T, Integer> _topologicalIndex;
    private MultiMap<T, T> _backEdges;
    @NotNull
    private final Lazy dfsOrder$delegate;
    @NotNull
    private final Lazy topologicalOrder$delegate;
    @NotNull
    private final Lazy backEdges$delegate;
    @NotNull
    private final Lazy startNodes$delegate;
    @NotNull
    private final Lazy stronglyConnectedComponents$delegate;

    public GraphAlgorithmsImpl(@NotNull Graph<T> graph2) {
        Intrinsics.checkNotNullParameter(graph2, (String)"graph");
        this.graph = graph2;
        this.invertedGraph$delegate = LazyKt.lazy((Function0)new Function0<Graph<T>>(this){
            final /* synthetic */ GraphAlgorithmsImpl<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Graph<T> invoke() {
                return GraphAlgorithmsImplKt.inverted(this.this$0.getGraph());
            }
        });
        this.dfsOrder$delegate = LazyKt.lazy((Function0)new Function0<List<? extends T>>(this){
            final /* synthetic */ GraphAlgorithmsImpl<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final List<T> invoke() {
                this.this$0.traverse();
                List list = GraphAlgorithmsImpl.access$get_dfsOrder$p(this.this$0);
                if (list == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"_dfsOrder");
                    list = null;
                }
                return list;
            }
        });
        this.topologicalOrder$delegate = LazyKt.lazy((Function0)new Function0<List<? extends T>>(this){
            final /* synthetic */ GraphAlgorithmsImpl<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final List<T> invoke() {
                this.this$0.traverse();
                List list = GraphAlgorithmsImpl.access$get_topologicalOrder$p(this.this$0);
                if (list == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"_topologicalOrder");
                    list = null;
                }
                return list;
            }
        });
        this.backEdges$delegate = LazyKt.lazy((Function0)new Function0<MultiMap<T, T>>(this){
            final /* synthetic */ GraphAlgorithmsImpl<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final MultiMap<T, T> invoke() {
                this.this$0.traverse();
                MultiMap multiMap = GraphAlgorithmsImpl.access$get_backEdges$p(this.this$0);
                if (multiMap == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"_backEdges");
                    multiMap = null;
                }
                return multiMap;
            }
        });
        this.startNodes$delegate = LazyKt.lazy((Function0)new Function0<List<? extends T>>(this){
            final /* synthetic */ GraphAlgorithmsImpl<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final List<T> invoke() {
                return this.this$0.findStartNodes();
            }
        });
        this.stronglyConnectedComponents$delegate = LazyKt.lazy((Function0)new Function0<List<List<? extends T>>>(this){
            final /* synthetic */ GraphAlgorithmsImpl<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final List<List<T>> invoke() {
                List<T> order = this.this$0.getTopologicalOrder();
                Set visited = new LinkedHashSet<E>();
                List scc = new ArrayList<E>();
                for (T v : order) {
                    if (visited.contains(v)) continue;
                    List component = new ArrayList<E>();
                    stronglyConnectedComponents.2.invoke$traverse(visited, this.this$0, v, component);
                    scc.add(component);
                }
                return scc;
            }

            private static final <T> void invoke$traverse(Set<T> visited, GraphAlgorithmsImpl<T> this$0, T v, List<T> component) {
                if (!visited.contains(v)) {
                    visited.add(v);
                    component.add(v);
                    for (E to : this$0.getGraph().incomingNodes(v)) {
                        stronglyConnectedComponents.2.invoke$traverse(visited, this$0, to, component);
                    }
                }
            }
        });
    }

    @NotNull
    public Graph<T> getGraph() {
        return this.graph;
    }

    @NotNull
    public Graph<T> getInvertedGraph() {
        Lazy lazy = this.invertedGraph$delegate;
        return (Graph)lazy.getValue();
    }

    @NotNull
    public List<T> getDfsOrder() {
        Lazy lazy = this.dfsOrder$delegate;
        return (List)lazy.getValue();
    }

    public int dfsIndex(T node) {
        this.traverse();
        Map<T, Integer> map2 = this._dfsIndex;
        if (map2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"_dfsIndex");
            map2 = null;
        }
        Integer n = map2.get(node);
        Intrinsics.checkNotNull((Object)n);
        return ((Number)n).intValue();
    }

    @Nullable
    public T getDfsParent(T node) {
        this.traverse();
        Map<T, T> map2 = this._dfsParent;
        if (map2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"_dfsParent");
            map2 = null;
        }
        return map2.get(node);
    }

    @NotNull
    public List<T> getTopologicalOrder() {
        Lazy lazy = this.topologicalOrder$delegate;
        return (List)lazy.getValue();
    }

    public int topologicalIndex(T node) {
        this.traverse();
        Map<T, Integer> map2 = this._topologicalIndex;
        if (map2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"_topologicalIndex");
            map2 = null;
        }
        Integer n = map2.get(node);
        Intrinsics.checkNotNull((Object)n);
        return ((Number)n).intValue();
    }

    @NotNull
    protected final MultiMap<T, T> getBackEdges() {
        Lazy lazy = this.backEdges$delegate;
        return (MultiMap)lazy.getValue();
    }

    public boolean isBackEdge(@NotNull Pair<? extends T, ? extends T> edge) {
        Intrinsics.checkNotNullParameter(edge, (String)"edge");
        this.traverse();
        MultiMap<T, T> multiMap = this._backEdges;
        if (multiMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"_backEdges");
            multiMap = null;
        }
        return multiMap.get(edge.getSecond()).contains(edge.getFirst());
    }

    @NotNull
    public final List<T> getStartNodes() {
        Lazy lazy = this.startNodes$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<T> findStartNodes() {
        void $this$filterTo$iv$iv;
        Set unprocessed = CollectionsKt.toMutableSet((Iterable)CollectionsKt.toSet((Iterable)this.getGraph().nodes()));
        Iterable $this$filter$iv = this.getGraph().nodes();
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            Object it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!this.getGraph().incomingNodes(it).isEmpty()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List rootNodes = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        Iterable $this$forEach$iv = rootNodes;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            Object element$iv;
            Object it = element$iv = object.next();
            boolean bl = false;
            GraphAlgorithmsImpl.findStartNodes$traverse(unprocessed, this, it);
        }
        while (!((Collection)unprocessed).isEmpty()) {
            Object root = CollectionsKt.first((Iterable)unprocessed);
            ((Collection)rootNodes).add(root);
            GraphAlgorithmsImpl.findStartNodes$traverse(unprocessed, this, root);
        }
        return rootNodes;
    }

    protected final void traverse() {
        if (this._dfsOrder != null) {
            return;
        }
        this._dfsOrder = new ArrayList();
        this._dfsIndex = new LinkedHashMap();
        this._dfsParent = new LinkedHashMap();
        this._topologicalIndex = new LinkedHashMap();
        Map set = new LinkedHashMap();
        Stack<Object> stack = new Stack<Object>();
        int curOrder = this.getGraph().getNodesCnt();
        this._backEdges = new MultiMap();
        Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)this.getStartNodes());
        boolean $i$f$forEach2 = false;
        Map<T, Integer> map2 = $this$forEach$iv.iterator();
        while (map2.hasNext()) {
            Object element$iv;
            Object it = element$iv = map2.next();
            boolean bl = false;
            stack.push(it);
        }
        while (!stack.isEmpty()) {
            Object node = stack.pop();
            Integer $i$f$forEach2 = (Integer)set.get(node);
            if ($i$f$forEach2 == null) {
                List<T> list;
                Map<T, Integer> map3 = this._dfsIndex;
                if (map3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"_dfsIndex");
                    map3 = map2 = null;
                }
                if ((list = this._dfsOrder) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"_dfsOrder");
                    list = null;
                }
                Integer element$iv = list.size();
                map2.put(node, element$iv);
                List<T> list2 = this._dfsOrder;
                if (list2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"_dfsOrder");
                    list2 = null;
                }
                this._dfsOrder = CollectionsKt.plus((Collection)list2, node);
                set.put(node, 0);
                stack.push(node);
                Iterable $this$forEach$iv2 = this.getGraph().get(node);
                boolean $i$f$forEach3 = false;
                Iterator iterator = $this$forEach$iv2.iterator();
                while (iterator.hasNext()) {
                    Object element$iv2;
                    Object it = element$iv2 = iterator.next();
                    boolean bl = false;
                    Integer n = (Integer)set.get(it);
                    if (n == null) {
                        Map<T, T> map4 = this._dfsParent;
                        if (map4 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"_dfsParent");
                            map4 = null;
                        }
                        map4.put(it, node);
                        stack.push(it);
                        continue;
                    }
                    if (n != 0) continue;
                    MultiMap<T, T> multiMap = this._backEdges;
                    if (multiMap == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"_backEdges");
                        multiMap = null;
                    }
                    multiMap.putValue(it, node);
                }
                continue;
            }
            if ($i$f$forEach2 != 0) continue;
            set.put(node, 1);
            Map<T, Integer> map5 = this._topologicalIndex;
            if (map5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"_topologicalIndex");
                map5 = null;
            }
            map2 = map5;
            Integer n = --curOrder;
            map2.put(node, n);
        }
        Iterable $this$sortedBy$iv = this.getGraph().nodes();
        boolean $i$f$sortedBy = false;
        this._topologicalOrder = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(this){
            final /* synthetic */ GraphAlgorithmsImpl this$0;
            {
                this.this$0 = graphAlgorithmsImpl;
            }

            public final int compare(T a, T b) {
                T it = a;
                boolean bl = false;
                Map map2 = GraphAlgorithmsImpl.access$get_topologicalIndex$p(this.this$0);
                if (map2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"_topologicalIndex");
                    map2 = null;
                }
                Comparable comparable = (Integer)map2.get(it);
                it = b;
                Comparable comparable2 = comparable;
                bl = false;
                Map map3 = GraphAlgorithmsImpl.access$get_topologicalIndex$p(this.this$0);
                if (map3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"_topologicalIndex");
                    map3 = null;
                }
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)map3.get(it)));
            }
        });
    }

    @NotNull
    public List<List<T>> getStronglyConnectedComponents() {
        Lazy lazy = this.stronglyConnectedComponents$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public List<T> traverseBfs(@NotNull List<? extends T> startNodes2, boolean isForward, int maxDist) {
        Intrinsics.checkNotNullParameter(startNodes2, (String)"startNodes");
        ArrayDeque<Object> queue = new ArrayDeque<Object>();
        Map distances = new LinkedHashMap();
        List processed = new ArrayList();
        for (T node : startNodes2) {
            distances.put(node, 0);
            queue.add(node);
            ((Collection)processed).add(node);
        }
        while (!((Collection)queue).isEmpty()) {
            Object node = queue.poll();
            Object v = distances.get(node);
            Intrinsics.checkNotNull(v);
            int dist = ((Number)v).intValue();
            for (Object next : isForward ? this.getGraph().outgoingNodes(node) : this.getGraph().incomingNodes(node)) {
                if (distances.containsKey(next)) continue;
                ((Collection)processed).add(next);
                distances.put(next, dist + 1);
                if (maxDist != -1 && dist >= maxDist) continue;
                queue.add(next);
            }
        }
        return processed;
    }

    private static final <T> void findStartNodes$traverse(Set<T> unprocessed, GraphAlgorithmsImpl<T> this$0, T node) {
        if (unprocessed.contains(node)) {
            ((Collection)unprocessed).remove(node);
            Iterable $this$forEach$iv = this$0.getGraph().get(node);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                GraphAlgorithmsImpl.findStartNodes$traverse(unprocessed, this$0, it);
            }
        }
    }

    public static final /* synthetic */ Map access$get_topologicalIndex$p(GraphAlgorithmsImpl $this) {
        return $this._topologicalIndex;
    }

    public static final /* synthetic */ List access$get_dfsOrder$p(GraphAlgorithmsImpl $this) {
        return $this._dfsOrder;
    }

    public static final /* synthetic */ List access$get_topologicalOrder$p(GraphAlgorithmsImpl $this) {
        return $this._topologicalOrder;
    }

    public static final /* synthetic */ MultiMap access$get_backEdges$p(GraphAlgorithmsImpl $this) {
        return $this._backEdges;
    }
}

