/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process.mediator.client.util;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.ClosedReceiveChannelException;
import kotlinx.coroutines.channels.ReceiveChannel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\b\u001a\u00020\tH\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\u0004H\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/execution/process/mediator/client/util/ChannelInputStream;", "Ljava/io/InputStream;", "readChannel", "Lkotlinx/coroutines/channels/ReceiveChannel;", "Lcom/google/protobuf/ByteString;", "<init>", "(Lkotlinx/coroutines/channels/ReceiveChannel;)V", "carryChunk", "read", "", "b", "", "off", "len", "available", "drainChannel", "close", "", "intellij.execution.process.mediator.client"})
@SourceDebugExtension(value={"SMAP\nChannelInputStream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChannelInputStream.kt\ncom/intellij/execution/process/mediator/client/util/ChannelInputStream\n+ 2 Channel.kt\nkotlinx/coroutines/channels/ChannelKt\n*L\n1#1,71:1\n557#2,5:72\n*S KotlinDebug\n*F\n+ 1 ChannelInputStream.kt\ncom/intellij/execution/process/mediator/client/util/ChannelInputStream\n*L\n56#1:72,5\n*E\n"})
public final class ChannelInputStream
extends InputStream {
    @NotNull
    private final ReceiveChannel<ByteString> readChannel;
    @NotNull
    private ByteString carryChunk;

    public ChannelInputStream(@NotNull ReceiveChannel<? extends ByteString> readChannel) {
        Intrinsics.checkNotNullParameter(readChannel, (String)"readChannel");
        this.readChannel = readChannel;
        ByteString byteString = ByteString.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)byteString, (String)"EMPTY");
        this.carryChunk = byteString;
    }

    @Override
    public int read() {
        byte[] byteArray = new byte[1];
        int n = this.read(byteArray);
        return n == 1 ? byteArray[0] & 0xFF : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        ChannelInputStream channelInputStream = this;
        synchronized (channelInputStream) {
            boolean bl = false;
            Objects.checkFromIndexSize(off, len, b.length);
            if (len == 0) {
                return 0;
            }
            if (this.drainChannel().isEmpty()) {
                ByteString byteString;
                ChannelInputStream channelInputStream2 = this;
                try {
                    ChannelInputStream channelInputStream3 = channelInputStream2;
                    byteString = (ByteString)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ByteString>, Object>(this, null){
                        int label;
                        final /* synthetic */ ChannelInputStream this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    Object object3 = ChannelInputStream.access$getReadChannel$p(this.this$0).receive((Continuation)this);
                                    if (object3 != object2) return object3;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return object3;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super ByteString> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)1, null);
                }
                catch (CancellationException cancellationException) {
                    void e;
                    ChannelInputStream channelInputStream4 = channelInputStream2;
                    throw new IOException((Throwable)e);
                }
                catch (ClosedReceiveChannelException e) {
                    ChannelInputStream channelInputStream5 = channelInputStream2;
                    return -1;
                }
                channelInputStream3.carryChunk = byteString;
            }
            ByteString copyChunk = this.carryChunk.size() > len ? this.carryChunk.substring(0, len) : this.carryChunk;
            copyChunk.copyTo(b, off);
            this.carryChunk = this.carryChunk.size() > len ? this.carryChunk.substring(len) : ByteString.EMPTY;
            return copyChunk.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() {
        ChannelInputStream channelInputStream = this;
        synchronized (channelInputStream) {
            boolean bl = false;
            int n = this.drainChannel().size();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final ByteString drainChannel() {
        ByteString chunk = this.carryChunk;
        try {
            while (true) {
                ByteString nextChunk;
                void var3_4;
                Object $this$onClosed_u2dWpGqRn0$iv = this.readChannel.tryReceive-PtdJZtk();
                boolean bl = false;
                if ($this$onClosed_u2dWpGqRn0$iv instanceof ChannelResult.Closed) {
                    Throwable it = ChannelResult.exceptionOrNull-impl((Object)$this$onClosed_u2dWpGqRn0$iv);
                    boolean bl2 = false;
                    if (it instanceof CancellationException) {
                        throw new IOException(it);
                    }
                }
                if ((ByteString)ChannelResult.getOrNull-impl((Object)var3_4) == null) {
                    break;
                }
                chunk = chunk.concat(nextChunk);
            }
        }
        finally {
            this.carryChunk = chunk;
        }
        return chunk;
    }

    @Override
    public void close() {
        ReceiveChannel.DefaultImpls.cancel$default(this.readChannel, null, (int)1, null);
    }

    public static final /* synthetic */ ReceiveChannel access$getReadChannel$p(ChannelInputStream $this) {
        return $this.readChannel;
    }
}

