/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.connectivity.dataSource;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DataSourceManagerUi;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class BasicDataSourceManager<T extends RawDataSource>
extends DataSourceManager<T>
implements DataSourceManagerUi<T> {
    protected final Project myProject;
    private final Set<T> myDataSources;

    protected BasicDataSourceManager(@NotNull Project project, @NotNull List<? extends T> dataSources) {
        if (project == null) {
            BasicDataSourceManager.$$$reportNull$$$0(0);
        }
        if (dataSources == null) {
            BasicDataSourceManager.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myDataSources = Collections.synchronizedSet(new LinkedHashSet<T>(dataSources));
    }

    @Nullable
    public abstract DatabaseDialectEx getDatabaseDialect(@NotNull T var1);

    @Nullable
    public abstract Language getQueryLanguage(@NotNull T var1);

    @Nullable
    public abstract Language getPushedQueryLanguage(@NotNull T var1);

    protected void resetElementMap(@NotNull List<? extends T> sources) {
        if (sources == null) {
            BasicDataSourceManager.$$$reportNull$$$0(2);
        }
        HashSet<T> oldSources = new HashSet<T>(this.myDataSources);
        HashSet<T> newSources = new HashSet<T>(sources);
        for (RawDataSource source : oldSources) {
            if (newSources.contains(source)) continue;
            this.detachDataSource(source);
        }
        for (RawDataSource source : newSources) {
            if (!this.myDataSources.contains(source)) {
                this.attachDataSource(source);
                continue;
            }
            this.updateDataSource(source);
        }
    }

    protected void updateDataSource(T source) {
        ((DataSourceManager.Listener)this.myProject.getMessageBus().syncPublisher(TOPIC)).dataSourceChanged(this, source);
    }

    protected void attachDataSource(@NotNull T source) {
        if (source == null) {
            BasicDataSourceManager.$$$reportNull$$$0(3);
        }
        this.myDataSources.add(source);
        ((DataSourceManager.Listener)this.myProject.getMessageBus().syncPublisher(TOPIC)).dataSourceAdded(this, source);
    }

    protected void detachDataSource(@NotNull T source) {
        if (source == null) {
            BasicDataSourceManager.$$$reportNull$$$0(4);
        }
        if (this.myDataSources.remove(source)) {
            ((DataSourceManager.Listener)this.myProject.getMessageBus().syncPublisher(TOPIC)).dataSourceRemoved(this, source);
        }
    }

    @NotNull
    public Promise<?> getLoadingPromise(@NotNull T source) {
        if (source == null) {
            BasicDataSourceManager.$$$reportNull$$$0(5);
        }
        Promise promise = Promises.resolvedPromise();
        if (promise == null) {
            BasicDataSourceManager.$$$reportNull$$$0(6);
        }
        return promise;
    }

    @Override
    @NotNull
    public List<T> getDataSources() {
        return new ArrayList<T>(this.myDataSources);
    }

    @Override
    public boolean containsDataSource(@NotNull T element) {
        if (element == null) {
            BasicDataSourceManager.$$$reportNull$$$0(7);
        }
        return this.myDataSources.contains(element);
    }

    public boolean canCreateDataSourceByFiles(@NotNull Collection<VirtualFile> files2) {
        if (files2 == null) {
            BasicDataSourceManager.$$$reportNull$$$0(8);
        }
        return false;
    }

    @NotNull
    public List<T> createDataSourceByFiles(@NotNull DatabaseCredentials credentials, @NotNull List<VirtualFile> files2) {
        if (credentials == null) {
            BasicDataSourceManager.$$$reportNull$$$0(9);
        }
        if (files2 == null) {
            BasicDataSourceManager.$$$reportNull$$$0(10);
        }
        List list = Collections.emptyList();
        if (list == null) {
            BasicDataSourceManager.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSources";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/connectivity/dataSource/BasicDataSourceManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/connectivity/dataSource/BasicDataSourceManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadingPromise";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSourceByFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetElementMap";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "attachDataSource";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "detachDataSource";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLoadingPromise";
                break;
            }
            case 6: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "containsDataSource";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canCreateDataSourceByFiles";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceByFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 11 -> new IllegalStateException(string);
        };
    }
}

