/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.JdbcConsoleRunContext;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.FieldSize;
import com.intellij.database.dataSource.url.ParamEditor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.IdeaActionButtonLook;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.ui.components.JBBox;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ParamEditorBase<T extends JComponent>
implements ParamEditor {
    private static final Key<ParamEditorBase<?>> PARAM_EDITOR = Key.create((String)"PARAM_EDITOR");
    private final T myEditorComponent;
    private final JComponent myComponent;
    private final @NlsContexts.Label String myCaption;
    private final FieldSize myFieldSize;
    private final PresentationFactory myPresentationFactory;
    private final DataInterchange myInterchange;
    private Runnable myChangeListener;

    public ParamEditorBase(@NotNull T editorComponent, @NotNull DataInterchange interchange, @NotNull FieldSize fieldSize, @NlsContexts.Label @Nullable String caption, AnAction ... actions) {
        if (editorComponent == null) {
            ParamEditorBase.$$$reportNull$$$0(0);
        }
        if (interchange == null) {
            ParamEditorBase.$$$reportNull$$$0(1);
        }
        if (fieldSize == null) {
            ParamEditorBase.$$$reportNull$$$0(2);
        }
        if (actions == null) {
            ParamEditorBase.$$$reportNull$$$0(3);
        }
        this.myEditorComponent = editorComponent;
        this.myInterchange = interchange;
        this.myFieldSize = fieldSize;
        this.myCaption = caption;
        this.myComponent = this.createComponent(this.myEditorComponent);
        this.myComponent.putClientProperty(PARAM_EDITOR, this);
        this.myPresentationFactory = new PresentationFactory();
        for (AnAction action : actions) {
            this.addButton(action);
        }
    }

    @NotNull
    protected JComponent createComponent(T editorComponent) {
        JBBox component = new JBBox(0);
        component.add((Component)editorComponent);
        JBBox jBBox = component;
        if (jBBox == null) {
            ParamEditorBase.$$$reportNull$$$0(4);
        }
        return jBBox;
    }

    public void dispose() {
    }

    @Override
    @NlsContexts.Label
    @Nullable
    public String getCaption() {
        return this.myCaption;
    }

    @Override
    public FieldSize getFieldSize() {
        return this.myFieldSize;
    }

    @Override
    public void addFocusListener(@NotNull FocusListener listener2) {
        if (listener2 == null) {
            ParamEditorBase.$$$reportNull$$$0(5);
        }
        ((Component)this.getEditorComponent()).addFocusListener(listener2);
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusableComponent() {
        T t = this.getEditorComponent();
        if (t == null) {
            ParamEditorBase.$$$reportNull$$$0(6);
        }
        return t;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            ParamEditorBase.$$$reportNull$$$0(7);
        }
        return jComponent;
    }

    @Override
    public void setChangeListener(@NotNull Runnable callback) {
        if (callback == null) {
            ParamEditorBase.$$$reportNull$$$0(8);
        }
        this.myChangeListener = callback;
    }

    @NotNull
    public T getEditorComponent() {
        T t = this.myEditorComponent;
        if (t == null) {
            ParamEditorBase.$$$reportNull$$$0(9);
        }
        return t;
    }

    protected void fireChanged() {
        if (this.myChangeListener != null) {
            this.myChangeListener.run();
        }
    }

    public ActionButton addButton(@NotNull AnAction action) {
        if (action == null) {
            ParamEditorBase.$$$reportNull$$$0(10);
        }
        ActionButton button = new ActionButton(action, this.myPresentationFactory.getPresentation(action), "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){

            protected DataContext getDataContext() {
                DataContext context = super.getDataContext();
                DataManager.getInstance().saveInDataContext(context, PARAM_EDITOR, (Object)ParamEditorBase.this);
                return context;
            }
        };
        button.setMaximumSize(ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        button.setLook((ActionButtonLook)new IdeaActionButtonLook(){

            public void paintBorder(Graphics g, JComponent component, int state) {
                if (state == 0) {
                    ActionButtonLook.SYSTEM_LOOK.paintBorder(g, component, JBUI.CurrentTheme.ActionButton.hoverBorder());
                } else {
                    super.paintBorder(g, component, state);
                }
            }
        });
        this.myComponent.add((Component)button);
        return button;
    }

    @NotNull
    public DataInterchange getInterchange() {
        DataInterchange dataInterchange = this.myInterchange;
        if (dataInterchange == null) {
            ParamEditorBase.$$$reportNull$$$0(11);
        }
        return dataInterchange;
    }

    protected static Color getBackground(boolean active) {
        return active ? UIUtil.getTextFieldBackground() : UIUtil.getPanelBackground();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorComponent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interchange";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldSize";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/ui/ParamEditorBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/ui/ParamEditorBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusableComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorComponent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterchange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addFocusListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setChangeListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addButton";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7, 9, 11 -> new IllegalStateException(string);
        };
    }

    public static class FMSaveAction
    extends ParamActionBase {
        private final FileSaverDescriptor myDesc;

        public FMSaveAction(@NotNull FileSaverDescriptor desc) {
            if (desc == null) {
                FMSaveAction.$$$reportNull$$$0(0);
            }
            super(DatabaseBundle.message("action.new.text", new Object[0]), DatabaseBundle.message("action.select.file.description", new Object[0]), IconUtil.getAddIcon());
            this.myDesc = desc;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            FileSaverDialog chooser;
            VirtualFileWrapper file;
            String dir;
            ParamEditorBase<?> editor2;
            if (e == null) {
                FMSaveAction.$$$reportNull$$$0(1);
            }
            if ((editor2 = FMSaveAction.getEditor(e)) == null) {
                return;
            }
            VirtualFile curFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)editor2.getText()));
            if (curFile == null && (dir = FMChooseAction.getWorkingDir(editor2)) != null) {
                curFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)(dir + File.separator + editor2.getText())));
            }
            if ((file = (chooser = FileChooserFactory.getInstance().createSaveFileDialog(this.myDesc, (Component)editor2.getComponent())).save(curFile == null ? null : curFile.getParent(), curFile == null ? null : curFile.getName())) != null) {
                editor2.setText(file.getFile().getPath());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "desc";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/url/ui/ParamEditorBase$FMSaveAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class FMChooseAction
    extends ParamActionBase {
        private final FileChooserDescriptor myDesc;

        public FMChooseAction(@NotNull FileChooserDescriptor desc) {
            if (desc == null) {
                FMChooseAction.$$$reportNull$$$0(0);
            }
            super(DatabaseBundle.message("action.open.text", new Object[0]), DatabaseBundle.message("action.select.file.description", new Object[0]), AllIcons.General.Ellipsis);
            this.myDesc = desc;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            VirtualFile file;
            String dir;
            ParamEditorBase<?> editor2;
            if (e == null) {
                FMChooseAction.$$$reportNull$$$0(1);
            }
            if ((editor2 = FMChooseAction.getEditor(e)) == null) {
                return;
            }
            VirtualFile curFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)editor2.getText()));
            if (curFile == null && (dir = FMChooseAction.getWorkingDir(editor2)) != null) {
                curFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)(dir + File.separator + editor2.getText())));
            }
            if ((file = FileChooser.chooseFile((FileChooserDescriptor)this.myDesc, (Component)editor2.getComponent(), null, (VirtualFile)curFile)) != null) {
                this.setFile(editor2, file);
            }
        }

        @Nullable
        public static String getWorkingDir(ParamEditorBase<?> editor2) {
            LocalDataSource ds = editor2.getInterchange().getDataSource();
            String dir = ds.getWorkingDir();
            Project project = editor2.getInterchange().getProject();
            if ("".equals(dir)) {
                dir = ds.isGlobal() ? null : project.getBasePath();
            }
            return JdbcConsoleRunContext.expand(project, dir);
        }

        protected void setFile(@NotNull ParamEditorBase<?> editor2, @NotNull VirtualFile file) {
            if (editor2 == null) {
                FMChooseAction.$$$reportNull$$$0(2);
            }
            if (file == null) {
                FMChooseAction.$$$reportNull$$$0(3);
            }
            editor2.setText(file.getPath());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "desc";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/url/ui/ParamEditorBase$FMChooseAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class ParamActionBase
    extends DumbAwareAction {
        public ParamActionBase(@NlsActions.ActionText String name2, @NlsActions.ActionDescription String tip, Icon icon) {
            super(name2, tip, icon);
        }

        @Nullable
        static ParamEditorBase<?> getEditor(AnActionEvent e) {
            return (ParamEditorBase)DataManager.getInstance().loadFromDataContext(e.getDataContext(), PARAM_EDITOR);
        }
    }
}

