/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle;

import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.base.SqlLanguageDialectBase;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.oracle.OraDialect;
import com.intellij.sql.dialects.oracle._OraLexer;
import com.intellij.sql.psi.SqlTokens;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraLexer
extends SqlLexer {
    public OraLexer() {
        super(OraDialect.INSTANCE, (FlexLexer)new _OraLexer());
    }

    protected OraLexer(SqlLanguageDialectBase dialect, FlexLexer flexLexer) {
        super(dialect, flexLexer);
    }

    @Override
    protected void lookAhead(@NotNull Lexer baseLexer) {
        if (baseLexer == null) {
            OraLexer.$$$reportNull$$$0(0);
        }
        if (!this.lookAheadRangeOperator(baseLexer) && !this.lookAheadCustomQuotation(baseLexer)) {
            super.lookAhead(baseLexer);
        }
    }

    @Override
    protected boolean lookAheadCustomQuotation(Lexer baseLexer) {
        String ident = OraLexer.getCustomEndingQuote(baseLexer);
        if (ident == null) {
            return false;
        }
        int identLen = ident.length();
        int stringStart = baseLexer.getTokenStart() + identLen + baseLexer.getTokenText().indexOf("'");
        return this.processCustomQuotation(baseLexer, ident, stringStart);
    }

    @Nullable
    private static String getCustomEndingQuote(Lexer baseLexer) {
        char prefix;
        IElementType type = baseLexer.getTokenType();
        if (type != SqlTokens.SQL_STRING_TOKEN && type != SqlTokens.BAD_CHARACTER && type != SqlTokens.SQL_UNCLOSED_TOKEN) {
            return null;
        }
        String text2 = baseLexer.getTokenText();
        int index = text2.indexOf(39);
        if (index + 1 >= text2.length()) {
            return null;
        }
        char c2 = prefix = index > 0 ? text2.charAt(index - 1) : (char)'\u0000';
        if (prefix != 'Q' && prefix != 'q') {
            return null;
        }
        char delimiter = text2.charAt(index + 1);
        if (delimiter == '(') {
            return ")'";
        }
        if (delimiter == '<') {
            return ">'";
        }
        if (delimiter == '{') {
            return "}'";
        }
        if (delimiter == '[') {
            return "]'";
        }
        return delimiter + "'";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseLexer", "com/intellij/sql/dialects/oracle/OraLexer", "lookAhead"));
    }
}

