/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlCallStatement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import com.intellij.sql.psi.stubs.SqlCallStatementElementStub;
import com.intellij.sql.psi.stubs.SqlNamedStubElementType;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SqlCallStatementStubElementType
extends SqlNamedStubElementType<SqlCallStatementElementStub, SqlCallStatement> {
    public static final NotNullFunction<String, SqlCallStatementStubElementType> FACTORY = name2 -> new SqlCallStatementStubElementType((String)name2);

    public SqlCallStatementStubElementType(@NonNls @NotNull String debugName) {
        if (debugName == null) {
            SqlCallStatementStubElementType.$$$reportNull$$$0(0);
        }
        super(debugName, SqlCompositeElementTypes.SQL_ANY_CALLABLE_REFERENCE);
    }

    @NotNull
    public SqlCallStatementElementStub createStub(@NotNull SqlCallStatement psi, StubElement parentStub) {
        if (psi == null) {
            SqlCallStatementStubElementType.$$$reportNull$$$0(1);
        }
        return new SqlCallStatementElementStub(parentStub, this, SqlCallStatementStubElementType.asStringRef((PsiElement)psi.getCallableReference()), ContainerUtil.map((Collection)psi.getArguments(), PsiElement::getText));
    }

    @Override
    public void serialize(@NotNull SqlCallStatementElementStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            SqlCallStatementStubElementType.$$$reportNull$$$0(2);
        }
        if (dataStream == null) {
            SqlCallStatementStubElementType.$$$reportNull$$$0(3);
        }
        super.serialize(stub, dataStream);
        IOUtil.writeStringList((DataOutput)dataStream, stub.getArguments());
    }

    @NotNull
    public SqlCallStatementElementStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            SqlCallStatementStubElementType.$$$reportNull$$$0(4);
        }
        return new SqlCallStatementElementStub(parentStub, this, dataStream.readName(), IOUtil.readStringList((DataInput)dataStream));
    }

    @Override
    public boolean shouldCreateStub(ASTNode node) {
        ASTNode it;
        FileASTNode file = TreeUtil.getFileElement((ASTNode)node);
        ASTNode call = node.findChildByType((IElementType)SqlCompositeElementTypes.SQL_FUNCTION_CALL);
        ASTNode callable = null;
        ASTNode aSTNode = it = call == null ? null : call.getFirstChildNode();
        while (it != null) {
            if (it.getElementType() instanceof SqlReferenceElementType) {
                callable = it;
                break;
            }
            it = it.getTreeNext();
        }
        if (callable == null) {
            return false;
        }
        ASTNode identifier = TreeUtil.findLastLeaf(callable);
        if (identifier == null) {
            return false;
        }
        String name2 = SqlStringTokenElement.getTokenText(identifier);
        SqlLanguageDialect dialect = file == null ? null : (SqlLanguageDialect)ObjectUtils.tryCast((Object)file.getElementType().getLanguage(), SqlLanguageDialect.class);
        return dialect != null && dialect.shouldStubCall(name2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/psi/stubs/SqlCallStatementStubElementType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createStub";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

