/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.go.linter.handler;

import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoElseStatement;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoIfStatement;
import com.goide.psi.GoIncDecStatement;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoPackageClause;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoResult;
import com.goide.psi.GoSignature;
import com.goide.psi.GoStatement;
import com.goide.quickfix.GoRenameToQuickFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.LocalQuickFixOnPsiElementAsIntentionAdapter;
import com.intellij.go.linter.handler.ProblemHandler;
import com.intellij.go.linter.model.LintIssue;
import com.intellij.go.linter.quickfix.GoOutdentElseFix;
import com.intellij.go.linter.quickfix.GoRenamePackageFix;
import com.intellij.go.linter.quickfix.GoReorderFuncParamFix;
import com.intellij.go.linter.quickfix.GoReorderFuncReturnFix;
import com.intellij.go.linter.quickfix.GoReplaceElementFix;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016JD\u0010\u0013\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0004R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/go/linter/handler/GolintHandler;", "Lcom/intellij/go/linter/handler/ProblemHandler;", "<init>", "()V", "doSuggestFix", "Lkotlin/Pair;", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/openapi/util/TextRange;", "file", "Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "issue", "Lcom/intellij/go/linter/model/LintIssue;", "overrideLine", "", "replaceRegex", "Lkotlin/text/Regex;", "suggestFix", "text", "", "intellij.go.linter"})
@SourceDebugExtension(value={"SMAP\nGolintHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GolintHandler.kt\ncom/intellij/go/linter/handler/GolintHandler\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 ProblemHandler.kt\ncom/intellij/go/linter/handler/ProblemHandler\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n434#2:107\n507#2,5:108\n32#3,7:113\n32#3,7:120\n32#3,7:127\n32#3,7:134\n32#3,5:141\n37#3,2:156\n32#3,7:158\n32#3,7:165\n32#3,7:172\n32#3,7:179\n32#3,7:186\n1368#4:146\n1454#4,2:147\n1557#4:149\n1628#4,3:150\n1456#4,3:153\n*S KotlinDebug\n*F\n+ 1 GolintHandler.kt\ncom/intellij/go/linter/handler/GolintHandler\n*L\n16#1:107\n16#1:108,5\n23#1:113,7\n27#1:120,7\n31#1:127,7\n35#1:134,7\n39#1:141,5\n39#1:156,2\n50#1:158,7\n57#1:165,7\n63#1:172,7\n87#1:179,7\n97#1:186,7\n43#1:146\n43#1:147,2\n43#1:149\n43#1:150,3\n43#1:153,3\n*E\n"})
public class GolintHandler
extends ProblemHandler {
    @NotNull
    private final Regex replaceRegex = new Regex("`?([\\w\\d_]+)`? should be `?([\\w\\d_]+)`?");

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Pair<IntentionAction[], TextRange> doSuggestFix(@NotNull PsiFile file, @NotNull Document document, @NotNull LintIssue issue, int overrideLine) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Object object = new char[]{'\"'};
        object = StringsKt.trim((String)issue.getText(), (char[])object);
        GolintHandler golintHandler = this;
        boolean $i$f$filter = false;
        CharSequence charSequence = (CharSequence)$this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!(it != '`')) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        return golintHandler.suggestFix(((StringBuilder)destination$iv$iv).toString(), file, document, issue, overrideLine);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    protected final Pair<IntentionAction[], TextRange> suggestFix(@NotNull String text, @NotNull PsiFile file, @NotNull Document document, @NotNull LintIssue issue, int overrideLine) {
        Pair pair;
        MatchResult match;
        block50: {
            block49: {
                block48: {
                    block47: {
                        block46: {
                            void $this$flatMapTo$iv$iv;
                            block45: {
                                block44: {
                                    block43: {
                                        block42: {
                                            block41: {
                                                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                                                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                                                Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                                                Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
                                                if (Intrinsics.areEqual((Object)text, (Object)"if block ends with a return statement, so drop this else and outdent its block")) break block41;
                                                if (Intrinsics.areEqual((Object)text, (Object)"if block ends with a return statement, so drop this else and outdent its block (move short variable declaration to its own line if necessary)")) break block42;
                                                if (Intrinsics.areEqual((Object)text, (Object)"error should be the last type when returning multiple items")) break block43;
                                                if (Intrinsics.areEqual((Object)text, (Object)"context.Context should be the first parameter of a function")) break block44;
                                                if (Intrinsics.areEqual((Object)text, (Object)"don't use ALL_CAPS in Go names; use CamelCase") || StringsKt.startsWith$default((String)text, (String)"don't use underscores in Go names;", (boolean)false, (int)2, null)) break block45;
                                                if (StringsKt.startsWith$default((String)text, (String)"type name will be used as ", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)text, (String)"func name will be used as ", (boolean)false, (int)2, null)) break block46;
                                                if (StringsKt.startsWith$default((String)text, (String)"don't use MixedCaps in package name", (boolean)false, (int)2, null)) break block47;
                                                if (StringsKt.startsWith$default((String)text, (String)"should replace", (boolean)false, (int)2, null)) break block48;
                                                if (StringsKt.startsWith$default((String)text, (String)"receiver name ", (boolean)false, (int)2, null)) break block49;
                                                match = Regex.find$default((Regex)this.replaceRegex, (CharSequence)text, (int)0, (int)2, null);
                                                if (match == null) {
                                                    pair = ProblemHandler.Companion.getNonAvailableFix();
                                                    return pair;
                                                }
                                                break block50;
                                            }
                                            ProblemHandler this_$iv = this;
                                            boolean $i$f$chainFindAndHandle = false;
                                            PsiElement element$iv = file.findElementAt(ProblemHandler.access$calcPos(this_$iv, document, issue, overrideLine));
                                            while (true) {
                                                PsiElement psiElement;
                                                if ((psiElement = element$iv) instanceof GoElseStatement) {
                                                    GoElseStatement element = (GoElseStatement)element$iv;
                                                    boolean bl = false;
                                                    IntentionAction[] intentionActionArray = new IntentionAction[]{new GoOutdentElseFix((GoStatement)element)};
                                                    pair = TuplesKt.to((Object)intentionActionArray, (Object)element.getElse().getTextRange());
                                                    return pair;
                                                }
                                                if (psiElement instanceof GoFile || psiElement == null) {
                                                    pair = ProblemHandler.Companion.getNonAvailableFix();
                                                    return pair;
                                                }
                                                element$iv = element$iv.getParent();
                                            }
                                        }
                                        ProblemHandler this_$iv = this;
                                        boolean $i$f$chainFindAndHandle = false;
                                        PsiElement element$iv = file.findElementAt(ProblemHandler.access$calcPos(this_$iv, document, issue, overrideLine));
                                        while (true) {
                                            PsiElement psiElement;
                                            if ((psiElement = element$iv) instanceof GoIfStatement) {
                                                GoIfStatement element = (GoIfStatement)element$iv;
                                                boolean bl = false;
                                                IntentionAction[] intentionActionArray = new IntentionAction[]{new GoOutdentElseFix((GoStatement)element)};
                                                pair = TuplesKt.to((Object)intentionActionArray, (Object)element.getIf().getTextRange());
                                                return pair;
                                            }
                                            if (psiElement instanceof GoFile || psiElement == null) {
                                                pair = ProblemHandler.Companion.getNonAvailableFix();
                                                return pair;
                                            }
                                            element$iv = element$iv.getParent();
                                        }
                                    }
                                    ProblemHandler this_$iv = this;
                                    boolean $i$f$chainFindAndHandle = false;
                                    PsiElement element$iv = file.findElementAt(ProblemHandler.access$calcPos(this_$iv, document, issue, overrideLine));
                                    while (true) {
                                        PsiElement psiElement;
                                        if ((psiElement = element$iv) instanceof GoFunctionOrMethodDeclaration) {
                                            GoFunctionOrMethodDeclaration element = (GoFunctionOrMethodDeclaration)element$iv;
                                            boolean bl = false;
                                            IntentionAction[] intentionActionArray = new IntentionAction[]{new GoReorderFuncReturnFix(element)};
                                            GoSignature goSignature = element.getSignature();
                                            Intrinsics.checkNotNull((Object)goSignature);
                                            GoResult goResult = goSignature.getResult();
                                            Intrinsics.checkNotNull((Object)goResult);
                                            pair = TuplesKt.to((Object)intentionActionArray, (Object)goResult.getTextRange());
                                            return pair;
                                        }
                                        if (psiElement instanceof GoFile || psiElement == null) {
                                            pair = ProblemHandler.Companion.getNonAvailableFix();
                                            return pair;
                                        }
                                        element$iv = element$iv.getParent();
                                    }
                                }
                                ProblemHandler this_$iv = this;
                                boolean $i$f$chainFindAndHandle = false;
                                PsiElement element$iv = file.findElementAt(ProblemHandler.access$calcPos(this_$iv, document, issue, overrideLine));
                                while (true) {
                                    PsiElement psiElement;
                                    if ((psiElement = element$iv) instanceof GoFunctionOrMethodDeclaration) {
                                        GoFunctionOrMethodDeclaration element = (GoFunctionOrMethodDeclaration)element$iv;
                                        boolean bl = false;
                                        IntentionAction[] intentionActionArray = new IntentionAction[]{new GoReorderFuncParamFix(element)};
                                        GoSignature goSignature = element.getSignature();
                                        Intrinsics.checkNotNull((Object)goSignature);
                                        pair = TuplesKt.to((Object)intentionActionArray, (Object)goSignature.getParameters().getTextRange());
                                        return pair;
                                    }
                                    if (psiElement instanceof GoFile || psiElement == null) {
                                        pair = ProblemHandler.Companion.getNonAvailableFix();
                                        return pair;
                                    }
                                    element$iv = element$iv.getParent();
                                }
                            }
                            ProblemHandler this_$iv = this;
                            boolean $i$f$chainFindAndHandle = false;
                            PsiElement element$iv = file.findElementAt(ProblemHandler.access$calcPos(this_$iv, document, issue, overrideLine));
                            while (true) {
                                PsiElement psiElement;
                                if ((psiElement = element$iv) instanceof GoNamedElement) break;
                                if (psiElement instanceof GoFile || psiElement == null) {
                                    pair = ProblemHandler.Companion.getNonAvailableFix();
                                    return pair;
                                }
                                element$iv = element$iv.getParent();
                            }
                            GoNamedElement element = (GoNamedElement)element$iv;
                            boolean bl = false;
                            PsiElement psiElement = element.getIdentifier();
                            Intrinsics.checkNotNull((Object)psiElement);
                            String string = psiElement.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                            char[] cArray = new char[]{'_'};
                            Iterable iterable = StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                            boolean $i$f$flatMap = false;
                            Iterable iterable2 = iterable;
                            Collection destination$iv$iv = new ArrayList();
                            boolean $i$f$flatMapTo = false;
                            Iterator iterator = $this$flatMapTo$iv$iv.iterator();
                            while (true) {
                                void $this$mapTo$iv$iv;
                                if (!iterator.hasNext()) {
                                    String replace = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
                                    IntentionAction[] intentionActionArray = new IntentionAction[]{new LocalQuickFixOnPsiElementAsIntentionAdapter((LocalQuickFixOnPsiElement)new GoRenameToQuickFix(element, replace))};
                                    PsiElement psiElement2 = element.getIdentifier();
                                    Intrinsics.checkNotNull((Object)psiElement2);
                                    pair = TuplesKt.to((Object)intentionActionArray, (Object)psiElement2.getTextRange());
                                    return pair;
                                }
                                Object element$iv$iv = iterator.next();
                                String it = (String)element$iv$iv;
                                boolean bl2 = false;
                                Iterable $this$map$iv = StringsKt.withIndex((CharSequence)it);
                                boolean $i$f$map = false;
                                Iterable iterable3 = $this$map$iv;
                                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                    void iv;
                                    IndexedValue indexedValue = (IndexedValue)item$iv$iv;
                                    Collection collection = destination$iv$iv2;
                                    boolean bl3 = false;
                                    collection.add(Character.valueOf(iv.getIndex() == 0 ? ((Character)iv.getValue()).charValue() : Character.toLowerCase(((Character)iv.getValue()).charValue())));
                                }
                                Iterable list$iv$iv = (List)destination$iv$iv2;
                                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                            }
                        }
                        String string = text.substring(StringsKt.lastIndexOf$default((CharSequence)text, (char)' ', (int)0, (boolean)false, (int)6, null) + 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        String newName = string;
                        ProblemHandler this_$iv = this;
                        boolean $i$f$chainFindAndHandle = false;
                        PsiElement element$iv2 = file.findElementAt(ProblemHandler.access$calcPos(this_$iv, document, issue, overrideLine));
                        while (true) {
                            PsiElement element;
                            if ((element = element$iv2) instanceof GoNamedElement) {
                                GoNamedElement element2 = (GoNamedElement)element$iv2;
                                boolean bl = false;
                                PsiElement psiElement = element2.getIdentifier();
                                Intrinsics.checkNotNull((Object)psiElement);
                                String string2 = psiElement.getText();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                                String string3 = element2.getContainingFile().getPackageName();
                                if (string3 == null) {
                                    string3 = "";
                                }
                                if (StringsKt.startsWith((String)string2, (String)string3, (boolean)true)) {
                                    IntentionAction[] intentionActionArray = new IntentionAction[]{new LocalQuickFixOnPsiElementAsIntentionAdapter((LocalQuickFixOnPsiElement)new GoRenameToQuickFix(element2, newName))};
                                    PsiElement psiElement3 = element2.getIdentifier();
                                    Intrinsics.checkNotNull((Object)psiElement3);
                                    pair = TuplesKt.to((Object)intentionActionArray, (Object)psiElement3.getTextRange());
                                    return pair;
                                }
                                pair = ProblemHandler.Companion.getNonAvailableFix();
                                return pair;
                            }
                            if (element instanceof GoFile || element == null) {
                                pair = ProblemHandler.Companion.getNonAvailableFix();
                                return pair;
                            }
                            element$iv2 = element$iv2.getParent();
                        }
                    }
                    ProblemHandler this_$iv = this;
                    boolean $i$f$chainFindAndHandle = false;
                    PsiElement element$iv = file.findElementAt(ProblemHandler.access$calcPos(this_$iv, document, issue, overrideLine));
                    while (true) {
                        PsiElement element$iv2;
                        if ((element$iv2 = element$iv) instanceof GoPackageClause) {
                            GoPackageClause element = (GoPackageClause)element$iv;
                            boolean bl = false;
                            IntentionAction[] intentionActionArray = new IntentionAction[1];
                            PsiElement psiElement = element.getIdentifier();
                            Intrinsics.checkNotNull((Object)psiElement);
                            String string = psiElement.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                            String string4 = string;
                            Locale locale = Locale.getDefault();
                            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                            String string5 = string4.toLowerCase(locale);
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                            intentionActionArray[0] = new GoRenamePackageFix(element, string5);
                            PsiElement psiElement4 = element.getIdentifier();
                            Intrinsics.checkNotNull((Object)psiElement4);
                            pair = TuplesKt.to((Object)intentionActionArray, (Object)psiElement4.getTextRange());
                            return pair;
                        }
                        if (element$iv2 instanceof GoFile || element$iv2 == null) {
                            pair = ProblemHandler.Companion.getNonAvailableFix();
                            return pair;
                        }
                        element$iv = element$iv.getParent();
                    }
                }
                ProblemHandler this_$iv = this;
                boolean $i$f$chainFindAndHandle = false;
                PsiElement element$iv = file.findElementAt(ProblemHandler.access$calcPos(this_$iv, document, issue, overrideLine));
                while (true) {
                    PsiElement element$iv2;
                    if ((element$iv2 = element$iv) instanceof GoAssignmentStatement) {
                        GoAssignmentStatement element = (GoAssignmentStatement)element$iv;
                        boolean bl = false;
                        MatchResult matchResult = new Regex("should replace (.+) with (.+)").matchEntire((CharSequence)text);
                        if (matchResult != null) {
                            List list = matchResult.getGroupValues();
                            String pre = (String)list.get(1);
                            String replace = (String)list.get(2);
                            if (Intrinsics.areEqual((Object)pre, (Object)element.getText())) {
                                String it = replace;
                                boolean bl4 = false;
                                if (!StringsKt.endsWith$default((String)it, (String)"++", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)it, (String)"--", (boolean)false, (int)2, null)) {
                                    IntentionAction[] intentionActionArray = new IntentionAction[]{new GoReplaceElementFix<GoAssignmentStatement>(it, (PsiElement)element, GoAssignmentStatement.class)};
                                    pair = TuplesKt.to((Object)intentionActionArray, (Object)element.getTextRange());
                                    return pair;
                                }
                                IntentionAction[] intentionActionArray = new IntentionAction[]{new GoReplaceElementFix<GoIncDecStatement>(it, (PsiElement)element, GoIncDecStatement.class)};
                                pair = TuplesKt.to((Object)intentionActionArray, (Object)element.getTextRange());
                                return pair;
                            }
                        }
                        pair = ProblemHandler.Companion.getNonAvailableFix();
                        return pair;
                    }
                    if (element$iv2 instanceof GoFile || element$iv2 == null) {
                        pair = ProblemHandler.Companion.getNonAvailableFix();
                        return pair;
                    }
                    element$iv = element$iv.getParent();
                }
            }
            String searchPattern = "receiver name ";
            int begin = StringsKt.indexOf$default((CharSequence)text, (String)searchPattern, (int)0, (boolean)false, (int)6, null) + searchPattern.length();
            String string = text.substring(begin, StringsKt.indexOf$default((CharSequence)text, (char)' ', (int)begin, (boolean)false, (int)4, null));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String curName = string;
            begin = StringsKt.indexOf$default((CharSequence)text, (String)searchPattern, (int)(begin + 1), (boolean)false, (int)4, null) + searchPattern.length();
            String string6 = text.substring(begin, StringsKt.indexOf$default((CharSequence)text, (char)' ', (int)begin, (boolean)false, (int)4, null));
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            String newName = string6;
            ProblemHandler this_$iv = this;
            boolean $i$f$chainFindAndHandle = false;
            PsiElement psiElement = file.findElementAt(ProblemHandler.access$calcPos(this_$iv, document, issue, overrideLine));
            while (true) {
                void var12_77;
                void var13_84;
                if ((var13_84 = var12_77) instanceof GoMethodDeclaration) {
                    GoMethodDeclaration element = (GoMethodDeclaration)var12_77;
                    boolean bl = false;
                    GoReceiver receiver = element.getReceiver();
                    if (receiver != null) {
                        PsiElement psiElement5 = receiver.getIdentifier();
                        Intrinsics.checkNotNull((Object)psiElement5);
                        if (Intrinsics.areEqual((Object)psiElement5.getText(), (Object)curName)) {
                            IntentionAction[] intentionActionArray = new IntentionAction[]{new LocalQuickFixOnPsiElementAsIntentionAdapter((LocalQuickFixOnPsiElement)new GoRenameToQuickFix((GoNamedElement)receiver, newName))};
                            PsiElement psiElement6 = receiver.getIdentifier();
                            pair = TuplesKt.to((Object)intentionActionArray, (Object)(psiElement6 != null ? psiElement6.getTextRange() : null));
                            return pair;
                        }
                    }
                    pair = ProblemHandler.Companion.getNonAvailableFix();
                    return pair;
                }
                if (var13_84 instanceof GoFile || var13_84 == null) {
                    pair = ProblemHandler.Companion.getNonAvailableFix();
                    return pair;
                }
                PsiElement psiElement7 = var12_77.getParent();
            }
        }
        ProblemHandler this_$iv = this;
        boolean $i$f$chainFindAndHandle = false;
        PsiElement element$iv = file.findElementAt(ProblemHandler.access$calcPos(this_$iv, document, issue, overrideLine));
        while (true) {
            PsiElement psiElement;
            if ((psiElement = element$iv) instanceof GoNamedElement) {
                GoNamedElement element = (GoNamedElement)element$iv;
                boolean bl = false;
                PsiElement psiElement8 = element.getIdentifier();
                String string = psiElement8 != null ? psiElement8.getText() : null;
                MatchGroup matchGroup = match.getGroups().get(1);
                Intrinsics.checkNotNull((Object)matchGroup);
                if (!Intrinsics.areEqual((Object)string, (Object)matchGroup.getValue())) {
                    pair = ProblemHandler.Companion.getNonAvailableFix();
                    return pair;
                }
                IntentionAction[] intentionActionArray = new IntentionAction[1];
                MatchGroup matchGroup2 = match.getGroups().get(2);
                Intrinsics.checkNotNull((Object)matchGroup2);
                intentionActionArray[0] = new LocalQuickFixOnPsiElementAsIntentionAdapter((LocalQuickFixOnPsiElement)new GoRenameToQuickFix(element, matchGroup2.getValue()));
                PsiElement psiElement9 = element.getIdentifier();
                pair = TuplesKt.to((Object)intentionActionArray, (Object)(psiElement9 != null ? psiElement9.getTextRange() : null));
                return pair;
            }
            if (psiElement instanceof GoFile || psiElement == null) {
                pair = ProblemHandler.Companion.getNonAvailableFix();
                return pair;
            }
            element$iv = element$iv.getParent();
        }
    }
}

