/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.go.linter.handler;

import com.goide.inspections.GoInspectionUtil;
import com.goide.psi.GoConstDefinition;
import com.goide.psi.GoFieldDeclaration;
import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.quickfix.GoDeleteRangeQuickFix;
import com.goide.quickfix.GoRenameToBlankQuickFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.LocalQuickFixOnPsiElementAsIntentionAdapter;
import com.intellij.go.linter.GoLinterBundle;
import com.intellij.go.linter.handler.ProblemHandler;
import com.intellij.go.linter.model.LintIssue;
import com.intellij.go.linter.quickfix.GoDeleteConstDefinitionFix;
import com.intellij.go.linter.quickfix.GoDeleteElementFix;
import com.intellij.go.linter.quickfix.GoDeleteVarDefinitionFix;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/go/linter/handler/NamedElementHandler;", "Lcom/intellij/go/linter/handler/ProblemHandler;", "<init>", "()V", "doSuggestFix", "Lkotlin/Pair;", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/openapi/util/TextRange;", "file", "Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "issue", "Lcom/intellij/go/linter/model/LintIssue;", "overrideLine", "", "intellij.go.linter"})
@SourceDebugExtension(value={"SMAP\nNamedElementHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamedElementHandler.kt\ncom/intellij/go/linter/handler/NamedElementHandler\n+ 2 ProblemHandler.kt\ncom/intellij/go/linter/handler/ProblemHandler\n*L\n1#1,53:1\n32#2,7:54\n*S KotlinDebug\n*F\n+ 1 NamedElementHandler.kt\ncom/intellij/go/linter/handler/NamedElementHandler\n*L\n22#1:54,7\n*E\n"})
public final class NamedElementHandler
extends ProblemHandler {
    @NotNull
    public static final NamedElementHandler INSTANCE = new NamedElementHandler();

    private NamedElementHandler() {
    }

    @Override
    @NotNull
    public Pair<IntentionAction[], TextRange> doSuggestFix(@NotNull PsiFile file, @NotNull Document document, @NotNull LintIssue issue, int overrideLine) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        ProblemHandler this_$iv = this;
        boolean $i$f$chainFindAndHandle = false;
        PsiElement element$iv = file.findElementAt(ProblemHandler.access$calcPos(this_$iv, document, issue, overrideLine));
        while (true) {
            PsiElement psiElement;
            if ((psiElement = element$iv) instanceof GoNamedElement) {
                IntentionAction[] intentionActionArray;
                GoNamedElement element = (GoNamedElement)element$iv;
                boolean bl = false;
                GoNamedElement goNamedElement = element;
                if (goNamedElement instanceof GoFieldDefinition) {
                    PsiElement decl = ((GoFieldDefinition)element).getParent();
                    if (decl instanceof GoFieldDeclaration) {
                        PsiElement start = decl;
                        while (!(start.getPrevSibling() == null || start.getPrevSibling() instanceof PsiWhiteSpaceImpl && Intrinsics.areEqual((Object)start.getPrevSibling().getText(), (Object)"\n"))) {
                            start = start.getPrevSibling();
                        }
                        PsiElement psiElement2 = ((GoFieldDeclaration)decl).getNextSibling();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getNextSibling(...)");
                        PsiElement end = psiElement2;
                        while (!(end instanceof PsiWhiteSpaceImpl) || !Intrinsics.areEqual((Object)((PsiWhiteSpaceImpl)end).getText(), (Object)"\n")) {
                            end = end.getNextSibling();
                        }
                        IntentionAction[] intentionActionArray2 = new IntentionAction[1];
                        Object[] objectArray = new Object[]{((GoFieldDefinition)element).getIdentifier().getText()};
                        intentionActionArray2[0] = new GoDeleteRangeQuickFix(start, end, GoLinterBundle.message("intention.name.delete.field", objectArray));
                        intentionActionArray = intentionActionArray2;
                    } else {
                        intentionActionArray = new IntentionAction[]{};
                    }
                } else if (goNamedElement instanceof GoFunctionDeclaration) {
                    IntentionAction[] intentionActionArray3 = new IntentionAction[]{new GoDeleteElementFix((PsiElement)element, GoLinterBundle.message("intention.name.delete.function", new Object[0])), new LocalQuickFixOnPsiElementAsIntentionAdapter((LocalQuickFixOnPsiElement)new GoRenameToBlankQuickFix(element))};
                    intentionActionArray = intentionActionArray3;
                } else if (goNamedElement instanceof GoTypeSpec) {
                    IntentionAction[] intentionActionArray4 = new IntentionAction[]{new GoDeleteElementFix((PsiElement)element, GoLinterBundle.message("intention.name.delete.type", new Object[0]))};
                    intentionActionArray = intentionActionArray4;
                } else if (goNamedElement instanceof GoVarDefinition) {
                    if (GoInspectionUtil.canDeleteDefinition((GoVarOrConstDefinition)((GoVarOrConstDefinition)element))) {
                        IntentionAction[] intentionActionArray5 = new IntentionAction[]{new LocalQuickFixOnPsiElementAsIntentionAdapter((LocalQuickFixOnPsiElement)new GoRenameToBlankQuickFix(element)), new GoDeleteVarDefinitionFix((GoVarDefinition)element)};
                        intentionActionArray = intentionActionArray5;
                    } else {
                        IntentionAction[] intentionActionArray6 = new IntentionAction[]{new LocalQuickFixOnPsiElementAsIntentionAdapter((LocalQuickFixOnPsiElement)new GoRenameToBlankQuickFix(element))};
                        intentionActionArray = intentionActionArray6;
                    }
                } else if (goNamedElement instanceof GoConstDefinition) {
                    if (GoInspectionUtil.canDeleteDefinition((GoVarOrConstDefinition)((GoVarOrConstDefinition)element))) {
                        IntentionAction[] intentionActionArray7 = new IntentionAction[]{new LocalQuickFixOnPsiElementAsIntentionAdapter((LocalQuickFixOnPsiElement)new GoDeleteConstDefinitionFix((GoConstDefinition)element))};
                        intentionActionArray = intentionActionArray7;
                    } else {
                        intentionActionArray = new IntentionAction[]{};
                    }
                } else if (goNamedElement instanceof GoMethodDeclaration) {
                    IntentionAction[] intentionActionArray8 = new IntentionAction[]{new GoDeleteElementFix((PsiElement)element, GoLinterBundle.message("intention.name.delete.method", new Object[0]))};
                    intentionActionArray = intentionActionArray8;
                } else {
                    intentionActionArray = ProblemHandler.Companion.getEmptyLocalQuickFix();
                }
                PsiElement psiElement3 = element.getIdentifier();
                pair = TuplesKt.to((Object)intentionActionArray, (Object)(psiElement3 != null ? psiElement3.getTextRange() : null));
                break;
            }
            if (psiElement instanceof GoFile || psiElement == null) {
                pair = ProblemHandler.Companion.getNonAvailableFix();
                break;
            }
            element$iv = element$iv.getParent();
        }
        return pair;
    }
}

