/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.go.linter.handler;

import com.goide.psi.GoBinaryExpr;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoConditionalExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFile;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoLiteral;
import com.goide.psi.GoStringLiteral;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.go.linter.handler.ProblemHandler;
import com.intellij.go.linter.model.LintIssue;
import com.intellij.go.linter.quickfix.GoDecapitalizeStringFix;
import com.intellij.go.linter.quickfix.GoEscapeStringFix;
import com.intellij.go.linter.quickfix.GoRemoveDuplImportFix;
import com.intellij.go.linter.quickfix.GoSwapBinaryExprFix;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/go/linter/handler/StyleCheckHandler;", "Lcom/intellij/go/linter/handler/ProblemHandler;", "<init>", "()V", "doSuggestFix", "Lkotlin/Pair;", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/openapi/util/TextRange;", "file", "Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "issue", "Lcom/intellij/go/linter/model/LintIssue;", "overrideLine", "", "intellij.go.linter"})
@SourceDebugExtension(value={"SMAP\nStyleCheckHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StyleCheckHandler.kt\ncom/intellij/go/linter/handler/StyleCheckHandler\n+ 2 ProblemHandler.kt\ncom/intellij/go/linter/handler/ProblemHandler\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n32#2,7:51\n32#2,7:58\n32#2,7:65\n32#2,5:72\n37#2,2:83\n774#3:77\n865#3,2:78\n1734#3,3:80\n*S KotlinDebug\n*F\n+ 1 StyleCheckHandler.kt\ncom/intellij/go/linter/handler/StyleCheckHandler\n*L\n19#1:51,7\n27#1:58,7\n33#1:65,7\n42#1:72,5\n42#1:83,2\n43#1:77\n43#1:78,2\n43#1:80,3\n*E\n"})
public final class StyleCheckHandler
extends ProblemHandler {
    @NotNull
    public static final StyleCheckHandler INSTANCE = new StyleCheckHandler();

    private StyleCheckHandler() {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Pair<IntentionAction[], TextRange> doSuggestFix(@NotNull PsiFile file, @NotNull Document document, @NotNull LintIssue issue, int overrideLine) {
        boolean bl;
        GoImportSpec element;
        Pair pair;
        block32: {
            Iterator iterator;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
            String string = issue.getText().substring(0, StringsKt.indexOf$default((CharSequence)issue.getText(), (char)':', (int)0, (boolean)false, (int)6, null));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            block6 : switch (string) {
                case "ST1005": {
                    ProblemHandler this_$iv = this;
                    boolean $i$f$chainFindAndHandle = false;
                    PsiElement element$iv = file.findElementAt(ProblemHandler.access$calcPos(this_$iv, document, issue, overrideLine));
                    while (true) {
                        PsiElement psiElement;
                        if ((psiElement = element$iv) instanceof GoCallExpr) {
                            GoCallExpr element2 = (GoCallExpr)element$iv;
                            boolean bl2 = false;
                            List list = element2.getArgumentList().getExpressionList();
                            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExpressionList(...)");
                            GoExpression formatString = (GoExpression)CollectionsKt.first((List)list);
                            if (formatString instanceof GoStringLiteral) {
                                IntentionAction[] intentionActionArray = new IntentionAction[]{new GoDecapitalizeStringFix((GoStringLiteral)formatString)};
                                pair = TuplesKt.to((Object)intentionActionArray, (Object)((GoStringLiteral)formatString).getTextRange());
                                return pair;
                            }
                            pair = ProblemHandler.Companion.getNonAvailableFix();
                            return pair;
                        }
                        if (psiElement instanceof GoFile || psiElement == null) {
                            pair = ProblemHandler.Companion.getNonAvailableFix();
                            return pair;
                        }
                        element$iv = element$iv.getParent();
                    }
                }
                case "ST1017": {
                    ProblemHandler this_$iv = this;
                    boolean $i$f$chainFindAndHandle = false;
                    PsiElement element$iv = file.findElementAt(ProblemHandler.access$calcPos(this_$iv, document, issue, overrideLine));
                    while (true) {
                        PsiElement psiElement;
                        if ((psiElement = element$iv) instanceof GoConditionalExpr) {
                            GoConditionalExpr element3 = (GoConditionalExpr)element$iv;
                            boolean bl3 = false;
                            if (!(element3.getLeft() instanceof GoLiteral) && !(element3.getLeft() instanceof GoStringLiteral)) {
                                pair = ProblemHandler.Companion.getNonAvailableFix();
                                return pair;
                            }
                            IntentionAction[] formatString = new IntentionAction[]{new GoSwapBinaryExprFix((GoBinaryExpr)element3)};
                            pair = TuplesKt.to((Object)formatString, (Object)element3.getTextRange());
                            return pair;
                        }
                        if (psiElement instanceof GoFile || psiElement == null) {
                            pair = ProblemHandler.Companion.getNonAvailableFix();
                            return pair;
                        }
                        element$iv = element$iv.getParent();
                    }
                }
                case "ST1018": {
                    ProblemHandler this_$iv = this;
                    boolean $i$f$chainFindAndHandle = false;
                    PsiElement element$iv = file.findElementAt(ProblemHandler.access$calcPos(this_$iv, document, issue, overrideLine));
                    while (true) {
                        PsiElement psiElement;
                        if ((psiElement = element$iv) instanceof GoStringLiteral) {
                            GoStringLiteral element4 = (GoStringLiteral)element$iv;
                            boolean bl4 = false;
                            int begin = StringsKt.indexOf$default((CharSequence)issue.getText(), (char)'\'', (int)0, (boolean)false, (int)6, null);
                            int end = StringsKt.indexOf$default((CharSequence)issue.getText(), (char)'\'', (int)(begin + 1), (boolean)false, (int)4, null);
                            String string2 = issue.getText().substring(begin + 1, end);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                            String utfChar = string2;
                            boolean bl5 = StringsKt.startsWith$default((String)utfChar, (String)"\\u", (boolean)false, (int)2, null);
                            if (_Assertions.ENABLED && !bl5) {
                                String string3 = "Assertion failed";
                                throw new AssertionError((Object)string3);
                            }
                            IntentionAction[] intentionActionArray = new IntentionAction[]{new GoEscapeStringFix(utfChar, element4)};
                            pair = TuplesKt.to((Object)intentionActionArray, (Object)element4.getTextRange());
                            return pair;
                        }
                        if (psiElement instanceof GoFile || psiElement == null) {
                            pair = ProblemHandler.Companion.getNonAvailableFix();
                            return pair;
                        }
                        element$iv = element$iv.getParent();
                    }
                }
                case "ST1019": {
                    ProblemHandler this_$iv = this;
                    boolean $i$f$chainFindAndHandle = false;
                    PsiElement element$iv = file.findElementAt(ProblemHandler.access$calcPos(this_$iv, document, issue, overrideLine));
                    while (true) {
                        PsiElement psiElement;
                        if ((psiElement = element$iv) instanceof GoImportSpec) {
                            void $this$filterTo$iv$iv;
                            element = (GoImportSpec)element$iv;
                            boolean bl6 = false;
                            List list = ((GoFile)file).getImports();
                            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getImports(...)");
                            Iterable $this$filter$iv = list;
                            boolean $i$f$filter = false;
                            Iterable utfChar = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList();
                            boolean $i$f$filterTo = false;
                            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                                GoImportSpec it = (GoImportSpec)element$iv$iv;
                                boolean bl7 = false;
                                if (!Intrinsics.areEqual((Object)it.getPath(), (Object)element.getPath())) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            Iterable $this$all$iv = (List)destination$iv$iv;
                            boolean $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl = true;
                                break block32;
                            } else {
                                iterator = $this$all$iv.iterator();
                                break block6;
                            }
                        }
                        if (psiElement instanceof GoFile || psiElement == null) {
                            pair = ProblemHandler.Companion.getNonAvailableFix();
                            return pair;
                        }
                        element$iv = element$iv.getParent();
                    }
                }
                default: {
                    pair = ProblemHandler.Companion.getNonAvailableFix();
                    return pair;
                }
            }
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                GoImportSpec it = (GoImportSpec)element$iv;
                boolean bl8 = false;
                if (!it.isForSideEffects() && !it.isDot()) continue;
                bl = false;
                break block32;
            }
            bl = true;
        }
        if (bl) {
            IntentionAction[] intentionActionArray = new IntentionAction[]{new GoRemoveDuplImportFix(element)};
            pair = TuplesKt.to((Object)intentionActionArray, (Object)element.getTextRange());
            return pair;
        }
        pair = ProblemHandler.Companion.getNonAvailableFix();
        return pair;
    }
}

