/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.go.linter.handler;

import com.goide.quickfix.GoDeleteRangeQuickFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.go.linter.GoLinterBundle;
import com.intellij.go.linter.handler.ProblemHandler;
import com.intellij.go.linter.model.LineRange;
import com.intellij.go.linter.model.LintIssue;
import com.intellij.go.linter.quickfix.GoDeleteElementFix;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/go/linter/handler/WhitespaceHandler;", "Lcom/intellij/go/linter/handler/ProblemHandler;", "<init>", "()V", "doSuggestFix", "Lkotlin/Pair;", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/openapi/util/TextRange;", "file", "Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "issue", "Lcom/intellij/go/linter/model/LintIssue;", "overrideLine", "", "intellij.go.linter"})
@SourceDebugExtension(value={"SMAP\nSimpleHandlers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleHandlers.kt\ncom/intellij/go/linter/handler/WhitespaceHandler\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,229:1\n1069#2,2:230\n*S KotlinDebug\n*F\n+ 1 SimpleHandlers.kt\ncom/intellij/go/linter/handler/WhitespaceHandler\n*L\n69#1:230,2\n*E\n"})
public final class WhitespaceHandler
extends ProblemHandler {
    @NotNull
    public static final WhitespaceHandler INSTANCE = new WhitespaceHandler();

    private WhitespaceHandler() {
    }

    @Override
    @NotNull
    public Pair<IntentionAction[], TextRange> doSuggestFix(@NotNull PsiFile file, @NotNull Document document, @NotNull LintIssue issue, int overrideLine) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        boolean bl2 = bl = issue.getLineRange() != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        List elements = new ArrayList();
        int shift = overrideLine - issue.getPos().getLine();
        LineRange lineRange = issue.getLineRange();
        Intrinsics.checkNotNull((Object)lineRange);
        int l = lineRange.getFrom();
        int n = issue.getLineRange().getTo();
        if (l <= n) {
            while (true) {
                PsiElement element;
                int e;
                int line;
                int s;
                if ((s = document.getLineStartOffset(line = l + shift)) == (e = document.getLineEndOffset(line)) && (element = file.findElementAt(s)) instanceof PsiWhiteSpaceImpl) {
                    boolean bl3;
                    block10: {
                        CharSequence $this$all$iv;
                        Intrinsics.checkNotNullExpressionValue((Object)((PsiWhiteSpaceImpl)element).getChars(), (String)"getChars(...)");
                        boolean $i$f$all = false;
                        for (int i = 0; i < $this$all$iv.length(); ++i) {
                            char element$iv;
                            char it = element$iv = $this$all$iv.charAt(i);
                            boolean bl4 = false;
                            if (it == '\n') continue;
                            bl3 = false;
                            break block10;
                        }
                        bl3 = true;
                    }
                    if (bl3) {
                        elements.add(element);
                    }
                }
                if (l == n) break;
                ++l;
            }
        }
        int start = document.getLineStartOffset(issue.getLineRange().getFrom() + shift);
        int end = document.getLineEndOffset(issue.getLineRange().getTo() + shift);
        return switch (elements.size()) {
            case 0 -> ProblemHandler.Companion.getNonAvailableFix();
            case 1 -> {
                IntentionAction[] var10_13 = new IntentionAction[]{new GoDeleteElementFix((PsiElement)CollectionsKt.single((List)elements), GoLinterBundle.message("intention.name.remove.whitespace", new Object[0]))};
                yield TuplesKt.to((Object)var10_13, (Object)new TextRange(start, end));
            }
            default -> {
                IntentionAction[] var10_14 = new IntentionAction[]{new GoDeleteRangeQuickFix((PsiElement)CollectionsKt.first((List)elements), (PsiElement)CollectionsKt.last((List)elements), GoLinterBundle.message("intention.name.remove.whitespace", new Object[0]))};
                yield TuplesKt.to((Object)var10_14, (Object)new TextRange(start, end));
            }
        };
    }
}

