/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.go.linter.platform;

import com.goide.util.GoUtil;
import com.intellij.go.linter.platform.Platform;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.platform.templates.github.ZipUtil;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0007H\u0014J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0007H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/go/linter/platform/Windows;", "Lcom/intellij/go/linter/platform/Platform;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getDownloadArchiveName", "", "version", "tempPath", "decompress", "", "archive", "Ljava/io/File;", "targetDir", "fileName", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "linterName", "defaultPath", "Ljava/nio/file/Path;", "adjustLinterExeChooser", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "initial", "intellij.go.linter"})
@SourceDebugExtension(value={"SMAP\nWindows.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Windows.kt\ncom/intellij/go/linter/platform/Windows\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,28:1\n1#2:29\n*E\n"})
public final class Windows
extends Platform {
    public Windows(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Override
    @NotNull
    public String getDownloadArchiveName(@NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        return "golangci-lint-" + version2 + "-windows-" + GoUtil.systemArch() + ".zip";
    }

    @Override
    @NotNull
    protected String tempPath() {
        String string = System.getenv("TEMP");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getenv(...)");
        return string;
    }

    @Override
    protected void decompress(@NotNull File archive, @NotNull File targetDir, @NotNull String fileName, @NotNull ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)archive, (String)"archive");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        ZipUtil.unzip((ProgressIndicator)progressIndicator, (File)targetDir, (File)archive, null, (arg_0, arg_1) -> Windows.decompress$lambda$0(fileName, arg_0, arg_1), (boolean)true);
    }

    @Override
    @NotNull
    public String linterName() {
        return "golangci-lint.exe";
    }

    @Override
    @NotNull
    public Path defaultPath() {
        String string = System.getenv("PUBLIC");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getenv(...)");
        Path path = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @Override
    @NotNull
    public FileChooserDescriptor adjustLinterExeChooser(@NotNull FileChooserDescriptor initial) {
        FileChooserDescriptor fileChooserDescriptor;
        Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
        FileChooserDescriptor it = fileChooserDescriptor = initial;
        boolean bl = false;
        it.withExtensionFilter("exe");
        return fileChooserDescriptor;
    }

    private static final byte[] decompress$lambda$0(String $fileName, byte[] content, File file) {
        return (byte[])(Intrinsics.areEqual((Object)file.getName(), (Object)$fileName) ? content : null);
    }
}

