/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.go.linter.quickfix;

import com.goide.psi.GoExpression;
import com.goide.psi.GoStatement;
import com.goide.psi.impl.GoElementFactory;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.go.linter.GoLinterBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\f\u001a\u00020\u0005H\u0016J3\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0002H\u0096\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/go/linter/quickfix/GoReplaceElementFix;", "T", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "replacement", "", "element", "typeTag", "Ljava/lang/Class;", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;Ljava/lang/Class;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "endElement", "intellij.go.linter"})
public final class GoReplaceElementFix<T extends PsiElement>
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @NotNull
    private final String replacement;
    @NotNull
    private final Class<T> typeTag;

    public GoReplaceElementFix(@NotNull String replacement, @NotNull PsiElement element, @NotNull Class<T> typeTag) {
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(typeTag, (String)"typeTag");
        super(element);
        this.replacement = replacement;
        this.typeTag = typeTag;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.replacement};
        return GoLinterBundle.message("intention.name.replace.element.with", objectArray);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Class<T> clazz = this.typeTag;
        if (Intrinsics.areEqual(clazz, GoExpression.class)) {
            GoExpression goExpression = GoElementFactory.createExpression((Project)project, (String)this.replacement);
            Intrinsics.checkNotNullExpressionValue((Object)goExpression, (String)"createExpression(...)");
            psiElement = (PsiElement)goExpression;
        } else if (Intrinsics.areEqual(clazz, GoStatement.class)) {
            GoStatement goStatement = GoElementFactory.createStatement((Project)project, (String)this.replacement);
            Intrinsics.checkNotNullExpressionValue((Object)goStatement, (String)"createStatement(...)");
            psiElement = (PsiElement)goStatement;
        } else {
            psiElement = GoElementFactory.createElement((Project)project, (String)("package a; func a() {\n " + this.replacement + " }"), this.typeTag);
            if (psiElement == null) {
                return;
            }
        }
        startElement.replace(psiElement);
    }
}

