/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.go.linter.quickfix;

import com.goide.psi.GoBlock;
import com.goide.psi.GoIfStatement;
import com.goide.psi.GoSimpleStatement;
import com.goide.psi.GoStatement;
import com.goide.psi.impl.GoElementFactory;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.go.linter.GoLinterBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J3\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0096\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/go/linter/quickfix/GoShortenIfFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "element", "Lcom/goide/psi/GoSimpleStatement;", "ifStatementLine", "", "<init>", "(Lcom/goide/psi/GoSimpleStatement;I)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.go.linter"})
public final class GoShortenIfFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final int ifStatementLine;

    public GoShortenIfFix(@NotNull GoSimpleStatement element, int ifStatementLine) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element);
        this.ifStatementLine = ifStatementLine;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return GoLinterBundle.message("intention.name.shorten.if.with.assignment", new Object[0]);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document == null) {
            return;
        }
        Document document2 = document;
        GoIfStatement goIfStatement = (GoIfStatement)PsiTreeUtil.findFirstParent((PsiElement)file.findElementAt(document2.getLineEndOffset(this.ifStatementLine)), arg_0 -> GoShortenIfFix.invoke$lambda$1(GoShortenIfFix::invoke$lambda$0, arg_0));
        if (goIfStatement == null) {
            return;
        }
        GoIfStatement ifStatement = goIfStatement;
        GoStatement goStatement = ifStatement.getStatement();
        String string = startElement.getText() + "; " + (goStatement != null ? goStatement.getText() : null);
        GoBlock goBlock = ifStatement.getBlock();
        Intrinsics.checkNotNull((Object)goBlock);
        List list = goBlock.getStatementList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStatementList(...)");
        ifStatement.replace((PsiElement)GoElementFactory.createIfStatement((Project)project, (String)string, (String)CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", null, null, (int)0, null, GoShortenIfFix::invoke$lambda$2, (int)30, null), null));
        startElement.delete();
    }

    private static final boolean invoke$lambda$0(PsiElement it) {
        return it instanceof GoIfStatement;
    }

    private static final boolean invoke$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final CharSequence invoke$lambda$2(GoStatement it) {
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }
}

