/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.go.linter.quickfix;

import com.goide.psi.GoExprCaseClause;
import com.goide.psi.GoExprSwitchStatement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoStatement;
import com.goide.psi.GoSwitchStatement;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeCaseClause;
import com.goide.psi.GoTypeSwitchGuard;
import com.goide.psi.GoTypeSwitchStatement;
import com.goide.psi.impl.GoElementFactory;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.go.linter.GoLinterBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J3\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0096\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/go/linter/quickfix/GoSingleCaseSwitchFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "element", "Lcom/goide/psi/GoSwitchStatement;", "<init>", "(Lcom/goide/psi/GoSwitchStatement;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.go.linter"})
public final class GoSingleCaseSwitchFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    public GoSingleCaseSwitchFix(@NotNull GoSwitchStatement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return GoLinterBundle.message("intention.name.replace.single.switch.case", new Object[0]);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        GoSwitchStatement element = (GoSwitchStatement)startElement;
        if (element instanceof GoTypeSwitchStatement) {
            List list = ((GoTypeSwitchStatement)element).getTypeCaseClauseList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTypeCaseClauseList(...)");
            GoTypeCaseClause caseClause = (GoTypeCaseClause)CollectionsKt.single((List)list);
            GoTypeSwitchGuard goTypeSwitchGuard = ((GoTypeSwitchStatement)element).getTypeSwitchGuard();
            Intrinsics.checkNotNullExpressionValue((Object)goTypeSwitchGuard, (String)"getTypeSwitchGuard(...)");
            GoTypeSwitchGuard cond = goTypeSwitchGuard;
            Object object = cond.getVarDefinition();
            if (object == null || (object = object.getText()) == null) {
                object = "_";
            }
            Object varName = object;
            String string = cond.getExpression().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            boolean bl = StringsKt.endsWith$default((String)string, (String)".(type)", (boolean)false, (int)2, null);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            String string3 = cond.getExpression().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
            String string4 = StringsKt.dropLast((String)string3, (int)7);
            GoType goType = caseClause.getType();
            Intrinsics.checkNotNull((Object)goType);
            String string5 = (String)varName + ", ok := " + string4 + ".(" + goType.getText() + "); ok";
            List list2 = caseClause.getStatementList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatementList(...)");
            element.replace((PsiElement)GoElementFactory.createIfStatement((Project)project, (String)string5, (String)CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)"\n", null, null, (int)0, null, GoSingleCaseSwitchFix::invoke$lambda$0, (int)30, null), null));
        } else if (element instanceof GoExprSwitchStatement) {
            List list = ((GoExprSwitchStatement)element).getExprCaseClauseList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExprCaseClauseList(...)");
            GoExprCaseClause caseClause = (GoExprCaseClause)CollectionsKt.single((List)list);
            GoExpression goExpression = ((GoExprSwitchStatement)element).getCondition();
            Intrinsics.checkNotNull((Object)goExpression);
            String cond = goExpression.getText();
            StringBuilder condBuilder = new StringBuilder();
            GoStatement goStatement = ((GoExprSwitchStatement)element).getInitStatement();
            if (goStatement != null) {
                GoStatement it = goStatement;
                boolean bl = false;
                condBuilder.append(it.getText() + "; ");
            }
            List list3 = caseClause.getExpressionList();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getExpressionList(...)");
            condBuilder.append(CollectionsKt.joinToString$default((Iterable)list3, (CharSequence)" || ", null, null, (int)0, null, arg_0 -> GoSingleCaseSwitchFix.invoke$lambda$2(cond, arg_0), (int)30, null));
            String string = condBuilder.toString();
            List list4 = caseClause.getStatementList();
            Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getStatementList(...)");
            element.replace((PsiElement)GoElementFactory.createIfStatement((Project)project, (String)string, (String)CollectionsKt.joinToString$default((Iterable)list4, (CharSequence)"\n", null, null, (int)0, null, GoSingleCaseSwitchFix::invoke$lambda$3, (int)30, null), null));
        }
    }

    private static final CharSequence invoke$lambda$0(GoStatement it) {
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final CharSequence invoke$lambda$2(String $cond, GoExpression it) {
        return $cond + " == " + it.getText();
    }

    private static final CharSequence invoke$lambda$3(GoStatement it) {
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }
}

