/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.go.linter.quickfix;

import com.goide.psi.impl.GoElementFactory;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.go.linter.GoLinterBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0003H\u0016J\b\u0010\t\u001a\u00020\u0003H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J%\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/go/linter/quickfix/NoLintSingleLineCommentFix;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "linter", "", "lineNumber", "", "<init>", "(Ljava/lang/String;I)V", "getText", "getFamilyName", "startInWriteAction", "", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "invoke", "", "createComment", "Lcom/intellij/psi/PsiComment;", "text", "intellij.go.linter"})
@SourceDebugExtension(value={"SMAP\nNoLintSingleLineCommentFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NoLintSingleLineCommentFix.kt\ncom/intellij/go/linter/quickfix/NoLintSingleLineCommentFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n1#2:48\n*E\n"})
public final class NoLintSingleLineCommentFix
implements IntentionAction {
    @NotNull
    private final String linter;
    private final int lineNumber;

    public NoLintSingleLineCommentFix(@NotNull String linter, int lineNumber) {
        Intrinsics.checkNotNullParameter((Object)linter, (String)"linter");
        this.linter = linter;
        this.lineNumber = lineNumber;
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.linter};
        return GoLinterBundle.message("intention.name.suppress.linter.here", objectArray);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean startInWriteAction() {
        return true;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return true;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        block6: {
            PsiComment psiComment;
            PsiElement element;
            block5: {
                PsiComment psiComment2;
                String string;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                if (file == null) {
                    return;
                }
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
                if (document == null) {
                    return;
                }
                Document document2 = document;
                PsiElement psiElement = file.findElementAt(document2.getLineEndOffset(this.lineNumber));
                if (psiElement == null || (psiElement = psiElement.getPrevSibling()) == null) {
                    return;
                }
                element = psiElement;
                if (!(element instanceof PsiComment)) break block5;
                String text = ((PsiComment)element).getText();
                Intrinsics.checkNotNull((Object)text);
                if (StringsKt.startsWith$default((String)text, (String)"//nolint:", (boolean)false, (int)2, null)) {
                    String string2 = text.substring(9);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    string = "//nolint:" + this.linter + "," + string2;
                } else {
                    string = "//nolint:" + this.linter + "    " + text;
                }
                String replace = string;
                PsiComment psiComment3 = this.createComment(project, replace);
                if (psiComment3 == null) break block6;
                PsiComment it = psiComment2 = psiComment3;
                boolean bl = false;
                element.replace((PsiElement)it);
                break block6;
            }
            PsiComment psiComment4 = this.createComment(project, "//nolint:" + this.linter);
            if (psiComment4 == null) break block6;
            PsiComment it = psiComment = psiComment4;
            boolean bl = false;
            element.getParent().addAfter((PsiElement)it, element);
        }
    }

    private final PsiComment createComment(Project project, String text) {
        return (PsiComment)GoElementFactory.createElement((Project)project, (String)("package a; \n " + text + "\n}"), PsiComment.class);
    }
}

