/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.validity;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.validity.FunctionWithInconsistentReturnsJSInspectionBase;
import org.jetbrains.annotations.NotNull;

public class FunctionWithInconsistentReturnsJSInspection
extends FunctionWithInconsistentReturnsJSInspectionBase {
    @Override
    protected InspectionJSFix[] buildFixes(PsiElement location, boolean onTheFly) {
        JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)location, JSFunction.class);
        if (fun == null || fun.getReturnType() == null || !DialectDetector.isActionScript(fun)) {
            return null;
        }
        InspectionJSFix makeVoidFix = new InspectionJSFix(){

            @Override
            protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
                JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), JSFunction.class);
                if (fun != null) {
                    JSRefactoringUtil.setType(fun, "void");
                }
            }

            @NotNull
            public String getFamilyName() {
                String string = InspectionJSBundle.message("set.return.type.to.void.fix.name", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/validity/FunctionWithInconsistentReturnsJSInspection$1", "getFamilyName"));
            }
        };
        if (!onTheFly) {
            return new InspectionJSFix[]{makeVoidFix};
        }
        return new InspectionJSFix[]{makeVoidFix, new InspectionJSFix(){

            @Override
            protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
                PsiElement element = descriptor.getPsiElement();
                JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class);
                if (fun != null) {
                    JSType type2 = fun.getReturnType();
                    TemplateManager templateManager = TemplateManager.getInstance((Project)project);
                    Template t = templateManager.createTemplate("", "");
                    t.setToReformat(true);
                    t.addTextSegment("return ");
                    t.addEndVariable();
                    t.addSelectionStartVariable();
                    String value = type2 == null ? "null" : type2.getDefaultValue();
                    t.addTextSegment(value);
                    t.addSelectionEndVariable();
                    String s = JSCodeStyleSettings.getSemicolon(fun);
                    if (!s.isEmpty()) {
                        t.addTextSegment(s);
                    }
                    t.addTextSegment("\n");
                    int offset = InjectedLanguageManager.getInstance((Project)project).injectedToHost(element, element.getTextRange().getStartOffset());
                    Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, fun.getContainingFile().getVirtualFile(), offset), false);
                    if (editor != null) {
                        if (offset != -1) {
                            editor.getCaretModel().moveToOffset(offset);
                        }
                        templateManager.startTemplate(editor, t);
                    }
                }
            }

            @NotNull
            public String getFamilyName() {
                String string = InspectionJSBundle.message("add.return.statement.fix.name", new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/validity/FunctionWithInconsistentReturnsJSInspection$2", "getFamilyName"));
            }
        }};
    }
}

