/*
 * Decompiled with CFR 0.152.
 */
package com.goide.codeInsight.editorActions;

import com.goide.GoLanguage;
import com.goide.GoParserDefinition;
import com.goide.GoTypes;
import com.goide.formatter.settings.GoCodeStyleSettings;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.codeStyle.SemanticEditorPosition;
import com.intellij.psi.impl.source.codeStyle.lineIndent.JavaLikeLangLineIndentProvider;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoEnterHandler
implements EnterHandlerDelegate {
    private static final SemanticEditorPosition.SyntaxElement TOKEN_TO_EXPAND = new SemanticEditorPosition.SyntaxElement(){};
    private static final HashMap<IElementType, SemanticEditorPosition.SyntaxElement> SYNTAX_MAP = new HashMap<IElementType, SemanticEditorPosition.SyntaxElement>(){
        {
            this.put(TokenType.WHITE_SPACE, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace);
            this.put(GoParserDefinition.Lazy.NLS, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace);
            this.put(GoParserDefinition.Lazy.WS, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace);
            this.put(GoTypes.LPAREN, JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis);
            this.put(GoTypes.RPAREN, JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis);
            this.put(GoTypes.VAR, TOKEN_TO_EXPAND);
            this.put(GoTypes.CONST, TOKEN_TO_EXPAND);
            this.put(GoTypes.IMPORT, TOKEN_TO_EXPAND);
            this.put(GoTypes.TYPE_, TOKEN_TO_EXPAND);
        }
    };

    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        if (file == null) {
            GoEnterHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GoEnterHandler.$$$reportNull$$$0(1);
        }
        if (caretOffset == null) {
            GoEnterHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            GoEnterHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            GoEnterHandler.$$$reportNull$$$0(4);
        }
        if (file.getLanguage() != GoLanguage.INSTANCE) {
            return EnterHandlerDelegate.Result.Continue;
        }
        SemanticEditorPosition position = GoEnterHandler.getPosition(editor, (Integer)caretOffset.get());
        if (!GoEnterHandler.moveBefore(position, GoTypes.RPAREN)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (!GoEnterHandler.moveBefore(position, GoTypes.LPAREN)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        position.moveBeforeOptional((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace);
        return position.isAt(TOKEN_TO_EXPAND) ? EnterHandlerDelegate.Result.Continue : EnterHandlerDelegate.Result.DefaultForceIndent;
    }

    public EnterHandlerDelegate.Result postProcessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull DataContext dataContext) {
        if (file == null) {
            GoEnterHandler.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            GoEnterHandler.$$$reportNull$$$0(6);
        }
        if (dataContext == null) {
            GoEnterHandler.$$$reportNull$$$0(7);
        }
        if (file.getLanguage() != GoLanguage.INSTANCE) {
            return EnterHandlerDelegate.Result.Continue;
        }
        CharSequence text = editor.getDocument().getCharsSequence();
        int commentLastSlash = GoEnterHandler.getLineCommentLastSlashIndex(text, editor.getCaretModel().getOffset());
        if (commentLastSlash != -1 && commentLastSlash < text.length() - 1 && text.charAt(commentLastSlash + 1) == ' ' && !GoCodeStyleSettings.getSettings((PsiFile)file).ADD_LEADING_SPACE_TO_COMMENTS) {
            editor.getDocument().deleteString(commentLastSlash + 1, commentLastSlash + 2);
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static int getLineCommentLastSlashIndex(@NotNull CharSequence text, int offset) {
        if (text == null) {
            GoEnterHandler.$$$reportNull$$$0(8);
        }
        if (offset >= text.length()) {
            return -1;
        }
        block4: for (int i = offset; i >= 0; --i) {
            char c = text.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    return -1;
                }
                case '/': {
                    if (i <= 0 || text.charAt(i - 1) != '/') continue block4;
                    return i;
                }
            }
        }
        return -1;
    }

    private static SemanticEditorPosition getPosition(@NotNull Editor editor, int offset) {
        if (editor == null) {
            GoEnterHandler.$$$reportNull$$$0(9);
        }
        return SemanticEditorPosition.createEditorPosition((Editor)editor, (int)offset, GoEnterHandler::createIterator, SYNTAX_MAP::get);
    }

    @NotNull
    private static HighlighterIterator createIterator(@NotNull Editor editor, int offset) {
        if (editor == null) {
            GoEnterHandler.$$$reportNull$$$0(10);
        }
        HighlighterIterator highlighterIterator = editor.getHighlighter().createIterator(offset);
        if (highlighterIterator == null) {
            GoEnterHandler.$$$reportNull$$$0(11);
        }
        return highlighterIterator;
    }

    private static boolean moveBefore(@NotNull SemanticEditorPosition position, @NotNull IElementType type) {
        if (position == null) {
            GoEnterHandler.$$$reportNull$$$0(12);
        }
        if (type == null) {
            GoEnterHandler.$$$reportNull$$$0(13);
        }
        if (!position.isAt(type)) {
            return false;
        }
        position.moveBefore();
        return !position.isAtEnd();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/codeInsight/editorActions/GoEnterHandler";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/codeInsight/editorActions/GoEnterHandler";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "preprocessEnter";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "postProcessEnter";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLineCommentLastSlashIndex";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPosition";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createIterator";
                break;
            }
            case 11: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "moveBefore";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11 -> new IllegalStateException(string);
        };
    }
}

