/*
 * Decompiled with CFR 0.152.
 */
package com.goide.formatter;

import com.goide.GoLanguage;
import com.goide.GoParserDefinition;
import com.goide.GoTypes;
import com.intellij.formatting.Indent;
import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.codeStyle.SemanticEditorPosition;
import com.intellij.psi.impl.source.codeStyle.lineIndent.IndentCalculator;
import com.intellij.psi.impl.source.codeStyle.lineIndent.JavaLikeLangLineIndentProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import java.util.HashMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoLineIndentProvider {
    private static final HashMap<IElementType, SemanticEditorPosition.SyntaxElement> SYNTAX_MAP = new HashMap<IElementType, SemanticEditorPosition.SyntaxElement>(){
        {
            this.put(TokenType.WHITE_SPACE, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace);
            this.put(GoParserDefinition.Lazy.NLS, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace);
            this.put(GoParserDefinition.Lazy.WS, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace);
            this.put(GoTypes.SEMICOLON_SYNTHETIC, GoElement.NewLine);
            this.put(GoTypes.SEMICOLON, JavaLikeLangLineIndentProvider.JavaLikeElement.Semicolon);
            this.put(GoTypes.LBRACE, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace);
            this.put(GoTypes.RBRACE, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace);
            this.put(GoTypes.LBRACK, JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket);
            this.put(GoTypes.RBRACK, JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket);
            this.put(GoTypes.RPAREN, JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis);
            this.put(GoTypes.LPAREN, JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis);
            this.put(GoTypes.COLON, JavaLikeLangLineIndentProvider.JavaLikeElement.Colon);
            this.put(GoTypes.CASE, JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchCase);
            this.put(GoTypes.DEFAULT, JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchDefault);
            this.put(GoTypes.IF, JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword);
            this.put(GoTypes.ELSE, JavaLikeLangLineIndentProvider.JavaLikeElement.ElseKeyword);
            this.put(GoTypes.FOR, JavaLikeLangLineIndentProvider.JavaLikeElement.ForKeyword);
            this.put(GoParserDefinition.Lazy.MULTILINE_COMMENT, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment);
            this.put(GoTypes.COMMA, JavaLikeLangLineIndentProvider.JavaLikeElement.Comma);
            this.put(GoTypes.SWITCH, GoElement.Switch);
            this.put(GoTypes.SELECT, GoElement.Select);
            this.put(GoTypes.FUNC, GoElement.Func);
            this.put(GoParserDefinition.Lazy.LINE_COMMENT, JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment);
        }
    };

    @Nullable
    public static SemanticEditorPosition.SyntaxElement mapType(@NotNull IElementType tokenType) {
        if (tokenType == null) {
            GoLineIndentProvider.$$$reportNull$$$0(0);
        }
        return SYNTAX_MAP.get(tokenType);
    }

    public static boolean isSuitableForLanguage(@NotNull Language language) {
        if (language == null) {
            GoLineIndentProvider.$$$reportNull$$$0(1);
        }
        return language.isKindOf(GoLanguage.INSTANCE);
    }

    @NotNull
    public abstract CharSequence getText();

    public abstract boolean isIndentOnEnterInRawStrings();

    @NotNull
    public abstract JavaLikeLangLineIndentProvider.IndentCalculatorFactory getIndentCalculatorFactory();

    public abstract SemanticEditorPosition getPosition(int var1);

    @Nullable
    public IndentCalculator getIndent(int offset) {
        SemanticEditorPosition prevLeftBrace;
        JavaLikeLangLineIndentProvider.IndentCalculatorFactory factory = this.getIndentCalculatorFactory();
        if (!this.isIndentOnEnterInRawStrings() && this.getPosition(offset).isAt(GoTypes.RAW_STRING)) {
            return factory.createIndentCalculator(Indent.Type.NONE, position -> 0);
        }
        if (this.getPosition(offset).beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace}).matchesRule(at -> at.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace) && at.isAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{GoElement.Switch, GoElement.Select}))) {
            return factory.createIndentCalculator(Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
        }
        SemanticEditorPosition rparenBlockStart = GoLineIndentProvider.findBlockStartForRParen(this.getPosition(offset + 1));
        if (rparenBlockStart != null) {
            return factory.createIndentCalculator(Indent.Type.NONE, pos -> rparenBlockStart.getStartOffset());
        }
        if (this.getPosition(offset).matchesRule(at -> at.beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace}).isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis))) {
            Indent.Type indent = GoLineIndentProvider.getIndentTypeInsideParens(this.getText(), this.getPosition(offset), Indent.Type.NORMAL);
            return factory.createIndentCalculator(indent, IndentCalculator.LINE_BEFORE);
        }
        SemanticEditorPosition prevLineEndBeforeComments = this.getPosition(offset).beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, GoElement.NewLine, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment});
        if (prevLineEndBeforeComments.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace) && !GoLineIndentProvider.isAtSameLineBeforeRBrace(this.getPosition(offset + 1))) {
            int baseLineOffset = this.getBaseLineOffsetForBlock(prevLineEndBeforeComments.getStartOffset());
            return factory.createIndentCalculator(Indent.Type.NORMAL, position -> baseLineOffset);
        }
        if (this.getPosition(offset).beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace}).isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon)) {
            return factory.createIndentCalculator(Indent.Type.NORMAL, IndentCalculator.LINE_BEFORE);
        }
        if (this.getPosition(offset).beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace}).isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Comma)) {
            if (this.getPosition(offset).afterOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace}).isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis)) {
                Indent.Type indent = GoLineIndentProvider.getIndentTypeInsideParens(this.getText(), this.getPosition(offset), Indent.Type.NONE);
                return factory.createIndentCalculator(indent, IndentCalculator.LINE_BEFORE);
            }
            if (this.getPosition(offset).matchesRule(position -> {
                SemanticEditorPosition p = position.afterOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
                return !p.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace, JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis}) && !position.isAtEnd() && GoLineIndentProvider.isTheSameLineLeftParenthesis(position);
            })) {
                Indent.Type indent = GoLineIndentProvider.getIndentTypeInsideParens(this.getText(), this.getPosition(offset), Indent.Type.NONE);
                return factory.createIndentCalculator(indent, IndentCalculator.LINE_BEFORE);
            }
            SemanticEditorPosition comma = this.getPosition(offset).beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
            SemanticEditorPosition prevLeftBrace2 = GoLineIndentProvider.prevLeftBrace(comma.copy());
            if (prevLeftBrace2.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace)) {
                if (GoLineIndentProvider.isAtSameLine(prevLeftBrace2, comma)) {
                    return factory.createIndentCalculator(Indent.Type.NORMAL, IndentCalculator.LINE_BEFORE);
                }
                IndentCalculator.BaseLineOffsetCalculator calculator = GoLineIndentProvider.isAtSameLineBeforeRBrace(this.getPosition(offset)) ? position -> prevLeftBrace2.getStartOffset() : IndentCalculator.LINE_BEFORE;
                return factory.createIndentCalculator(Indent.Type.NONE, calculator);
            }
        }
        if (this.getPosition(offset).beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace}).matchesRule(at -> at.isAt(GoTypes.DOT) || GoLineIndentProvider.isAt(at, GoParserDefinition.Lazy.OPERATOR_TYPES))) {
            return factory.createIndentCalculator(Indent.Type.NORMAL, this::getStatementStartOffset);
        }
        if (GoLineIndentProvider.isAtSameLineBeforeRBrace(this.getPosition(offset + 1)) && !(prevLeftBrace = GoLineIndentProvider.prevLeftBrace(this.getPosition(offset))).isAtEnd()) {
            return factory.createIndentCalculator(Indent.Type.NONE, p -> prevLeftBrace.getStartOffset());
        }
        if (this.getPosition(offset).beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, GoElement.NewLine}).matchesRule(at -> at.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace) && at.before().beforeOptional((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace).isAtMultiline())) {
            return factory.createIndentCalculator(Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
        }
        if (this.getPosition(offset).beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, GoElement.NewLine}).matchesRule(at -> at.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis) || !at.isAt(GoTypes.DOT) && !GoLineIndentProvider.isAt(at, GoParserDefinition.Lazy.OPERATOR_TYPES) && !at.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment}))) {
            return factory.createIndentCalculator(Indent.Type.NONE, this::getStatementStartOffset);
        }
        SemanticEditorPosition prevLineEnd = this.getPosition(offset).beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, GoElement.NewLine});
        if (prevLineEnd.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment)) {
            return factory.createIndentCalculator(Indent.Type.NONE, p -> prevLineEnd.getStartOffset());
        }
        return factory.createIndentCalculator(Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
    }

    private static boolean isAt(@NotNull SemanticEditorPosition at, Set<IElementType> types) {
        if (at == null) {
            GoLineIndentProvider.$$$reportNull$$$0(2);
        }
        for (IElementType type : types) {
            if (!at.isAt(type)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static Indent.Type getIndentTypeInsideParens(@NotNull CharSequence text, @NotNull SemanticEditorPosition position, @NotNull Indent.Type fallbackIndentType) {
        SemanticEditorPosition prevLeftParen;
        if (text == null) {
            GoLineIndentProvider.$$$reportNull$$$0(3);
        }
        if (position == null) {
            GoLineIndentProvider.$$$reportNull$$$0(4);
        }
        if (fallbackIndentType == null) {
            GoLineIndentProvider.$$$reportNull$$$0(5);
        }
        int offset = position.getStartOffset();
        SemanticEditorPosition firstLeftParen = null;
        while (!(prevLeftParen = position.findLeftParenthesisBackwardsSkippingNested((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis)).isAtEnd()) {
            firstLeftParen = prevLeftParen;
            position = prevLeftParen.before().beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
            if (position.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis) && !(position = position.before()).isAtEnd()) continue;
        }
        if (firstLeftParen == null) {
            Indent.Type type = fallbackIndentType;
            if (type == null) {
                GoLineIndentProvider.$$$reportNull$$$0(6);
            }
            return type;
        }
        int leftParenLineEndOffset = StringUtil.indexOf((CharSequence)text, (char)'\n', (int)firstLeftParen.getStartOffset());
        String betweenParenAndPosition = leftParenLineEndOffset <= offset ? text.subSequence(leftParenLineEndOffset, offset) : "";
        Indent.Type type = StringUtil.isEmptyOrSpaces((CharSequence)betweenParenAndPosition) ? Indent.Type.NORMAL : Indent.Type.NONE;
        if (type == null) {
            GoLineIndentProvider.$$$reportNull$$$0(7);
        }
        return type;
    }

    private static boolean isTheSameLineLeftParenthesis(@NotNull SemanticEditorPosition position) {
        if (position == null) {
            GoLineIndentProvider.$$$reportNull$$$0(8);
        }
        return GoLineIndentProvider.isLeftParenthesis(GoLineIndentProvider.prevLeft(position));
    }

    private static boolean isLeftParenthesis(@NotNull SemanticEditorPosition position) {
        if (position == null) {
            GoLineIndentProvider.$$$reportNull$$$0(9);
        }
        return position.matchesRule(it -> it.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis) && !it.after().isAt(GoParserDefinition.Lazy.NLS));
    }

    private static SemanticEditorPosition prevLeft(@NotNull SemanticEditorPosition position) {
        if (position == null) {
            GoLineIndentProvider.$$$reportNull$$$0(10);
        }
        return position.findLeftParenthesisBackwardsSkippingNestedWithPredicate((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis, e -> e.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, JavaLikeLangLineIndentProvider.JavaLikeElement.Semicolon}));
    }

    private static SemanticEditorPosition prevLeftBrace(@NotNull SemanticEditorPosition position) {
        if (position == null) {
            GoLineIndentProvider.$$$reportNull$$$0(11);
        }
        return position.findLeftParenthesisBackwardsSkippingNestedWithPredicate((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace, e -> false);
    }

    private static boolean isAtSameLineBeforeRBrace(@NotNull SemanticEditorPosition p) {
        if (p == null) {
            GoLineIndentProvider.$$$reportNull$$$0(12);
        }
        return p.afterOptional((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace).matchesRule(it -> it.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace) && GoLineIndentProvider.isAtSameLine(p, it));
    }

    private static boolean isAtSameLine(@NotNull SemanticEditorPosition p1, @NotNull SemanticEditorPosition p2) {
        if (p1 == null) {
            GoLineIndentProvider.$$$reportNull$$$0(13);
        }
        if (p2 == null) {
            GoLineIndentProvider.$$$reportNull$$$0(14);
        }
        return !CharArrayUtil.containLineBreaks((CharSequence)p1.getChars(), (int)p1.getStartOffset(), (int)p2.getStartOffset());
    }

    private int getStatementStartOffset(@NotNull SemanticEditorPosition position) {
        SemanticEditorPosition initialPosition;
        if (position == null) {
            GoLineIndentProvider.$$$reportNull$$$0(15);
        }
        if ((initialPosition = position.copy().after()).isAtEnd()) {
            initialPosition = position.copy();
        }
        boolean wasStartAtClosingBrace = initialPosition.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace);
        Language currLanguage = position.getLanguage();
        while (!position.isAtEnd()) {
            if (currLanguage == Language.ANY || currLanguage == null) {
                currLanguage = position.getLanguage();
            }
            if (GoLineIndentProvider.moveBeforeParentheses(position)) continue;
            if (!wasStartAtClosingBrace && position.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace) || position.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Semicolon, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.DocBlockEnd, JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis, JavaLikeLangLineIndentProvider.JavaLikeElement.LanguageStartDelimiter}) || position.getLanguage() != Language.ANY && !position.isAtLanguage(currLanguage) || GoLineIndentProvider.isAtCaseColon(position)) {
                SemanticEditorPosition statementStart = this.getPosition(position.getStartOffset());
                if (!(statementStart = statementStart.after().afterOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment})).isAtEnd() && statementStart.getStartOffset() < initialPosition.getStartOffset()) {
                    return statementStart.getStartOffset();
                }
            } else if (GoLineIndentProvider.isAt(position, GoParserDefinition.Lazy.ASSIGN_OPERATOR_TYPES)) {
                SemanticEditorPosition after = position.after();
                SemanticEditorPosition afterSpaces = after.afterOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment});
                if (afterSpaces.isAtEnd() || afterSpaces.getStartOffset() > initialPosition.getStartOffset()) {
                    return after.getStartOffset();
                }
                if (GoLineIndentProvider.isAtSameLine(position, afterSpaces)) {
                    return afterSpaces.getStartOffset();
                }
                SemanticEditorPosition p = initialPosition.copy();
                GoLineIndentProvider.moveToNewlineBackwards(p);
                boolean assignmentComplete = !p.beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment}).matchesRule(it -> it.isAt(GoTypes.DOT) || it.isAt(GoTypes.COMMA) || GoLineIndentProvider.isAt(it, GoParserDefinition.Lazy.OPERATOR_TYPES));
                return assignmentComplete ? position.getStartOffset() : afterSpaces.getStartOffset();
            }
            position.moveBefore();
        }
        return 0;
    }

    private static void moveToNewlineBackwards(@NotNull SemanticEditorPosition position) {
        if (position == null) {
            GoLineIndentProvider.$$$reportNull$$$0(16);
        }
        while (!position.isAtEnd()) {
            if (position.isAt(GoParserDefinition.Lazy.NLS)) {
                return;
            }
            position.moveBefore();
        }
    }

    private static boolean isAtCaseColon(@NotNull SemanticEditorPosition position) {
        if (position == null) {
            GoLineIndentProvider.$$$reportNull$$$0(17);
        }
        return position.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon) && position.copy().isAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchCase, JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchDefault});
    }

    private int getBaseLineOffsetForBlock(int openBraceOffset) {
        if (openBraceOffset == 0) {
            return openBraceOffset;
        }
        SemanticEditorPosition p = this.getPosition(openBraceOffset - 1);
        while (!p.isAtEnd()) {
            if (p.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.ElseKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.ForKeyword, GoElement.Func})) {
                return p.getStartOffset();
            }
            if (GoLineIndentProvider.moveBeforeParentheses(p)) continue;
            if (p.isAt(GoParserDefinition.Lazy.NLS)) {
                SemanticEditorPosition prevLineEnd = p.copy();
                prevLineEnd.moveBeforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, GoElement.NewLine, JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment});
                if (prevLineEnd.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.ElseKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.ForKeyword, GoElement.Func})) {
                    return prevLineEnd.getStartOffset();
                }
                if (!(GoLineIndentProvider.isAt(prevLineEnd, GoParserDefinition.Lazy.OPERATOR_TYPES) || prevLineEnd.isAt(GoTypes.COMMA) || prevLineEnd.isAt(GoTypes.COLON))) {
                    return p.after().getStartOffset();
                }
                p = prevLineEnd;
                continue;
            }
            p.moveBefore();
        }
        return 0;
    }

    private static boolean moveBeforeParentheses(@NotNull SemanticEditorPosition p) {
        if (p == null) {
            GoLineIndentProvider.$$$reportNull$$$0(18);
        }
        if (p.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis)) {
            p.moveBeforeParentheses((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis);
            return true;
        }
        if (p.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace)) {
            p.moveBeforeParentheses((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace);
            return true;
        }
        if (p.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket)) {
            p.moveBeforeParentheses((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket);
            return true;
        }
        return false;
    }

    @Nullable
    private static SemanticEditorPosition findBlockStartForRParen(@NotNull SemanticEditorPosition p) {
        SemanticEditorPosition beforeLeftParen;
        SemanticEditorPosition leftParen;
        SemanticEditorPosition afterSpaces;
        if (p == null) {
            GoLineIndentProvider.$$$reportNull$$$0(19);
        }
        if ((afterSpaces = p.afterOptional((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace)).matchesRule(it -> it.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis) && GoLineIndentProvider.isAtSameLine(p, it)) && !(leftParen = afterSpaces.beforeParentheses((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis)).isAtEnd() && (beforeLeftParen = leftParen.beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, GoElement.NewLine})).matchesRule(it -> it.isAt(GoTypes.VAR) || it.isAt(GoTypes.CONST) || it.isAt(GoTypes.TYPE_) || it.isAt(GoTypes.IMPORT))) {
            return beforeLeftParen;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "at";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallbackIndentType";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/formatter/GoLineIndentProvider";
                break;
            }
            case 12: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p1";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/formatter/GoLineIndentProvider";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentTypeInsideParens";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "mapType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableForLanguage";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAt";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getIndentTypeInsideParens";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isTheSameLineLeftParenthesis";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isLeftParenthesis";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prevLeft";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "prevLeftBrace";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAtSameLineBeforeRBrace";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isAtSameLine";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getStatementStartOffset";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "moveToNewlineBackwards";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isAtCaseColon";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "moveBeforeParentheses";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findBlockStartForRParen";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }

    private static enum GoElement implements SemanticEditorPosition.SyntaxElement
    {
        Switch,
        Select,
        NewLine,
        Func;

    }
}

