/*
 * Decompiled with CFR 0.152.
 */
package com.goide;

import com.goide.psi.GoInternedLeafTokenType;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoCharTable
implements CharTable {
    private static final String[] TABS;
    private static final String[] NEWLINES;
    private static final int DEFAULT_TABLE_INTERN_THRESHOLD = 40;
    private final CharTable myDefaultTable = new CharTableImpl();
    private IElementType myCurrentToken;

    public void setCurrentToken(@Nullable IElementType currentToken) {
        this.myCurrentToken = currentToken;
    }

    @NotNull
    public CharSequence intern(@NotNull CharSequence text) {
        if (text == null) {
            GoCharTable.$$$reportNull$$$0(0);
        }
        CharSequence charSequence = this.intern(text, 0, text.length());
        if (charSequence == null) {
            GoCharTable.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    @NotNull
    public CharSequence intern(@NotNull CharSequence text, int startOffset, int endOffset) {
        IElementType token;
        if (text == null) {
            GoCharTable.$$$reportNull$$$0(2);
        }
        if ((token = this.myCurrentToken) instanceof GoInternedLeafTokenType) {
            String string = ((GoInternedLeafTokenType)token).getInternedChars();
            if (string == null) {
                GoCharTable.$$$reportNull$$$0(3);
            }
            return string;
        }
        int len = endOffset - startOffset;
        if (len > 0) {
            String[] table;
            char c = text.charAt(startOffset);
            switch (c) {
                case '\t': {
                    String[] stringArray = TABS;
                    break;
                }
                case '\n': {
                    String[] stringArray = NEWLINES;
                    break;
                }
                default: {
                    String[] stringArray = table = null;
                }
            }
            if (table != null && len < table.length) {
                boolean same = true;
                for (int i = endOffset - 1; i > startOffset; --i) {
                    if (text.charAt(i) == c) continue;
                    same = false;
                    break;
                }
                if (same) {
                    String string = table[len];
                    if (string == null) {
                        GoCharTable.$$$reportNull$$$0(4);
                    }
                    return string;
                }
            }
        }
        if (len > 40) {
            CharSequence charSequence = text.subSequence(startOffset, endOffset);
            if (charSequence == null) {
                GoCharTable.$$$reportNull$$$0(5);
            }
            return charSequence;
        }
        CharSequence charSequence = this.myDefaultTable.intern(text, startOffset, endOffset);
        if (charSequence == null) {
            GoCharTable.$$$reportNull$$$0(6);
        }
        return charSequence;
    }

    static {
        int i;
        TABS = new String[16];
        for (i = 0; i < TABS.length; ++i) {
            GoCharTable.TABS[i] = "\t".repeat(i);
        }
        NEWLINES = new String[4];
        for (i = 0; i < NEWLINES.length; ++i) {
            GoCharTable.NEWLINES[i] = "\n".repeat(i);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/GoCharTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/GoCharTable";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "intern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "intern";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

