/*
 * Decompiled with CFR 0.152.
 */
package com.goide.actions.debugger;

import com.goide.dlv.DlvDisconnectOption;
import com.goide.dlv.attach.DlvDebugSessionStarter;
import com.goide.execution.GoModuleBasedConfiguration;
import com.goide.execution.GoRunConfigurationBase;
import com.goide.execution.GoRunUtil;
import com.goide.execution.GoRunningState;
import com.goide.execution.application.GoApplicationConfiguration;
import com.goide.i18n.GoBundle;
import com.goide.util.GoElfUtil;
import com.goide.util.GoExecutor;
import com.goide.util.GoWinUtil;
import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.layout.LayoutAttractionPolicy;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.net.InetSocketAddress;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoDebugCoreDumpAction
extends AnAction
implements DumbAware {
    @NonNls
    private static final String RECENT_EXECUTABLE_KEY = "GoDebugCoreDumpAction.RECENT_EXECUTABLE_KEY";
    @NonNls
    private static final String RECENT_CORE_DUMP_KEY = "GoDebugCoreDumpAction.RECENT_CORE_DUMP_KEY";

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GoDebugCoreDumpAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GoDebugCoreDumpAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            GoDebugCoreDumpAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        CoreDumpDialog dialog = new CoreDumpDialog(project);
        if (dialog.showAndGet()) {
            RecentsManager.getInstance((Project)project).registerRecentEntry(RECENT_EXECUTABLE_KEY, dialog.getExecutable());
            RecentsManager.getInstance((Project)project).registerRecentEntry(RECENT_CORE_DUMP_KEY, dialog.getCoreDump());
            try {
                new DlvDebugCoreDumpSessionStarter(project, dialog.getExecutable(), dialog.getCoreDump()).start();
            }
            catch (ExecutionException ex) {
                Messages.showErrorDialog((Project)project, (String)GoBundle.message((String)"go.core.dump.failed.to.start.error.message", (Object[])new Object[]{dialog.getCoreDump(), ex.getMessage()}), (String)CommonBundle.getErrorTitle());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/actions/debugger/GoDebugCoreDumpAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/actions/debugger/GoDebugCoreDumpAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static class CoreDumpDialog
    extends DialogWrapper {
        private final Project myProject;
        private final TextFieldWithHistoryWithBrowseButton myExecutable;
        private final TextFieldWithHistoryWithBrowseButton myCoreDump;

        protected CoreDumpDialog(@NotNull Project project) {
            if (project == null) {
                CoreDumpDialog.$$$reportNull$$$0(0);
            }
            super(project, false);
            this.myProject = project;
            this.myExecutable = this.createPathField(RecentsManager.getInstance((Project)project).getRecentEntries(GoDebugCoreDumpAction.RECENT_EXECUTABLE_KEY));
            this.myCoreDump = this.createPathField(RecentsManager.getInstance((Project)project).getRecentEntries(GoDebugCoreDumpAction.RECENT_CORE_DUMP_KEY));
            this.init();
        }

        @NotNull
        public String getExecutable() {
            String string = this.myExecutable.getText();
            if (string == null) {
                CoreDumpDialog.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getCoreDump() {
            String string = this.myCoreDump.getText();
            if (string == null) {
                CoreDumpDialog.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myExecutable;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JPanel result = new JPanel(new BorderLayout());
            result.setPreferredSize((Dimension)JBUI.size((int)500, (int)0));
            result.add((Component)FormBuilder.createFormBuilder().addLabeledComponent(GoBundle.message((String)"go.core.dump.dialog.executable.label", (Object[])new Object[0]), (JComponent)this.myExecutable).addLabeledComponent(GoBundle.message((String)"go.core.dump.dialog.dump.path.label", (Object[])new Object[0]), (JComponent)this.myCoreDump).getPanel(), "North");
            return result;
        }

        @NotNull
        protected List<ValidationInfo> doValidateAll() {
            String coreDump;
            SmartList errors = new SmartList();
            String executable = this.getExecutable();
            if (StringUtil.isEmptyOrSpaces((String)executable)) {
                errors.add(new ValidationInfo(GoBundle.message((String)"go.core.dump.dialog.specify.executable.validation.message", (Object[])new Object[0]), (JComponent)this.myExecutable));
            }
            if (!GoWinUtil.isWinExecutable(executable) && !GoElfUtil.isElfExecutable(executable)) {
                errors.add(new ValidationInfo(GoBundle.message((String)"go.core.dump.dialog.invalid.executable.validation.message", (Object[])new Object[0]), (JComponent)this.myExecutable));
            }
            if (StringUtil.isEmptyOrSpaces((String)(coreDump = this.getCoreDump()))) {
                errors.add(new ValidationInfo(GoBundle.message((String)"go.core.dump.dialog.specify.core.dump.validation.message", (Object[])new Object[0]), (JComponent)this.myCoreDump));
            }
            if (!GoWinUtil.isMiniDump(coreDump) && !GoElfUtil.isElfCoreDump(coreDump)) {
                errors.add(new ValidationInfo(GoBundle.message((String)"go.core.dump.dialog.invalid.core.dump.validation.message", (Object[])new Object[0]), (JComponent)this.myCoreDump));
            }
            SmartList smartList = errors;
            if (smartList == null) {
                CoreDumpDialog.$$$reportNull$$$0(3);
            }
            return smartList;
        }

        @NotNull
        private TextFieldWithHistoryWithBrowseButton createPathField(@Nullable List<String> history) {
            TextFieldWithHistoryWithBrowseButton result = new TextFieldWithHistoryWithBrowseButton();
            GoRunUtil.installFileChooser(this.myProject, result);
            if (history != null) {
                ((TextFieldWithHistory)result.getChildComponent()).setHistory(history);
            }
            result.setText((String)ContainerUtil.getFirstItem(history, (Object)""));
            TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = result;
            if (textFieldWithHistoryWithBrowseButton == null) {
                CoreDumpDialog.$$$reportNull$$$0(4);
            }
            return textFieldWithHistoryWithBrowseButton;
        }

        @Nullable
        protected String getHelpId() {
            return "Exploring_Go_core_dumps";
        }

        @Nullable
        protected String getDimensionServiceKey() {
            return CoreDumpDialog.class.getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/actions/debugger/GoDebugCoreDumpAction$CoreDumpDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/actions/debugger/GoDebugCoreDumpAction$CoreDumpDialog";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExecutable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCoreDump";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidateAll";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPathField";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    public static class DlvDebugCoreDumpSessionStarter
    extends DlvDebugSessionStarter {
        private final String myExecutable;
        private final String myCoreDump;

        public DlvDebugCoreDumpSessionStarter(@NotNull Project project, @NotNull String executable, @NotNull String coreDump) {
            if (project == null) {
                DlvDebugCoreDumpSessionStarter.$$$reportNull$$$0(0);
            }
            if (executable == null) {
                DlvDebugCoreDumpSessionStarter.$$$reportNull$$$0(1);
            }
            if (coreDump == null) {
                DlvDebugCoreDumpSessionStarter.$$$reportNull$$$0(2);
            }
            super(project);
            this.myExecutable = executable;
            this.myCoreDump = coreDump;
        }

        @Override
        @NotNull
        protected GoRunningState<GoRunConfigurationBase<?>> createState(@NotNull InetSocketAddress address, @NotNull ExecutionEnvironment env, @NotNull GoApplicationConfiguration configuration) {
            if (address == null) {
                DlvDebugCoreDumpSessionStarter.$$$reportNull$$$0(3);
            }
            if (env == null) {
                DlvDebugCoreDumpSessionStarter.$$$reportNull$$$0(4);
            }
            if (configuration == null) {
                DlvDebugCoreDumpSessionStarter.$$$reportNull$$$0(5);
            }
            return new GoDebugCoreDumpState(address, env, configuration, this.myExecutable, this.myCoreDump);
        }

        @Override
        @NotNull
        protected String getSessionName() {
            String string = GoBundle.message((String)"go.core.dump.session.name", (Object[])new Object[]{this.myCoreDump});
            if (string == null) {
                DlvDebugCoreDumpSessionStarter.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Override
        @NotNull
        protected XDebugProcessStarter createDebugProcessStarter(@NotNull InetSocketAddress address, @NotNull ExecutionResult executionResult) {
            if (address == null) {
                DlvDebugCoreDumpSessionStarter.$$$reportNull$$$0(7);
            }
            if (executionResult == null) {
                DlvDebugCoreDumpSessionStarter.$$$reportNull$$$0(8);
            }
            XDebugProcessStarter xDebugProcessStarter = GoRunUtil.createDelveXDebugStarter(address, executionResult, DlvDisconnectOption.KILL, true);
            if (xDebugProcessStarter == null) {
                DlvDebugCoreDumpSessionStarter.$$$reportNull$$$0(9);
            }
            return xDebugProcessStarter;
        }

        @Override
        protected void customizeDebugSession(@NotNull XDebugSession session) {
            if (session == null) {
                DlvDebugCoreDumpSessionStarter.$$$reportNull$$$0(10);
            }
            if (session instanceof XDebugSessionImpl) {
                XDebugSessionImpl sessionImpl = (XDebugSessionImpl)session;
                sessionImpl.setReadOnly(true);
            }
            session.getUI().getDefaults().initContentAttraction("FrameContent", "startup", (LayoutAttractionPolicy)new LayoutAttractionPolicy.FocusOnce(false));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "coreDump";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "address";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "env";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/actions/debugger/GoDebugCoreDumpAction$DlvDebugCoreDumpSessionStarter";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executionResult";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/actions/debugger/GoDebugCoreDumpAction$DlvDebugCoreDumpSessionStarter";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSessionName";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDebugProcessStarter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createState";
                    break;
                }
                case 6: 
                case 9: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createDebugProcessStarter";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "customizeDebugSession";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 9 -> new IllegalStateException(string);
            };
        }
    }

    public static class GoDebugCoreDumpState
    extends GoRunningState<GoRunConfigurationBase<?>> {
        private final String myExecutable;
        private final String myCoreDump;
        private final InetSocketAddress myDebugAddress;

        public GoDebugCoreDumpState(@NotNull InetSocketAddress debugAddress, @NotNull ExecutionEnvironment env, @NotNull GoRunConfigurationBase<?> configuration, @NotNull String executable, @NotNull String coreDump) {
            if (debugAddress == null) {
                GoDebugCoreDumpState.$$$reportNull$$$0(0);
            }
            if (env == null) {
                GoDebugCoreDumpState.$$$reportNull$$$0(1);
            }
            if (configuration == null) {
                GoDebugCoreDumpState.$$$reportNull$$$0(2);
            }
            if (executable == null) {
                GoDebugCoreDumpState.$$$reportNull$$$0(3);
            }
            if (coreDump == null) {
                GoDebugCoreDumpState.$$$reportNull$$$0(4);
            }
            super(env, ((GoModuleBasedConfiguration)configuration.getConfigurationModule()).getModule(), configuration);
            this.myDebugAddress = debugAddress;
            this.myExecutable = executable;
            this.myCoreDump = coreDump;
        }

        @Override
        @NotNull
        public InetSocketAddress getDebugServerAddress() {
            InetSocketAddress inetSocketAddress = this.myDebugAddress;
            if (inetSocketAddress == null) {
                GoDebugCoreDumpState.$$$reportNull$$$0(5);
            }
            return inetSocketAddress;
        }

        @Override
        protected GoExecutor createRunExecutor() throws ExecutionException {
            return this.createDelveExecutor().withParameters("core").withPathParameters(this.myExecutable, this.myCoreDump).withParameters("--");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debugAddress";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "env";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executable";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "coreDump";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/actions/debugger/GoDebugCoreDumpAction$GoDebugCoreDumpState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/actions/debugger/GoDebugCoreDumpAction$GoDebugCoreDumpState";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDebugServerAddress";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

