/*
 * Decompiled with CFR 0.152.
 */
package com.goide.completion;

import com.goide.GoTypes;
import com.goide.completion.GoCompletionUtil;
import com.goide.completion.GoKeywordCompletionContributor;
import com.goide.completion.GoKeywordCompletionProvider;
import com.goide.i18n.GoBundle;
import com.goide.inspections.GoInspectionUtil;
import com.goide.inspections.GoRedundantTypeDeclInCompositeLit;
import com.goide.psi.GoArgumentList;
import com.goide.psi.GoArrayOrSliceType;
import com.goide.psi.GoCodeFragment;
import com.goide.psi.GoCompositeLit;
import com.goide.psi.GoDeferStatement;
import com.goide.psi.GoElement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionType;
import com.goide.psi.GoGoStatement;
import com.goide.psi.GoLeftHandExprList;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoMapType;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoReferenceExpressionBase;
import com.goide.psi.GoSignature;
import com.goide.psi.GoStructType;
import com.goide.psi.GoType;
import com.goide.psi.GoValue;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.refactor.template.GoTemplate;
import com.goide.util.GoUtil;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoLiteralCompletionContributor
extends CompletionContributor {
    public GoLiteralCompletionContributor() {
        this.extend(null, GoLiteralCompletionContributor.notInCodeFragment(GoKeywordCompletionContributor.referenceExpression()), new LiteralCompletionProvider(new StructLiteralCompletion()));
        this.extend(null, GoKeywordCompletionContributor.referenceExpression(), new LiteralCompletionProvider(new MapLiteralCompletion()));
        this.extend(null, GoKeywordCompletionContributor.referenceExpression(), new LiteralCompletionProvider(new SliceLiteralCompletion()));
        this.extend(null, GoKeywordCompletionContributor.referenceExpression(), new LiteralCompletionProvider(new ArrayLiteralCompletion()));
        this.extend(null, StandardPatterns.or((ElementPattern[])new ElementPattern[]{GoLiteralCompletionContributor.insideGoOrDeferStatements(), GoLiteralCompletionContributor.anonymousFunction()}), new LiteralCompletionProvider(new FuncLiteralCompletion()));
    }

    private static boolean isAccessibleFieldValue(@NotNull GoLiteralValue literalValue, GoStructType structType, @NotNull GoElement element) {
        if (literalValue == null) {
            GoLiteralCompletionContributor.$$$reportNull$$$0(0);
        }
        if (element == null) {
            GoLiteralCompletionContributor.$$$reportNull$$$0(1);
        }
        int elementIndex = literalValue.getElementList().indexOf(element);
        List<GoNamedElement> definitions = structType.getFieldDefinitions();
        if (elementIndex >= 0 && elementIndex < definitions.size()) {
            GoNamedElement field = definitions.get(elementIndex);
            PsiFile elementFile = element.getContainingFile().getOriginalFile();
            PsiFile typeFile = structType.getContainingFile();
            boolean isStructFromCurrentPackage = GoUtil.isDirectlyAccessible(typeFile, elementFile);
            if (GoInspectionUtil.canAccessField(field, isStructFromCurrentPackage)) {
                return true;
            }
        }
        return false;
    }

    private static boolean canOmitType(@NotNull InsertionContext context, @NotNull GoType type) {
        PsiElement at;
        if (context == null) {
            GoLiteralCompletionContributor.$$$reportNull$$$0(2);
        }
        if (type == null) {
            GoLiteralCompletionContributor.$$$reportNull$$$0(3);
        }
        if (GoPsiUtil.isCompositeLiteralElementValue(at = context.getFile().findElementAt(context.getStartOffset()))) {
            GoValue value = (GoValue)PsiTreeUtil.getParentOfType((PsiElement)at, GoValue.class);
            GoCompositeLit compositeLit = (GoCompositeLit)PsiTreeUtil.getParentOfType((PsiElement)value, GoCompositeLit.class);
            GoType expectedType = compositeLit != null ? GoTypeUtil.getExpectedValueType(compositeLit) : null;
            return GoRedundantTypeDeclInCompositeLit.canOmitDeclarationType(expectedType, type, at);
        }
        return false;
    }

    private static void startInlineTemplate(@NotNull InsertionContext context, @NotNull GoTemplate template) {
        if (context == null) {
            GoLiteralCompletionContributor.$$$reportNull$$$0(4);
        }
        if (template == null) {
            GoLiteralCompletionContributor.$$$reportNull$$$0(5);
        }
        if (GoCompletionUtil.isAtElementValueWithNewLineCheap(context)) {
            template.addTextSegment(",");
        }
        int offset = context.getStartOffset();
        TextRange rangeToRemove = new TextRange(offset, context.getTailOffset());
        template.startTemplate(context.getEditor(), offset, GoBundle.message((String)"go.completion.insert.literal.command.name", (Object[])new Object[0]), rangeToRemove);
    }

    private static PsiElementPattern.Capture<PsiElement> insideGoOrDeferStatements() {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)GoTypes.IDENTIFIER).withParent((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement(GoReferenceExpressionBase.class).with((PatternCondition)new GoKeywordCompletionContributor.GoNonQualifiedReference())).withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement(GoDeferStatement.class), PlatformPatterns.psiElement(GoGoStatement.class)})));
    }

    private static ElementPattern<? extends PsiElement> anonymousFunction() {
        return StandardPatterns.and((ElementPattern[])new ElementPattern[]{GoKeywordCompletionContributor.referenceExpression(), PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(GoReferenceExpression.class).withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement(GoArgumentList.class), StandardPatterns.not((ElementPattern)PlatformPatterns.psiElement(GoLeftHandExprList.class))})))});
    }

    private static ElementPattern<? extends PsiElement> notInCodeFragment(@NotNull ElementPattern<? extends PsiElement> pattern) {
        if (pattern == null) {
            GoLiteralCompletionContributor.$$$reportNull$$$0(6);
        }
        return StandardPatterns.and((ElementPattern[])new ElementPattern[]{pattern, StandardPatterns.not((ElementPattern)PlatformPatterns.psiElement().inFile((ElementPattern)PlatformPatterns.psiElement(GoCodeFragment.class)))});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalValue";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        objectArray2[1] = "com/goide/completion/GoLiteralCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAccessibleFieldValue";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "canOmitType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "startInlineTemplate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "notInCodeFragment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class LiteralCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        @NotNull
        private final LiteralCompletion myCompletion;

        LiteralCompletionProvider(@NotNull LiteralCompletion completion) {
            if (completion == null) {
                LiteralCompletionProvider.$$$reportNull$$$0(0);
            }
            this.myCompletion = completion;
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                LiteralCompletionProvider.$$$reportNull$$$0(1);
            }
            if (context == null) {
                LiteralCompletionProvider.$$$reportNull$$$0(2);
            }
            if (result == null) {
                LiteralCompletionProvider.$$$reportNull$$$0(3);
            }
            if (GoPsiImplUtil.prevDot(parameters.getPosition().getParent())) {
                return;
            }
            CompletionItem item = this.myCompletion.getCompletionItem(parameters, parameters.getPosition());
            if (item.isSuitableFor(parameters.getCompletionType())) {
                Object lookupObject = item.getLookupObject();
                String presentationText = item.getPresentationText(parameters.getPosition(), (GoType)ObjectUtils.tryCast((Object)lookupObject, GoType.class));
                LookupElementBuilder builder = LookupElementBuilder.create((Object)lookupObject, (String)item.getLookupString()).withTailText(presentationText, true).withInsertHandler(this.myCompletion.getInsertHandler());
                int priority = 35;
                if (lookupObject instanceof GoType) {
                    priority += 4;
                }
                result.addElement(PrioritizedLookupElement.withPriority((LookupElement)builder, (double)priority));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "completion";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "com/goide/completion/GoLiteralCompletionContributor$LiteralCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class StructLiteralCompletion
    extends LiteralCompletion {
        private StructLiteralCompletion() {
            super(GoStructType.class);
        }

        @Override
        @NotNull
        CompletionItem getCompletionItem(@NotNull CompletionParameters parameters, @NotNull PsiElement position) {
            if (parameters == null) {
                StructLiteralCompletion.$$$reportNull$$$0(0);
            }
            if (position == null) {
                StructLiteralCompletion.$$$reportNull$$$0(1);
            }
            return new CompletionItem(ObjectUtils.notNull((Object)this.findExpectedType(parameters), (Object)"struct"), "struct", " {...}{}");
        }

        @Override
        @NotNull
        InsertHandler<LookupElement> getInsertHandler() {
            StructLiteralInsertHandler structLiteralInsertHandler = StructLiteralInsertHandler.INSTANCE;
            if (structLiteralInsertHandler == null) {
                StructLiteralCompletion.$$$reportNull$$$0(2);
            }
            return structLiteralInsertHandler;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/completion/GoLiteralCompletionContributor$StructLiteralCompletion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/completion/GoLiteralCompletionContributor$StructLiteralCompletion";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInsertHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getCompletionItem";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static abstract class LiteralCompletion {
        protected final Class<? extends GoType> myTypeClass;

        private LiteralCompletion(@NotNull Class<? extends GoType> typeClass) {
            if (typeClass == null) {
                LiteralCompletion.$$$reportNull$$$0(0);
            }
            this.myTypeClass = typeClass;
        }

        @NotNull
        abstract CompletionItem getCompletionItem(@NotNull CompletionParameters var1, @NotNull PsiElement var2);

        @NotNull
        abstract InsertHandler<LookupElement> getInsertHandler();

        @Nullable
        protected GoType findExpectedType(@NotNull CompletionParameters parameters) {
            GoExpression expression;
            if (parameters == null) {
                LiteralCompletion.$$$reportNull$$$0(1);
            }
            if (parameters.getOriginalFile() instanceof GoFile && (expression = (GoExpression)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), GoExpression.class)) != null) {
                if (GoPsiUtil.isCompositeLiteralElementValue(expression)) {
                    GoType elementType;
                    PsiElement resolved;
                    GoValue value = (GoValue)PsiTreeUtil.getParentOfType((PsiElement)expression, GoValue.class);
                    GoElement element = (GoElement)ObjectUtils.tryCast((Object)(value != null ? value.getParent() : null), GoElement.class);
                    GoLiteralValue literalValue = (GoLiteralValue)PsiTreeUtil.getParentOfType((PsiElement)element, GoLiteralValue.class);
                    GoType literalValueType = GoInspectionUtil.getLiteralValueUnderlyingType(literalValue);
                    if (literalValueType instanceof GoStructType && !GoLiteralCompletionContributor.isAccessibleFieldValue(literalValue, (GoStructType)literalValueType, element)) {
                        return null;
                    }
                    if (literalValueType instanceof GoArrayOrSliceType && GoPsiUtil.isUnexportedAndFromOtherPackage(resolved = (elementType = ((GoArrayOrSliceType)literalValueType).getType()).resolve(elementType), literalValue)) {
                        return null;
                    }
                    if (literalValueType instanceof GoMapType) {
                        if (element.getKey() == null) {
                            return null;
                        }
                        GoType mapValueType = ((GoMapType)literalValueType).getValueType();
                        PsiElement psiElement = resolved = mapValueType != null ? mapValueType.resolve(mapValueType) : null;
                        if (GoPsiUtil.isUnexportedAndFromOtherPackage(resolved, literalValue)) {
                            return null;
                        }
                    }
                }
                return (GoType)ContainerUtil.findInstance((Iterable)ContainerUtil.map(GoTypeUtil.getExpectedTypes(expression, expression).getTypes(), t -> t.getUnderlyingType(expression)), this.myTypeClass);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
            }
            objectArray2[1] = "com/goide/completion/GoLiteralCompletionContributor$LiteralCompletion";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findExpectedType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MapLiteralCompletion
    extends LiteralCompletion {
        private MapLiteralCompletion() {
            super(GoMapType.class);
        }

        @Override
        @NotNull
        CompletionItem getCompletionItem(@NotNull CompletionParameters parameters, @NotNull PsiElement position) {
            if (parameters == null) {
                MapLiteralCompletion.$$$reportNull$$$0(0);
            }
            if (position == null) {
                MapLiteralCompletion.$$$reportNull$$$0(1);
            }
            GoType mapType = this.findExpectedType(parameters);
            String presentationText = GoPsiImplUtil.getPresentationText(mapType).replaceFirst("map", "") + "{...}";
            return new CompletionItem(ObjectUtils.notNull((Object)mapType, (Object)"map"), "map", presentationText);
        }

        @Override
        @NotNull
        InsertHandler<LookupElement> getInsertHandler() {
            MapLiteralInsertHandler mapLiteralInsertHandler = MapLiteralInsertHandler.INSTANCE;
            if (mapLiteralInsertHandler == null) {
                MapLiteralCompletion.$$$reportNull$$$0(2);
            }
            return mapLiteralInsertHandler;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/completion/GoLiteralCompletionContributor$MapLiteralCompletion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/completion/GoLiteralCompletionContributor$MapLiteralCompletion";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInsertHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getCompletionItem";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static final class SliceLiteralCompletion
    extends LiteralCompletion {
        private SliceLiteralCompletion() {
            super(GoArrayOrSliceType.class);
        }

        @Override
        @NotNull
        CompletionItem getCompletionItem(@NotNull CompletionParameters parameters, @NotNull PsiElement position) {
            if (parameters == null) {
                SliceLiteralCompletion.$$$reportNull$$$0(0);
            }
            if (position == null) {
                SliceLiteralCompletion.$$$reportNull$$$0(1);
            }
            GoArrayOrSliceType type = (GoArrayOrSliceType)ObjectUtils.tryCast((Object)this.findExpectedType(parameters), GoArrayOrSliceType.class);
            String presentationText = GoPsiImplUtil.getPresentationText(type) + "{...}";
            return new CompletionItem(ObjectUtils.notNull((Object)(!GoTypeUtil.isArray(type, position) ? type : null), (Object)"slice"), "slice", presentationText);
        }

        @Override
        @NotNull
        InsertHandler<LookupElement> getInsertHandler() {
            ArrayOrSliceLiteralInsertHandler arrayOrSliceLiteralInsertHandler = ArrayOrSliceLiteralInsertHandler.INSTANCE;
            if (arrayOrSliceLiteralInsertHandler == null) {
                SliceLiteralCompletion.$$$reportNull$$$0(2);
            }
            return arrayOrSliceLiteralInsertHandler;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/completion/GoLiteralCompletionContributor$SliceLiteralCompletion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/completion/GoLiteralCompletionContributor$SliceLiteralCompletion";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInsertHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getCompletionItem";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static final class ArrayLiteralCompletion
    extends LiteralCompletion {
        private ArrayLiteralCompletion() {
            super(GoArrayOrSliceType.class);
        }

        @Override
        @NotNull
        CompletionItem getCompletionItem(@NotNull CompletionParameters parameters, @NotNull PsiElement position) {
            if (parameters == null) {
                ArrayLiteralCompletion.$$$reportNull$$$0(0);
            }
            if (position == null) {
                ArrayLiteralCompletion.$$$reportNull$$$0(1);
            }
            GoArrayOrSliceType type = (GoArrayOrSliceType)ObjectUtils.tryCast((Object)this.findExpectedType(parameters), GoArrayOrSliceType.class);
            String presentationText = GoPsiImplUtil.getPresentationText(type) + "{...}";
            return new CompletionItem(ObjectUtils.notNull((Object)(GoTypeUtil.isArray(type, position) ? type : null), (Object)"array"), "array", presentationText);
        }

        @Override
        @NotNull
        InsertHandler<LookupElement> getInsertHandler() {
            ArrayOrSliceLiteralInsertHandler arrayOrSliceLiteralInsertHandler = ArrayOrSliceLiteralInsertHandler.INSTANCE;
            if (arrayOrSliceLiteralInsertHandler == null) {
                ArrayLiteralCompletion.$$$reportNull$$$0(2);
            }
            return arrayOrSliceLiteralInsertHandler;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/completion/GoLiteralCompletionContributor$ArrayLiteralCompletion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/completion/GoLiteralCompletionContributor$ArrayLiteralCompletion";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInsertHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getCompletionItem";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static final class FuncLiteralCompletion
    extends LiteralCompletion {
        private FuncLiteralCompletion() {
            super(GoFunctionType.class);
        }

        @Override
        @NotNull
        CompletionItem getCompletionItem(@NotNull CompletionParameters parameters, @NotNull PsiElement position) {
            if (parameters == null) {
                FuncLiteralCompletion.$$$reportNull$$$0(0);
            }
            if (position == null) {
                FuncLiteralCompletion.$$$reportNull$$$0(1);
            }
            final boolean insideGoOrDefer = GoLiteralCompletionContributor.insideGoOrDeferStatements().accepts((Object)parameters.getPosition());
            Object lookupObject = ObjectUtils.notNull((Object)this.findExpectedType(parameters), (Object)(insideGoOrDefer ? "func_call" : "func"));
            return new CompletionItem(lookupObject, "func", null){

                @Override
                boolean isSuitableFor(@NotNull CompletionType completionType) {
                    if (completionType == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return super.isSuitableFor(completionType) || insideGoOrDefer;
                }

                @Override
                @NotNull
                String getPresentationText(@NotNull PsiElement position, @Nullable GoType expectedType) {
                    if (position == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (insideGoOrDefer) {
                        return "() {...}()";
                    }
                    String string = GoPsiImplUtil.getPresentationText(expectedType).replaceFirst("func", "") + " {...}";
                    if (string == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 2 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "completionType";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "position";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/goide/completion/GoLiteralCompletionContributor$FuncLiteralCompletion$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/goide/completion/GoLiteralCompletionContributor$FuncLiteralCompletion$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getPresentationText";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "isSuitableFor";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "getPresentationText";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 2 -> new IllegalStateException(string);
                    };
                }
            };
        }

        @Override
        @NotNull
        InsertHandler<LookupElement> getInsertHandler() {
            FuncLiteralInsertHandler funcLiteralInsertHandler = FuncLiteralInsertHandler.INSTANCE;
            if (funcLiteralInsertHandler == null) {
                FuncLiteralCompletion.$$$reportNull$$$0(2);
            }
            return funcLiteralInsertHandler;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/completion/GoLiteralCompletionContributor$FuncLiteralCompletion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/completion/GoLiteralCompletionContributor$FuncLiteralCompletion";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInsertHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getCompletionItem";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class ArrayOrSliceLiteralInsertHandler
    extends LiteralInsertHandler {
        private static final ArrayOrSliceLiteralInsertHandler INSTANCE = new ArrayOrSliceLiteralInsertHandler();

        private ArrayOrSliceLiteralInsertHandler() {
        }

        @Override
        protected boolean handleInsert(@NotNull InsertionContext context, @NotNull PsiElement element) {
            GoArrayOrSliceType type;
            if (context == null) {
                ArrayOrSliceLiteralInsertHandler.$$$reportNull$$$0(0);
            }
            if (element == null) {
                ArrayOrSliceLiteralInsertHandler.$$$reportNull$$$0(1);
            }
            if ((type = (GoArrayOrSliceType)ObjectUtils.tryCast((Object)element, GoArrayOrSliceType.class)) == null) {
                return false;
            }
            GoTemplate template = new GoTemplate((GoFile)context.getFile());
            if (GoLiteralCompletionContributor.canOmitType(context, type)) {
                template.setupBracesWithEndVariableBetween(false);
            } else {
                template.setupArrayOrSliceLiteral(type);
            }
            GoLiteralCompletionContributor.startInlineTemplate(context, template);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "com/goide/completion/GoLiteralCompletionContributor$ArrayOrSliceLiteralInsertHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MapLiteralInsertHandler
    extends LiteralInsertHandler {
        private static final MapLiteralInsertHandler INSTANCE = new MapLiteralInsertHandler();

        private MapLiteralInsertHandler() {
        }

        @Override
        protected boolean handleInsert(@NotNull InsertionContext context, @NotNull PsiElement element) {
            GoMapType mapType;
            if (context == null) {
                MapLiteralInsertHandler.$$$reportNull$$$0(0);
            }
            if (element == null) {
                MapLiteralInsertHandler.$$$reportNull$$$0(1);
            }
            if ((mapType = (GoMapType)ObjectUtils.tryCast((Object)element, GoMapType.class)) == null) {
                return false;
            }
            GoTemplate template = new GoTemplate((GoFile)context.getFile());
            if (GoLiteralCompletionContributor.canOmitType(context, mapType)) {
                template.setupBracesWithEndVariableBetween(false);
            } else {
                template.setupMapLiteral(mapType);
            }
            GoLiteralCompletionContributor.startInlineTemplate(context, template);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "com/goide/completion/GoLiteralCompletionContributor$MapLiteralInsertHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FuncLiteralInsertHandler
    extends LiteralInsertHandler {
        private static final FuncLiteralInsertHandler INSTANCE = new FuncLiteralInsertHandler();

        private FuncLiteralInsertHandler() {
        }

        @Override
        protected boolean handleInsert(@NotNull InsertionContext context, @NotNull PsiElement element) {
            GoFunctionType funcType;
            GoSignature signature;
            if (context == null) {
                FuncLiteralInsertHandler.$$$reportNull$$$0(0);
            }
            if (element == null) {
                FuncLiteralInsertHandler.$$$reportNull$$$0(1);
            }
            GoSignature goSignature = signature = (funcType = (GoFunctionType)ObjectUtils.tryCast((Object)element, GoFunctionType.class)) != null ? funcType.getSignature() : null;
            if (signature == null) {
                return false;
            }
            GoTemplate template = new GoTemplate((GoFile)context.getFile());
            template.addTextSegment("func");
            template.setupSignature(signature, false, false);
            template.addTextSegment(" ");
            template.setupBracesWithEndVariableBetween();
            GoLiteralCompletionContributor.startInlineTemplate(context, template);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "com/goide/completion/GoLiteralCompletionContributor$FuncLiteralInsertHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class StructLiteralInsertHandler
    extends LiteralInsertHandler {
        private static final StructLiteralInsertHandler INSTANCE = new StructLiteralInsertHandler();

        private StructLiteralInsertHandler() {
        }

        @Override
        protected boolean handleInsert(@NotNull InsertionContext context, @NotNull PsiElement element) {
            GoStructType structType;
            if (context == null) {
                StructLiteralInsertHandler.$$$reportNull$$$0(0);
            }
            if (element == null) {
                StructLiteralInsertHandler.$$$reportNull$$$0(1);
            }
            if ((structType = (GoStructType)ObjectUtils.tryCast((Object)element, GoStructType.class)) == null) {
                return false;
            }
            GoTemplate template = new GoTemplate((GoFile)context.getFile());
            if (GoLiteralCompletionContributor.canOmitType(context, structType)) {
                template.setupStructWithImplicitType(structType);
            } else {
                template.setupStruct(structType);
            }
            GoLiteralCompletionContributor.startInlineTemplate(context, template);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "com/goide/completion/GoLiteralCompletionContributor$StructLiteralInsertHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LiteralInsertHandler
    implements InsertHandler<LookupElement> {
        private LiteralInsertHandler() {
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            PsiElement element;
            if (context == null) {
                LiteralInsertHandler.$$$reportNull$$$0(0);
            }
            if (item == null) {
                LiteralInsertHandler.$$$reportNull$$$0(1);
            }
            if ((element = item.getPsiElement()) != null && element.isValid() && this.handleInsert(context, element)) {
                return;
            }
            Object object = item.getObject();
            String templateId = "go_lang_anonymous_" + (object instanceof String ? (String)object : item.getLookupString());
            GoKeywordCompletionProvider.runTemplateBasedInsertHandler(templateId, context);
        }

        protected boolean handleInsert(@NotNull InsertionContext context, @NotNull PsiElement element) {
            if (context == null) {
                LiteralInsertHandler.$$$reportNull$$$0(2);
            }
            if (element == null) {
                LiteralInsertHandler.$$$reportNull$$$0(3);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "com/goide/completion/GoLiteralCompletionContributor$LiteralInsertHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CompletionItem {
        @NotNull
        private final Object myLookupObject;
        @NotNull
        private final String myLookupString;
        @Nullable
        private final String myPresentationText;

        CompletionItem(@NotNull Object lookupObject, @NotNull String lookupString, @Nullable String presentationText) {
            if (lookupObject == null) {
                CompletionItem.$$$reportNull$$$0(0);
            }
            if (lookupString == null) {
                CompletionItem.$$$reportNull$$$0(1);
            }
            this.myLookupObject = lookupObject;
            this.myLookupString = lookupString;
            this.myPresentationText = presentationText;
        }

        @NotNull
        Object getLookupObject() {
            Object object = this.myLookupObject;
            if (object == null) {
                CompletionItem.$$$reportNull$$$0(2);
            }
            return object;
        }

        @NotNull
        String getLookupString() {
            String string = this.myLookupString;
            if (string == null) {
                CompletionItem.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        String getPresentationText(@NotNull PsiElement position, @Nullable GoType expectedType) {
            if (position == null) {
                CompletionItem.$$$reportNull$$$0(4);
            }
            return this.myPresentationText;
        }

        boolean isSuitableFor(@NotNull CompletionType completionType) {
            if (completionType == null) {
                CompletionItem.$$$reportNull$$$0(5);
            }
            return completionType != CompletionType.SMART || this.myLookupObject instanceof GoType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lookupObject";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lookupString";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/completion/GoLiteralCompletionContributor$CompletionItem";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "completionType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/completion/GoLiteralCompletionContributor$CompletionItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupObject";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentationText";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isSuitableFor";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

