/*
 * Decompiled with CFR 0.152.
 */
package com.goide.completion;

import com.goide.codeInsight.GoCodeInsightSettings;
import com.goide.psi.GoParameterDeclaration;
import com.goide.psi.GoParameters;
import com.goide.psi.GoPointerType;
import com.goide.psi.GoResult;
import com.goide.psi.GoType;
import com.goide.refactor.GoNamesValidator;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoParameterNameDecorator {
    private static final Map<String, String> WELL_KNOWN_QUALIFIED_PARAMETER_ALIASES = Map.of("builtin.error", "err", "context.Context", "ctx", "http.ResponseWriter", "w", "http.Request", "r", "http.Client", "client");
    private static final Map<String, String> WELL_KNOWN_PARAMETER_SHORTCUTS = Map.of("error", "err", "context", "ctx");

    @NotNull
    public static LookupElement withParameterNameIfNeeded(final @NotNull LookupElement origin, @NotNull String qualifiedName, @NotNull Set<String> usedNames) {
        if (origin == null) {
            GoParameterNameDecorator.$$$reportNull$$$0(0);
        }
        if (qualifiedName == null) {
            GoParameterNameDecorator.$$$reportNull$$$0(1);
        }
        if (usedNames == null) {
            GoParameterNameDecorator.$$$reportNull$$$0(2);
        }
        if (!GoCodeInsightSettings.getInstance().isSuggestParametersNames() || qualifiedName.isEmpty()) {
            LookupElement lookupElement = origin;
            if (lookupElement == null) {
                GoParameterNameDecorator.$$$reportNull$$$0(3);
            }
            return lookupElement;
        }
        final String paramName = GoParameterNameDecorator.suggestParameterName(qualifiedName, usedNames);
        if (paramName.isEmpty()) {
            LookupElement lookupElement = origin;
            if (lookupElement == null) {
                GoParameterNameDecorator.$$$reportNull$$$0(4);
            }
            return lookupElement;
        }
        LookupElementDecorator lookupElementDecorator = LookupElementDecorator.withInsertHandler((LookupElement)LookupElementDecorator.withRenderer((LookupElement)origin, (LookupElementRenderer)new LookupElementRenderer<LookupElementDecorator<LookupElement>>(){

            public void renderElement(LookupElementDecorator<LookupElement> element, LookupElementPresentation presentation) {
                origin.renderElement(presentation);
                if (StringUtil.isNotEmpty((String)paramName)) {
                    presentation.setItemText(paramName + " " + presentation.getItemText());
                }
            }
        }), (context, handler) -> {
            origin.handleInsert(context);
            if (StringUtil.isNotEmpty((String)paramName)) {
                PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(context.getDocument());
                PsiElement at = context.getFile().findElementAt(context.getStartOffset());
                GoPointerType pointer = (GoPointerType)PsiTreeUtil.getParentOfType((PsiElement)at, GoPointerType.class, (boolean)true, (Class[])new Class[]{GoParameterDeclaration.class});
                if (pointer != null) {
                    context.getDocument().insertString(pointer.getTextRange().getStartOffset(), (CharSequence)(paramName + " "));
                } else {
                    GoType type = (GoType)PsiTreeUtil.getParentOfType((PsiElement)at, GoType.class, (boolean)true, (Class[])new Class[]{GoParameterDeclaration.class});
                    if (type != null) {
                        context.getDocument().insertString(type.getTextRange().getStartOffset(), (CharSequence)(paramName + " "));
                    }
                }
            }
        });
        if (lookupElementDecorator == null) {
            GoParameterNameDecorator.$$$reportNull$$$0(5);
        }
        return lookupElementDecorator;
    }

    public static boolean shouldSuggestNamesInParameters(@Nullable PsiElement parent) {
        GoParameterDeclaration currentDeclaration;
        PsiElement granny;
        if (!GoCodeInsightSettings.getInstance().isSuggestParametersNames()) {
            return false;
        }
        PsiElement psiElement = granny = parent != null ? parent.getParent() : null;
        if (!(granny instanceof GoType)) {
            return false;
        }
        PsiElement greatGranny = granny.getParent();
        if (greatGranny instanceof GoPointerType) {
            granny = greatGranny;
            greatGranny = greatGranny.getParent();
        }
        if ((currentDeclaration = (GoParameterDeclaration)ObjectUtils.tryCast((Object)greatGranny, GoParameterDeclaration.class)) == null || currentDeclaration.getFirstChild() != granny) {
            return false;
        }
        GoParameters parameters = (GoParameters)PsiTreeUtil.getParentOfType((PsiElement)currentDeclaration, GoParameters.class);
        if (parameters == null) {
            return false;
        }
        List<GoParameterDeclaration> parameterDeclarationList = parameters.getParameterDeclarationList();
        if (parameters.getParent() instanceof GoResult) {
            boolean hasNamedDefinitions = parameterDeclarationList.size() > 1 && ContainerUtil.exists(parameterDeclarationList, declaration -> declaration != currentDeclaration && !declaration.getParamDefinitionList().isEmpty());
            return hasNamedDefinitions;
        }
        boolean hasUnnamedDefinitions = parameterDeclarationList.size() > 1 && ContainerUtil.exists(parameterDeclarationList, declaration -> declaration != currentDeclaration && declaration.getParamDefinitionList().isEmpty());
        return !hasUnnamedDefinitions;
    }

    @NotNull
    private static String suggestParameterName(@NotNull String name, @NotNull Set<String> usedNames) {
        String alias;
        if (name == null) {
            GoParameterNameDecorator.$$$reportNull$$$0(6);
        }
        if (usedNames == null) {
            GoParameterNameDecorator.$$$reportNull$$$0(7);
        }
        if ((alias = GoParameterNameDecorator.generateNameFromMap(name, usedNames, WELL_KNOWN_QUALIFIED_PARAMETER_ALIASES)) != null) {
            String string = alias;
            if (string == null) {
                GoParameterNameDecorator.$$$reportNull$$$0(8);
            }
            return string;
        }
        JBIterable series = JBIterable.from((Iterable)NameUtil.getSuggestionsByName((String)name, (String)"", (String)"", (boolean)false, (boolean)false, (boolean)false)).filter(s -> GoNamesValidator.INSTANCE.isIdentifier((String)s, null));
        List filter = series.filter(s -> !usedNames.contains(s)).toList();
        String suggestedName = (String)ContainerUtil.getFirstItem((Collection)filter, (Object)UniqueNameGenerator.generateUniqueName((String)((String)ObjectUtils.notNull((Object)((String)series.first()), (Object)"p")), usedNames));
        String shortcut = GoParameterNameDecorator.generateNameFromMap(suggestedName, usedNames, WELL_KNOWN_PARAMETER_SHORTCUTS);
        String string = shortcut != null ? shortcut : suggestedName;
        if (string == null) {
            GoParameterNameDecorator.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    private static String generateNameFromMap(@NotNull String name, @NotNull Set<String> usedNames, @NotNull Map<String, String> aliases) {
        String wellKnown;
        if (name == null) {
            GoParameterNameDecorator.$$$reportNull$$$0(10);
        }
        if (usedNames == null) {
            GoParameterNameDecorator.$$$reportNull$$$0(11);
        }
        if (aliases == null) {
            GoParameterNameDecorator.$$$reportNull$$$0(12);
        }
        if ((wellKnown = aliases.get(name)) != null && usedNames.contains(wellKnown)) {
            return UniqueNameGenerator.generateUniqueName((String)wellKnown, usedNames);
        }
        return wellKnown;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 2: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedNames";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/completion/GoParameterNameDecorator";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aliases";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/completion/GoParameterNameDecorator";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withParameterNameIfNeeded";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestParameterName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withParameterNameIfNeeded";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "suggestParameterName";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "generateNameFromMap";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 8, 9 -> new IllegalStateException(string);
        };
    }
}

