/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dfa.translator;

import com.goide.dfa.GoDfaConfig;
import com.goide.dfa.translator.GoExpressionTranslatorKt;
import com.goide.dfa.translator.GoExpressionVisitor;
import com.goide.dfa.translator.GoPsiMapper;
import com.goide.intentions.negate.GoBooleanExpressionUtil;
import com.goide.psi.GoBinaryExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoUnaryExpr;
import com.intellij.rml.dfa.ir.ast.IrCondition;
import com.intellij.rml.dfa.ir.cfg.IrBoolExpr;
import com.intellij.rml.dfa.ir.cfg.IrBoolExprProvider;
import com.intellij.rml.dfa.ir.cfg.IrCfgRegionBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/goide/dfa/translator/GoBoolExprProvider;", "Lcom/intellij/rml/dfa/ir/cfg/IrBoolExprProvider;", "Lcom/goide/psi/GoExpression;", "config", "Lcom/goide/dfa/GoDfaConfig;", "psiMapper", "Lcom/goide/dfa/translator/GoPsiMapper;", "<init>", "(Lcom/goide/dfa/GoDfaConfig;Lcom/goide/dfa/translator/GoPsiMapper;)V", "parse", "Lcom/intellij/rml/dfa/ir/cfg/IrBoolExpr;", "expr", "translate", "Lcom/intellij/rml/dfa/ir/ast/IrCondition;", "condition", "builder", "Lcom/intellij/rml/dfa/ir/cfg/IrCfgRegionBuilder;", "intellij.go.dfa"})
public final class GoBoolExprProvider
implements IrBoolExprProvider<GoExpression> {
    @NotNull
    private final GoDfaConfig config;
    @NotNull
    private final GoPsiMapper psiMapper;

    public GoBoolExprProvider(@NotNull GoDfaConfig config, @NotNull GoPsiMapper psiMapper) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)psiMapper, (String)"psiMapper");
        this.config = config;
        this.psiMapper = psiMapper;
    }

    @NotNull
    public IrBoolExpr<GoExpression> parse(@NotNull GoExpression expr) {
        GoExpression rightOperand;
        GoBinaryExpr binaryExpr;
        GoExpression subExpr;
        GoExpression condition;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        GoExpression goExpression = expr.unwrapParentheses();
        if (goExpression == null) {
            goExpression = expr;
        }
        if ((condition = goExpression) instanceof GoUnaryExpr && GoBooleanExpressionUtil.isLogicalNotExpression(condition) && (subExpr = ((GoUnaryExpr)condition).getExpression()) != null) {
            return (IrBoolExpr)new IrBoolExpr.Not(this.parse(subExpr));
        }
        GoBinaryExpr goBinaryExpr = binaryExpr = condition instanceof GoBinaryExpr ? (GoBinaryExpr)condition : null;
        GoExpression leftOperand = goBinaryExpr != null ? goBinaryExpr.getLeft() : null;
        GoBinaryExpr goBinaryExpr2 = binaryExpr;
        GoExpression goExpression2 = rightOperand = goBinaryExpr2 != null ? goBinaryExpr2.getRight() : null;
        if (binaryExpr != null && rightOperand != null && GoBooleanExpressionUtil.isLogicalAndExpression(condition)) {
            GoExpression goExpression3 = leftOperand;
            Intrinsics.checkNotNull((Object)goExpression3);
            IrBoolExpr<GoExpression> left = this.parse(goExpression3);
            IrBoolExpr<GoExpression> right = this.parse(rightOperand);
            return (IrBoolExpr)new IrBoolExpr.And(left, right);
        }
        if (binaryExpr != null && rightOperand != null && GoBooleanExpressionUtil.isLogicalOrExpression(condition)) {
            GoExpression goExpression4 = leftOperand;
            Intrinsics.checkNotNull((Object)goExpression4);
            IrBoolExpr<GoExpression> left = this.parse(goExpression4);
            IrBoolExpr<GoExpression> right = this.parse(rightOperand);
            return (IrBoolExpr)new IrBoolExpr.Or(left, right);
        }
        return (IrBoolExpr)new IrBoolExpr.Condition((Object)condition);
    }

    @NotNull
    public IrCondition translate(@NotNull GoExpression condition, @NotNull IrCfgRegionBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        condition.accept(new GoExpressionVisitor(builder, this.psiMapper, true));
        return GoExpressionTranslatorKt.translateCoreCondition(condition, this.psiMapper, builder, this.config);
    }
}

