/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv;

import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DlvGoVersion
implements Comparable<DlvGoVersion> {
    @NonNls
    private static final String DEVEL = "devel";
    @NonNls
    private static final String BETA = "beta";
    @NonNls
    private static final String RC = "rc";
    @NonNls
    static final String GO_PREFIX = "go";
    private final int myMajor;
    private final int myMinor;
    private final int myRev;
    private final int myBeta;
    private final int myRC;

    DlvGoVersion(int major, int minor, int rev, int beta, int RC) {
        this.myMajor = major;
        this.myMinor = minor;
        this.myRev = rev;
        this.myBeta = beta;
        this.myRC = RC;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DlvGoVersion version = (DlvGoVersion)o;
        return this.myMajor == version.myMajor && this.myMinor == version.myMinor && this.myRev == version.myRev && this.myBeta == version.myBeta && this.myRC == version.myRC;
    }

    public int hashCode() {
        return Objects.hash(this.myMajor, this.myMinor, this.myRev, this.myBeta, this.myRC);
    }

    public int getMajor() {
        return this.myMajor;
    }

    public int getMinor() {
        return this.myMinor;
    }

    public String toString() {
        return "DlvGoVersion{myMajor=" + this.myMajor + ", myMinor=" + this.myMinor + ", myRev=" + this.myRev + ", myBeta=" + this.myBeta + ", myRC=" + this.myRC + "}";
    }

    boolean isDevel() {
        return this.myMajor < 0;
    }

    public boolean isAfterOrEqual(@NotNull DlvGoVersion other) {
        if (other == null) {
            DlvGoVersion.$$$reportNull$$$0(0);
        }
        return this.compareTo(other) >= 0;
    }

    @Override
    public int compareTo(@NotNull DlvGoVersion o) {
        if (o == null) {
            DlvGoVersion.$$$reportNull$$$0(1);
        }
        if (this.isDevel() && o.isDevel()) {
            return 0;
        }
        if (this.isDevel()) {
            return 1;
        }
        if (o.isDevel()) {
            return -1;
        }
        int sign = Integer.compare(this.myMajor, o.myMajor);
        if (sign != 0) {
            return sign;
        }
        sign = Integer.compare(this.myMinor, o.myMinor);
        if (sign != 0) {
            return sign;
        }
        sign = Integer.compare(this.myRev, o.myRev);
        if (sign != 0) {
            return sign;
        }
        sign = Integer.compare(this.myRC, o.myRC);
        if (sign != 0) {
            return sign;
        }
        return Integer.compare(this.myBeta, o.myBeta);
    }

    @Nullable
    public static DlvGoVersion parse(@Nullable String version) {
        if (version == null) {
            return null;
        }
        if (version.startsWith(DEVEL)) {
            return new DlvGoVersion(-1, 0, 0, 0, 0);
        }
        int spaceIdx = (version = StringUtil.trimStart((String)version, (String)GO_PREFIX)).indexOf(32);
        if (spaceIdx >= 0) {
            version = version.substring(0, spaceIdx);
        }
        List parts = StringUtil.split((String)version, (String)".");
        try {
            switch (parts.size()) {
                case 2: {
                    int rc;
                    int beta;
                    int rev;
                    int minor;
                    int major = Integer.parseInt((String)parts.get(0));
                    List betaParts = StringUtil.split((String)((String)parts.get(1)), (String)BETA);
                    if (betaParts.size() == 2) {
                        minor = Integer.parseInt((String)betaParts.get(0));
                        rev = -1;
                        beta = Integer.parseInt((String)betaParts.get(1));
                        rc = 0;
                    } else {
                        List rcParts = StringUtil.split((String)((String)parts.get(1)), (String)RC);
                        if (rcParts.size() == 2) {
                            minor = Integer.parseInt((String)rcParts.get(0));
                            rev = -1;
                            beta = 0;
                            rc = Integer.parseInt((String)rcParts.get(1));
                        } else {
                            minor = Integer.parseInt((String)parts.get(1));
                            rev = 0;
                            beta = 0;
                            rc = 0;
                        }
                    }
                    return new DlvGoVersion(major, minor, rev, beta, rc);
                }
                case 3: 
                case 4: {
                    int major = Integer.parseInt((String)parts.get(0));
                    int minor = Integer.parseInt((String)parts.get(1));
                    int revision = Integer.parseInt((String)parts.get(2));
                    return new DlvGoVersion(major, minor, revision, 0, 0);
                }
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        objectArray2[1] = "com/goide/dlv/DlvGoVersion";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAfterOrEqual";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "compareTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

