/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv.location;

import com.goide.dlv.DlvVm;
import com.goide.dlv.location.DlvPositionConverter;
import com.goide.psi.GoFile;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.GoUtil;
import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class DefaultDlvPositionConverter
implements DlvPositionConverter {
    @NotNull
    protected final Project myProject;
    protected final @Unmodifiable @NotNull Set<String> myRemotePaths;

    public DefaultDlvPositionConverter(@NotNull Project project, @NotNull @Unmodifiable Set<String> remotePaths) {
        if (project == null) {
            DefaultDlvPositionConverter.$$$reportNull$$$0(0);
        }
        if (remotePaths == null) {
            DefaultDlvPositionConverter.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myRemotePaths = remotePaths;
    }

    @Override
    @Nullable
    public String toRemotePath(@NotNull VirtualFile localFile) {
        VirtualFile parent;
        String path;
        if (localFile == null) {
            DefaultDlvPositionConverter.$$$reportNull$$$0(2);
        }
        if (this.myRemotePaths.contains(path = localFile.getPath())) {
            DlvVm.LOG.debug("Exact path match for local file " + path);
            return path;
        }
        String remotePathBySuffix = this.findRemotePathBySuffix(localFile);
        if (remotePathBySuffix != null && (parent = localFile.getParent()) != null) {
            VirtualFile bestMatch = this.getBestMatch(remotePathBySuffix, localFile.getName(), parent.getName());
            if (localFile.equals(bestMatch)) {
                return remotePathBySuffix;
            }
            if (bestMatch != null) {
                DlvVm.LOG.debug("Several files can be mapped to remote path " + remotePathBySuffix + ": " + path + ", " + bestMatch.getPath());
            } else {
                DlvVm.LOG.debug("Cannot check best match for remote path " + remotePathBySuffix);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public VirtualFile toLocalFile(@NotNull String remotePath) {
        if (remotePath == null) {
            DefaultDlvPositionConverter.$$$reportNull$$$0(3);
        }
        String name = PathUtil.getFileName((String)remotePath);
        String parentName = PathUtil.getFileName((String)PathUtil.getParentPath((String)remotePath));
        return this.getBestMatch(remotePath, name, parentName);
    }

    @Nullable
    private VirtualFile getBestMatch(@NotNull String remotePath, String name, String parentName) {
        List collect;
        if (remotePath == null) {
            DefaultDlvPositionConverter.$$$reportNull$$$0(4);
        }
        if ((collect = (List)ReadAction.compute(() -> ContainerUtil.filter((Collection)FilenameIndex.getVirtualFilesByName((String)name, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject)), it -> it.getParent() != null && parentName.equals(it.getParent().getName())))).size() == 1) {
            return (VirtualFile)collect.get(0);
        }
        return collect.stream().min(Comparator.comparingInt(v -> StringUtil.difference((String)v.getPath(), (String)remotePath))).orElse(null);
    }

    @Nullable
    private String findRemotePathBySuffix(@NotNull VirtualFile localFile) {
        if (localFile == null) {
            DefaultDlvPositionConverter.$$$reportNull$$$0(5);
        }
        String path = localFile.getPath();
        String importPathSuffix = DefaultDlvPositionConverter.getPathUsingImportPath(this.myProject, localFile);
        String remotePath = this.findUniqueRemotePathBySuffix(importPathSuffix);
        if (remotePath != null) {
            DlvVm.LOG.debug("Import path suffix " + importPathSuffix + " matches remote path " + remotePath);
            return remotePath;
        }
        DlvVm.LOG.debug("Cannot find unique remote path by suffix " + importPathSuffix);
        String goPathSuffix = DefaultDlvPositionConverter.stripGoPathsPrefix(this.myProject, localFile);
        remotePath = this.findUniqueRemotePathBySuffix(goPathSuffix);
        if (remotePath != null) {
            DlvVm.LOG.debug("Gopath suffix " + goPathSuffix + " matches remote path " + remotePath);
            return remotePath;
        }
        DlvVm.LOG.debug("Cannot find unique remote path by suffix " + goPathSuffix);
        WslPath wslPath = WslPath.parseWindowsUncPath((String)path);
        if (wslPath != null && (remotePath = this.findUniqueRemotePathBySuffix(wslPath.getLinuxPath())) != null) {
            DlvVm.LOG.debug("WSL path " + wslPath.getLinuxPath() + " matches remote path " + remotePath);
            return remotePath;
        }
        return null;
    }

    @NotNull
    private static String stripGoPathsPrefix(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            DefaultDlvPositionConverter.$$$reportNull$$$0(6);
        }
        if (file == null) {
            DefaultDlvPositionConverter.$$$reportNull$$$0(7);
        }
        return DefaultDlvPositionConverter.stripRootPrefix(GoSdkUtil.getSourcesPathsToLookup(project, GoUtil.module(project, file)), file);
    }

    @NotNull
    protected static String stripRootPrefix(@NotNull Iterable<VirtualFile> roots, @NotNull VirtualFile file) {
        if (roots == null) {
            DefaultDlvPositionConverter.$$$reportNull$$$0(8);
        }
        if (file == null) {
            DefaultDlvPositionConverter.$$$reportNull$$$0(9);
        }
        String filePath = file.getPath();
        for (VirtualFile goRootFile : roots) {
            String path = PathUtil.toSystemIndependentName((String)goRootFile.getPath());
            String trimmed = StringUtil.trimStart((String)filePath, (String)path);
            if (trimmed.length() >= filePath.length()) continue;
            String string = trimmed;
            if (string == null) {
                DefaultDlvPositionConverter.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = filePath;
        if (string == null) {
            DefaultDlvPositionConverter.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    private static String getPathUsingImportPath(@NotNull Project project, @NotNull VirtualFile file) {
        String importPath;
        PsiFile psiFile;
        if (project == null) {
            DefaultDlvPositionConverter.$$$reportNull$$$0(12);
        }
        if (file == null) {
            DefaultDlvPositionConverter.$$$reportNull$$$0(13);
        }
        if ((psiFile = (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)project).findFile(file))) instanceof GoFile && (importPath = (String)ReadAction.compute(() -> ((GoFile)psiFile).getImportPath(false))) != null) {
            return importPath + "/" + file.getName();
        }
        return null;
    }

    @Nullable
    protected String findUniqueRemotePathBySuffix(@Nullable String suffix) {
        return suffix != null ? (String)ContainerUtil.getOnlyItem((Collection)ContainerUtil.filter(this.myRemotePaths, it -> it.endsWith(suffix))) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePaths";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/dlv/location/DefaultDlvPositionConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/dlv/location/DefaultDlvPositionConverter";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "stripRootPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toRemotePath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toLocalFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBestMatch";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findRemotePathBySuffix";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "stripGoPathsPrefix";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "stripRootPrefix";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPathUsingImportPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11 -> new IllegalStateException(string);
        };
    }
}

