/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv.renderer;

import com.goide.dlv.DlvNamedType;
import com.goide.dlv.DlvUtil;
import com.goide.dlv.DlvXValue;
import com.goide.psi.GoFile;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoSignature;
import com.goide.psi.GoType;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.stubs.index.GoMethodIndex;
import com.goide.util.GoPathResolveScope;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"findStringMethod", "Lcom/goide/psi/GoMethodDeclaration;", "project", "Lcom/intellij/openapi/project/Project;", "value", "Lcom/goide/dlv/DlvXValue;", "getNameForMethodIndex", "", "packageName", "dlvNamedType", "Lcom/goide/dlv/DlvNamedType;", "intellij.go.impl"})
public final class DlvFmtSprintfValueRendererKt {
    @Nullable
    public static final GoMethodDeclaration findStringMethod(@NotNull Project project, @NotNull DlvXValue value) {
        GlobalSearchScope scope;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        Module module = DlvUtil.getModule(value.getProcess().getSession());
        if (DumbService.Companion.getInstance(project).isDumb() || module == null) {
            return null;
        }
        DlvNamedType dlvNamedType = DlvNamedType.parse(value.getVariable().type);
        if (dlvNamedType == null) {
            return null;
        }
        GlobalSearchScope globalSearchScope = scope = dlvNamedType.isFromMainPackage() ? value.getProcess().getMainPackageScope() : GoPathResolveScope.create(project, module, null);
        if (scope == null) {
            return null;
        }
        boolean vendoring = GoVendoringUtil.isVendoringEnabled(module);
        Set<String> set = value.getProcess().getSymbolPrettier().getPackageNames(dlvNamedType.getDlvPackagePath());
        Intrinsics.checkNotNullExpressionValue(set, (String)"getPackageNames(...)");
        Set<String> pkgNames = set;
        for (String pkgName : pkgNames) {
            Intrinsics.checkNotNull((Object)pkgName);
            Collection<GoMethodDeclaration> methods = GoMethodIndex.find(DlvFmtSprintfValueRendererKt.getNameForMethodIndex(pkgName, dlvNamedType), project, scope, null);
            String methodNames = Registry.Companion.stringValue("go.debugger.presentation.methods");
            for (String methodNameRaw : StringUtil.split((String)methodNames, (String)",")) {
                Intrinsics.checkNotNull((Object)methodNameRaw);
                String methodName = ((Object)StringsKt.trim((CharSequence)methodNameRaw)).toString();
                if (((CharSequence)methodName).length() == 0) continue;
                for (GoMethodDeclaration method : methods) {
                    GoType resultType;
                    GoSignature signature;
                    int paramsCount;
                    if (!Intrinsics.areEqual((Object)methodName, (Object)method.getName()) || method.getSignature() == null || (paramsCount = signature.getParameters().getParameterDeclarationList().size()) != 0) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)signature.getResultType(), (String)"getResultType(...)");
                    if (!GoTypeUtil.isString(resultType, method) || !dlvNamedType.isFromMainPackage() && !Intrinsics.areEqual((Object)dlvNamedType.getPackagePath(), (Object)"command-line-arguments") && !Intrinsics.areEqual((Object)dlvNamedType.getPackagePath(), (Object)((GoFile)method.getContainingFile()).getImportPath(vendoring))) continue;
                    return method;
                }
            }
        }
        return null;
    }

    private static final String getNameForMethodIndex(String packageName, DlvNamedType dlvNamedType) {
        Object object;
        if (((CharSequence)packageName).length() == 0) {
            String string = dlvNamedType.getTypeName();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTypeName(...)");
        } else {
            object = packageName + "." + dlvNamedType.getTypeName();
        }
        return object;
    }
}

