/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv.renderer;

import com.goide.dlv.protocol.DlvApi;
import com.goide.dlv.renderer.DlvIntegerValueRenderer;
import com.goide.i18n.GoBundle;
import com.intellij.openapi.util.text.StringUtil;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/goide/dlv/renderer/DlvHexValueRenderer;", "Lcom/goide/dlv/renderer/DlvIntegerValueRenderer;", "<init>", "()V", "formatNumericValue", "", "variable", "Lcom/goide/dlv/protocol/DlvApi$Variable;", "intellij.go.impl"})
public final class DlvHexValueRenderer
extends DlvIntegerValueRenderer {
    public DlvHexValueRenderer() {
        String string = GoBundle.message((String)"go.debugger.renderers.hex.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string);
    }

    @Override
    @NotNull
    public String formatNumericValue(@NotNull DlvApi.Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        String value = variable.value;
        try {
            long v = new BigInteger(value, 10).longValue();
            return "0x" + StringUtil.toUpperCase((String)Long.toHexString(v));
        }
        catch (NumberFormatException e) {
            String string = value;
            if (string == null) {
                string = "";
            }
            return string;
        }
    }
}

