/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv.renderer;

import com.goide.dlv.DlvUtil;
import com.goide.dlv.DlvXValue;
import com.goide.dlv.protocol.DlvApi;
import com.goide.dlv.renderer.DlvRegularValuePresentation;
import com.goide.dlv.renderer.DlvValueRenderer;
import com.goide.dlv.renderer.DlvValueRenderers;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.math.BigInteger;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0018\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u00072\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0014H\u0002J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/goide/dlv/renderer/DlvTimeValueRenderer;", "Lcom/goide/dlv/renderer/DlvValueRenderer;", "value", "Lcom/goide/dlv/DlvXValue;", "<init>", "(Lcom/goide/dlv/DlvXValue;)V", "getPresentation", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/xdebugger/frame/presentation/XValuePresentation;", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "computeValue", "", "variable", "Lcom/goide/dlv/protocol/DlvApi$Variable;", "getZoneId", "Ljava/time/ZoneId;", "locationPointer", "UTC", "NANOS_MASK", "Ljava/math/BigInteger;", "MONOTONIC_TIME_ORIGIN", "Ljava/time/LocalDateTime;", "NON_MONOTONIC_TIME_ORIGIN", "getNanoFormat", "nanoseconds", "", "hasMonotonic", "", "wall", "formatMonotonicTime", "ext", "", "tryGetZoneId", "zoneName", "offsetHours", "intellij.go.impl"})
public final class DlvTimeValueRenderer
implements DlvValueRenderer {
    @NotNull
    private final DlvXValue value;
    @Nullable
    private final ZoneId UTC;
    @NotNull
    private final BigInteger NANOS_MASK;
    @NotNull
    private final LocalDateTime MONOTONIC_TIME_ORIGIN;
    @NotNull
    private final LocalDateTime NON_MONOTONIC_TIME_ORIGIN;

    public DlvTimeValueRenderer(@NotNull DlvXValue value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.value = value;
        this.UTC = ZoneId.of("UTC");
        BigInteger bigInteger = BigInteger.valueOf(0x3FFFFFFFL);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
        this.NANOS_MASK = bigInteger;
        LocalDateTime localDateTime = LocalDateTime.of(1885, Month.JANUARY, 1, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"of(...)");
        this.MONOTONIC_TIME_ORIGIN = localDateTime;
        LocalDateTime localDateTime2 = LocalDateTime.of(1, Month.JANUARY, 1, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"of(...)");
        this.NON_MONOTONIC_TIME_ORIGIN = localDateTime2;
    }

    @Override
    @NotNull
    public Promise<XValuePresentation> getPresentation(@NotNull XValueNode node, @NotNull DlvXValue value) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        DlvApi.Variable variable = value.getVariable();
        Intrinsics.checkNotNullExpressionValue((Object)variable, (String)"getVariable(...)");
        Promise promise = this.computeValue(variable).thenAsync(arg_0 -> DlvTimeValueRenderer.getPresentation$lambda$3(arg_0 -> DlvTimeValueRenderer.getPresentation$lambda$2(value, node, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"thenAsync(...)");
        return promise;
    }

    private final Promise<String> computeValue(DlvApi.Variable variable) {
        DlvApi.Variable[] children = variable.children;
        DlvApi.Variable wallVar = DlvUtil.getByName(children, "wall");
        DlvApi.Variable extVar = DlvUtil.getByName(children, "ext");
        DlvApi.Variable locVar = DlvUtil.getByName(children, "loc");
        if (wallVar == null || extVar == null || locVar == null) {
            return Promises.resolvedPromise(null);
        }
        try {
            BigInteger wall = new BigInteger(wallVar.value);
            String string = extVar.value;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value");
            long ext = Long.parseLong(string);
            long nanos = wall.and(this.NANOS_MASK).longValue();
            if (this.hasMonotonic(wall)) {
                long seconds = wall.clearBit(63).shiftRight(30).longValue();
                ZonedDateTime time = ZonedDateTime.of(this.MONOTONIC_TIME_ORIGIN, this.UTC).plusSeconds(seconds).plusNanos(nanos).withZoneSameInstant(ZoneId.systemDefault());
                String nanoFormat = this.getNanoFormat(time.getNano());
                return Promises.resolvedPromise((Object)time.format(DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss" + nanoFormat + " ZZZ 'm=" + this.formatMonotonicTime(ext) + "'")));
            }
            Promise promise = this.getZoneId(locVar).thenAsync(arg_0 -> DlvTimeValueRenderer.computeValue$lambda$5(arg_0 -> DlvTimeValueRenderer.computeValue$lambda$4(this, ext, nanos, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"thenAsync(...)");
            return promise;
        }
        catch (NumberFormatException e) {
            return Promises.resolvedPromise(null);
        }
        catch (DateTimeException e) {
            return Promises.resolvedPromise(null);
        }
    }

    private final Promise<ZoneId> getZoneId(DlvApi.Variable locationPointer) {
        if (locationPointer.children.length != 1) {
            return Promises.resolvedPromise(null);
        }
        DlvApi.Variable location = locationPointer.children[0];
        if (Intrinsics.areEqual((Object)BigInteger.ZERO, (Object)location.addr)) {
            return Promises.resolvedPromise((Object)this.UTC);
        }
        Promise promise = DlvValueRenderers.loadChildrenIfNeeded(this.value, location).then(arg_0 -> DlvTimeValueRenderer.getZoneId$lambda$7(arg_0 -> DlvTimeValueRenderer.getZoneId$lambda$6(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return promise;
    }

    private final String getNanoFormat(int nanoseconds) {
        int nanos = nanoseconds;
        if (nanos == 0) {
            return "";
        }
        int digits = 9;
        while (nanos > 0 && nanos % 10 == 0) {
            --digits;
            nanos /= 10;
        }
        return "." + StringUtil.repeat((String)"S", (int)digits);
    }

    private final boolean hasMonotonic(BigInteger wall) {
        return wall.testBit(63);
    }

    private final String formatMonotonicTime(long ext) {
        long absNanos = Math.abs(ext);
        long seconds = absNanos / TimeUnit.SECONDS.toNanos(1L);
        long nanos = absNanos - seconds * TimeUnit.SECONDS.toNanos(1L);
        String string = "%+d.%09d";
        Object[] objectArray = new Object[]{(long)Long.signum(ext) * seconds, nanos};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private final ZoneId tryGetZoneId(String zoneName, int offsetHours) {
        ZoneId zoneId;
        try {
            zoneId = ZoneId.of(zoneName);
            Intrinsics.checkNotNull((Object)zoneId);
        }
        catch (DateTimeException e) {
            ZoneId zoneId2 = ZoneId.of(ZoneOffset.ofHours(offsetHours).getId());
            Intrinsics.checkNotNull((Object)zoneId2);
            zoneId = zoneId2;
        }
        return zoneId;
    }

    private static final XValuePresentation getPresentation$lambda$2$lambda$0(String $v, String t) {
        return (XValuePresentation)new DlvRegularValuePresentation($v, t);
    }

    private static final XValuePresentation getPresentation$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        return (XValuePresentation)$tmp0.invoke(p0);
    }

    private static final Promise getPresentation$lambda$2(DlvXValue $value, XValueNode $node, String v) {
        Promise promise;
        if (v != null) {
            Promise promise2 = $value.getTypePresentationAsync($node).then(arg_0 -> DlvTimeValueRenderer.getPresentation$lambda$2$lambda$1(arg_0 -> DlvTimeValueRenderer.getPresentation$lambda$2$lambda$0(v, arg_0), arg_0));
            promise = promise2;
            Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
        } else {
            promise = DlvValueRenderers.DEFAULT.getPresentation($node, $value);
        }
        return promise;
    }

    private static final Promise getPresentation$lambda$3(Function1 $tmp0, Object p0) {
        return (Promise)$tmp0.invoke(p0);
    }

    private static final Promise computeValue$lambda$4(DlvTimeValueRenderer this$0, long $ext, long $nanos, ZoneId zoneId) {
        if (zoneId == null) {
            return Promises.resolvedPromise(null);
        }
        ZonedDateTime time = ZonedDateTime.of(this$0.NON_MONOTONIC_TIME_ORIGIN, this$0.UTC).plusSeconds($ext).plusNanos($nanos).withZoneSameInstant(zoneId);
        String nanoFormat = this$0.getNanoFormat(time.getNano());
        return Promises.resolvedPromise((Object)time.format(DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss" + nanoFormat + " ZZZ")));
    }

    private static final Promise computeValue$lambda$5(Function1 $tmp0, Object p0) {
        return (Promise)$tmp0.invoke(p0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final ZoneId getZoneId$lambda$6(DlvTimeValueRenderer this$0, DlvApi.Variable loaded) {
        ZoneId zoneId;
        ZoneId zoneId2;
        Intrinsics.checkNotNullParameter((Object)loaded, (String)"loaded");
        DlvApi.Variable variable = DlvUtil.getByName(loaded.children, "name");
        if (variable == null) {
            return null;
        }
        DlvApi.Variable nameField = variable;
        String name = nameField.value;
        if (name != null) {
            int n = -1;
            switch (name.hashCode()) {
                case 68966: {
                    if (!name.equals("EST")) break;
                    n = 1;
                    break;
                }
                case 81318: {
                    if (!name.equals("ROC")) break;
                    n = 2;
                    break;
                }
                case 71849: {
                    if (!name.equals("HST")) break;
                    n = 3;
                    break;
                }
                case 572770538: {
                    if (!name.equals("Factory")) break;
                    n = 4;
                    break;
                }
                case 73592651: {
                    if (!name.equals("Local")) break;
                    n = 5;
                    break;
                }
                case -140870144: {
                    if (!name.equals("Asia/Qyzylorda")) break;
                    n = 6;
                    break;
                }
                case 1998854729: {
                    if (!name.equals("Asia/Qostanay")) break;
                    n = 7;
                    break;
                }
                case 76654: {
                    if (!name.equals("MST")) break;
                    n = 8;
                    break;
                }
            }
            switch (n) {
                case 7: {
                    zoneId2 = this$0.tryGetZoneId(name, 6);
                    return zoneId2;
                }
                case 6: {
                    zoneId2 = this$0.tryGetZoneId(name, 5);
                    return zoneId2;
                }
                case 4: {
                    zoneId2 = ZoneId.of(ZoneOffset.ofHours(0).getId());
                    return zoneId2;
                }
                case 1: {
                    zoneId2 = ZoneId.of(ZoneOffset.ofHours(-5).getId());
                    return zoneId2;
                }
                case 3: {
                    zoneId2 = ZoneId.of(ZoneOffset.ofHours(-10).getId());
                    return zoneId2;
                }
                case 8: {
                    zoneId2 = ZoneId.of(ZoneOffset.ofHours(-7).getId());
                    return zoneId2;
                }
                case 2: {
                    zoneId2 = ZoneId.of(ZoneOffset.ofHours(8).getId());
                    return zoneId2;
                }
                case 5: {
                    zoneId2 = ZoneId.systemDefault();
                    return zoneId2;
                }
            }
        }
        try {
            zoneId = ZoneId.of(name);
        }
        catch (DateTimeException e) {
            return null;
        }
        zoneId2 = zoneId;
        return zoneId2;
    }

    private static final ZoneId getZoneId$lambda$7(Function1 $tmp0, Object p0) {
        return (ZoneId)$tmp0.invoke(p0);
    }
}

