/*
 * Decompiled with CFR 0.152.
 */
package com.goide.documentation;

import com.goide.GoCommentsConverter;
import com.goide.GoLanguage;
import com.goide.GoParserDefinition;
import com.goide.GoTypes;
import com.goide.codeInsight.imports.GoImportOptimizer;
import com.goide.comments.GoCommentReferenceResolveContext;
import com.goide.comments.GoCommentReferenceResolver;
import com.goide.comments.GoDocLinkToken;
import com.goide.comments.GoLinkDefinition;
import com.goide.documentation.GoAdditionalDocumentationProvider;
import com.goide.documentation.GoDocLink;
import com.goide.documentation.GoDocumentationPackageVersionProvider;
import com.goide.documentation.GoKeywordDescription;
import com.goide.documentation.GoNavigatablePsiPresentationFunction;
import com.goide.execution.testing.GoTestFinder;
import com.goide.formatter.GoFormatterUtil;
import com.goide.formatter.GoLineCommentBlock;
import com.goide.highlighting.GoSyntaxHighlighter;
import com.goide.highlighting.GoSyntaxHighlightingLexer;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoAnonymousFieldDefinition;
import com.goide.psi.GoArgumentList;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoChannelType;
import com.goide.psi.GoConstDefinition;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFieldDeclaration;
import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoImportDeclaration;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoLiteral;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoPackageClause;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoPointerType;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoSendStatement;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeAssertionExpr;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoTypeSwitchGuard;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.GoVarOrConstDeclaration;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.psi.GoVarOrConstSpec;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.psi.impl.generics.GoSubstitution;
import com.goide.psi.impl.generics.GoTypeInferenceKt;
import com.goide.psi.impl.generics.instantiated.GoInstantiatedSignature;
import com.goide.psi.impl.generics.instantiated.GoInstantiatedType;
import com.goide.psi.presentation.GoPsiPresentationBuilder;
import com.goide.sdk.GoPackageUtil;
import com.goide.util.GoUtil;
import com.goide.util.Value;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.lang.documentation.DocumentationMarkup;
import com.intellij.lang.documentation.ExternalDocumentationHandler;
import com.intellij.lang.documentation.QuickDocHighlightingHelper;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testIntegration.TestFinder;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.VisibleForTesting;

public final class GoDocumentationProvider
extends AbstractDocumentationProvider
implements ExternalDocumentationHandler {
    private static final Logger LOG = Logger.getInstance(GoDocumentationProvider.class);
    private static final String EXAMPLE_URL_PREFIX = "goExample://";
    private static final GoCommentsConverter COMMENTS_CONVERTER = new GoCommentsConverter();
    private static final Map<Short, GoKeywordDescription> GO_KEYWORD_TO_DESCRIPTION = new ConcurrentHashMap<Short, GoKeywordDescription>();
    private static final String KEYWORD_DESCRIPTIONS_FOLDER = "/keywordDescriptions/";
    private static final String ADDITIONAL_DOCUMENTATION_FOLDER = "/languageConstructsAdditionalDocumentation/";

    @NotNull
    public static String getCommentText(@NotNull List<PsiComment> comments, boolean withHtml) {
        if (comments == null) {
            GoDocumentationProvider.$$$reportNull$$$0(0);
        }
        return GoDocumentationProvider.getCommentText(comments, withHtml, null);
    }

    @NotNull
    public static String getCommentText(@NotNull List<PsiComment> comments, boolean withHtml, @Nullable GoCommentsConverter.GoCommentLinkProvider linkProvider) {
        if (comments == null) {
            GoDocumentationProvider.$$$reportNull$$$0(1);
        }
        String string = withHtml ? COMMENTS_CONVERTER.toHtml(comments, linkProvider) : COMMENTS_CONVERTER.toText(comments);
        if (string == null) {
            GoDocumentationProvider.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static List<PsiComment> getUpperCommentsForElement(@Nullable PsiElement element, boolean withDirectives) {
        return GoDocumentationProvider.getCommentsForElementInner(element, target -> {
            List<PsiComment> comments = GoDocumentationProvider.getUpperComments(target);
            if (withDirectives) {
                return comments;
            }
            return GoDocumentationProvider.excludeDirectives(comments);
        });
    }

    @NotNull
    public static List<PsiComment> getAfterCommentsForElement(@Nullable PsiElement element) {
        return GoDocumentationProvider.getCommentsForElementInner(element, target -> GoDocumentationProvider.excludeDirectives(GoDocumentationProvider.getAfterComments(target)));
    }

    @NotNull
    public static List<PsiComment> getCommentsForElement(@Nullable PsiElement element) {
        return GoDocumentationProvider.getCommentsForElementInner(element, false);
    }

    public boolean handleExternalLink(PsiManager psiManager, String link, PsiElement context) {
        if (link.startsWith(EXAMPLE_URL_PREFIX)) {
            VirtualFile example = GoDocumentationProvider.getExampleFile(link, context);
            if (example == null) {
                return false;
            }
            FileEditorManager.getInstance((Project)context.getProject()).openFile(example, true);
            JBPopup hint = DocumentationManager.getInstance((Project)context.getProject()).getDocInfoHint();
            if (hint != null) {
                hint.cancel();
            }
            return true;
        }
        return false;
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiElement contextElement, int targetOffset) {
        PsiElement contextElementGrandparent;
        if (editor == null) {
            GoDocumentationProvider.$$$reportNull$$$0(3);
        }
        if (file == null) {
            GoDocumentationProvider.$$$reportNull$$$0(4);
        }
        if (contextElement == null) {
            return null;
        }
        PsiElement contextElementParent = contextElement.getParent();
        PsiElement psiElement = contextElementGrandparent = contextElementParent != null ? contextElementParent.getParent() : null;
        if (contextElementParent instanceof GoTypeAssertionExpr && contextElementGrandparent instanceof GoTypeSwitchGuard) {
            return contextElementGrandparent;
        }
        if (GoDocumentationProvider.isKeyword(contextElement)) {
            return contextElement;
        }
        if (contextElementParent instanceof GoChannelType) {
            return ((GoChannelType)contextElementParent).getChan();
        }
        if (GoDocumentationProvider.isChannelOperation(contextElement) && (contextElementParent instanceof GoSendStatement || contextElementParent instanceof GoUnaryExpr)) {
            return contextElement;
        }
        GoArgumentList argList = (GoArgumentList)ObjectUtils.tryCast((Object)contextElementParent, GoArgumentList.class);
        if (argList != null && argList.getExpressionList().isEmpty()) {
            GoCallExpr call = (GoCallExpr)ObjectUtils.tryCast((Object)argList.getParent(), GoCallExpr.class);
            GoReferenceExpression expression = call != null ? (GoReferenceExpression)ObjectUtils.tryCast((Object)call.getExpression(), GoReferenceExpression.class) : null;
            return expression != null ? expression.resolve() : null;
        }
        return GoDocumentationProvider.findCommentedElement(file, contextElement, targetOffset);
    }

    private static boolean isKeyword(@NotNull PsiElement element) {
        if (element == null) {
            GoDocumentationProvider.$$$reportNull$$$0(5);
        }
        return GoParserDefinition.Lazy.KEYWORDS.contains(PsiUtilCore.getElementType((PsiElement)element));
    }

    private static boolean isChannelOperation(@NotNull PsiElement element) {
        if (element == null) {
            GoDocumentationProvider.$$$reportNull$$$0(6);
        }
        return PsiUtilCore.getElementType((PsiElement)element) == GoTypes.ARROW;
    }

    @Nullable
    private static PsiElement findCommentedElement(@NotNull PsiFile file, @NotNull PsiElement contextElement, int targetOffset) {
        PsiElement prev;
        if (file == null) {
            GoDocumentationProvider.$$$reportNull$$$0(7);
        }
        if (contextElement == null) {
            GoDocumentationProvider.$$$reportNull$$$0(8);
        }
        PsiElement result = null;
        if (contextElement instanceof PsiWhiteSpace && (prev = contextElement.getPrevSibling()) != null && prev.getNode().getElementType() == GoParserDefinition.Lazy.LINE_COMMENT && prev.getTextRange().getEndOffset() == targetOffset) {
            contextElement = prev;
        }
        if (contextElement instanceof PsiComment && file.findReferenceAt(targetOffset) == null) {
            result = GoDocumentationProvider.findCommentedElement((PsiComment)contextElement);
        }
        return GoDocumentationProvider.adjustDocElement(result);
    }

    @Nullable
    private static PsiElement findCommentedElement(@NotNull PsiComment comment) {
        PsiElement element;
        if (comment == null) {
            GoDocumentationProvider.$$$reportNull$$$0(9);
        }
        if ((element = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)comment)) != null && GoDocumentationProvider.getAfterComments(element).contains(comment)) {
            return element;
        }
        return GoDocumentationProvider.findCommentedElementBelow(comment, false);
    }

    @Nullable
    public static PsiElement findCommentedElementBelow(@NotNull PsiComment comment, boolean allowEmptyLines) {
        PsiElement element;
        if (comment == null) {
            GoDocumentationProvider.$$$reportNull$$$0(10);
        }
        return (element = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)comment)) != null && GoDocumentationProvider.getUpperComments(element, allowEmptyLines).contains(comment) ? element : null;
    }

    @Nullable
    private static VirtualFile getExampleFile(@NotNull String link, @NotNull PsiElement context) {
        PsiFile psiFile;
        GoFunctionDeclaration exampleFunction;
        String text;
        if (link == null) {
            GoDocumentationProvider.$$$reportNull$$$0(11);
        }
        if (context == null) {
            GoDocumentationProvider.$$$reportNull$$$0(12);
        }
        VirtualFile scratchFile = (text = GoDocumentationProvider.getExampleFileText(exampleFunction = GoDocumentationProvider.findExample(link, context))) != null ? GoDocumentationProvider.createScratchFile(context.getProject(), text) : null;
        PsiFile psiFile2 = psiFile = scratchFile != null ? context.getManager().findFile(scratchFile) : null;
        if (psiFile == null) {
            return null;
        }
        WriteCommandAction.runWriteCommandAction((Project)context.getProject(), (String)OptimizeImportsProcessor.getCommandName(), null, (Runnable)new GoImportOptimizer().processFile(psiFile), (PsiFile[])new PsiFile[]{psiFile});
        return scratchFile;
    }

    @Nullable
    private static GoFunctionDeclaration findExample(@NotNull String link, @NotNull PsiElement context) {
        if (link == null) {
            GoDocumentationProvider.$$$reportNull$$$0(13);
        }
        if (context == null) {
            GoDocumentationProvider.$$$reportNull$$$0(14);
        }
        String exampleName = link.substring(EXAMPLE_URL_PREFIX.length());
        return (GoFunctionDeclaration)ContainerUtil.find(GoDocumentationProvider.getTestFinder().findExampleFunctions(context), it -> exampleName.equals(GoDocumentationProvider.getExampleName(context, it)) && it.getExampleCode() != null);
    }

    @NotNull
    private static GoTestFinder getTestFinder() {
        GoTestFinder goTestFinder = (GoTestFinder)TestFinder.EP_NAME.findExtensionOrFail(GoTestFinder.class);
        if (goTestFinder == null) {
            GoDocumentationProvider.$$$reportNull$$$0(15);
        }
        return goTestFinder;
    }

    @Nullable
    private static VirtualFile createScratchFile(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            GoDocumentationProvider.$$$reportNull$$$0(16);
        }
        if (text == null) {
            GoDocumentationProvider.$$$reportNull$$$0(17);
        }
        return ScratchRootType.getInstance().createScratchFile(project, "example.go", GoLanguage.INSTANCE, text, ScratchFileService.Option.create_new_always);
    }

    @VisibleForTesting
    @Nullable
    public static String getExampleFileText(@Nullable GoFunctionDeclaration exampleFunction) {
        String exampleCode;
        String string = exampleCode = exampleFunction != null ? exampleFunction.getExampleCode() : null;
        if (exampleCode == null) {
            return null;
        }
        StringBuilder text = new StringBuilder();
        text.append("package main\n\n");
        List<GoImportSpec> imports = exampleFunction.getContainingFile().getImports();
        if (!imports.isEmpty()) {
            text.append("import (\n");
            for (GoImportSpec importSpec : imports) {
                text.append("\t");
                String name = importSpec.getName();
                if (name != null) {
                    text.append(name).append(" ");
                }
                text.append("\"").append(importSpec.getPath()).append("\"\n");
            }
            text.append(")\n\n");
        }
        text.append("func main() {\n");
        text.append(StringUtil.trimTrailing((String)exampleCode));
        text.append("\n");
        String output2 = exampleFunction.getExampleOutput();
        if (output2 != null) {
            text.append("\n");
            text.append("\t").append(GoElementFactory.createLineCommentFromText(exampleFunction.getProject(), "Output:").getText()).append("\n");
            for (String line : StringUtil.splitByLines((String)output2)) {
                text.append("\t").append(GoElementFactory.createLineCommentFromText(exampleFunction.getProject(), line).getText()).append("\n");
            }
        }
        text.append("}\n");
        return text.toString();
    }

    @NotNull
    private static List<PsiComment> getCommentsForElementInner(@Nullable PsiElement element, boolean addSeparationComment) {
        return GoDocumentationProvider.getCommentsForElementInner(element, target -> GoDocumentationProvider.getCommentsForElementStrict(target, addSeparationComment));
    }

    @NotNull
    private static List<PsiComment> getCommentsForElementInner(@Nullable PsiElement element, @NotNull Function<PsiElement, List<PsiComment>> commentsSupplier) {
        List<PsiComment> comments;
        if (commentsSupplier == null) {
            GoDocumentationProvider.$$$reportNull$$$0(18);
        }
        if ((comments = commentsSupplier.apply(element)).isEmpty()) {
            if (element instanceof GoVarOrConstDefinition) {
                GoVarOrConstDeclaration declaration;
                PsiElement spec = element.getParent();
                comments = commentsSupplier.apply(spec);
                if (comments.isEmpty() && (declaration = (GoVarOrConstDeclaration)PsiTreeUtil.getParentOfType((PsiElement)spec, GoVarOrConstDeclaration.class)) != null) {
                    List<PsiComment> list = commentsSupplier.apply(declaration);
                    if (list == null) {
                        GoDocumentationProvider.$$$reportNull$$$0(19);
                    }
                    return list;
                }
            } else if (element instanceof GoTypeSpec || GoPsiImplUtil.isFieldDefinition(element)) {
                List<PsiComment> list = commentsSupplier.apply(element.getParent());
                if (list == null) {
                    GoDocumentationProvider.$$$reportNull$$$0(20);
                }
                return list;
            }
        }
        List<PsiComment> list = comments;
        if (list == null) {
            GoDocumentationProvider.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    private static List<PsiComment> getCommentsForElementStrict(@Nullable PsiElement element, boolean addSeparationComment) {
        if (element == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                GoDocumentationProvider.$$$reportNull$$$0(22);
            }
            return list;
        }
        List<PsiComment> upperComments = GoDocumentationProvider.excludeDirectives(GoDocumentationProvider.getUpperComments(element));
        List<PsiComment> afterComments = GoDocumentationProvider.excludeDirectives(GoDocumentationProvider.getAfterComments(element));
        if (upperComments.isEmpty()) {
            List<PsiComment> list = afterComments;
            if (list == null) {
                GoDocumentationProvider.$$$reportNull$$$0(23);
            }
            return list;
        }
        if (afterComments.isEmpty()) {
            List<PsiComment> list = upperComments;
            if (list == null) {
                GoDocumentationProvider.$$$reportNull$$$0(24);
            }
            return list;
        }
        ArrayList<PsiComment> result = new ArrayList<PsiComment>(upperComments);
        if (addSeparationComment) {
            result.add(GoDocumentationProvider.createEmptyComment(element));
        }
        result.addAll(afterComments);
        ArrayList<PsiComment> arrayList = result;
        if (arrayList == null) {
            GoDocumentationProvider.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @NotNull
    public static @Unmodifiable List<PsiComment> excludeDirectives(@NotNull List<PsiComment> comments) {
        if (comments == null) {
            GoDocumentationProvider.$$$reportNull$$$0(26);
        }
        List list = ContainerUtil.filter(comments, comment -> {
            if (comment.getNode().getElementType() == GoParserDefinition.Lazy.LINE_COMMENT) {
                String commentText = StringUtil.trimStart((String)comment.getText(), (String)"//");
                return !GoLineCommentBlock.isStandardDirectiveComment(commentText) && !GoLineCommentBlock.isGolandDirectiveComment(commentText);
            }
            return true;
        });
        if (list == null) {
            GoDocumentationProvider.$$$reportNull$$$0(27);
        }
        return list;
    }

    @NotNull
    public static List<PsiComment> getAfterComments(@NotNull PsiElement element) {
        if (element == null) {
            GoDocumentationProvider.$$$reportNull$$$0(28);
        }
        if (element instanceof PsiComment) {
            List<PsiComment> list = Collections.emptyList();
            if (list == null) {
                GoDocumentationProvider.$$$reportNull$$$0(29);
            }
            return list;
        }
        SmartList result = new SmartList();
        while ((element = element.getNextSibling()) != null) {
            if (element instanceof PsiComment) {
                result.add((PsiComment)element);
                continue;
            }
            if (element instanceof PsiWhiteSpace && !element.textContains('\n')) continue;
        }
        SmartList smartList = result;
        if (smartList == null) {
            GoDocumentationProvider.$$$reportNull$$$0(30);
        }
        return smartList;
    }

    @NotNull
    private static PsiComment createEmptyComment(@NotNull PsiElement element) {
        if (element == null) {
            GoDocumentationProvider.$$$reportNull$$$0(31);
        }
        PsiComment psiComment = PsiParserFacade.getInstance((Project)element.getProject()).createLineCommentFromText(GoLanguage.INSTANCE, "");
        if (psiComment == null) {
            GoDocumentationProvider.$$$reportNull$$$0(32);
        }
        return psiComment;
    }

    @NotNull
    public static List<PsiComment> getUpperComments(@NotNull PsiElement element) {
        if (element == null) {
            GoDocumentationProvider.$$$reportNull$$$0(33);
        }
        return GoDocumentationProvider.getUpperComments(element, false);
    }

    @NotNull
    public static List<PsiComment> getUpperComments(@NotNull PsiElement element, boolean allowEmptyLines) {
        PsiElement parent;
        if (element == null) {
            GoDocumentationProvider.$$$reportNull$$$0(34);
        }
        if (element instanceof PsiComment) {
            List<PsiComment> list = Collections.emptyList();
            if (list == null) {
                GoDocumentationProvider.$$$reportNull$$$0(35);
            }
            return list;
        }
        SmartList result = new SmartList();
        if (element instanceof GoImportSpec && (parent = element.getParent()) instanceof GoImportDeclaration && ((GoImportDeclaration)parent).getImportSpecList().size() == 1) {
            element = parent;
        }
        if (element instanceof GoImportDeclaration && element.getPrevSibling() == null) {
            element = element.getParent();
        }
        while ((element = element.getPrevSibling()) != null) {
            if (element instanceof PsiComment && GoFormatterUtil.isFirstElementOnLine(element)) {
                result.add(0, (PsiComment)element);
                continue;
            }
            if (element instanceof PsiWhiteSpace && (allowEmptyLines || !element.getText().contains("\n\n"))) continue;
        }
        SmartList smartList = result;
        if (smartList == null) {
            GoDocumentationProvider.$$$reportNull$$$0(36);
        }
        return smartList;
    }

    @Nullable
    private static GoFile findDocFileForDirectory(@Nullable PsiDirectory directory) {
        if (directory == null || !directory.isValid()) {
            return null;
        }
        PsiFile file = directory.findFile("doc.go");
        if (file instanceof GoFile) {
            return (GoFile)file;
        }
        PsiFile directoryFile = directory.findFile(GoUtil.suggestPackageForDirectory(directory) + ".go");
        return directoryFile instanceof GoFile ? (GoFile)directoryFile : null;
    }

    @Nullable
    public static PsiElement adjustDocElement(@Nullable PsiElement element) {
        if (element instanceof GoPackageClause) {
            return element.getContainingFile().getContainingDirectory();
        }
        GoPackage aPackage = GoPackageUtil.unwrapGoPackage(element);
        if (aPackage != null) {
            return aPackage.getNavigableElement();
        }
        if (element instanceof GoVarOrConstDeclaration) {
            return GoDocumentationProvider.getFirstDefinitionWithoutOwnComments((GoVarOrConstDeclaration)element);
        }
        if (element instanceof GoVarOrConstSpec) {
            return (PsiElement)ContainerUtil.getFirstItem(((GoVarOrConstSpec)element).getDefinitionList());
        }
        if (element instanceof GoTypeDeclaration && !((GoTypeDeclaration)element).getTypeSpecList().isEmpty()) {
            return GoDocumentationProvider.getFirstTypeSpecWithoutOwnComments((GoTypeDeclaration)element);
        }
        if (element instanceof GoFieldDeclaration) {
            GoAnonymousFieldDefinition anonymousField = ((GoFieldDeclaration)element).getAnonymousFieldDefinition();
            return anonymousField != null ? anonymousField : (PsiElement)ContainerUtil.getFirstItem(((GoFieldDeclaration)element).getFieldDefinitionList());
        }
        return element instanceof GoImportSpec ? GoPackageUtil.getFirstNavigableDirectory(((GoImportSpec)element).resolve(ResolveState.initial())) : element;
    }

    @Nullable
    private static GoVarOrConstDefinition getFirstDefinitionWithoutOwnComments(@NotNull GoVarOrConstDeclaration<?> declaration) {
        GoVarOrConstSpec spec;
        if (declaration == null) {
            GoDocumentationProvider.$$$reportNull$$$0(37);
        }
        return (spec = (GoVarOrConstSpec)ContainerUtil.getFirstItem(declaration.getSpecList())) != null && !(PsiTreeUtil.skipWhitespacesBackward((PsiElement)spec) instanceof PsiComment) ? (GoVarOrConstDefinition)ContainerUtil.getFirstItem(spec.getDefinitionList()) : null;
    }

    @Nullable
    private static GoTypeSpec getFirstTypeSpecWithoutOwnComments(@NotNull GoTypeDeclaration declaration) {
        GoTypeSpec spec;
        if (declaration == null) {
            GoDocumentationProvider.$$$reportNull$$$0(38);
        }
        return (spec = (GoTypeSpec)ContainerUtil.getFirstItem(declaration.getTypeSpecList())) != null && !(PsiTreeUtil.skipWhitespacesBackward((PsiElement)spec) instanceof PsiComment) ? spec : null;
    }

    @NotNull
    @NlsSafe
    private static String getResolvedValueText(@NotNull GoVarOrConstDefinition definition) {
        Value value;
        if (definition == null) {
            GoDocumentationProvider.$$$reportNull$$$0(39);
        }
        return (value = (Value)CoroutinesKt.blockingContextToIndicator(() -> definition.getValue())) != null && !GoDocumentationProvider.isLiteral(definition.findExpression()) ? StringUtil.notNullize((String)value.toString()) : "";
    }

    private static boolean isLiteral(@Nullable GoExpression expression) {
        return expression instanceof GoStringLiteral || expression instanceof GoLiteral || GoDocumentationProvider.isNumberLiteralWithSign(expression);
    }

    private static boolean isNumberLiteralWithSign(@Nullable GoExpression expression) {
        GoUnaryExpr expr = (GoUnaryExpr)ObjectUtils.tryCast((Object)expression, GoUnaryExpr.class);
        return expr != null && (expr.getMinus() != null || expr.getPlus() != null) && expr.getExpression() instanceof GoLiteral;
    }

    @NotNull
    @NlsSafe
    private static String getSignature(@NotNull GoNamedElement element, @Nullable PsiElement context) {
        String signature;
        if (element == null) {
            GoDocumentationProvider.$$$reportNull$$$0(40);
        }
        if ((signature = GoDocumentationProvider.calcSignature(element, context)).isEmpty()) {
            String string = signature;
            if (string == null) {
                GoDocumentationProvider.$$$reportNull$$$0(41);
            }
            return string;
        }
        GoSyntaxHighlighter highlighter = new GoSyntaxHighlighter();
        GoSyntaxHighlightingLexer lexer = highlighter.getHighlightingLexer();
        StringBuilder builder = new StringBuilder();
        lexer.start((CharSequence)signature);
        Pair<String, String> keywordStyle = GoDocumentationProvider.getKeywordStyle(element.getProject());
        while (lexer.getTokenType() != null) {
            IElementType type = lexer.getTokenType();
            String tokenText = lexer.getTokenText();
            boolean keyword = GoParserDefinition.Lazy.KEYWORDS.contains(type);
            builder.append(keyword ? GoDocumentationProvider.generateInternalKeywordLink(tokenText, keywordStyle) : tokenText);
            lexer.advance();
        }
        String string = builder.toString();
        if (string == null) {
            GoDocumentationProvider.$$$reportNull$$$0(42);
        }
        return string;
    }

    @NotNull
    private static String calcSignature(@NotNull GoNamedElement element, @Nullable PsiElement context) {
        if (element == null) {
            GoDocumentationProvider.$$$reportNull$$$0(43);
        }
        GoNavigatablePsiPresentationFunction presentationFunction = new GoNavigatablePsiPresentationFunction(element);
        GoPsiPresentationBuilder builder = GoPsiPresentationBuilder.create().withPresentationFunction(presentationFunction).html();
        String name = element.getName();
        if (element instanceof GoTypeSpec) {
            GoTypeSpec typeSpec = (GoTypeSpec)element;
            GoType type = typeSpec.getSpecType().getType();
            String typePresentationPrefix = typeSpec.isTypeAlias() ? " = " : " ";
            String typePresentation = builder.build(type);
            String typeParamsPresentation = builder.build(typeSpec.getSpecType().getTypeParameters());
            return StringUtil.isNotEmpty((String)name) ? "type " + name + typeParamsPresentation + typePresentationPrefix + typePresentation : "";
        }
        if (StringUtil.isNotEmpty((String)name)) {
            ResolveState resolveState = !(element instanceof GoConstDefinition) && context != null ? GoPsiImplUtil.createContextOnElement(context) : null;
            String type = builder.build(element.getGoType(resolveState));
            String text = name + (String)(!type.isEmpty() ? " " + type : "");
            if (element instanceof GoVarOrConstDefinition) {
                GoVarOrConstDefinition definition = (GoVarOrConstDefinition)element;
                GoExpression expression = definition.findExpression();
                String kindOfElement = element instanceof GoConstDefinition ? "const " : "var ";
                String string = kindOfElement + text + GoDocumentationProvider.getExpressionHtml(expression);
                if (string == null) {
                    GoDocumentationProvider.$$$reportNull$$$0(44);
                }
                return string;
            }
            if (element instanceof GoParamDefinition || element instanceof GoReceiver) {
                String string = "var " + text;
                if (string == null) {
                    GoDocumentationProvider.$$$reportNull$$$0(45);
                }
                return string;
            }
            if (GoPsiImplUtil.isFieldDefinition(element)) {
                GoSpecType specType = (GoSpecType)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)element, GoSpecType.class);
                String parentTypeText = builder.build(specType);
                String typeParamsPresentation = builder.build(specType != null ? specType.getTypeParameters() : null);
                String textAndLinkToParentStruct = !parentTypeText.isEmpty() ? " of " + parentTypeText + typeParamsPresentation + " type" : "";
                PsiElement parent = PsiTreeUtil.getStubOrPsiParent((PsiElement)element);
                String tagText = parent instanceof GoFieldDeclaration ? ((GoFieldDeclaration)parent).getTagText() : null;
                String suffix = GoDocumentationProvider.calcTagMarkup(element.getProject(), tagText) + textAndLinkToParentStruct;
                String string = element instanceof GoAnonymousFieldDefinition ? "<b>anonymous field</b> " + type + suffix : "<b>field</b> " + text + suffix;
                if (string == null) {
                    GoDocumentationProvider.$$$reportNull$$$0(46);
                }
                return string;
            }
        }
        return element instanceof GoSignatureOwner ? builder.build((GoSignatureOwner)((Object)element), true) : "";
    }

    @Nullable
    private static GoSubstitution getElementSubstitution(@Nullable PsiElement element) {
        GoSignature signature;
        ResolveState state;
        GoType type;
        GoReferenceExpression reference = (GoReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)element, GoReferenceExpression.class);
        if (reference != null && GoTypeInferenceKt.isReverseTypeInferenceEnabled(reference) && (type = GoPsiImplUtil.getGoType(reference, state = GoPsiImplUtil.createContextOnElement(reference))) instanceof GoInstantiatedType) {
            GoInstantiatedType instantiatedElement = (GoInstantiatedType)type;
            return instantiatedElement.getSubstitution();
        }
        GoCallExpr callExpr = (GoCallExpr)PsiTreeUtil.getParentOfType((PsiElement)element, GoCallExpr.class);
        if (callExpr != null && (signature = callExpr.resolveSignature()) instanceof GoInstantiatedSignature) {
            GoInstantiatedSignature instantiatedSignature = (GoInstantiatedSignature)signature;
            return instantiatedSignature.getSubstitution();
        }
        return null;
    }

    @NlsSafe
    private static String generateInternalKeywordLink(@NlsSafe @NotNull String keyword, @NotNull Pair<String, String> keywordStyle) {
        if (keyword == null) {
            GoDocumentationProvider.$$$reportNull$$$0(47);
        }
        if (keywordStyle == null) {
            GoDocumentationProvider.$$$reportNull$$$0(48);
        }
        StringBuilder builder = new StringBuilder();
        @NlsSafe String keywordOpeningTag = (String)keywordStyle.first;
        @NlsSafe String keywordClosingTag = (String)keywordStyle.second;
        HtmlChunk.tag((String)"a").attr("href", "psi_element://" + GoDocLink.getKeywordLink(keyword)).addRaw(String.format("%s%s%s", keywordOpeningTag, keyword, keywordClosingTag)).appendTo(builder);
        return builder.toString();
    }

    @NotNull
    public static String calcTagMarkup(@NotNull Project project, @Nullable String tagText) {
        if (project == null) {
            GoDocumentationProvider.$$$reportNull$$$0(49);
        }
        if (StringUtil.isEmpty((String)tagText)) {
            return "";
        }
        return GoDocumentationProvider.convertToHtml(project, tagText);
    }

    @NotNull
    private static String getExpressionHtml(@Nullable GoExpression expression) {
        if (expression == null) {
            return "";
        }
        String expressionText = expression.getText();
        if (expressionText.length() > 1000 || StringUtil.countNewLines((CharSequence)expressionText) > 200) {
            String message = GoBundle.message((String)"go.quick.doc.too.large.to.render", (Object[])new Object[0]);
            String string = "&#32;=&#32;&lt;" + message + "&gt;";
            if (string == null) {
                GoDocumentationProvider.$$$reportNull$$$0(50);
            }
            return string;
        }
        String html = GoDocumentationProvider.convertToHtml(expression.getProject(), expressionText);
        String string = "&#32;=&#32;" + html;
        if (string == null) {
            GoDocumentationProvider.$$$reportNull$$$0(51);
        }
        return string;
    }

    @Nullable
    public static String getLocalUrlToElement(@NotNull PsiElement element) {
        if (element == null) {
            GoDocumentationProvider.$$$reportNull$$$0(52);
        }
        return GoDocumentationProvider.hasUrl(element) ? GoDocumentationProvider.getReferenceText(element, true) : null;
    }

    private static boolean hasUrl(@Nullable PsiElement element) {
        if (element instanceof PsiDirectory) {
            return true;
        }
        if (element instanceof GoMethodSpec) {
            GoTypeSpec typeSpec = (GoTypeSpec)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)element, GoTypeSpec.class);
            return typeSpec != null && typeSpec.isPublic() && GoPsiUtil.isTopLevelDeclaration(typeSpec);
        }
        if (element instanceof GoFieldDefinition) {
            GoTypeSpec typeSpec = (GoTypeSpec)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)element, GoTypeSpec.class);
            return typeSpec != null && typeSpec.isPublic() && GoPsiUtil.isTopLevelDeclaration(typeSpec) && GoDocumentationProvider.hasFieldDefinition(typeSpec, element);
        }
        return (element instanceof GoTypeSpec || element instanceof GoFunctionOrMethodDeclaration || element instanceof GoVarOrConstDefinition) && GoPsiUtil.isTopLevelDeclaration(element);
    }

    private static boolean hasFieldDefinition(@NotNull GoTypeSpec typeSpec, @NotNull PsiElement field) {
        GoType type;
        if (typeSpec == null) {
            GoDocumentationProvider.$$$reportNull$$$0(53);
        }
        if (field == null) {
            GoDocumentationProvider.$$$reportNull$$$0(54);
        }
        Object[] children = (type = typeSpec.getSpecType().getType()) != null ? type.getChildren() : PsiElement.EMPTY_ARRAY;
        return ContainerUtil.find((Object[])children, it -> {
            GoFieldDeclaration declaration = (GoFieldDeclaration)ObjectUtils.tryCast((Object)it, GoFieldDeclaration.class);
            return declaration != null && declaration.getFieldDefinitionList().contains(field);
        }) != null;
    }

    @Nullable
    public static String getReferenceText(@Nullable PsiElement element, boolean includePackageName) {
        if (element instanceof GoNamedElement) {
            GoNamedElement goNamedElement = (GoNamedElement)element;
            GoFile file = goNamedElement.getContainingFile();
            String importPath = file.getImportPath(GoVendoringUtil.isVendoringEnabled(element));
            if (element instanceof GoFunctionDeclaration || element instanceof GoTypeSpec || element instanceof GoVarOrConstDefinition) {
                String name = goNamedElement.getName();
                if (StringUtil.isNotEmpty((String)name)) {
                    String fqn = GoDocumentationProvider.getElementFqn(goNamedElement, name, includePackageName);
                    return GoDocLink.serialize(element, importPath, fqn);
                }
            } else if (element instanceof GoMethodDeclaration) {
                GoType receiverType = ((GoMethodDeclaration)element).getReceiverType();
                String receiver = GoTypeUtil.getReceiverTypeName(receiverType);
                String name = ((GoMethodDeclaration)element).getName();
                if (StringUtil.isNotEmpty((String)receiver) && StringUtil.isNotEmpty((String)name)) {
                    String fqn = GoDocumentationProvider.getElementFqn(goNamedElement, receiver, includePackageName);
                    return GoDocLink.serialize(element, importPath, fqn + "." + name);
                }
            } else if (!(!(element instanceof GoMethodSpec) && !(element instanceof GoFieldDefinition) || element instanceof GoMethodSpec && ((GoMethodSpec)element).getTypeReferenceExpression() != null)) {
                return GoDocumentationProvider.getReferenceToTypeMember(element, importPath, includePackageName);
            }
        } else if (element instanceof PsiDirectory) {
            String importPath = GoPackageUtil.findFirstImportPath((PsiDirectory)element, GoVendoringUtil.isVendoringEnabled(element));
            return GoDocLink.serialize(element, importPath, null);
        }
        return null;
    }

    @Nullable
    private static String getReferenceToTypeMember(@NotNull PsiElement element, @Nullable String importPath, boolean includePackageName) {
        String typeName;
        if (element == null) {
            GoDocumentationProvider.$$$reportNull$$$0(55);
        }
        if (!(element instanceof GoMethodSpec) && !(element instanceof GoFieldDefinition)) {
            return null;
        }
        GoTypeSpec typeSpec = (GoTypeSpec)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)element, GoTypeSpec.class);
        String name = ((GoNamedElement)element).getName();
        String string = typeName = typeSpec != null ? typeSpec.getName() : null;
        if (StringUtil.isNotEmpty((String)name) && StringUtil.isNotEmpty((String)typeName)) {
            String fqn = GoDocumentationProvider.getElementFqn((GoNamedElement)element, typeName, includePackageName);
            return GoDocLink.serialize(element, importPath, fqn + "." + name);
        }
        return null;
    }

    @NotNull
    private static String getElementFqn(@NotNull GoNamedElement element, @NotNull String name, boolean includePackageName) {
        String packageName;
        if (element == null) {
            GoDocumentationProvider.$$$reportNull$$$0(56);
        }
        if (name == null) {
            GoDocumentationProvider.$$$reportNull$$$0(57);
        }
        if (includePackageName && !StringUtil.isEmpty((String)(packageName = element.getContainingFile().getPackageName()))) {
            String string = packageName + "." + name;
            if (string == null) {
                GoDocumentationProvider.$$$reportNull$$$0(58);
            }
            return string;
        }
        String string = name;
        if (string == null) {
            GoDocumentationProvider.$$$reportNull$$$0(59);
        }
        return string;
    }

    @Nls
    @Nullable
    public String generateHoverDoc(@NotNull PsiElement element, @Nullable PsiElement originalElement) {
        if (element == null) {
            GoDocumentationProvider.$$$reportNull$$$0(60);
        }
        if (originalElement instanceof PsiComment && element == GoDocumentationProvider.findCommentedElement((PsiComment)originalElement)) {
            return null;
        }
        return this.generateDoc(element, originalElement);
    }

    @Nls
    @Nullable
    public String generateDoc(@Nullable PsiElement element, @Nullable PsiElement originalElement) {
        if ((element = GoDocumentationProvider.adjustDocElement(element)) == null) {
            return null;
        }
        @NlsSafe StringBuilder builder = new StringBuilder();
        if (GoDocumentationProvider.isKeyword(element)) {
            GoDocumentationProvider.generateKeywordDocumentation(builder, element);
        } else if (GoDocumentationProvider.isChannelOperation(element)) {
            String channelOpLabel = null;
            PsiElement parent = element.getParent();
            if (parent instanceof GoSendStatement) {
                channelOpLabel = GoBundle.message((String)"go.quick.doc.channel.send.label", (Object[])new Object[0]);
            }
            if (parent instanceof GoUnaryExpr) {
                channelOpLabel = GoBundle.message((String)"go.quick.doc.channel.receive.label", (Object[])new Object[0]);
            }
            if (channelOpLabel != null) {
                int length = GoDocumentationProvider.start(builder, "<div class='definition'><pre>");
                builder.append(GoDocumentationProvider.convertToHtml(element.getProject(), parent.getText()));
                GoDocumentationProvider.finishOrDiscard(builder, length, "<div class='definition'><pre>", "</pre></div>");
                length = GoDocumentationProvider.start(builder, "<div class='content'>");
                builder.append(channelOpLabel);
                GoDocumentationProvider.finishOrDiscard(builder, length, "<div class='content'>", "</div>");
            }
        } else if (element instanceof GoTypeSwitchGuard) {
            int length = GoDocumentationProvider.start(builder, "<div class='content'>");
            builder.append(GoBundle.message((String)"go.quick.doc.keyword.type.switch", (Object[])new Object[0]));
            GoDocumentationProvider.finishOrDiscard(builder, length, "<div class='content'>", "</div>");
            String resourcePath = "/languageConstructsAdditionalDocumentation/GoTypeSwitchExample.html";
            try (InputStream is = Objects.requireNonNull(GoDocumentationProvider.class.getResourceAsStream(resourcePath));){
                String exampleHTML = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                builder.append(DocumentationMarkup.CONTENT_ELEMENT.addRaw(exampleHTML));
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        } else if (element instanceof GoNamedElement) {
            GoType type;
            GoSubstitution substitution;
            int length = GoDocumentationProvider.start(builder, "<table class='sections'>");
            if (GoPsiUtil.isTopLevelDeclaration(element)) {
                GoDocumentationProvider.addSection(builder, GoBundle.message((String)"go.quick.doc.package.label", (Object[])new Object[0]), GoDocumentationProvider.getPackageHeader(element));
            }
            GoDocumentationProvider.finishOrDiscard(builder, length, "<table class='sections'>", "</table>");
            length = GoDocumentationProvider.start(builder, "<div class='definition'><pre>");
            builder.append(GoDocumentationProvider.getSignature((GoNamedElement)element, originalElement));
            GoDocumentationProvider.finishOrDiscard(builder, length, "<div class='definition'><pre>", "</pre></div>");
            if (element instanceof GoSignatureOwner && (substitution = GoDocumentationProvider.getElementSubstitution(originalElement)) != null) {
                length = GoDocumentationProvider.start(builder, "<table class='sections'>");
                GoNavigatablePsiPresentationFunction presentationFunction = new GoNavigatablePsiPresentationFunction(element);
                GoPsiPresentationBuilder psiPresentationBuilder = GoPsiPresentationBuilder.create().withPresentationFunction(presentationFunction).html();
                GoDocumentationProvider.addSection(builder, GoBundle.message((String)"go.quick.doc.substitution.label", (Object[])new Object[0]), GoDocumentationProvider.formatSubstitution(substitution, psiPresentationBuilder));
                GoDocumentationProvider.finishOrDiscard(builder, length, "<table class='sections'>", "</table>");
            }
            if (StringUtil.isNotEmpty((String)((GoNamedElement)element).getName()) && element instanceof GoVarOrConstDefinition) {
                GoVarOrConstDefinition definition = (GoVarOrConstDefinition)element;
                length = GoDocumentationProvider.start(builder, "<table class='sections'>");
                GoDocumentationProvider.addSection(builder, GoBundle.message((String)"go.quick.doc.resolved.value.label", (Object[])new Object[0]), GoDocumentationProvider.getResolvedValueText(definition));
                GoDocumentationProvider.finishOrDiscard(builder, length, "<table class='sections'>", "</table>");
            }
            length = GoDocumentationProvider.start(builder, "<div class='content'>");
            DocCommentLinkProvider provider = GoDocumentationProvider.getCommentLinkProvider(element);
            builder.append(GoDocumentationProvider.getCommentText(GoDocumentationProvider.getCommentsForElementInner(element, true), true, provider));
            for (Example example : GoDocumentationProvider.getExamples(element)) {
                GoDocumentationProvider.appendExample(element, builder, example);
            }
            GoDocumentationProvider.finishOrDiscard(builder, length, "<div class='content'>", "</div>");
            if (element instanceof GoTypeSpec) {
                GoDocumentationProvider.appendMethodSections(builder, (GoTypeSpec)element, originalElement);
            }
            if ((type = ((GoNamedElement)element).getGoUnderlyingType(null)) instanceof GoChannelType) {
                GoDocumentationProvider.generateChannelDoc(builder, (GoChannelType)type);
            }
        } else if (element instanceof PsiDirectory) {
            GoFile file = GoDocumentationProvider.findDocFileForDirectory((PsiDirectory)element);
            if (file != null) {
                int length = GoDocumentationProvider.start(builder, "<table class='sections'>");
                GoDocumentationProvider.addSection(builder, GoBundle.message((String)"go.quick.doc.package.label", (Object[])new Object[0]), "<b>" + GoUtil.suggestPackageForDirectory(file.getParent()) + "</b>");
                GoDocumentationProvider.finishOrDiscard(builder, length, "<table class='sections'>", "</table>");
                length = GoDocumentationProvider.start(builder, "<div class='definition'><pre>");
                builder.append("import \"").append(StringUtil.notNullize((String)file.getImportPath(GoVendoringUtil.isVendoringEnabled((PsiElement)file)))).append("\"");
                GoDocumentationProvider.finishOrDiscard(builder, length, "<div class='definition'><pre>", "</pre></div>");
                length = GoDocumentationProvider.start(builder, "<div class='content'>");
                GoPackageClause pack = (GoPackageClause)PsiTreeUtil.findChildOfType((PsiElement)file, GoPackageClause.class);
                DocCommentLinkProvider provider = GoDocumentationProvider.getCommentLinkProvider(pack);
                builder.append(GoDocumentationProvider.getCommentText(GoDocumentationProvider.getCommentsForElementInner((PsiElement)pack, true), true, provider));
                GoDocumentationProvider.finishOrDiscard(builder, length, "<div class='content'>", "</div>");
            }
        } else if (element instanceof GoLinkDefinition) {
            GoLinkDefinition linkDef = (GoLinkDefinition)element;
            int length = GoDocumentationProvider.start(builder, "<div class='content'>");
            builder.append(String.format("<p>[%s]: <a href=\"%s\">%s</a></p>\n", linkDef.getLinkText(), XmlStringUtil.escapeString((String)linkDef.getUrl()), linkDef.getUrl()));
            GoDocumentationProvider.finishOrDiscard(builder, length, "<div class='content'>", "</div>");
        }
        for (GoAdditionalDocumentationProvider additionalDocumentationProvider : GoAdditionalDocumentationProvider.EP_NAME.getExtensionList()) {
            builder.append(additionalDocumentationProvider.provideAdditionalDocumentation(element, originalElement));
        }
        return !builder.isEmpty() ? builder.toString() : null;
    }

    private static void generateKeywordDocumentation(@NotNull StringBuilder builder, @NotNull PsiElement keywordElement) {
        GoKeywordDescription keywordDescription;
        IElementType keyword;
        if (builder == null) {
            GoDocumentationProvider.$$$reportNull$$$0(61);
        }
        if (keywordElement == null) {
            GoDocumentationProvider.$$$reportNull$$$0(62);
        }
        if ((keyword = keywordElement.getNode().getElementType()) == GoTypes.INTERFACE && (PsiTreeUtil.getParentOfType((PsiElement)keywordElement, GoTypeAssertionExpr.class) != null || GoDocumentationProvider.isKeywordElementEmptyInterface(keywordElement))) {
            return;
        }
        int length = GoDocumentationProvider.start(builder, "<div class='definition'><pre>");
        builder.append(GoDocumentationProvider.convertToHtml(keywordElement.getProject(), keywordElement.getText()));
        GoDocumentationProvider.finishOrDiscard(builder, length, "<div class='definition'><pre>", "</pre></div>");
        if (keywordElement.getParent() instanceof GoChannelType) {
            GoDocumentationProvider.generateChannelDoc(builder, (GoChannelType)keywordElement.getParent());
        }
        if ((keywordDescription = GoDocumentationProvider.retrieveKeywordDescription(keyword)) == null) {
            return;
        }
        length = GoDocumentationProvider.start(builder, "<div class='content'>");
        builder.append(keywordDescription.getDescriptionText());
        GoDocumentationProvider.finishOrDiscard(builder, length, "<div class='content'>", "</div>");
        length = GoDocumentationProvider.start(builder, "<div class='content'>");
        String linkFormatted = String.format("<p><a href=\"%s\">%s</a></p>\n", keywordDescription.getSpecificationLink(), GoBundle.message((String)"go.quick.doc.keyword.resource.language.spec.label", (Object[])new Object[0]));
        builder.append(linkFormatted);
        GoDocumentationProvider.finishOrDiscard(builder, length, "<div class='content'>", "</div>");
        length = GoDocumentationProvider.start(builder, "<div class='content'>");
        for (String furtherReadingLink : keywordDescription.getFurtherReadingLinks()) {
            linkFormatted = String.format("<a href=\"%s\">%s</a>\n", furtherReadingLink, GoDocumentationProvider.generateFurtherReadingTitle(furtherReadingLink));
            builder.append(linkFormatted);
        }
        GoDocumentationProvider.finishOrDiscard(builder, length, "<div class='content'>", "</div>");
    }

    private static void generateChannelDoc(@NotNull StringBuilder builder, @NotNull GoChannelType element) {
        if (builder == null) {
            GoDocumentationProvider.$$$reportNull$$$0(63);
        }
        if (element == null) {
            GoDocumentationProvider.$$$reportNull$$$0(64);
        }
        int length = GoDocumentationProvider.start(builder, "<table class='sections'>");
        GoPsiImplUtil.ChannelDirection direction = element.getDirection();
        String directionFormatted = String.format("<p>%s</p>", direction.name().toLowerCase(Locale.ENGLISH));
        GoDocumentationProvider.addSection(builder, GoBundle.message((String)"go.quick.doc.channel.direction.label", (Object[])new Object[0]), directionFormatted);
        GoDocumentationProvider.finishOrDiscard(builder, length, "<table class='sections'>", "</table>");
    }

    public static boolean isKeywordElementEmptyInterface(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            GoDocumentationProvider.$$$reportNull$$$0(65);
        }
        return (parent = PsiTreeUtil.getStubOrPsiParent((PsiElement)element)) instanceof GoInterfaceType && GoTypeUtil.isEmptyInterface((GoInterfaceType)parent);
    }

    @Nullable
    private static GoKeywordDescription retrieveKeywordDescription(@NotNull IElementType keyword) {
        if (keyword == null) {
            GoDocumentationProvider.$$$reportNull$$$0(66);
        }
        return GO_KEYWORD_TO_DESCRIPTION.computeIfAbsent(keyword.getIndex(), k -> {
            GoKeywordDescription goKeywordDescription;
            block8: {
                String resourcePath = KEYWORD_DESCRIPTIONS_FOLDER + String.valueOf(keyword) + ".xml";
                InputStream is = GoDocumentationProvider.class.getResourceAsStream(resourcePath);
                try {
                    JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GoKeywordDescription.class});
                    goKeywordDescription = (GoKeywordDescription)context.createUnmarshaller().unmarshal(is);
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | ClassCastException | JAXBException e) {
                        LOG.error("Unable to read documentation for keyword from disc", e);
                        return null;
                    }
                }
                is.close();
            }
            return goKeywordDescription;
        });
    }

    @NotNull
    private static String generateFurtherReadingTitle(@NotNull String href) {
        if (href == null) {
            GoDocumentationProvider.$$$reportNull$$$0(67);
        }
        if (href.contains("go.dev/doc/effective_go")) {
            String string = GoBundle.message((String)"go.quick.doc.keyword.resource.effective.go.label", (Object[])new Object[0]);
            if (string == null) {
                GoDocumentationProvider.$$$reportNull$$$0(68);
            }
            return string;
        }
        if (href.contains("go.dev/blog")) {
            String string = GoBundle.message((String)"go.quick.doc.keyword.resource.go.blog.label", (Object[])new Object[0]);
            if (string == null) {
                GoDocumentationProvider.$$$reportNull$$$0(69);
            }
            return string;
        }
        String string = href.split("#")[0];
        if (string == null) {
            GoDocumentationProvider.$$$reportNull$$$0(70);
        }
        return string;
    }

    private static int start(StringBuilder builder, String start) {
        int initialLength = builder.length();
        builder.append(start);
        return initialLength;
    }

    private static void finishOrDiscard(StringBuilder builder, int initialLength, String start, String end) {
        if (builder.length() == initialLength + start.length()) {
            builder.setLength(initialLength);
        } else {
            builder.append(end).append('\n');
        }
    }

    private static void addSection(@NotNull StringBuilder builder, @Nls @NotNull String name, @Nullable String content2) {
        if (builder == null) {
            GoDocumentationProvider.$$$reportNull$$$0(71);
        }
        if (name == null) {
            GoDocumentationProvider.$$$reportNull$$$0(72);
        }
        if (StringUtil.isNotEmpty((String)content2)) {
            builder.append("<tr><td valign='top' class='section'><p>");
            builder.append(name);
            builder.append("</td><td valign='top'>");
            builder.append(content2);
            builder.append("</td>");
            builder.append('\n');
        }
    }

    @NotNull
    private static String getPackageHeader(PsiElement element) {
        GoFile file = element != null ? (GoFile)((Object)ObjectUtils.tryCast((Object)element.getContainingFile(), GoFile.class)) : null;
        String packageName = file != null ? file.getPackageName() : null;
        PsiDirectory directory = file != null ? file.getContainingDirectory() : null;
        String url = directory != null ? GoDocumentationProvider.getLocalUrlToElement((PsiElement)directory) : null;
        return url != null ? String.format("<p><a href=\"%s%s\">%s</a></p>\n", "psi_element://", url, packageName) : "";
    }

    private static void appendExample(@NotNull PsiElement element, @NotNull StringBuilder result, @NotNull Example example) {
        if (element == null) {
            GoDocumentationProvider.$$$reportNull$$$0(73);
        }
        if (result == null) {
            GoDocumentationProvider.$$$reportNull$$$0(74);
        }
        if (example == null) {
            GoDocumentationProvider.$$$reportNull$$$0(75);
        }
        result.append("\n<br/><div><a href='goExample://");
        result.append(example.myName);
        result.append("'>");
        result.append(example.myName);
        result.append("</a></div>\n");
        if (example.myOutput != null) {
            result.append("<div>Code:</div>\n");
        }
        result.append("<div style='padding-left: 10px;'>");
        String html = GoDocumentationProvider.convertToHtml(element.getProject(), example.myCode);
        result.append(html);
        result.append("</div>\n");
        if (example.myOutput != null) {
            result.append("<div>Output:</div>\n");
            result.append("<div style='padding-left: 10px;'><pre>");
            result.append(StringUtil.escapeXmlEntities((String)example.myOutput));
            result.append("</pre></div>\n");
        }
    }

    @NotNull
    private static List<Example> getExamples(@NotNull PsiElement element) {
        String name;
        if (element == null) {
            GoDocumentationProvider.$$$reportNull$$$0(76);
        }
        SmartList result = new SmartList();
        String string = name = element instanceof PsiNamedElement ? ((PsiNamedElement)element).getName() : null;
        if (name == null) {
            SmartList smartList = result;
            if (smartList == null) {
                GoDocumentationProvider.$$$reportNull$$$0(77);
            }
            return smartList;
        }
        for (GoFunctionDeclaration exampleFunction : GoDocumentationProvider.getTestFinder().findExampleFunctions(element)) {
            String exampleOutput;
            String exampleName = GoDocumentationProvider.getExampleName(element, exampleFunction);
            String exampleCode = exampleName != null ? exampleFunction.getExampleCode() : null;
            String string2 = exampleOutput = exampleCode != null ? exampleFunction.getExampleOutput() : null;
            if (exampleName == null || exampleCode == null) continue;
            result.add(new Example(exampleName, exampleCode, exampleOutput));
        }
        ContainerUtil.sort((List)result, Comparator.comparing(it -> it.myName));
        SmartList smartList = result;
        if (smartList == null) {
            GoDocumentationProvider.$$$reportNull$$$0(78);
        }
        return smartList;
    }

    @Nullable
    private static String getExampleName(@NotNull PsiElement element, @NotNull GoFunctionDeclaration exampleFunction) {
        String exampleName;
        if (element == null) {
            GoDocumentationProvider.$$$reportNull$$$0(79);
        }
        if (exampleFunction == null) {
            GoDocumentationProvider.$$$reportNull$$$0(80);
        }
        if ((exampleName = exampleFunction.getName()) == null) {
            return null;
        }
        String examplePrefix = GoTestFinder.getExamplePrefix(element);
        if (examplePrefix == null) {
            return null;
        }
        if (exampleName.equals(examplePrefix)) {
            return "Example";
        }
        if (exampleName.startsWith(examplePrefix + "_")) {
            String details = exampleName.substring(examplePrefix.length() + 1);
            return "Example (" + details + ")";
        }
        return null;
    }

    private static void appendMethodSections(@NotNull StringBuilder builder, @NotNull GoTypeSpec typeSpec, @Nullable PsiElement context) {
        List definedOnValueType;
        if (builder == null) {
            GoDocumentationProvider.$$$reportNull$$$0(81);
        }
        if (typeSpec == null) {
            GoDocumentationProvider.$$$reportNull$$$0(82);
        }
        if (DumbService.isDumb((Project)typeSpec.getProject())) {
            return;
        }
        List<GoMethodDeclaration> methods = typeSpec.getMethods();
        if (methods.isEmpty()) {
            return;
        }
        GoNavigatablePsiPresentationFunction presentationFunction = new GoNavigatablePsiPresentationFunction(context);
        GoPsiPresentationBuilder goPsiPresentationBuilder = GoPsiPresentationBuilder.create().withPresentationFunction(presentationFunction).html();
        int length = GoDocumentationProvider.start(builder, "<table class='sections'>");
        List definedOnPointerType = ContainerUtil.filter(methods, method -> method.getReceiverType() instanceof GoPointerType);
        if (!definedOnPointerType.isEmpty()) {
            String methodListHeader = GoBundle.message((String)"go.quick.doc.methods.on.label", (Object[])new Object[0]) + " (*" + typeSpec.getName() + "):";
            String methodList = GoDocumentationProvider.formatMethodList(definedOnPointerType, goPsiPresentationBuilder);
            GoDocumentationProvider.addSection(builder, methodListHeader, methodList);
        }
        if (!(definedOnValueType = ContainerUtil.filter(methods, method -> !(method.getReceiverType() instanceof GoPointerType))).isEmpty()) {
            String methodListHeader = GoBundle.message((String)"go.quick.doc.methods.on.label", (Object[])new Object[0]) + " (" + typeSpec.getName() + "):";
            String methodList = GoDocumentationProvider.formatMethodList(definedOnValueType, goPsiPresentationBuilder);
            GoDocumentationProvider.addSection(builder, methodListHeader, methodList);
        }
        GoDocumentationProvider.finishOrDiscard(builder, length, "<table class='sections'>", "</table>");
    }

    @NotNull
    private static String formatMethodList(@NotNull List<GoMethodDeclaration> methodDeclarations, @NotNull GoPsiPresentationBuilder psiPresentationBuilder) {
        if (methodDeclarations == null) {
            GoDocumentationProvider.$$$reportNull$$$0(83);
        }
        if (psiPresentationBuilder == null) {
            GoDocumentationProvider.$$$reportNull$$$0(84);
        }
        if (methodDeclarations.isEmpty()) {
            return "";
        }
        String string = "<pre>" + StringUtil.join(methodDeclarations, element -> psiPresentationBuilder.build((GoSignatureOwner)element, false, true), (String)"\n") + "</pre>";
        if (string == null) {
            GoDocumentationProvider.$$$reportNull$$$0(85);
        }
        return string;
    }

    @NotNull
    private static String formatSubstitution(@NotNull GoSubstitution substitution, @NotNull GoPsiPresentationBuilder psiPresentationBuilder) {
        if (substitution == null) {
            GoDocumentationProvider.$$$reportNull$$$0(86);
        }
        if (psiPresentationBuilder == null) {
            GoDocumentationProvider.$$$reportNull$$$0(87);
        }
        String string = "<pre>" + psiPresentationBuilder.build(substitution) + "</pre>";
        if (string == null) {
            GoDocumentationProvider.$$$reportNull$$$0(88);
        }
        return string;
    }

    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        String externalLink;
        PsiElement docElement = GoDocumentationProvider.adjustDocElement(element);
        if (GoDocumentationProvider.hasUrl(docElement) && (!(docElement instanceof GoNamedElement) || ((GoNamedElement)docElement).isPublic() || GoPsiImplUtil.isBuiltinFile(docElement.getContainingFile())) && StringUtil.isNotEmpty((String)(externalLink = GoDocumentationProvider.getExternalLink(docElement, GoVendoringUtil.isVendoringEnabled(docElement))))) {
            return Collections.singletonList(externalLink);
        }
        return super.getUrlFor(element, originalElement);
    }

    @NonNls
    @Nullable
    private static String getExternalLink(@Nullable PsiElement element, boolean vendoring) {
        String importPath;
        String anchor = null;
        GoPackage pkg = null;
        if (element instanceof GoNamedElement) {
            anchor = GoDocumentationProvider.getExternalLinkAnchor(element);
            GoFile file = (GoFile)((Object)ObjectUtils.tryCast((Object)element.getContainingFile(), GoFile.class));
            pkg = file != null ? GoPackage.of(file) : null;
        } else if (element instanceof PsiDirectory && GoDocumentationProvider.findDocFileForDirectory((PsiDirectory)element) != null) {
            anchor = "";
            pkg = (GoPackage)ContainerUtil.find(GoPackage.in((PsiDirectory)element), it -> it.getImportPath(vendoring) != null);
        }
        String string = importPath = pkg != null ? pkg.getImportPath(vendoring) : null;
        if (anchor == null || importPath == null) {
            return null;
        }
        String version = GoDocumentationPackageVersionProvider.getPackageVersion(pkg);
        return "https://pkg.go.dev/" + importPath + (String)(StringUtil.isNotEmpty((String)version) ? "@" + version : "") + (String)(StringUtil.isNotEmpty((String)anchor) ? "#" + anchor : "");
    }

    @Nullable
    private static String getExternalLinkAnchor(@Nullable PsiElement element) {
        if (element instanceof GoFunctionDeclaration || element instanceof GoTypeSpec || element instanceof GoVarOrConstDefinition) {
            return StringUtil.nullize((String)((GoNamedElement)element).getName());
        }
        if (element instanceof GoMethodDeclaration) {
            GoType receiverType = ((GoMethodDeclaration)element).getReceiverType();
            String receiver = GoTypeUtil.getReceiverTypeName(receiverType);
            String methodName = ((GoMethodDeclaration)element).getName();
            if (StringUtil.isNotEmpty((String)receiver) && StringUtil.isNotEmpty((String)methodName)) {
                return receiver + "." + methodName;
            }
        }
        if (element instanceof GoMethodSpec && ((GoMethodSpec)element).getTypeReferenceExpression() == null || element instanceof GoFieldDefinition) {
            GoTypeSpec typeSpec = (GoTypeSpec)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)element, GoTypeSpec.class);
            String typeName = typeSpec != null ? typeSpec.getName() : null;
            String memberName = ((GoNamedElement)element).getName();
            if (StringUtil.isNotEmpty((String)memberName) && StringUtil.isNotEmpty((String)typeName)) {
                return typeName + "." + memberName;
            }
        }
        return null;
    }

    @Nullable
    @Nls
    public String getQuickNavigateInfo(PsiElement element, @Nullable PsiElement originalElement) {
        if (element instanceof GoNamedElement) {
            GoVarOrConstDefinition definition;
            String value;
            HtmlBuilder builder = new HtmlBuilder();
            String signature = GoDocumentationProvider.getSignature((GoNamedElement)element, originalElement);
            if (!signature.isEmpty()) {
                builder.append((HtmlChunk)HtmlChunk.raw((String)signature).code());
            }
            if (StringUtil.isNotEmpty((String)((GoNamedElement)element).getName()) && element instanceof GoVarOrConstDefinition && StringUtil.isNotEmpty((String)(value = GoDocumentationProvider.getResolvedValueText(definition = (GoVarOrConstDefinition)element)))) {
                builder.append((HtmlChunk)HtmlChunk.br()).append(GoBundle.message((String)"go.quick.doc.resolved.value.label", (Object[])new Object[0])).append(" ").append(value);
            }
            if (!builder.isEmpty()) {
                return builder.wrapWith(HtmlChunk.div()).toString();
            }
        }
        if (element instanceof GoLinkDefinition) {
            GoLinkDefinition linkDef = (GoLinkDefinition)element;
            HtmlBuilder builder = new HtmlBuilder();
            builder.append("[").append(linkDef.getLinkText()).append("]: ").append(linkDef.getUrl());
            return builder.wrapWith(HtmlChunk.div()).toString();
        }
        return null;
    }

    public PsiElement getDocumentationElementForLink(@NotNull PsiManager psiManager, @NotNull String link, @Nullable PsiElement context) {
        if (psiManager == null) {
            GoDocumentationProvider.$$$reportNull$$$0(89);
        }
        if (link == null) {
            GoDocumentationProvider.$$$reportNull$$$0(90);
        }
        if (!DumbService.isDumb((Project)psiManager.getProject())) {
            GoDocLink docLink = GoDocLink.parseLink(link);
            Project project = psiManager.getProject();
            ResolveState state = GoPsiImplUtil.createContextOnElement(context);
            Collection<GoPackage> packages = GoPackageUtil.findByImportPath(docLink.getImportPath(), project, GoUtil.module(context), state);
            if (docLink.canFindElement()) {
                return docLink.findElement(project, packages);
            }
            return GoPackageUtil.getFirstNavigableDirectory(packages);
        }
        return super.getDocumentationElementForLink(psiManager, link, context);
    }

    @NotNull
    private static Pair<String, String> getKeywordStyle(@NotNull Project project) {
        if (project == null) {
            GoDocumentationProvider.$$$reportNull$$$0(91);
        }
        Pair defaultKeywordStyle = Pair.create((Object)"<b>", (Object)"</b>");
        String text = "package";
        String html = GoDocumentationProvider.convertToHtml(project, text);
        int idx = html.indexOf(text);
        Pair pair = idx < 0 ? defaultKeywordStyle : Pair.create((Object)html.substring(0, idx), (Object)html.substring(idx + text.length()));
        if (pair == null) {
            GoDocumentationProvider.$$$reportNull$$$0(92);
        }
        return pair;
    }

    @VisibleForTesting
    @NotNull
    public static String convertToHtml(@NotNull Project project, @NotNull String code) {
        if (project == null) {
            GoDocumentationProvider.$$$reportNull$$$0(93);
        }
        if (code == null) {
            GoDocumentationProvider.$$$reportNull$$$0(94);
        }
        String string = QuickDocHighlightingHelper.getStyledCodeFragment((Project)project, (Language)GoLanguage.INSTANCE, (String)code);
        if (string == null) {
            GoDocumentationProvider.$$$reportNull$$$0(95);
        }
        return string;
    }

    @Nullable
    public static DocCommentLinkProvider getCommentLinkProvider(@Nullable PsiElement element) {
        if (!Registry.is((String)"go.comment.references.enabled")) {
            return null;
        }
        GoCommentReferenceResolver resolver = GoCommentReferenceResolver.getResolver(element);
        if (resolver == null) {
            return null;
        }
        GoNamedElement commentTarget = (GoNamedElement)ObjectUtils.tryCast((Object)element, GoNamedElement.class);
        return new DocCommentLinkProvider(resolver, commentTarget);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 15, 19, 20, 21, 22, 23, 24, 25, 27, 29, 30, 32, 35, 36, 41, 42, 44, 45, 46, 50, 51, 58, 59, 68, 69, 70, 77, 78, 85, 88, 92, 95 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
            case 2: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 35: 
            case 36: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 50: 
            case 51: 
            case 58: 
            case 59: 
            case 68: 
            case 69: 
            case 70: 
            case 77: 
            case 78: 
            case 85: 
            case 88: 
            case 92: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/documentation/GoDocumentationProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: 
            case 28: 
            case 31: 
            case 33: 
            case 34: 
            case 40: 
            case 43: 
            case 52: 
            case 55: 
            case 56: 
            case 60: 
            case 64: 
            case 65: 
            case 73: 
            case 76: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 11: 
            case 13: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: 
            case 49: 
            case 91: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentsSupplier";
                break;
            }
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 47: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywordStyle";
                break;
            }
            case 53: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSpec";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 57: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 61: 
            case 63: 
            case 71: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywordElement";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "href";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "example";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exampleFunction";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodDeclarations";
                break;
            }
            case 84: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPresentationBuilder";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitution";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/documentation/GoDocumentationProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentText";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFinder";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentsForElementInner";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentsForElementStrict";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "excludeDirectives";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getAfterComments";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyComment";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpperComments";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignature";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "calcSignature";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionHtml";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementFqn";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "generateFurtherReadingTitle";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getExamples";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "formatMethodList";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "formatSubstitution";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywordStyle";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToHtml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCommentText";
                break;
            }
            case 2: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 35: 
            case 36: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 50: 
            case 51: 
            case 58: 
            case 59: 
            case 68: 
            case 69: 
            case 70: 
            case 77: 
            case 78: 
            case 85: 
            case 88: 
            case 92: 
            case 95: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCustomDocumentationElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isKeyword";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isChannelOperation";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findCommentedElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findCommentedElementBelow";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getExampleFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findExample";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createScratchFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCommentsForElementInner";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "excludeDirectives";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getAfterComments";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyComment";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getUpperComments";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getFirstDefinitionWithoutOwnComments";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getFirstTypeSpecWithoutOwnComments";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedValueText";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getSignature";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "calcSignature";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "generateInternalKeywordLink";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "calcTagMarkup";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getLocalUrlToElement";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "hasFieldDefinition";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceToTypeMember";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getElementFqn";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "generateHoverDoc";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "generateKeywordDocumentation";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "generateChannelDoc";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "isKeywordElementEmptyInterface";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "retrieveKeywordDescription";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "generateFurtherReadingTitle";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "addSection";
                break;
            }
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "appendExample";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getExamples";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getExampleName";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "appendMethodSections";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "formatMethodList";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "formatSubstitution";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentationElementForLink";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getKeywordStyle";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "convertToHtml";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 15, 19, 20, 21, 22, 23, 24, 25, 27, 29, 30, 32, 35, 36, 41, 42, 44, 45, 46, 50, 51, 58, 59, 68, 69, 70, 77, 78, 85, 88, 92, 95 -> new IllegalStateException(string);
        };
    }

    public static final class DocCommentLinkProvider
    implements GoCommentsConverter.GoCommentLinkProvider {
        private final GoCommentReferenceResolver myResolver;
        private final GoNamedElement myCommentTarget;
        private final GoCommentReferenceResolveContext myResolveContext;

        private DocCommentLinkProvider(@NotNull GoCommentReferenceResolver resolver, @Nullable GoNamedElement commentTarget) {
            if (resolver == null) {
                DocCommentLinkProvider.$$$reportNull$$$0(0);
            }
            this.myResolver = resolver;
            this.myCommentTarget = commentTarget;
            this.myResolveContext = GoCommentReferenceResolver.createResolveContext(this.myCommentTarget);
        }

        @Override
        @Nullable
        public String getWordLink(@NotNull String word) {
            PsiElement element;
            if (word == null) {
                DocCommentLinkProvider.$$$reportNull$$$0(1);
            }
            if ((element = this.myResolver.resolveWord(this.myResolveContext, word)) == this.myCommentTarget) {
                return null;
            }
            return DocCommentLinkProvider.getLink(element);
        }

        @Override
        public @Unmodifiable @NotNull List<String> getWordChainLinks(@NotNull List<String> wordChainParts) {
            if (wordChainParts == null) {
                DocCommentLinkProvider.$$$reportNull$$$0(2);
            }
            List list = ContainerUtil.map(this.myResolver.resolveWordChain(this.myResolveContext, wordChainParts), it -> DocCommentLinkProvider.getLink(it));
            if (list == null) {
                DocCommentLinkProvider.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Override
        public @Unmodifiable @NotNull List<Pair<String, String>> getDocLinkLinks(@NotNull GoDocLinkToken docLink, @NotNull String docLinkText) {
            if (docLink == null) {
                DocCommentLinkProvider.$$$reportNull$$$0(4);
            }
            if (docLinkText == null) {
                DocCommentLinkProvider.$$$reportNull$$$0(5);
            }
            List<Pair<TextRange, PsiElement>> links = this.myResolver.resolveDocLink(this.myResolveContext, docLink);
            List list = ContainerUtil.map(links, it -> Pair.create((Object)((TextRange)it.first).substring(docLinkText), (Object)DocCommentLinkProvider.getLink((PsiElement)it.second)));
            if (list == null) {
                DocCommentLinkProvider.$$$reportNull$$$0(6);
            }
            return list;
        }

        @Nullable
        private static String getLink(@Nullable PsiElement element) {
            String url = element != null ? GoDocumentationProvider.getLocalUrlToElement(element) : null;
            return url != null ? "psi_element://" + url : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolver";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "word";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wordChainParts";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/documentation/GoDocumentationProvider$DocCommentLinkProvider";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "docLink";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "docLinkText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/documentation/GoDocumentationProvider$DocCommentLinkProvider";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWordChainLinks";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDocLinkLinks";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getWordLink";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getWordChainLinks";
                    break;
                }
                case 3: 
                case 6: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getDocLinkLinks";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 6 -> new IllegalStateException(string);
            };
        }
    }

    private static final class Example {
        private final String myName;
        private final String myCode;
        private final String myOutput;

        Example(@NotNull String name, @NotNull String code, @Nullable String output2) {
            if (name == null) {
                Example.$$$reportNull$$$0(0);
            }
            if (code == null) {
                Example.$$$reportNull$$$0(1);
            }
            this.myName = name;
            this.myCode = code;
            this.myOutput = output2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "code";
                    break;
                }
            }
            objectArray[1] = "com/goide/documentation/GoDocumentationProvider$Example";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

