/*
 * Decompiled with CFR 0.152.
 */
package com.goide.editor;

import com.goide.GoFileType;
import com.goide.i18n.GoBundle;
import com.goide.index.GoImportPathToAliasIndexKt;
import com.goide.psi.GoFile;
import com.goide.psi.GoImportSpec;
import com.goide.sdk.GoSdkService;
import com.goide.util.GoUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GoInstallTemplatePluginNotificationProvider
implements EditorNotificationProvider,
DumbAware {
    private static final String DO_NOT_SUGGEST_PLUGIN = "do.not.suggest.installing.go.template.plugin";
    private static final String GO_TEMPLATE_PLUGIN_ID = "org.jetbrains.plugins.go-template";
    private volatile boolean myEnabled = true;

    GoInstallTemplatePluginNotificationProvider() {
    }

    @Nullable
    public @Nullable Function<? super @NotNull FileEditor, ? extends @Nullable JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        GlobalSearchScope scope;
        if (project == null) {
            GoInstallTemplatePluginNotificationProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            GoInstallTemplatePluginNotificationProvider.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() || !this.myEnabled || Lazy.PLUGIN != null && Lazy.PLUGIN.isEnabled() || PropertiesComponent.getInstance((Project)project).isTrueValue(DO_NOT_SUGGEST_PLUGIN)) {
            return null;
        }
        Module module = GoUtil.module(project, file);
        if (!GoSdkService.getInstance(project).isGoModule(module)) {
            return null;
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        if (fileTypeManager.isFileOfType(file, (FileType)GoFileType.INSTANCE)) {
            Map<String, GoImportSpec> imports;
            GoFile psiFile = (GoFile)((Object)ObjectUtils.tryCast((Object)PsiManager.getInstance((Project)project).findFile(file), GoFile.class));
            if (psiFile != null && ((imports = psiFile.getImportedPackagesMap()).containsKey("text/template") || imports.containsKey("html/template"))) {
                return fileEditor -> this.createPanel(project, (FileEditor)fileEditor);
            }
        } else if (!(!fileTypeManager.isFileOfType(file, FileTypeManager.getInstance().getStdFileType("HTML")) || GoImportPathToAliasIndexKt.processAliasesByImportPath(scope = GoUtil.moduleScopeWithoutLibraries(project, module), "text/template", (FileBasedIndex.ValueProcessor<? super String>)((FileBasedIndex.ValueProcessor)(f, v) -> false)) && GoImportPathToAliasIndexKt.processAliasesByImportPath(scope, "html/template", (FileBasedIndex.ValueProcessor<? super String>)((FileBasedIndex.ValueProcessor)(f, v) -> false)))) {
            return fileEditor -> this.createPanel(project, (FileEditor)fileEditor);
        }
        return null;
    }

    @RequiresEdt
    @Nullable
    private EditorNotificationPanel createPanel(@NotNull Project project, @NotNull FileEditor fileEditor) {
        if (project == null) {
            GoInstallTemplatePluginNotificationProvider.$$$reportNull$$$0(2);
        }
        if (fileEditor == null) {
            GoInstallTemplatePluginNotificationProvider.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (Lazy.PLUGIN != null && Lazy.PLUGIN.isEnabled()) {
            return null;
        }
        EditorNotificationPanel panel = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Info);
        if (Lazy.PLUGIN != null) {
            panel.setText(GoBundle.message((String)"go.enable.template.plugin.notification.text", (Object[])new Object[0]));
            panel.createActionLabel(GoBundle.message((String)"go.enable.template.plugin.action.text", (Object[])new Object[0]), () -> {
                if (project.isDisposed()) {
                    return;
                }
                PluginManagerConfigurable.showPluginConfigurableAndEnable((Project)project, Set.of(Lazy.PLUGIN));
                EditorNotifications.getInstance((Project)project).updateAllNotifications();
            });
        } else {
            panel.setText(GoBundle.message((String)"go.install.template.plugin.notification.text", (Object[])new Object[0]));
            panel.createActionLabel(GoBundle.message((String)"go.install.template.plugin.action.text", (Object[])new Object[0]), () -> {
                if (project.isDisposed()) {
                    return;
                }
                PluginsAdvertiser.installAndEnable((Project)project, Collections.singleton(Lazy.PLUGIN_ID), (boolean)true, () -> {
                    this.myEnabled = false;
                    EditorNotifications.getInstance((Project)project).updateAllNotifications();
                });
            });
        }
        panel.createActionLabel(GoBundle.message((String)"go.ignore.template.plugin.action.text", (Object[])new Object[0]), () -> {
            if (project.isDisposed()) {
                return;
            }
            PropertiesComponent.getInstance((Project)project).setValue(DO_NOT_SUGGEST_PLUGIN, true);
            EditorNotifications.getInstance((Project)project).updateAllNotifications();
        });
        return panel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        objectArray2[1] = "com/goide/editor/GoInstallTemplatePluginNotificationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectNotificationData";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createPanel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static interface Lazy {
        public static final PluginId PLUGIN_ID = PluginId.getId((String)"org.jetbrains.plugins.go-template");
        public static final IdeaPluginDescriptor PLUGIN = PluginManagerCore.getPlugin((PluginId)PLUGIN_ID);
    }
}

