/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution;

import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GoVersions {
    private static final Logger LOG = Logger.getInstance(GoVersions.class);
    private static final Map<String, Pair<Long, String>> ourGoVersions = new ConcurrentHashMap<String, Pair<Long, String>>();

    GoVersions() {
    }

    @RequiresBackgroundThread
    @Nullable
    static String getGoVersionOutput(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            GoVersions.$$$reportNull$$$0(0);
        }
        ThreadingAssertions.assertBackgroundThread();
        GoSdk sdk = GoSdkService.getInstance(project).getSdk(module);
        VirtualFile go = sdk.getExecutable();
        if (go == null) {
            LOG.debug("Cannot retrieve go version: go executable is not found");
            return null;
        }
        long timeStamp = go.getTimeStamp();
        Pair<Long, String> existing = ourGoVersions.get(go.getPath());
        if (existing != null && ((Long)existing.first).equals(timeStamp)) {
            return (String)existing.second;
        }
        String goVersion = GoVersions.runGoVersion(go.getPath());
        ourGoVersions.put(go.getPath(), (Pair<Long, String>)Pair.create((Object)timeStamp, (Object)goVersion));
        return goVersion;
    }

    @RequiresBackgroundThread
    @Nullable
    private static String runGoVersion(@NotNull String goExecutable) {
        if (goExecutable == null) {
            GoVersions.$$$reportNull$$$0(1);
        }
        ThreadingAssertions.assertBackgroundThread();
        GeneralCommandLine goVersion = new GeneralCommandLine(new String[]{goExecutable, "version"});
        try {
            Process proc = goVersion.createProcess();
            proc.waitFor(10L, TimeUnit.SECONDS);
            String output2 = StreamUtil.readText((Reader)new InputStreamReader(proc.getInputStream(), StandardCharsets.UTF_8)).trim();
            String result = StringUtil.nullize((String)output2);
            if (result == null) {
                LOG.warn("Empty output from go version command");
            }
            return result;
        }
        catch (Exception e) {
            LOG.warn("Failed to run go version", (Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goExecutable";
                break;
            }
        }
        objectArray2[1] = "com/goide/execution/GoVersions";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getGoVersionOutput";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "runGoVersion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

