/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.testing;

import com.goide.GoConstants;
import com.goide.GoNotifications;
import com.goide.GoOsManager;
import com.goide.execution.GoBuildingRunConfiguration;
import com.goide.execution.GoBuildingRunningState;
import com.goide.execution.GoConsoleFilter;
import com.goide.execution.GoLazyDelegatingSearchScope;
import com.goide.execution.GoRunUtil;
import com.goide.execution.GoRunningState;
import com.goide.execution.GoRuntimeErrorsListener;
import com.goide.execution.target.GoLanguageRuntimeType;
import com.goide.execution.testing.GoTestConsoleProperties;
import com.goide.execution.testing.GoTestFinder;
import com.goide.execution.testing.GoTestRunConfiguration;
import com.goide.execution.testing.frameworks.gofuzz.GoFuzzFramework;
import com.goide.execution.testing.frameworks.gofuzz.GoTestFuzzFuncFailureOnSeedFileConsoleFilter;
import com.goide.execution.testing.frameworks.gofuzz.GoTestFuzzFuncRunConsoleFilter;
import com.goide.execution.testing.frameworks.gofuzz.GoTestSeedCorpusFailureConsoleFilter;
import com.goide.execution.testing.frameworks.testify.GoTestifySupport;
import com.goide.i18n.GoBundle;
import com.goide.inspections.buildTag.GoBuildElement;
import com.goide.inspections.buildTag.GoBuildTagEnvironment;
import com.goide.inspections.buildTag.GoBuildTagUtil;
import com.goide.inspections.buildTag.plusBuild.GoPlusBuildElement;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoNamedElement;
import com.goide.psi.properties.GoFileProperties;
import com.goide.sdk.GoSdkService;
import com.goide.stubs.index.GoFunctionIndex;
import com.goide.stubs.index.GoIdFilter;
import com.goide.stubs.index.GoMethodFingerprintIndex;
import com.goide.util.GoBuildMatcher;
import com.goide.util.GoCommandLineParameter;
import com.goide.util.GoExecutor;
import com.goide.util.GoUtil;
import com.google.common.base.Suppliers;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.process.ElevationService;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.actions.AbstractRerunFailedTestsAction;
import com.intellij.execution.testframework.autotest.ToggleAutoTestAction;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.execution.testframework.sm.runner.ui.TestResultsViewer;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoTestRunningState
extends GoBuildingRunningState<GoTestRunConfiguration> {
    private String myFailedTestsPattern;
    @NotNull
    private final GoLazyDelegatingSearchScope myConsoleScope;
    @NotNull
    private final Supplier<String> myBuildTagsSupplier;

    public GoTestRunningState(@NotNull ExecutionEnvironment env, @NotNull Module module, @NotNull GoTestRunConfiguration configuration) {
        if (env == null) {
            GoTestRunningState.$$$reportNull$$$0(0);
        }
        if (module == null) {
            GoTestRunningState.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            GoTestRunningState.$$$reportNull$$$0(2);
        }
        super(env, module, configuration);
        this.myBuildTagsSupplier = Suppliers.memoize(this::getBuildTagsModal);
        this.myConsoleScope = new GoLazyDelegatingSearchScope(env.getProject(), () -> configuration.getSearchScope());
    }

    @Override
    @Nullable
    public List<GoCommandLineParameter> getBuildingTarget() {
        return switch (((GoTestRunConfiguration)this.myConfiguration).getKind()) {
            default -> throw new IncompatibleClassChangeError();
            case GoBuildingRunConfiguration.Kind.DIRECTORY -> {
                List<GoCommandLineParameter> var1_1 = Collections.singletonList(GoCommandLineParameter.map(GoCommandLineParameter.path(((GoTestRunConfiguration)this.myConfiguration).getDirectoryPath()), s -> s + "/..."));
                yield var1_1;
            }
            case GoBuildingRunConfiguration.Kind.PACKAGE -> {
                List<GoCommandLineParameter> var1_2;
                yield var1_2 = Collections.singletonList(GoCommandLineParameter.string(((GoTestRunConfiguration)this.myConfiguration).getPackage()));
            }
            case GoBuildingRunConfiguration.Kind.FILE -> {
                List<GoCommandLineParameter> var1_4;
                List<String> filePaths = ((GoTestRunConfiguration)this.myConfiguration).getFilePaths();
                if (filePaths.size() == 1) {
                    try {
                        String importPath = ((GoTestRunConfiguration)this.myConfiguration).findGoFile((String)ContainerUtil.getFirstItem(filePaths)).getImportPath(false);
                        if (StringUtil.isNotEmpty((String)importPath)) {
                            List<GoCommandLineParameter> var1_3;
                            yield var1_3 = Collections.singletonList(GoCommandLineParameter.string(importPath));
                        }
                    }
                    catch (ExecutionException var3_7) {
                        // empty catch block
                    }
                }
                yield var1_4 = ContainerUtil.map(filePaths, GoCommandLineParameter::path);
            }
        };
    }

    @Override
    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner, @NotNull ProcessHandler processHandler) throws ExecutionException {
        BaseTestsOutputConsoleView consoleView;
        TestConsoleProperties consoleProperties;
        ExecutionConsole console;
        ExecutionResult executionResult;
        if (executor == null) {
            GoTestRunningState.$$$reportNull$$$0(3);
        }
        if (runner == null) {
            GoTestRunningState.$$$reportNull$$$0(4);
        }
        if (processHandler == null) {
            GoTestRunningState.$$$reportNull$$$0(5);
        }
        if ((executionResult = super.execute(executor, runner, processHandler)) instanceof DefaultExecutionResult && (console = executionResult.getExecutionConsole()) instanceof BaseTestsOutputConsoleView && (consoleProperties = (consoleView = (BaseTestsOutputConsoleView)console).getProperties()) instanceof SMTRunnerConsoleProperties) {
            AbstractRerunFailedTestsAction rerun = ((SMTRunnerConsoleProperties)consoleProperties).createRerunFailedTestsAction((ConsoleView)consoleView);
            if (rerun != null) {
                rerun.setModelProvider(() -> consoleView instanceof SMTRunnerConsoleView && ((SMTRunnerConsoleView)consoleView).getResultsViewer().getFailedTestCount() > 0 ? ((SMTRunnerConsoleView)consoleView).getResultsViewer() : null);
                ((DefaultExecutionResult)executionResult).setRestartActions(new AnAction[]{rerun, new ToggleAutoTestAction()});
            } else {
                ((DefaultExecutionResult)executionResult).setRestartActions(new AnAction[]{new ToggleAutoTestAction()});
            }
        }
        ExecutionResult executionResult2 = executionResult;
        if (executionResult2 == null) {
            GoTestRunningState.$$$reportNull$$$0(6);
        }
        return executionResult2;
    }

    @Override
    @NotNull
    protected String getRunParameters() {
        String parameters = super.getRunParameters();
        if (this.myFailedTestsPattern != null) {
            ArrayList<String> resultParameterList = new ArrayList<String>();
            @NotNull List parametersList = ParametersListUtil.parse((String)parameters, (boolean)false, (boolean)true);
            String matchMethodFlag = "-" + GoTestifySupport.testifyMatchMethodFlag();
            Iterator iterator = parametersList.iterator();
            while (iterator.hasNext()) {
                String parameter = (String)iterator.next();
                if (parameter.equals(matchMethodFlag)) {
                    resultParameterList.add(parameter);
                    resultParameterList.add(this.myFailedTestsPattern);
                    if (!iterator.hasNext()) continue;
                    iterator.next();
                    continue;
                }
                resultParameterList.add(parameter);
            }
            String string = ParametersListUtil.join(resultParameterList);
            if (string == null) {
                GoTestRunningState.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = parameters;
        if (string == null) {
            GoTestRunningState.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @Nullable
    protected ConsoleView createConsoleInner(@NotNull Executor executor, final @NotNull ProcessHandler processHandler) throws ExecutionException {
        if (executor == null) {
            GoTestRunningState.$$$reportNull$$$0(9);
        }
        if (processHandler == null) {
            GoTestRunningState.$$$reportNull$$$0(10);
        }
        if (this.myCompilationExitCode == 0) {
            String frameworkName = ((GoTestRunConfiguration)this.myConfiguration).getTestFramework().getName();
            ((GoTestRunConfiguration)this.myConfiguration).setConsoleScope(this.getConsoleScope());
            GoTestConsoleProperties consoleProperties = ((GoTestRunConfiguration)this.myConfiguration).createTestConsoleProperties(executor);
            consoleProperties.setUsePredefinedMessageFilter(false);
            String splitterPropertyName = SMTestRunnerConnectionUtil.getSplitterPropertyName((String)frameworkName);
            SMTRunnerConsoleView consoleView = new SMTRunnerConsoleView((TestConsoleProperties)consoleProperties, splitterPropertyName);
            UIUtil.invokeLaterIfNeeded(() -> {
                SMTestRunnerConnectionUtil.initConsoleView((SMTRunnerConsoleView)consoleView, (String)frameworkName);
                final SMTestRunnerResultsForm resultsViewer = consoleView.getResultsViewer();
                resultsViewer.addEventsListener(new TestResultsViewer.EventsListener(){

                    public void onTestingFinished(@NotNull TestResultsViewer sender) {
                        if (sender == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (resultsViewer.getFinishedTestCount() == 0 && resultsViewer.getFailedTestCount() == 0) {
                            1.setError(GoBundle.message((String)"go.test.no.tests.were.run", (Object[])new Object[0]), true, resultsViewer);
                        } else {
                            Integer exitCode = processHandler.getExitCode();
                            if (exitCode != null && exitCode != 0) {
                                if (((GoTestRunConfiguration)GoTestRunningState.this.myConfiguration).getTestFramework() == GoFuzzFramework.INSTANCE && Boolean.TRUE.equals(processHandler.getUserData(ProcessHandler.TERMINATION_REQUESTED))) {
                                    return;
                                }
                                String message = GoBundle.message((String)"go.execution.process.finished.with.exit.code", (Object[])new Object[]{GoTestRunningState.this.getProcessName(), exitCode});
                                1.setError(message, false, resultsViewer);
                            }
                        }
                    }

                    private static void setError(@NotNull @Nls String message, boolean setRootName, @NotNull SMTestRunnerResultsForm resultsViewer2) {
                        if (message == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (resultsViewer2 == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        resultsViewer2.getStatusLine().setText(message);
                        SMTestProxy.SMRootTestProxy root = resultsViewer2.getTestsRootNode();
                        if (setRootName) {
                            root.setPresentation(message);
                        }
                        root.setTestFailed("", null, true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "sender";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "message";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "resultsViewer";
                                break;
                            }
                        }
                        objectArray2[1] = "com/goide/execution/testing/GoTestRunningState$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onTestingFinished";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "setError";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            });
            String workingDirectoryUrl = ((GoTestRunConfiguration)this.myConfiguration).getWorkingDirectoryUrl();
            GoConsoleFilter consoleFilter = new GoConsoleFilter(this.myEnvironment.getProject(), this.myModule, workingDirectoryUrl);
            consoleProperties.addStackTraceFilter(consoleFilter);
            GoTestSeedCorpusFailureConsoleFilter corpusFilter = new GoTestSeedCorpusFailureConsoleFilter(this.myEnvironment.getProject(), workingDirectoryUrl);
            consoleView.addMessageFilter((Filter)corpusFilter);
            GoTestFuzzFuncRunConsoleFilter runFilter = new GoTestFuzzFuncRunConsoleFilter(this.myEnvironment.getProject(), workingDirectoryUrl);
            consoleView.addMessageFilter((Filter)runFilter);
            GoTestFuzzFuncFailureOnSeedFileConsoleFilter failureFilter = new GoTestFuzzFuncFailureOnSeedFileConsoleFilter(this.myEnvironment.getProject(), workingDirectoryUrl);
            consoleView.addMessageFilter((Filter)failureFilter);
            return consoleView;
        }
        return super.createConsoleInner(executor, processHandler);
    }

    @Override
    protected GoExecutor createRunExecutor() throws ExecutionException {
        boolean supportsJsonTestsOutput;
        if (((GoTestRunConfiguration)this.myConfiguration).getKind() == GoBuildingRunConfiguration.Kind.DIRECTORY) {
            return this.createRunTestsInDirectoryExecutor();
        }
        GoExecutor executor = super.createRunExecutor();
        if (GoOsManager.isWindows()) {
            executor.withConsoleMode();
        }
        if (supportsJsonTestsOutput = ((GoTestRunConfiguration)this.myConfiguration).supportsJsonTestsOutput()) {
            if (this.isDebug()) {
                TargetEnvironmentRequest runner = executor.getTargetEnvironmentRequest();
                executor.withParametersAtStart(GoCommandLineParameter.path(GoRunUtil.dlv(runner).getAbsolutePath()));
            } else {
                executor.withParametersAtStart(GoCommandLineParameter.path(Objects.requireNonNull((String)this.myOutputFilePath.get())).withVolumeDescriptor(GoLanguageRuntimeType.COMPILED_EXECUTABLES_VOLUME));
            }
            executor.withExePath((GoCommandLineParameter)null).withParametersAtStart("tool", "test2json", "-t");
        }
        String testOutputMode = supportsJsonTestsOutput && GoSdkService.getInstance(this.myEnvironment.getProject()).getSdk(this.myModule).supportsMoreRobustTest2Json() ? "-test.v=test2json" : "-test.v";
        executor.withParameters(testOutputMode);
        if (((GoTestRunConfiguration)this.myConfiguration).supportsPanicOnExit0()) {
            executor.withParameters("-test.paniconexit0");
        }
        this.addFilterParameter(executor, this.getRunFilterParameter());
        if (this.myCoverageLocation != null) {
            executor.withParameters(GoCommandLineParameter.string("-test.coverprofile"), this.getCoverageFilePathParameter(executor));
        }
        return executor;
    }

    @NotNull
    public String getRunFilterParameter() {
        if (this.myFailedTestsPattern != null) {
            String string = this.myFailedTestsPattern;
            if (string == null) {
                GoTestRunningState.$$$reportNull$$$0(11);
            }
            return string;
        }
        String pattern = ((GoTestRunConfiguration)this.myConfiguration).getPattern();
        if (pattern.isEmpty() && ((GoTestRunConfiguration)this.myConfiguration).getKind() == GoBuildingRunConfiguration.Kind.FILE) {
            String string = (String)ReadAction.compute(() -> this.buildFilterPatternForFiles(((GoTestRunConfiguration)this.myConfiguration).getContextFiles()));
            if (string == null) {
                GoTestRunningState.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = pattern;
        if (string == null) {
            GoTestRunningState.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    protected GoExecutor createBuildExecutorInner() throws ExecutionException {
        if (((GoTestRunConfiguration)this.myConfiguration).getKind() == GoBuildingRunConfiguration.Kind.DIRECTORY) {
            String message = GoBundle.message((String)"go.test.cannot.run.compiling.on.directory.kind.run.configurations.error", (Object[])new Object[0]);
            throw new ExecutionExceptionWithLink(message){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && RunDialog.editConfiguration((ExecutionEnvironment)GoTestRunningState.this.myEnvironment, (String)ExecutionBundle.message((String)"dialog.title.edit.configuration", (Object[])new Object[]{0}))) {
                        ExecutionUtil.restart((ExecutionEnvironment)GoTestRunningState.this.myEnvironment);
                    }
                }
            };
        }
        GoExecutor executor = this.createCommonExecutor().withParameters("test", "-c");
        if (this.myCoverageLocation != null) {
            return this.addCommonCoverageFlags(executor);
        }
        return executor;
    }

    @Override
    @NotNull
    public String getBuildingWorkingDirectory() {
        GoBuildingRunConfiguration.Kind kind = ((GoTestRunConfiguration)this.myConfiguration).getKind();
        if (kind == GoBuildingRunConfiguration.Kind.PACKAGE || kind == GoBuildingRunConfiguration.Kind.FILE) {
            String string = super.getBuildingWorkingDirectory();
            if (string == null) {
                GoTestRunningState.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = ((GoTestRunConfiguration)this.myConfiguration).getWorkingDirectory();
        if (string == null) {
            GoTestRunningState.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Override
    @NotNull
    public String getGoBuildParams() {
        String params = super.getGoBuildParams();
        @NotNull List paramsList = ParametersListUtil.parse((String)params, (boolean)false, (boolean)true);
        if (GoRunUtil.hasTagsParameter(paramsList)) {
            String string = params;
            if (string == null) {
                GoTestRunningState.$$$reportNull$$$0(16);
            }
            return string;
        }
        String buildTags = this.myBuildTagsSupplier.get();
        if (!buildTags.isEmpty()) {
            paramsList.add("-tags");
            paramsList.add(buildTags);
            String string = ParametersListUtil.join((List)paramsList);
            if (string == null) {
                GoTestRunningState.$$$reportNull$$$0(17);
            }
            return string;
        }
        String string = params;
        if (string == null) {
            GoTestRunningState.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    protected String buildFilterPatternForFiles(@NotNull List<GoFile> files) {
        if (files == null) {
            GoTestRunningState.$$$reportNull$$$0(19);
        }
        LinkedHashSet testNames = new LinkedHashSet();
        for (GoFile file : files) {
            if (!GoTestFinder.isTestFile((PsiFile)file)) continue;
            for (GoFunctionDeclaration goFunctionDeclaration : file.getFunctions()) {
                ContainerUtil.addIfNotNull(testNames, GoTestFinder.isTestOrExampleFunction(goFunctionDeclaration) ? GoTestRunningState.escapePattern(goFunctionDeclaration.getName()) : null);
            }
        }
        String string = "^" + StringUtil.join(testNames, (String)"|") + "$";
        if (string == null) {
            GoTestRunningState.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static String escapePattern(@Nullable String name) {
        return name != null ? StreamEx.of((Object[])name.split("\\|")).map(s -> s.isEmpty() ? s : Pattern.quote(s)).joining((CharSequence)"|") : null;
    }

    protected void addFilterParameter(@NotNull GoExecutor executor, @Nullable String pattern) {
        if (executor == null) {
            GoTestRunningState.$$$reportNull$$$0(21);
        }
        if (StringUtil.isNotEmpty((String)pattern)) {
            executor.withParameters(this.isBuildable() ? "-test.run" : "-run", pattern);
        }
    }

    void setFailedTests(@NotNull List<AbstractTestProxy> failedTests) {
        if (failedTests == null) {
            GoTestRunningState.$$$reportNull$$$0(22);
        }
        this.myFailedTestsPattern = "^" + StringUtil.join(failedTests, t -> GoTestRunningState.escapePattern(t.getName()), (String)"|") + "$";
    }

    @NotNull
    private GoExecutor createRunTestsInDirectoryExecutor() throws ExecutionException {
        String basePath;
        Object path;
        GoExecutor executor = this.patchCommandLine(this.createCommonExecutor(), GoRunningState.CommandLineType.RUN);
        if (GoOsManager.isWindows()) {
            executor.withConsoleMode();
        }
        boolean isElevationServiceAvailable = ElevationService.getInstance().isAvailable();
        if (((GoTestRunConfiguration)this.myConfiguration).isRunWithSudo() && isElevationServiceAvailable) {
            executor.withSudo();
        }
        executor.withParameters("test");
        if (((GoTestRunConfiguration)this.myConfiguration).supportsJsonTestsOutput()) {
            executor.withParameters("-json");
            executor.withPtyEnabled(false);
        } else {
            executor.withParameters("-v");
        }
        executor.withParameterString(GoRunUtil.filterOutInstallParameter(this.getGoBuildParams()));
        String relativePath = FileUtil.getRelativePath((String)FileUtil.toSystemDependentName((String)FileUtil.toCanonicalPath((String)((GoTestRunConfiguration)this.myConfiguration).getWorkingDirectory())), (String)FileUtil.toSystemDependentName((String)FileUtil.toCanonicalPath((String)((GoTestRunConfiguration)this.myConfiguration).getDirectoryPath())), (char)File.separatorChar);
        if (((GoTestRunConfiguration)this.myConfiguration).getTestFramework() == GoFuzzFramework.INSTANCE && ((GoTestRunConfiguration)this.myConfiguration).getKind() == GoBuildingRunConfiguration.Kind.DIRECTORY && StringUtil.isNotEmpty((String)((GoTestRunConfiguration)this.myConfiguration).getPackage())) {
            path = ((GoTestRunConfiguration)this.myConfiguration).getPackage();
            basePath = ((GoTestRunConfiguration)this.myConfiguration).getWorkingDirectory();
        } else if (relativePath != null && !".".equals(relativePath)) {
            path = "./" + FileUtil.toSystemIndependentName((String)relativePath) + "/...";
            basePath = ((GoTestRunConfiguration)this.myConfiguration).getWorkingDirectory();
        } else {
            path = "./...";
            basePath = ((GoTestRunConfiguration)this.myConfiguration).getDirectoryPath();
            executor.withWorkDirectory(basePath);
        }
        executor.withParameters(new String[]{path});
        this.addFilterParameter(executor, this.getRunFilterParameter());
        if (this.myCoverageLocation != null) {
            if (!GoSdkService.getInstance(this.myEnvironment.getProject()).getSdk(this.myModule).supportsMultiPackageCoverage()) {
                throw new ExecutionException(GoBundle.message((String)"go.execution.coverage.cannot.run.coverage.on.directory.kind.run.configurations.error", (Object[])new Object[0]));
            }
            executor.withParameters("-covermode=atomic");
            String coverPkg = this.getCoverPkgString(basePath);
            if (!"./...".equals(path)) {
                executor.withParameters("-coverpkg=" + (String)(coverPkg.isEmpty() ? path : coverPkg));
            }
            executor.withParameters(GoCommandLineParameter.string("-coverprofile"), this.getCoverageFilePathParameter(executor));
        }
        GoExecutor goExecutor = executor;
        if (goExecutor == null) {
            GoTestRunningState.$$$reportNull$$$0(23);
        }
        return goExecutor;
    }

    @NotNull
    private String getBuildTagsModal() {
        String title = GoBundle.message((String)"go.execution.test.collecting.build.tags.progress.title", (Object[])new Object[0]);
        String string = (String)ActionUtil.underModalProgress((Project)this.getModule().getProject(), (String)title, () -> this.getBuildTags());
        if (string == null) {
            GoTestRunningState.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    private String getBuildTags() {
        if (((GoTestRunConfiguration)this.myConfiguration).getKind() == GoBuildingRunConfiguration.Kind.FILE) {
            return this.getBuildTags((StreamEx<GoFile>)StreamEx.of(((GoTestRunConfiguration)this.myConfiguration).getContextFiles()));
        }
        if (((GoTestRunConfiguration)this.myConfiguration).getKind() == GoBuildingRunConfiguration.Kind.PACKAGE) {
            String name;
            String nameWithoutSubtest;
            String pattern = ((GoTestRunConfiguration)this.myConfiguration).getPattern();
            if (!(pattern.isEmpty() || (nameWithoutSubtest = (String)ObjectUtils.notNull((Object)StringUtil.substringBefore((String)(name = GoTestRunConfiguration.patternToName(pattern)), (String)"/"), (Object)name)).isEmpty() || StringUtil.containsChar((String)nameWithoutSubtest, (char)'|'))) {
                Collection functions = (Collection)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> {
                    GlobalSearchScope scope = ((GoTestRunConfiguration)this.myConfiguration).getSearchScope();
                    return GoFunctionIndex.find(nameWithoutSubtest, this.myEnvironment.getProject(), scope, null);
                });
                if (functions.isEmpty() && DumbService.isDumb((Project)this.myEnvironment.getProject())) {
                    this.showNotification(GoBundle.message((String)"go.execution.cannot.resolve.test.function", (Object[])new Object[]{nameWithoutSubtest}));
                }
                return this.getBuildTags((StreamEx<GoFile>)StreamEx.of((Collection)functions).map(GoNamedElement::getContainingFile));
            }
            return this.getBuildTags((StreamEx<GoFile>)this.findTestifyMethods(GoTestifySupport.findTestifyPattern(this.getRunParameters()), ((GoTestRunConfiguration)this.myConfiguration).getSearchScope()).map(GoNamedElement::getContainingFile));
        }
        return "";
    }

    private StreamEx<GoMethodDeclaration> findTestifyMethods(@Nullable String testifyPattern, @NotNull GlobalSearchScope scope) {
        if (scope == null) {
            GoTestRunningState.$$$reportNull$$$0(25);
        }
        if (StringUtil.isEmpty((String)testifyPattern) || scope == GlobalSearchScope.EMPTY_SCOPE) {
            return StreamEx.empty();
        }
        return StreamEx.of((Object[])GoTestRunningState.unwrapPattern(testifyPattern).split("\\|")).flatMap(methodName -> {
            Project project = this.myEnvironment.getProject();
            return StreamEx.of(GoMethodFingerprintIndex.find(methodName + "/0", project, scope, GoIdFilter.getTestsFilter(project)));
        });
    }

    @NotNull
    private static String unwrapPattern(@NotNull String pattern) {
        if (pattern == null) {
            GoTestRunningState.$$$reportNull$$$0(26);
        }
        String string = StringUtil.trimEnd((String)StringUtil.trimStart((String)pattern, (String)"^"), (String)"$");
        if (string == null) {
            GoTestRunningState.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    private String getBuildTags(@NotNull StreamEx<GoFile> files) {
        if (files == null) {
            GoTestRunningState.$$$reportNull$$$0(28);
        }
        ArrayList<GoPlusBuildElement> plusBuildConstraints = new ArrayList<GoPlusBuildElement>();
        ArrayList<GoBuildElement> goBuildDirectives = new ArrayList<GoBuildElement>();
        this.collectConstraints(files, plusBuildConstraints, goBuildDirectives);
        if (plusBuildConstraints.isEmpty() && goBuildDirectives.isEmpty()) {
            return "";
        }
        Set<String> tags = GoTestRunningState.getAllTags(plusBuildConstraints, goBuildDirectives);
        tags.removeAll(GoConstants.KNOWN_OS);
        tags.removeAll(GoConstants.KNOWN_ARCH);
        tags.remove("cgo");
        if (tags.isEmpty()) {
            return "";
        }
        if (tags.size() > 10) {
            return "";
        }
        Set<String> implicitTags = this.getImplicitTags();
        for (List<String> trueTags : GoTestRunningState.getPowerSet(tags)) {
            HashSet<String> satisfiedTags = new HashSet<String>(implicitTags);
            satisfiedTags.addAll(trueTags);
            GoBuildTagEnvironment env = GoBuildTagEnvironment.create(satisfiedTags);
            if (!GoBuildTagUtil.eval(plusBuildConstraints, (GoBuildTagEnvironment)env).matches || !GoBuildMatcher.MatchingResult.and(goBuildDirectives, (Function<GoBuildElement, GoBuildMatcher.MatchingResult>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getBuildTags$10(com.goide.inspections.buildTag.GoBuildTagEnvironment com.goide.inspections.buildTag.GoBuildElement ), (Lcom/goide/inspections/buildTag/GoBuildElement;)Lcom/goide/util/GoBuildMatcher$MatchingResult;)((GoBuildTagEnvironment)env)).matches) continue;
            String string = String.join((CharSequence)" ", new TreeSet<String>(trueTags));
            if (string == null) {
                GoTestRunningState.$$$reportNull$$$0(29);
            }
            return string;
        }
        return "";
    }

    @NotNull
    private Set<String> getImplicitTags() {
        String cgoEnabled;
        String arch;
        TargetEnvironmentRequest request;
        try {
            request = this.getTargetEnvironmentRequest();
        }
        catch (ExecutionException e) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                GoTestRunningState.$$$reportNull$$$0(30);
            }
            return set;
        }
        HashSet<String> result = new HashSet<String>();
        Map<String, String> userEnv = ((GoTestRunConfiguration)this.myConfiguration).getCustomEnvironment();
        String os = userEnv.getOrDefault("GOOS", GoRunUtil.getTargetPlatform(request));
        if (os != null) {
            result.add(os);
        }
        if (!"unknown".equals(arch = userEnv.getOrDefault("GOARCH", GoUtil.systemArch()))) {
            result.add(arch);
        }
        if ((cgoEnabled = userEnv.getOrDefault("CGO_ENABLED", os != null && GoUtil.systemCgo(os, arch) == ThreeState.YES ? "1" : "0")).equals("1")) {
            result.add("cgo");
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            GoTestRunningState.$$$reportNull$$$0(31);
        }
        return hashSet;
    }

    @NotNull
    private static Set<String> getAllTags(@NotNull List<GoPlusBuildElement> plusBuildConstraints, @NotNull List<GoBuildElement> goBuildDirectives) {
        if (plusBuildConstraints == null) {
            GoTestRunningState.$$$reportNull$$$0(32);
        }
        if (goBuildDirectives == null) {
            GoTestRunningState.$$$reportNull$$$0(33);
        }
        HashSet<String> result = new HashSet<String>(GoBuildTagUtil.getTags(plusBuildConstraints));
        for (GoBuildElement directive : goBuildDirectives) {
            result.addAll(GoBuildTagUtil.getTags(directive));
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            GoTestRunningState.$$$reportNull$$$0(34);
        }
        return hashSet;
    }

    private void collectConstraints(@NotNull StreamEx<GoFile> files, @NotNull List<GoPlusBuildElement> plusBuildConstraints, @NotNull List<GoBuildElement> goBuildConstraints) {
        if (files == null) {
            GoTestRunningState.$$$reportNull$$$0(35);
        }
        if (plusBuildConstraints == null) {
            GoTestRunningState.$$$reportNull$$$0(36);
        }
        if (goBuildConstraints == null) {
            GoTestRunningState.$$$reportNull$$$0(37);
        }
        boolean useGoBuildDirectives = GoSdkService.getInstance(this.myEnvironment.getProject()).getSdk(this.myModule).getGoBuildDirectiveOptions().isUseForFileMatching();
        HashSet<String> uniqueGoBuildConstraints = new HashSet<String>();
        HashSet<String> uniquePlusBuildConstraints = new HashSet<String>();
        for (GoFile file : (StreamEx)files.distinct()) {
            GoFileProperties properties = file.getFileProperties();
            if (properties == null) continue;
            if (useGoBuildDirectives && properties.goBuildConstraint != null) {
                GoBuildElement element = uniqueGoBuildConstraints.add(properties.goBuildConstraint) ? GoBuildTagUtil.parseGoBuildElement(file.getProject(), properties.goBuildConstraint) : null;
                ContainerUtil.addIfNotNull(goBuildConstraints, (Object)((Object)element));
                continue;
            }
            for (String constraint : StringUtil.split((String)((String)ObjectUtils.notNull((Object)properties.buildFlags, (Object)"")), (String)"|")) {
                GoPlusBuildElement element = uniquePlusBuildConstraints.add(constraint) ? GoBuildTagUtil.parsePlusBuildElement(file.getProject(), constraint) : null;
                ContainerUtil.addIfNotNull(plusBuildConstraints, (Object)((Object)element));
            }
        }
    }

    @NotNull
    private static List<List<String>> getPowerSet(@NotNull Set<String> terms) {
        if (terms == null) {
            GoTestRunningState.$$$reportNull$$$0(38);
        }
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        for (Set<String> subSet : GoBuildTagUtil.getPowerSet(terms)) {
            ArrayList<String> sortedTerms = new ArrayList<String>(subSet);
            Collections.sort(sortedTerms);
            result.add(sortedTerms);
        }
        Collections.sort(result, (s1, s2) -> {
            int bySize = Integer.compare(s1.size(), s2.size());
            if (bySize != 0) {
                return bySize;
            }
            for (int i = 0; i < s1.size(); ++i) {
                int alphabetically = ((String)s1.get(i)).compareTo((String)s2.get(i));
                if (alphabetically == 0) continue;
                return alphabetically;
            }
            return 0;
        });
        ArrayList<List<String>> arrayList = result;
        if (arrayList == null) {
            GoTestRunningState.$$$reportNull$$$0(39);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected ProcessListener getRuntimeErrorsListener() {
        return new GoRuntimeErrorsListener(this.myEnvironment.getProject(), false);
    }

    @Override
    public void prepareStateInBGT() {
        super.prepareStateInBGT();
        this.myConsoleScope.initialize();
    }

    private void showNotification(@NotNull @NlsSafe String text) {
        Project project;
        if (text == null) {
            GoTestRunningState.$$$reportNull$$$0(40);
        }
        if ((project = this.myEnvironment.getProject()).isDisposed()) {
            return;
        }
        NotificationGroup notificationGroup = this.isDebug() ? GoNotifications.getDebugGroup() : GoNotifications.getExecutionGroup();
        final Runnable show = () -> notificationGroup.createNotification("", text, NotificationType.WARNING).notify(project);
        final String toolWindowId = this.myEnvironment.getExecutor().getToolWindowId();
        if (ToolWindowManager.getInstance((Project)project).canShowNotification(toolWindowId) || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            show.run();
        } else {
            final MessageBusConnection connection = project.getMessageBus().connect((Disposable)this.myEnvironment);
            connection.subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){
                private boolean myIsInvoked = false;

                public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                    if (toolWindowManager == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (!this.myIsInvoked && toolWindowManager.canShowNotification(toolWindowId)) {
                        this.myIsInvoked = true;
                        connection.disconnect();
                        show.run();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowManager", "com/goide/execution/testing/GoTestRunningState$3", "stateChanged"));
                }
            });
        }
    }

    @NotNull
    private GlobalSearchScope getConsoleScope() {
        GoLazyDelegatingSearchScope goLazyDelegatingSearchScope = this.myConsoleScope;
        if (goLazyDelegatingSearchScope == null) {
            GoTestRunningState.$$$reportNull$$$0(41);
        }
        return goLazyDelegatingSearchScope;
    }

    private static /* synthetic */ GoBuildMatcher.MatchingResult lambda$getBuildTags$10(GoBuildTagEnvironment env, GoBuildElement it) {
        return GoBuildTagUtil.eval(it, env);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 11, 12, 13, 14, 15, 16, 17, 18, 20, 23, 24, 27, 29, 30, 31, 34, 39, 41 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 9: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 23: 
            case 24: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/testing/GoTestRunningState";
                break;
            }
            case 19: 
            case 28: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failedTests";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plusBuildConstraints";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goBuildDirectives";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goBuildConstraints";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terms";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/testing/GoTestRunningState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunParameters";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunFilterParameter";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildingWorkingDirectory";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getGoBuildParams";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFilterPatternForFiles";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createRunTestsInDirectoryExecutor";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildTagsModal";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapPattern";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildTags";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitTags";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTags";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getPowerSet";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 23: 
            case 24: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 39: 
            case 41: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleInner";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "buildFilterPatternForFiles";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addFilterParameter";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setFailedTests";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findTestifyMethods";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "unwrapPattern";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getBuildTags";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getAllTags";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "collectConstraints";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getPowerSet";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 11, 12, 13, 14, 15, 16, 17, 18, 20, 23, 24, 27, 29, 30, 31, 34, 39, 41 -> new IllegalStateException(string);
        };
    }

    private static abstract class ExecutionExceptionWithLink
    extends ExecutionException
    implements HyperlinkListener {
        ExecutionExceptionWithLink(@NlsContexts.DialogMessage String s) {
            super(s);
        }
    }
}

