/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.testing.coverage;

import com.goide.GoFileType;
import com.goide.execution.GoBuildingRunConfiguration;
import com.goide.execution.application.GoApplicationConfiguration;
import com.goide.execution.testing.GoTestFinder;
import com.goide.execution.testing.GoTestRunConfiguration;
import com.goide.execution.testing.coverage.GoCoverageAnnotator;
import com.goide.execution.testing.coverage.GoCoverageEnabledConfiguration;
import com.goide.execution.testing.coverage.GoCoverageSuite;
import com.goide.i18n.GoBundle;
import com.goide.sdk.GoSdkService;
import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageListRootNode;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.DirectoryCoverageViewExtension;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class GoCoverageEngine
extends CoverageEngine {
    public static final GoCoverageEngine INSTANCE = new GoCoverageEngine();
    private static final Condition<AbstractTreeNode<?>> NODE_TO_COVERAGE = node -> {
        Object value = node.getValue();
        if (value instanceof PsiFile) {
            return GoCoverageEngine.isProductionGoFile((PsiFile)value);
        }
        return !StringUtil.equals((CharSequence)node.getName(), (CharSequence)".idea");
    };

    public static boolean isApplicable(@Nullable RunProfile conf) {
        if (conf instanceof WrappingRunConfiguration) {
            conf = ((WrappingRunConfiguration)conf).getPeer();
        }
        Module module = (Module)ObjectUtils.doIfCast((Object)conf, ModuleBasedConfiguration.class, c -> c.getConfigurationModule().getModule());
        if (conf instanceof GoTestRunConfiguration) {
            if (((GoTestRunConfiguration)conf).getKind() != GoBuildingRunConfiguration.Kind.DIRECTORY) {
                return true;
            }
            if (module != null) {
                return GoSdkService.getInstance(module.getProject()).getSdk(module).supportsMultiPackageCoverage();
            }
        }
        if (conf instanceof GoApplicationConfiguration && module != null) {
            return GoSdkService.getInstance(module.getProject()).getSdk(module).supportsApplicationCoverage();
        }
        return false;
    }

    public boolean isApplicableTo(@NotNull RunConfigurationBase conf) {
        if (conf == null) {
            GoCoverageEngine.$$$reportNull$$$0(0);
        }
        return GoCoverageEngine.isApplicable((RunProfile)conf);
    }

    @NotNull
    public CoverageEnabledConfiguration createCoverageEnabledConfiguration(@NotNull RunConfigurationBase conf) {
        if (conf == null) {
            GoCoverageEngine.$$$reportNull$$$0(1);
        }
        return new GoCoverageEnabledConfiguration((GoBuildingRunConfiguration)conf);
    }

    /*
     * WARNING - void declaration
     */
    public CoverageSuite createCoverageSuite(@NotNull CoverageRunner runner, @NotNull String name, @NotNull CoverageFileProvider coverageDataFileProvider, String @Nullable [] filters, long lastCoverageTimeStamp, @Nullable String suiteToMerge, boolean coverageByTestEnabled, boolean branchCoverage, boolean trackTestFolders, Project project) {
        void project2;
        if (runner == null) {
            GoCoverageEngine.$$$reportNull$$$0(2);
        }
        if (name == null) {
            GoCoverageEngine.$$$reportNull$$$0(3);
        }
        if (coverageDataFileProvider == null) {
            GoCoverageEngine.$$$reportNull$$$0(4);
        }
        return new GoCoverageSuite(name, (Project)project2, runner, coverageDataFileProvider, lastCoverageTimeStamp);
    }

    public CoverageSuite createCoverageSuite(@NotNull CoverageRunner runner, @NotNull String name, @NotNull CoverageFileProvider coverageDataFileProvider, @NotNull CoverageEnabledConfiguration config) {
        if (runner == null) {
            GoCoverageEngine.$$$reportNull$$$0(5);
        }
        if (name == null) {
            GoCoverageEngine.$$$reportNull$$$0(6);
        }
        if (coverageDataFileProvider == null) {
            GoCoverageEngine.$$$reportNull$$$0(7);
        }
        if (config == null) {
            GoCoverageEngine.$$$reportNull$$$0(8);
        }
        if (config instanceof GoCoverageEnabledConfiguration) {
            return new GoCoverageSuite(name, config.getConfiguration().getProject(), runner, coverageDataFileProvider, config.createTimestamp());
        }
        return null;
    }

    public CoverageSuite createEmptyCoverageSuite(@NotNull CoverageRunner coverageRunner) {
        if (coverageRunner == null) {
            GoCoverageEngine.$$$reportNull$$$0(9);
        }
        return new GoCoverageSuite();
    }

    @NotNull
    public CoverageAnnotator getCoverageAnnotator(Project project) {
        GoCoverageAnnotator goCoverageAnnotator = GoCoverageAnnotator.getInstance(project);
        if (goCoverageAnnotator == null) {
            GoCoverageEngine.$$$reportNull$$$0(10);
        }
        return goCoverageAnnotator;
    }

    public boolean coverageEditorHighlightingApplicableTo(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            GoCoverageEngine.$$$reportNull$$$0(11);
        }
        return GoCoverageEngine.isProductionGoFile(psiFile);
    }

    public boolean acceptedByFilters(@NotNull PsiFile psiFile, @NotNull CoverageSuitesBundle suite) {
        if (psiFile == null) {
            GoCoverageEngine.$$$reportNull$$$0(12);
        }
        if (suite == null) {
            GoCoverageEngine.$$$reportNull$$$0(13);
        }
        return GoCoverageEngine.isProductionGoFile(psiFile);
    }

    private static boolean isProductionGoFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            GoCoverageEngine.$$$reportNull$$$0(14);
        }
        return psiFile.getFileType() == GoFileType.INSTANCE && !GoTestFinder.isTestFile(psiFile);
    }

    protected String getQualifiedName(@NotNull File outputFile, @NotNull PsiFile sourceFile) {
        if (outputFile == null) {
            GoCoverageEngine.$$$reportNull$$$0(15);
        }
        if (sourceFile == null) {
            GoCoverageEngine.$$$reportNull$$$0(16);
        }
        return sourceFile.getVirtualFile().getPath();
    }

    @NotNull
    public Set<String> getQualifiedNames(@NotNull PsiFile sourceFile) {
        if (sourceFile == null) {
            GoCoverageEngine.$$$reportNull$$$0(17);
        }
        Set<String> set = Collections.singleton(sourceFile.getVirtualFile().getPath());
        if (set == null) {
            GoCoverageEngine.$$$reportNull$$$0(18);
        }
        return set;
    }

    public List<Integer> collectSrcLinesForUntouchedFile(@NotNull File classFile, @NotNull CoverageSuitesBundle suite) {
        if (classFile == null) {
            GoCoverageEngine.$$$reportNull$$$0(19);
        }
        if (suite == null) {
            GoCoverageEngine.$$$reportNull$$$0(20);
        }
        return null;
    }

    @Nls
    public String getPresentableText() {
        return GoBundle.message((String)"go.execution.coverage.engine.name", (Object[])new Object[0]);
    }

    public boolean coverageProjectViewStatisticsApplicableTo(VirtualFile fileOrDir) {
        return !fileOrDir.isDirectory() && FileTypeRegistry.getInstance().isFileOfType(fileOrDir, (FileType)GoFileType.INSTANCE) && !GoTestFinder.isTestFile(fileOrDir);
    }

    public CoverageViewExtension createCoverageViewExtension(final Project project, CoverageSuitesBundle suiteBundle) {
        return new DirectoryCoverageViewExtension(project, this.getCoverageAnnotator(project), suiteBundle){

            @NotNull
            public AbstractTreeNode<?> createRootNode() {
                VirtualFile[] roots = ProjectRootManager.getInstance((Project)project).getContentRoots();
                VirtualFile commonAncestor = VfsUtil.getCommonAncestor(Arrays.asList(roots));
                VirtualFile baseDir = (VirtualFile)ObjectUtils.chooseNotNull((Object)commonAncestor, (Object)ProjectUtil.guessProjectDir((Project)project));
                PsiDirectory root = PsiManager.getInstance((Project)this.myProject).findDirectory(Objects.requireNonNull(baseDir));
                return new CoverageListRootNode(this.myProject, (PsiNamedElement)Objects.requireNonNull(root), this.mySuitesBundle);
            }

            public @Unmodifiable List<AbstractTreeNode<?>> getChildrenNodes(AbstractTreeNode node) {
                return ContainerUtil.filter((Collection)super.getChildrenNodes(node), NODE_TO_COVERAGE);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conf";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageDataFileProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageRunner";
                break;
            }
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/testing/coverage/GoCoverageEngine";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/testing/coverage/GoCoverageEngine";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageAnnotator";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableTo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createCoverageEnabledConfiguration";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createCoverageSuite";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyCoverageSuite";
                break;
            }
            case 10: 
            case 18: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "coverageEditorHighlightingApplicableTo";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "acceptedByFilters";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isProductionGoFile";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNames";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collectSrcLinesForUntouchedFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 18 -> new IllegalStateException(string);
        };
    }
}

