/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.testing.frameworks.gofuzz;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lcom/goide/execution/testing/frameworks/gofuzz/GoFuzzConsoleFilterBase;", "Lcom/intellij/execution/filters/Filter;", "project", "Lcom/intellij/openapi/project/Project;", "workingDirectoryUrl", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "pattern", "Ljava/util/regex/Pattern;", "getPattern", "()Ljava/util/regex/Pattern;", "pathPrefix", "getPathPrefix", "()Ljava/lang/String;", "checkFileExistence", "", "getCheckFileExistence", "()Z", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "entireLength", "", "intellij.go.impl"})
public abstract class GoFuzzConsoleFilterBase
implements Filter {
    @NotNull
    private final Project project;
    @NotNull
    private final String workingDirectoryUrl;
    private final boolean checkFileExistence;

    public GoFuzzConsoleFilterBase(@NotNull Project project, @NotNull String workingDirectoryUrl) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)workingDirectoryUrl, (String)"workingDirectoryUrl");
        this.project = project;
        this.workingDirectoryUrl = workingDirectoryUrl;
    }

    @NotNull
    protected abstract Pattern getPattern();

    @NotNull
    protected abstract String getPathPrefix();

    protected boolean getCheckFileExistence() {
        return this.checkFileExistence;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Matcher matcher = this.getPattern().matcher(line);
        if (matcher.find()) {
            int lineStart = entireLength - line.length();
            String corpusFilePath = matcher.group("fuzzCorpusFilePath");
            String path = this.workingDirectoryUrl + "/" + this.getPathPrefix() + corpusFilePath;
            if (this.getCheckFileExistence() && VirtualFileManager.getInstance().findFileByUrl(path) == null) {
                return null;
            }
            HyperlinkInfo hyperlinkInfo = (HyperlinkInfo)new UrlFilter.FileUrlHyperlinkInfo(this.project, VfsUtilCore.urlToPath((String)path), 0, 0, path, false);
            int startOffset = matcher.start("fuzzCorpusFilePath");
            int endOffset = matcher.end("fuzzCorpusFilePath");
            return new Filter.Result(lineStart + startOffset, lineStart + endOffset, hyperlinkInfo);
        }
        return null;
    }
}

