/*
 * Decompiled with CFR 0.152.
 */
package com.goide.formatter.settings;

import com.goide.GoFileType;
import com.goide.GoParserDefinition;
import com.goide.configuration.GoUIUtil;
import com.goide.formatter.settings.GoCodeStyleSettings;
import com.goide.formatter.settings.GoCommentsWithoutLeadingSpace;
import com.goide.highlighting.GoSyntaxHighlighter;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoPsiTreeUtil;
import com.goide.psi.impl.GoElementFactory;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.AddEditDeleteListPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBBox;
import com.intellij.ui.components.fields.IntegerField;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoCodeStyleOtherPanel
extends CodeStyleAbstractPanel {
    private final JPanel myPanel;
    private JCheckBox myAddLeadingSpaceToComments;
    private AddLeadingSpaceToCommentsExceptionsPanel myAddLeadingSpaceExceptionsPanel;
    protected IntegerField myFillParagraphWidth;
    private JCheckBox myOnReformatCheckBox;

    public GoCodeStyleOtherPanel(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            GoCodeStyleOtherPanel.$$$reportNull$$$0(0);
        }
        super(settings);
        this.myPanel = this.createPanel();
    }

    private JPanel createPanel() {
        this.myAddLeadingSpaceToComments = new JCheckBox(GoBundle.message((String)"go.fmt.add.leading.space.to.comments", (Object[])new Object[0]));
        this.myAddLeadingSpaceExceptionsPanel = new AddLeadingSpaceToCommentsExceptionsPanel();
        this.myAddLeadingSpaceToComments.addItemListener(e -> this.myAddLeadingSpaceExceptionsPanel.setEnabled(this.myAddLeadingSpaceToComments.isSelected()));
        this.myFillParagraphWidth = new IntegerField(null, 0, Integer.MAX_VALUE);
        this.myFillParagraphWidth.setColumns(4);
        JBBox goFmtPanel = JBBox.createVerticalBox();
        goFmtPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)GoBundle.message((String)"go.fmt.run.gofmt.panel.border.title", (Object[])new Object[0])));
        this.myOnReformatCheckBox = GoCodeStyleOtherPanel.addCheckBox((JComponent)goFmtPanel, GoBundle.message((String)"go.fmt.run.gofmt.on.code.reformat.label", (Object[])new Object[0]), "ReformatCode");
        FormBuilder builder = FormBuilder.createFormBuilder().addComponent((JComponent)this.myAddLeadingSpaceToComments).setFormLeftIndent(10).addComponent((JComponent)((Object)this.myAddLeadingSpaceExceptionsPanel)).setFormLeftIndent(0).addLabeledComponent(GoBundle.message((String)"go.fmt.fill.paragraph.width.label", (Object[])new Object[0]), (JComponent)this.myFillParagraphWidth).addComponent((JComponent)goFmtPanel).addComponentFillVertically((JComponent)new JPanel(), 0);
        JPanel previewPanel = new JPanel();
        this.installPreviewPanel(previewPanel);
        return GoUIUtil.wrapWithPreviewPanel(builder.getPanel(), previewPanel);
    }

    @NotNull
    private static JCheckBox addCheckBox(@NotNull JComponent panel, @NotNull @NlsContexts.Checkbox String title, @NotNull String actionId) {
        if (panel == null) {
            GoCodeStyleOtherPanel.$$$reportNull$$$0(1);
        }
        if (title == null) {
            GoCodeStyleOtherPanel.$$$reportNull$$$0(2);
        }
        if (actionId == null) {
            GoCodeStyleOtherPanel.$$$reportNull$$$0(3);
        }
        JBBox box = JBBox.createHorizontalBox();
        JCheckBox checkBox = new JCheckBox(title);
        box.add((Component)checkBox);
        KeyboardShortcut shortcut = ActionManager.getInstance().getKeyboardShortcut(actionId);
        if (shortcut != null) {
            String text = KeymapUtil.getShortcutText((Shortcut)shortcut);
            JLabel comment = ComponentPanelBuilder.createCommentComponent((String)text, (boolean)true);
            box.add(Box.createRigidArea((Dimension)new JBDimension(5, 0)));
            box.add((Component)comment);
        }
        panel.add((Component)box);
        JCheckBox jCheckBox = checkBox;
        if (jCheckBox == null) {
            GoCodeStyleOtherPanel.$$$reportNull$$$0(4);
        }
        return jCheckBox;
    }

    protected int getRightMargin() {
        return 0;
    }

    @Nullable
    protected EditorHighlighter createHighlighter(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            GoCodeStyleOtherPanel.$$$reportNull$$$0(5);
        }
        return HighlighterFactory.createHighlighter((SyntaxHighlighter)new GoSyntaxHighlighter(), (EditorColorsScheme)scheme);
    }

    @NotNull
    protected FileType getFileType() {
        LanguageFileType languageFileType = GoFileType.INSTANCE;
        if (languageFileType == null) {
            GoCodeStyleOtherPanel.$$$reportNull$$$0(6);
        }
        return languageFileType;
    }

    @NotNull
    protected PsiFile doReformat(Project project, @NotNull PsiFile psiFile) {
        if (psiFile == null) {
            GoCodeStyleOtherPanel.$$$reportNull$$$0(7);
        }
        ((SyntaxTraverser)GoPsiTreeUtil.goTraverser().withRoot((Object)psiFile)).filter(PsiComment.class).forEach(comment -> {
            if (comment.getTokenType() == GoParserDefinition.Lazy.LINE_COMMENT) {
                String text = comment.getText();
                text = StringUtil.trimLeading((String)StringUtil.trimStart((String)text, (String)"//"));
                comment.replace((PsiElement)GoElementFactory.createLineCommentFromText(project, text));
            }
        });
        PsiFile psiFile2 = super.doReformat(project, psiFile);
        if (psiFile2 == null) {
            GoCodeStyleOtherPanel.$$$reportNull$$$0(8);
        }
        return psiFile2;
    }

    @Nullable
    protected String getPreviewText() {
        return "package foo\n\nimport \"fmt\"\n\n// Foo docs\nfunc Foo() {\n\tfmt.Println(\"Hello\")\n}";
    }

    public void apply(@NotNull CodeStyleSettings rootSettings) {
        if (rootSettings == null) {
            GoCodeStyleOtherPanel.$$$reportNull$$$0(9);
        }
        GoCodeStyleSettings settings = (GoCodeStyleSettings)rootSettings.getCustomSettings(GoCodeStyleSettings.class);
        settings.ADD_LEADING_SPACE_TO_COMMENTS = this.myAddLeadingSpaceToComments.isSelected();
        this.myAddLeadingSpaceExceptionsPanel.applyTo(settings.COMMENTS_WITHOUT_LEADING_SPACE);
        settings.FILL_PARAGRAPH_WIDTH = this.myFillParagraphWidth.getValue();
        settings.RUN_GO_FMT_ON_REFORMAT = this.myOnReformatCheckBox.isSelected();
    }

    public boolean isModified(CodeStyleSettings rootSettings) {
        GoCodeStyleSettings settings = (GoCodeStyleSettings)rootSettings.getCustomSettings(GoCodeStyleSettings.class);
        return this.myAddLeadingSpaceToComments.isSelected() != settings.ADD_LEADING_SPACE_TO_COMMENTS || this.myAddLeadingSpaceExceptionsPanel.isModified(settings.COMMENTS_WITHOUT_LEADING_SPACE) || settings.FILL_PARAGRAPH_WIDTH != this.myFillParagraphWidth.getValue() || settings.RUN_GO_FMT_ON_REFORMAT != this.myOnReformatCheckBox.isSelected();
    }

    @Nullable
    public JComponent getPanel() {
        return this.myPanel;
    }

    protected void resetImpl(@NotNull CodeStyleSettings rootSettings) {
        if (rootSettings == null) {
            GoCodeStyleOtherPanel.$$$reportNull$$$0(10);
        }
        GoCodeStyleSettings settings = (GoCodeStyleSettings)rootSettings.getCustomSettings(GoCodeStyleSettings.class);
        this.myAddLeadingSpaceToComments.setSelected(settings.ADD_LEADING_SPACE_TO_COMMENTS);
        this.myAddLeadingSpaceExceptionsPanel.resetFrom(settings.COMMENTS_WITHOUT_LEADING_SPACE);
        this.myAddLeadingSpaceExceptionsPanel.setEnabled(this.myAddLeadingSpaceToComments.isSelected());
        this.myFillParagraphWidth.setValue(Integer.valueOf(settings.FILL_PARAGRAPH_WIDTH));
        this.myOnReformatCheckBox.setSelected(settings.RUN_GO_FMT_ON_REFORMAT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/formatter/settings/GoCodeStyleOtherPanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/formatter/settings/GoCodeStyleOtherPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addCheckBox";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doReformat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addCheckBox";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighter";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doReformat";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resetImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 8 -> new IllegalStateException(string);
        };
    }

    private static final class AddLeadingSpaceToCommentsExceptionsPanel
    extends AddEditDeleteListPanel<String> {
        private AddLeadingSpaceToCommentsExceptionsPanel() {
            super(GoBundle.message((String)"go.settings.formatter.add.space.except.for.comments.label", (Object[])new Object[0]), new ArrayList());
            this.getEmptyText().setText(GoBundle.message((String)"go.settings.formatter.no.exceptions.empty.text", (Object[])new Object[0]));
            Dimension preferredSize = this.getPreferredSize();
            this.setPreferredSize(new Dimension(Math.max(preferredSize.width, JBUI.scale((int)300)), preferredSize.height));
        }

        @Nullable
        protected String editSelectedItem(String item) {
            return this.showEditDialog(item);
        }

        @Nullable
        protected String findItemToAdd() {
            return this.showEditDialog("");
        }

        void resetFrom(@NotNull GoCommentsWithoutLeadingSpace comments) {
            if (comments == null) {
                AddLeadingSpaceToCommentsExceptionsPanel.$$$reportNull$$$0(0);
            }
            this.myListModel.clear();
            comments.getPrefixes().stream().sorted(String.CASE_INSENSITIVE_ORDER).forEach(this.myListModel::addElement);
        }

        void applyTo(@NotNull GoCommentsWithoutLeadingSpace comments) {
            if (comments == null) {
                AddLeadingSpaceToCommentsExceptionsPanel.$$$reportNull$$$0(1);
            }
            comments.reset();
            for (Object o : this.getListItems()) {
                comments.add((String)o);
            }
        }

        boolean isModified(@NotNull GoCommentsWithoutLeadingSpace comments) {
            if (comments == null) {
                AddLeadingSpaceToCommentsExceptionsPanel.$$$reportNull$$$0(2);
            }
            return !ContainerUtil.newHashSet((Object[])this.getListItems()).equals(new HashSet(comments.getPrefixes()));
        }

        @Nullable
        private String showEditDialog(String initialValue) {
            return Messages.showInputDialog((Component)((Object)this), null, (String)GoBundle.message((String)"go.settings.formatter.comment.prefix.dialog.title", (Object[])new Object[0]), null, (String)initialValue, (InputValidator)new InputValidatorEx(){

                public boolean checkInput(String inputString) {
                    return !StringUtil.isEmpty((String)inputString);
                }

                public boolean canClose(String inputString) {
                    return !StringUtil.isEmpty((String)inputString);
                }

                @Nullable
                public String getErrorText(String inputString) {
                    if (!this.checkInput(inputString)) {
                        return GoBundle.message((String)"go.settings.formatter.comment.prefix.cannot.be.empty.validation.message", (Object[])new Object[0]);
                    }
                    return null;
                }
            });
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.myList.setEnabled(enabled);
            for (JButton button : this.createButtons()) {
                button.setEnabled(enabled);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "comments";
            objectArray2[1] = "com/goide/formatter/settings/GoCodeStyleOtherPanel$AddLeadingSpaceToCommentsExceptionsPanel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resetFrom";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyTo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isModified";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

