/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting;

import com.goide.documentation.GoDocumentationProvider;
import com.goide.editor.GoParameterInfoHandler;
import com.goide.i18n.GoBundle;
import com.goide.inspections.GoInspectionUtil;
import com.goide.psi.GoArgumentList;
import com.goide.psi.GoBinaryExpr;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoCompositeLit;
import com.goide.psi.GoElement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFunctionType;
import com.goide.psi.GoLiteral;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoParameters;
import com.goide.psi.GoParenthesesExpr;
import com.goide.psi.GoPsiTreeUtil;
import com.goide.psi.GoResult;
import com.goide.psi.GoReturnStatement;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.GoStructType;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.GoValue;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.quickfix.GoAddKeysToStructLiteralValueQuickFix;
import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.Option;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoInlayParameterHintsProvider
implements InlayParameterHintsProvider {
    private static final Option SHOW_UNNAMED_FIELDS = new Option("go.struct.unnamed.struct.fields", GoBundle.messagePointer((String)"go.inlays.show.unnamed.fields.in.structure.values.option", (Object[])new Object[0]), true);
    private static final Option SHOW_RETURN_PARAMETERS = new Option("go.return.parameters", GoBundle.messagePointer((String)"go.inlays.show.return.parameters.option", (Object[])new Object[0]), true);

    @NotNull
    public List<InlayInfo> getParameterHints(@NotNull PsiElement o) {
        if (o == null) {
            GoInlayParameterHintsProvider.$$$reportNull$$$0(0);
        }
        if (o instanceof GoArgumentList) {
            PsiElement parent = o.getParent();
            if (parent instanceof GoCallExpr) {
                GoSignature signature;
                GoFunctionType type = GoParameterInfoHandler.findCallType((GoCallExpr)parent);
                GoSignature goSignature = signature = type != null ? type.getSignature() : null;
                if (signature != null) {
                    return GoInlayParameterHintsProvider.annotateParameters(signature.getParameters(), ((GoArgumentList)o).getExpressionList());
                }
            }
        } else if (o instanceof GoLiteralValue && SHOW_UNNAMED_FIELDS.get()) {
            GoStructType type = GoInspectionUtil.findStructTypeForLiteralValue((GoLiteralValue)o);
            if (type == null) {
                List<InlayInfo> list = Collections.emptyList();
                if (list == null) {
                    GoInlayParameterHintsProvider.$$$reportNull$$$0(1);
                }
                return list;
            }
            List<GoNamedElement> fields = type.getFieldDefinitions();
            List<GoElement> elements = ((GoLiteralValue)o).getElementList();
            if (ContainerUtil.exists(elements, e -> e.getKey() != null)) {
                List<InlayInfo> list = Collections.emptyList();
                if (list == null) {
                    GoInlayParameterHintsProvider.$$$reportNull$$$0(2);
                }
                return list;
            }
            ArrayList<InlayInfo> result = new ArrayList<InlayInfo>(fields.size());
            if (GoAddKeysToStructLiteralValueQuickFix.processElements(elements, fields, (e, f) -> ContainerUtil.addIfNotNull((Collection)result, (Object)GoInlayParameterHintsProvider.createFieldInlay(e, f)))) {
                ArrayList<InlayInfo> arrayList = result;
                if (arrayList == null) {
                    GoInlayParameterHintsProvider.$$$reportNull$$$0(3);
                }
                return arrayList;
            }
        } else if (o instanceof GoReturnStatement && SHOW_RETURN_PARAMETERS.get()) {
            GoParameters parameters;
            GoSignatureOwner parent = (GoSignatureOwner)PsiTreeUtil.getParentOfType((PsiElement)o, GoSignatureOwner.class);
            GoSignature signature = parent != null ? parent.getSignature() : null;
            GoResult goResult = signature != null ? signature.getResult() : null;
            GoParameters goParameters = parameters = goResult != null ? goResult.getParameters() : null;
            if (parameters != null) {
                return GoInlayParameterHintsProvider.annotateParameters(parameters, ((GoReturnStatement)o).getExpressionList());
            }
        }
        List<InlayInfo> list = Collections.emptyList();
        if (list == null) {
            GoInlayParameterHintsProvider.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private static List<InlayInfo> annotateParameters(@NotNull GoParameters parameters, @NotNull List<GoExpression> exprs) {
        if (parameters == null) {
            GoInlayParameterHintsProvider.$$$reportNull$$$0(5);
        }
        if (exprs == null) {
            GoInlayParameterHintsProvider.$$$reportNull$$$0(6);
        }
        List<String> parametersPresentations = GoParameterInfoHandler.getParameterPresentations(parameters, t -> "");
        ArrayList<InlayInfo> result = new ArrayList<InlayInfo>(parametersPresentations.size());
        for (int i = 0; i < exprs.size() && i < parametersPresentations.size(); ++i) {
            GoExpression e = exprs.get(i);
            String text = parametersPresentations.get(i);
            if (!StringUtil.isNotEmpty((String)text) || "_".equals(text) || !GoInlayParameterHintsProvider.showInlay(e)) continue;
            result.add(new InlayInfo(text, e.getTextRange().getStartOffset()));
        }
        ArrayList<InlayInfo> arrayList = result;
        if (arrayList == null) {
            GoInlayParameterHintsProvider.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static InlayInfo createFieldInlay(@NotNull GoElement e, @NotNull GoNamedElement field) {
        if (e == null) {
            GoInlayParameterHintsProvider.$$$reportNull$$$0(8);
        }
        if (field == null) {
            GoInlayParameterHintsProvider.$$$reportNull$$$0(9);
        }
        if (e.getKey() != null) {
            return null;
        }
        String name = field.getName();
        if (name == null) {
            return null;
        }
        GoValue value = e.getValue();
        if (value != null && GoInlayParameterHintsProvider.isCompositeLiteralWithSimilarName(value, name)) {
            return null;
        }
        return new InlayInfo(name, e.getTextRange().getStartOffset());
    }

    private static boolean isCompositeLiteralWithSimilarName(@NotNull GoValue value, @NotNull String name) {
        if (value == null) {
            GoInlayParameterHintsProvider.$$$reportNull$$$0(10);
        }
        if (name == null) {
            GoInlayParameterHintsProvider.$$$reportNull$$$0(11);
        }
        GoCompositeLit literal = (GoCompositeLit)ObjectUtils.tryCast((Object)value.getExpression(), GoCompositeLit.class);
        GoTypeReferenceExpression expression = (GoTypeReferenceExpression)ObjectUtils.doIfNotNull((Object)literal, GoCompositeLit::getTypeReferenceExpression);
        PsiElement identifier = (PsiElement)ObjectUtils.doIfNotNull((Object)expression, GoTypeReferenceExpression::getIdentifier);
        String text = (String)ObjectUtils.doIfNotNull((Object)identifier, PsiElement::getText);
        return name.equalsIgnoreCase(text);
    }

    private static boolean showInlay(@NotNull GoExpression e) {
        if (e == null) {
            GoInlayParameterHintsProvider.$$$reportNull$$$0(12);
        }
        return GoInlayParameterHintsProvider.isSimpleExpression(e) && GoPsiTreeUtil.goTraverser().api.children((Object)e).filter(c -> !GoInlayParameterHintsProvider.isSimpleExpression(c)).isEmpty();
    }

    private static boolean isSimpleExpression(PsiElement c) {
        return c instanceof GoStringLiteral || c instanceof GoLiteral || c instanceof GoBinaryExpr || c instanceof GoUnaryExpr || c instanceof LeafPsiElement || c instanceof GoParenthesesExpr || GoExpressionUtil.isNil(c) || GoExpressionUtil.isBooleanLiteral(c);
    }

    @Nullable
    public HintInfo getHintInfo(@NotNull PsiElement element) {
        if (element == null) {
            GoInlayParameterHintsProvider.$$$reportNull$$$0(13);
        }
        if (element instanceof GoArgumentList) {
            PsiElement parent = element.getParent();
            if (parent instanceof GoCallExpr) {
                GoSignature signature;
                GoFunctionType type = GoParameterInfoHandler.findCallType((GoCallExpr)parent);
                GoSignature goSignature = signature = type != null ? type.getSignature() : null;
                if (signature != null) {
                    GoParameters parameters = signature.getParameters();
                    List<String> parametersPresentations = GoParameterInfoHandler.getParameterPresentations(parameters, t -> "");
                    GoSignatureOwner resolve = GoPsiImplUtil.resolveCall((GoCallExpr)parent);
                    String referenceText = GoDocumentationProvider.getReferenceText(resolve, false);
                    String text = referenceText != null ? referenceText : ((GoCallExpr)parent).getExpression().getText();
                    return new HintInfo.MethodInfo(text, parametersPresentations);
                }
            }
        } else {
            if (element instanceof GoLiteralValue) {
                return new HintInfo.OptionInfo(SHOW_UNNAMED_FIELDS);
            }
            if (element instanceof GoReturnStatement) {
                return new HintInfo.OptionInfo(SHOW_RETURN_PARAMETERS);
            }
        }
        return null;
    }

    @NotNull
    public Set<String> getDefaultBlackList() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            GoInlayParameterHintsProvider.$$$reportNull$$$0(14);
        }
        return set;
    }

    @NotNull
    public List<Option> getSupportedOptions() {
        return new SmartList((Object[])new Option[]{SHOW_UNNAMED_FIELDS, SHOW_RETURN_PARAMETERS});
    }

    @Nls
    public String getProperty(String key) {
        return GoBundle.message((String)key, (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 7, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/highlighting/GoInlayParameterHintsProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exprs";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/highlighting/GoInlayParameterHintsProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterHints";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "annotateParameters";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultBlackList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getParameterHints";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 14: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "annotateParameters";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createFieldInlay";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isCompositeLiteralWithSimilarName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "showInlay";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getHintInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 7, 14 -> new IllegalStateException(string);
        };
    }
}

