/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.errors;

import com.goide.formatter.GoBuildDirectivePostFormatProcessor;
import com.goide.formatter.GoFormatterUtil;
import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.errors.GoSpecCheckerBase;
import com.goide.i18n.GoBundle;
import com.goide.inspections.buildTag.GoBuildDirectiveOptions;
import com.goide.inspections.buildTag.GoBuildElement;
import com.goide.inspections.buildTag.GoBuildTagUtil;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.psi.GoFile;
import com.goide.psi.GoPackageClause;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.quickfix.GoDeleteQuickFix;
import com.goide.quickfix.GoPlaceBeforePackageQuickFix;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoTargetSdkVersionProvider;
import com.goide.util.GoUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoBuildDirectiveSpecChecker
extends GoSpecCheckerBase {
    public GoBuildDirectiveSpecChecker(@NotNull GoAnnotationHolder holder) {
        if (holder == null) {
            GoBuildDirectiveSpecChecker.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    public void visitComment(@NotNull PsiComment comment) {
        GoPackageClause pkg;
        if (comment == null) {
            GoBuildDirectiveSpecChecker.$$$reportNull$$$0(1);
        }
        super.visitComment(comment);
        GoSdk sdk = GoSdkService.getInstance(comment.getProject()).getSdk(GoUtil.module((PsiElement)comment));
        GoBuildDirectiveOptions options = sdk.getGoBuildDirectiveOptions();
        if (!(options.isReportMisplacedDirective() || options.isReportMissingPlusBuildTags() || options.isReportSemanticErrors())) {
            return;
        }
        if (!GoPsiUtil.isGoBuildDirective((PsiElement)comment)) {
            return;
        }
        GoFile file = (GoFile)((Object)ObjectUtils.tryCast((Object)comment.getContainingFile(), GoFile.class));
        GoPackageClause goPackageClause = pkg = file != null ? file.getPackage() : null;
        if (pkg == null) {
            return;
        }
        if (comment.getTextRange().getStartOffset() > pkg.getTextRange().getEndOffset()) {
            this.myHolder.newErrorAnnotation(comment.getTextRange(), (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.go.build.after.package")).withFix((IntentionAction)new GoPlaceBeforePackageQuickFix((PsiElement)comment, "go:build")).create();
        } else {
            if (!GoFormatterUtil.isFirstElementOnLine((PsiElement)comment)) {
                this.myHolder.newErrorAnnotation(comment.getTextRange(), (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.go.build.non.first.element")).create();
                return;
            }
            if (options.isReportSemanticErrors() && GoBuildDirectiveSpecChecker.hasGoBuildDirectiveBefore((PsiElement)comment)) {
                GoInspectionMessageWithI18n msg = GoInspectionMessageWithI18n.message("go.error.go.build.only.one.allowed");
                AnnotationBuilder annotation = this.myHolder.newErrorAnnotation(comment.getTextRange(), (GoInspectionMessage)msg);
                GoBuildDirectiveSpecChecker.withQuickFix(annotation, GoDeleteQuickFix.Fixes.DELETE_COMMENT_FIX, (PsiElement)comment, msg).create();
                return;
            }
            List<PsiComment> plusBuildComments = file.getBuildFlagElements();
            if (plusBuildComments.isEmpty()) {
                this.reportMissingPlusBuildComments(comment, options);
            } else if (options.isReportSemanticErrors()) {
                GoBuildElement goBuildConstraint = GoBuildTagUtil.parseGoBuildElement((PsiElement)comment);
                if (goBuildConstraint == null) {
                    return;
                }
                List<String> plusBuildConstraints = GoBuildTagUtil.getPlusBuildConstraintsForGoBuildDirective(goBuildConstraint);
                if (plusBuildConstraints.isEmpty()) {
                    this.myHolder.newWarningAnnotation(comment.getTextRange(), GoInspectionMessageWithI18n.message("go.error.go.build.expression.is.too.complex")).create();
                } else if (!GoBuildDirectiveSpecChecker.areEquivalent(goBuildConstraint, plusBuildComments)) {
                    this.myHolder.newWarningAnnotation(comment.getTextRange(), GoInspectionMessageWithI18n.message("go.error.go.build.and.plus.build.lines.dont.match")).withFix((IntentionAction)new UpdatePlusBuildCommentsFix(comment)).create();
                }
            }
        }
    }

    private void reportMissingPlusBuildComments(@NotNull PsiComment goBuildDirective, @NotNull GoBuildDirectiveOptions options) {
        if (goBuildDirective == null) {
            GoBuildDirectiveSpecChecker.$$$reportNull$$$0(2);
        }
        if (options == null) {
            GoBuildDirectiveSpecChecker.$$$reportNull$$$0(3);
        }
        AnnotationBuilder annotation = null;
        if (options.isReportMissingPlusBuildTags()) {
            annotation = this.myHolder.newErrorAnnotation(goBuildDirective.getTextRange(), (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.go.build.without.plus.build"));
        } else if (options.isReportMissingPlusBuildTags(GoTargetSdkVersionProvider.getTargetGoSdkVersion((PsiElement)goBuildDirective))) {
            annotation = this.myHolder.newWarningAnnotation(goBuildDirective.getTextRange(), GoInspectionMessageWithI18n.message("go.error.go.build.without.plus.build"));
        }
        if (annotation == null) {
            return;
        }
        if (!GoBuildTagUtil.getPlusBuildConstraintsForGoBuildDirective(GoBuildTagUtil.parseGoBuildElement((PsiElement)goBuildDirective)).isEmpty()) {
            annotation = annotation.withFix((IntentionAction)new AddPlusBuildCommentsFix(goBuildDirective));
        }
        annotation.create();
    }

    public static boolean areEquivalent(@NotNull GoBuildElement expected, @NotNull List<PsiComment> plusBuildComments) {
        if (expected == null) {
            GoBuildDirectiveSpecChecker.$$$reportNull$$$0(4);
        }
        if (plusBuildComments == null) {
            GoBuildDirectiveSpecChecker.$$$reportNull$$$0(5);
        }
        return Objects.equals(GoBuildDirectivePostFormatProcessor.formatGoBuildElement((PsiElement)expected), GoBuildDirectivePostFormatProcessor.convertToGoBuildExpression(expected.getProject(), plusBuildComments));
    }

    private static boolean hasGoBuildDirectiveBefore(@NotNull PsiElement element) {
        if (element == null) {
            GoBuildDirectiveSpecChecker.$$$reportNull$$$0(6);
        }
        for (PsiElement result = element.getPrevSibling(); result != null; result = result.getPrevSibling()) {
            if (!GoPsiUtil.isGoBuildDirective(result)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goBuildDirective";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plusBuildComments";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/errors/GoBuildDirectiveSpecChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitComment";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "reportMissingPlusBuildComments";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "areEquivalent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "hasGoBuildDirectiveBefore";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @ApiStatus.Internal
    public static final class UpdatePlusBuildCommentsFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        public UpdatePlusBuildCommentsFix(@Nullable PsiComment element) {
            super((PsiElement)element);
        }

        @NotNull
        public String getText() {
            return UpdatePlusBuildCommentsFix.name();
        }

        @NotNull
        public String getFamilyName() {
            return UpdatePlusBuildCommentsFix.name();
        }

        @NotNull
        @IntentionName
        public static String name() {
            String string = GoBundle.message((String)"go.fix.update.plus.build.comments", (Object[])new Object[0]);
            if (string == null) {
                UpdatePlusBuildCommentsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PsiComment goBuildDirective;
            if (project == null) {
                UpdatePlusBuildCommentsFix.$$$reportNull$$$0(1);
            }
            if (file == null) {
                UpdatePlusBuildCommentsFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                UpdatePlusBuildCommentsFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                UpdatePlusBuildCommentsFix.$$$reportNull$$$0(4);
            }
            if ((goBuildDirective = (PsiComment)ObjectUtils.tryCast((Object)startElement, PsiComment.class)) != null) {
                GoBuildDirectivePostFormatProcessor.canonicalize(goBuildDirective);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/highlighting/errors/GoBuildDirectiveSpecChecker$UpdatePlusBuildCommentsFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "name";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/highlighting/errors/GoBuildDirectiveSpecChecker$UpdatePlusBuildCommentsFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    @ApiStatus.Internal
    public static final class AddPlusBuildCommentsFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        AddPlusBuildCommentsFix(@Nullable PsiComment element) {
            super((PsiElement)element);
        }

        @NotNull
        public String getText() {
            return AddPlusBuildCommentsFix.name();
        }

        @NotNull
        public String getFamilyName() {
            return AddPlusBuildCommentsFix.name();
        }

        @NotNull
        @IntentionName
        public static String name() {
            String string = GoBundle.message((String)"go.fix.add.plus.build.comments", (Object[])new Object[0]);
            if (string == null) {
                AddPlusBuildCommentsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PsiComment goBuildDirective;
            if (project == null) {
                AddPlusBuildCommentsFix.$$$reportNull$$$0(1);
            }
            if (file == null) {
                AddPlusBuildCommentsFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                AddPlusBuildCommentsFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                AddPlusBuildCommentsFix.$$$reportNull$$$0(4);
            }
            if ((goBuildDirective = (PsiComment)ObjectUtils.tryCast((Object)startElement, PsiComment.class)) != null) {
                GoBuildDirectivePostFormatProcessor.canonicalize(goBuildDirective);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/highlighting/errors/GoBuildDirectiveSpecChecker$AddPlusBuildCommentsFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "name";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/highlighting/errors/GoBuildDirectiveSpecChecker$AddPlusBuildCommentsFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

