/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.errors;

import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.GoStringLiteralLexer;
import com.goide.highlighting.errors.GoSpecCheckerBase;
import com.goide.highlighting.errors.GoStringLiteralLexerAdapter;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.psi.GoStringLiteral;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoStringLiteralSpecChecker
extends GoSpecCheckerBase {
    public GoStringLiteralSpecChecker(@NotNull GoAnnotationHolder holder) {
        if (holder == null) {
            GoStringLiteralSpecChecker.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    @Override
    public void visitStringLiteral(@NotNull GoStringLiteral literal) {
        if (literal == null) {
            GoStringLiteralSpecChecker.$$$reportNull$$$0(1);
        }
        if (literal.getRawString() != null) {
            return;
        }
        if (GoStringLiteralSpecChecker.isNewLineInString(literal)) {
            this.myHolder.newErrorAnnotation(literal, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.new.line.in.string")).create();
            return;
        }
        if (!literal.textContains('\\')) {
            return;
        }
        List<Pair<TextRange, GoInspectionMessage>> problems = GoStringLiteralSpecChecker.findProblems(new GoStringLiteralLexerAdapter(literal));
        for (Pair<TextRange, GoInspectionMessage> problem : problems) {
            this.createErrorAnnotation(literal, (TextRange)problem.getFirst(), (GoInspectionMessage)problem.getSecond());
        }
    }

    private static boolean isNewLineInString(@NotNull GoStringLiteral literal) {
        int length;
        if (literal == null) {
            GoStringLiteralSpecChecker.$$$reportNull$$$0(2);
        }
        if ((length = literal.getTextLength()) == 1) {
            return true;
        }
        CharSequence chars = GoStringLiteralSpecChecker.getChars(literal);
        if (!chars.isEmpty() && chars.charAt(chars.length() - 1) != '\"') {
            return true;
        }
        return length == 3 && literal.textMatches("\"\\\"");
    }

    @NotNull
    public static List<Pair<TextRange, GoInspectionMessage>> findProblems(@NotNull GoStringLiteralLexer lexer) {
        IElementType tokenType;
        if (lexer == null) {
            GoStringLiteralSpecChecker.$$$reportNull$$$0(3);
        }
        ArrayList<Pair<TextRange, GoInspectionMessage>> problems = new ArrayList<Pair<TextRange, GoInspectionMessage>>();
        while ((tokenType = lexer.getTokenType()) != null) {
            GoInspectionMessage problem;
            if (tokenType == StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN) {
                problems.add((Pair<TextRange, GoInspectionMessage>)Pair.create((Object)lexer.getTokenRange(), (Object)GoStringLiteralSpecChecker.invalidEscapeSequenceMessage(lexer.getTokenText())));
            } else if (tokenType == StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN) {
                String tokenText = lexer.getTokenText();
                if (tokenText.startsWith("\\") && GoStringLiteralSpecChecker.containsDigitsOnly(tokenText.substring(1))) {
                    problems.add((Pair<TextRange, GoInspectionMessage>)Pair.create((Object)lexer.getTokenRange(), (Object)GoInspectionMessageWithI18n.message("go.error.annotator.bad.octal.escape")));
                } else {
                    problems.add((Pair<TextRange, GoInspectionMessage>)Pair.create((Object)lexer.getTokenRange(), (Object)GoInspectionMessageWithI18n.message("go.error.annotator.invalid.escape.sequence")));
                }
            } else if (tokenType == StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN && (problem = GoStringLiteralSpecChecker.checkEscapeSequence(lexer.getTokenText(), false, false)) != null) {
                problems.add((Pair<TextRange, GoInspectionMessage>)Pair.create((Object)lexer.getTokenRange(), (Object)problem));
            }
            lexer.advance();
            ProgressManager.checkCanceled();
        }
        ArrayList<Pair<TextRange, GoInspectionMessage>> arrayList = problems;
        if (arrayList == null) {
            GoStringLiteralSpecChecker.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    private static CharSequence getChars(@NotNull GoStringLiteral literal) {
        if (literal == null) {
            GoStringLiteralSpecChecker.$$$reportNull$$$0(5);
        }
        CharSequence charSequence = Optional.of(literal).map(GoStringLiteral::getString).map(s -> (LeafPsiElement)ObjectUtils.tryCast((Object)s, LeafPsiElement.class)).map(LeafElement::getChars).orElse("");
        if (charSequence == null) {
            GoStringLiteralSpecChecker.$$$reportNull$$$0(6);
        }
        return charSequence;
    }

    @NotNull
    private static GoInspectionMessage invalidEscapeSequenceMessage(@NotNull String tokenText) {
        if (tokenText == null) {
            GoStringLiteralSpecChecker.$$$reportNull$$$0(7);
        }
        if (tokenText.startsWith("\\x")) {
            GoInspectionMessageWithI18n goInspectionMessageWithI18n = GoInspectionMessageWithI18n.message("go.error.annotator.invalid.hex.escape.sequence.syntax");
            if (goInspectionMessageWithI18n == null) {
                GoStringLiteralSpecChecker.$$$reportNull$$$0(8);
            }
            return goInspectionMessageWithI18n;
        }
        if (tokenText.startsWith("\\u")) {
            GoInspectionMessageWithI18n goInspectionMessageWithI18n = GoInspectionMessageWithI18n.message("go.error.annotator.invalid.unicode.escape.sequence.syntax");
            if (goInspectionMessageWithI18n == null) {
                GoStringLiteralSpecChecker.$$$reportNull$$$0(9);
            }
            return goInspectionMessageWithI18n;
        }
        if (tokenText.startsWith("\\U")) {
            GoInspectionMessageWithI18n goInspectionMessageWithI18n = GoInspectionMessageWithI18n.message("go.error.annotator.invalid.long.unicode.escape.sequence.syntax");
            if (goInspectionMessageWithI18n == null) {
                GoStringLiteralSpecChecker.$$$reportNull$$$0(10);
            }
            return goInspectionMessageWithI18n;
        }
        GoInspectionMessageWithI18n goInspectionMessageWithI18n = GoInspectionMessageWithI18n.message("go.error.annotator.invalid.escape.sequence");
        if (goInspectionMessageWithI18n == null) {
            GoStringLiteralSpecChecker.$$$reportNull$$$0(11);
        }
        return goInspectionMessageWithI18n;
    }

    @Nullable
    public static GoInspectionMessage checkEscapeSequence(@NotNull String text, boolean fullCheck, boolean isRune) {
        if (text == null) {
            GoStringLiteralSpecChecker.$$$reportNull$$$0(12);
        }
        assert (text.startsWith("\\"));
        if (fullCheck && text.startsWith("\\x")) {
            if (text.length() != 4 || !GoStringLiteralSpecChecker.containsHexDigitsOnly(text.substring(2))) {
                return GoInspectionMessageWithI18n.message("go.error.annotator.invalid.hex.escape.sequence.syntax");
            }
            return null;
        }
        if (text.startsWith("\\u")) {
            String codePoint = text.substring(2);
            if (fullCheck && (codePoint.length() != 4 || !GoStringLiteralSpecChecker.containsHexDigitsOnly(codePoint))) {
                return GoInspectionMessageWithI18n.message("go.error.annotator.invalid.unicode.escape.sequence.syntax");
            }
            assert (codePoint.length() == 4);
            if (GoStringLiteralSpecChecker.isSurrogateCodePoint(codePoint)) {
                return GoInspectionMessageWithI18n.message("go.error.annotator.invalid.unicode.code.point");
            }
            return null;
        }
        if (text.startsWith("\\U")) {
            String codePoint = text.substring(2);
            if (fullCheck && (codePoint.length() != 8 || !GoStringLiteralSpecChecker.containsHexDigitsOnly(codePoint))) {
                return GoInspectionMessageWithI18n.message("go.error.annotator.invalid.long.unicode.escape.sequence.syntax");
            }
            assert (codePoint.length() == 8);
            if (codePoint.startsWith("0000") && GoStringLiteralSpecChecker.isSurrogateCodePoint(codePoint.substring(4))) {
                return GoInspectionMessageWithI18n.message("go.error.annotator.invalid.unicode.code.point");
            }
            if (!codePoint.startsWith("000") && Integer.parseInt(codePoint, 16) > 0x10FFFF) {
                return GoInspectionMessageWithI18n.message("go.error.annotator.invalid.unicode.code.point");
            }
            return null;
        }
        if (text.length() > 1 && StringUtil.isDecimalDigit((char)text.charAt(1))) {
            char firstDigit = text.charAt(1);
            if (text.length() != 4 || '0' > firstDigit || firstDigit > '3' || !GoStringLiteralSpecChecker.containsOctalDigitsOnly(text.substring(2))) {
                return GoInspectionMessageWithI18n.message("go.error.annotator.bad.octal.escape");
            }
            return null;
        }
        if (fullCheck) {
            return !GoStringLiteralSpecChecker.isValidSingleCharEscape(text, isRune) ? GoInspectionMessageWithI18n.message("go.error.annotator.invalid.escape.sequence") : null;
        }
        return text.equals(isRune ? "\\\"" : "\\'") ? GoInspectionMessageWithI18n.message("go.error.annotator.invalid.escape.sequence") : null;
    }

    private static boolean isSurrogateCodePoint(@NotNull String codePoint) {
        if (codePoint == null) {
            GoStringLiteralSpecChecker.$$$reportNull$$$0(13);
        }
        assert (codePoint.length() == 4);
        char c0 = codePoint.charAt(0);
        char c1 = codePoint.charAt(1);
        return (c0 == 'd' || c0 == 'D') && (c1 == '8' || c1 == '9' || 'a' <= c1 && c1 <= 'f' || 'A' <= c1 && c1 <= 'F');
    }

    private static boolean containsHexDigitsOnly(@NotNull String s) {
        if (s == null) {
            GoStringLiteralSpecChecker.$$$reportNull$$$0(14);
        }
        for (int i = 0; i < s.length(); ++i) {
            if (StringUtil.isHexDigit((char)s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean containsDigitsOnly(@NotNull String s) {
        if (s == null) {
            GoStringLiteralSpecChecker.$$$reportNull$$$0(15);
        }
        for (int i = 0; i < s.length(); ++i) {
            if (StringUtil.isDecimalDigit((char)s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean containsOctalDigitsOnly(@NotNull String s) {
        if (s == null) {
            GoStringLiteralSpecChecker.$$$reportNull$$$0(16);
        }
        for (int i = 0; i < s.length(); ++i) {
            if (StringUtil.isOctalDigit((char)s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidSingleCharEscape(@NotNull String text, boolean isRune) {
        if (text == null) {
            GoStringLiteralSpecChecker.$$$reportNull$$$0(17);
        }
        assert (text.startsWith("\\"));
        if (text.length() != 2) {
            return false;
        }
        char c = text.charAt(1);
        return c == 'a' || c == 'b' || c == 'f' || c == 'n' || c == 'r' || c == 't' || c == 'v' || c == '\\' || (isRune ? c == '\'' : c == '\"');
    }

    private void createErrorAnnotation(@NotNull GoStringLiteral literal, @NotNull TextRange range, @NotNull GoInspectionMessage message) {
        if (literal == null) {
            GoStringLiteralSpecChecker.$$$reportNull$$$0(18);
        }
        if (range == null) {
            GoStringLiteralSpecChecker.$$$reportNull$$$0(19);
        }
        if (message == null) {
            GoStringLiteralSpecChecker.$$$reportNull$$$0(20);
        }
        this.myHolder.newErrorAnnotation(range.shiftRight(literal.getTextOffset()), message).create();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/highlighting/errors/GoStringLiteralSpecChecker";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenText";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codePoint";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/highlighting/errors/GoStringLiteralSpecChecker";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findProblems";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChars";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "invalidEscapeSequenceMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitStringLiteral";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isNewLineInString";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findProblems";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getChars";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invalidEscapeSequenceMessage";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkEscapeSequence";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isSurrogateCodePoint";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "containsHexDigitsOnly";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "containsDigitsOnly";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "containsOctalDigitsOnly";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isValidSingleCharEscape";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createErrorAnnotation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

