/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.legacyErrorInspections;

import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionProblemUtil;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoFile;
import com.goide.psi.GoPackageClause;
import com.goide.psi.GoVisitor;
import com.goide.quickfix.GoMultiplePackagesQuickFix;
import com.goide.sdk.GoPackageUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GoMultiplePackagesInspection
extends GoVisitor {
    @NotNull
    private final GoProblemsHolder myHolder;

    public GoMultiplePackagesInspection(@NotNull GoProblemsHolder holder) {
        if (holder == null) {
            GoMultiplePackagesInspection.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    @Override
    public void visitGoFile(@NotNull GoFile file) {
        if (file == null) {
            GoMultiplePackagesInspection.$$$reportNull$$$0(1);
        }
        if (ScratchUtil.isScratch((VirtualFile)file.getOriginalFile().getVirtualFile())) {
            return;
        }
        GoPackageClause packageClause = file.getPackage();
        if (packageClause == null) {
            return;
        }
        String packageName = packageClause.getName();
        if (packageName == null) {
            return;
        }
        PsiDirectory dir = file.getOriginalFile().getContainingDirectory();
        Set<String> packages = GoPackageUtil.getAllPackagesInDirectory(dir, null, true);
        if (packages.size() > 1) {
            ArrayList<GoMultiplePackagesQuickFix> fixes = new ArrayList<GoMultiplePackagesQuickFix>();
            if (this.myHolder.isOnTheFly()) {
                fixes.add(new GoMultiplePackagesQuickFix(packageClause, packageName, packages, true));
            } else {
                for (String name : packages) {
                    fixes.add(new GoMultiplePackagesQuickFix(packageClause, name, packages, false));
                }
            }
            Object packagesText = (String)JBIterable.from(packages).take(3).join((Object)", ").reduce((Object)"", String::concat);
            if (packages.size() > 3) {
                packagesText = (String)packagesText + " ...";
            }
            GoInspectionMessage message = GoInspectionProblemUtil.message("go.inspection.problem.multiple.packages.in.directory", packagesText);
            this.myHolder.registerProblem((PsiElement)packageClause, message, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoMultiplePackagesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitGoFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

