/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.inspections.unresolved.GoExportQuickFix;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeList;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.quickfix.GoRenameQuickFix;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.usageView.UsageViewUtil;
import org.jetbrains.annotations.NotNull;

public final class GoExportedFuncWithUnexportedTypeInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoExportedFuncWithUnexportedTypeInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoExportedFuncWithUnexportedTypeInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            @Override
            public void visitMethodDeclaration(@NotNull GoMethodDeclaration o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitMethodDeclaration(o);
                if (!o.isPublic()) {
                    return;
                }
                GoType receiverType = GoTypeUtil.unwrapPointerAndParTypes(o.getReceiverType());
                if (receiverType == null || !StringUtil.isCapitalized((String)receiverType.getText())) {
                    return;
                }
                this.checkResultType(o);
            }

            @Override
            public void visitFunctionDeclaration(@NotNull GoFunctionDeclaration o) {
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitFunctionDeclaration(o);
                if (!o.isPublic()) {
                    return;
                }
                this.checkResultType(o);
            }

            private void checkResultType(@NotNull GoFunctionOrMethodDeclaration o) {
                GoType resultType;
                if (o == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((resultType = o.getResultType()) instanceof GoTypeList) {
                    ((GoTypeList)resultType).getTypeList().forEach(type -> this.registerProblemIfNeeded(o, (GoType)type));
                } else {
                    this.registerProblemIfNeeded(o, resultType);
                }
            }

            private void registerProblemIfNeeded(@NotNull GoFunctionOrMethodDeclaration declaration, @NotNull GoType o) {
                GoTypeSpec typeSpec;
                GoType type;
                PsiElement psiElement;
                if (declaration == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (o == null) {
                    1.$$$reportNull$$$0(4);
                }
                if ((psiElement = (type = GoTypeUtil.unwrapPointerAndParTypes(o)).contextlessResolve()) instanceof GoTypeSpec && !(typeSpec = (GoTypeSpec)psiElement).isPublic()) {
                    String description = UsageViewUtil.getType((PsiElement)declaration);
                    GoTypeReferenceExpression typeRefExpr = type.getTypeReferenceExpression();
                    LocalQuickFix[] localQuickFixes = LocalQuickFix.EMPTY_ARRAY;
                    if (typeRefExpr != null && GoPsiUtil.isExportable(declaration.getProject(), typeSpec)) {
                        String refType = UsageViewUtil.getType((PsiElement)typeSpec);
                        localQuickFixes = new LocalQuickFix[]{StringUtil.canBeCapitalized((String)typeSpec.getName()) ? new GoExportQuickFix(typeRefExpr, refType) : new GoRenameQuickFix(typeSpec)};
                    }
                    holder.registerProblem((PsiElement)o, GoExportedFuncWithUnexportedTypeInspection.message("go.inspection.problem.exported.function.with.unexported.return.type", new Object[]{description}), localQuickFixes);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "declaration";
                        break;
                    }
                }
                objectArray2[1] = "com/goide/inspections/GoExportedFuncWithUnexportedTypeInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodDeclaration";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFunctionDeclaration";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkResultType";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerProblemIfNeeded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/goide/inspections/GoExportedFuncWithUnexportedTypeInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

