/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFile;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoType;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVarOrConstDeclaration;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.psi.GoVarOrConstSpec;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoPsiUtil;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.diagnostic.CoreAttachmentFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.util.Processor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class GoExportedOwnDeclarationInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoExportedOwnDeclarationInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoExportedOwnDeclarationInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            @Override
            public void visitVarOrConstDeclaration(@NotNull GoVarOrConstDeclaration o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(o.getParent() instanceof GoFile)) {
                    return;
                }
                GoPsiUtil.processDefinitions(o, (Processor<GoNamedElement>)((Processor)definition -> {
                    if (!definition.isPublic() || definition.getPrevSibling() == null) {
                        return true;
                    }
                    GoInspectionMessage message = definition instanceof GoVarDefinition ? GoExportedOwnDeclarationInspection.message("go.inspection.problem.exported.var.should.have.its.own.declaration", new Object[]{REF}) : GoExportedOwnDeclarationInspection.message("go.inspection.problem.exported.const.should.have.its.own.declaration", new Object[]{REF});
                    holder.registerProblem((PsiElement)definition, message, new ExtractDefinitionFix());
                    return true;
                }));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/goide/inspections/GoExportedOwnDeclarationInspection$1", "visitVarOrConstDeclaration"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/goide/inspections/GoExportedOwnDeclarationInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ExtractDefinitionFix
    implements LocalQuickFix {
        private static final Logger LOG = Logger.getInstance(ExtractDefinitionFix.class);

        private ExtractDefinitionFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = GoBundle.message((String)"go.fix.extract.to.own.declaration.name", (Object[])new Object[0]);
            if (string == null) {
                ExtractDefinitionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement grandParent;
            PsiElement element;
            if (project == null) {
                ExtractDefinitionFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ExtractDefinitionFix.$$$reportNull$$$0(2);
            }
            if (!((element = descriptor.getPsiElement()) instanceof GoVarOrConstDefinition) || !element.isValid()) {
                return;
            }
            String name = ((GoVarOrConstDefinition)element).getName();
            if (StringUtil.isEmpty((String)name)) {
                return;
            }
            GoType type = ((GoVarOrConstDefinition)element).findSiblingType();
            GoExpression value = ((GoVarOrConstDefinition)element).findExpression();
            PsiElement parent = element.getParent();
            PsiElement psiElement = grandParent = parent != null ? parent.getParent() : null;
            if (parent instanceof GoVarOrConstSpec) {
                GoVarOrConstSpec spec = (GoVarOrConstSpec)parent;
                if (grandParent instanceof GoVarOrConstDeclaration) {
                    if (!parent.isValid() || spec.getDefinitionList().indexOf(element) <= 0) {
                        return;
                    }
                    String typeText = type != null ? type.getText() : "";
                    String valueText = value != null ? value.getText() : "";
                    spec.deleteDefinition((GoVarOrConstDefinition)element);
                    if (grandParent.isValid()) {
                        GoVarOrConstDeclaration declaration = (GoVarOrConstDeclaration)grandParent;
                        declaration.addSpec(name, typeText, valueText, spec);
                        CodeEditUtil.markToReformat((ASTNode)declaration.getNode(), (boolean)true);
                        return;
                    }
                }
            }
            LOG.error("Cannot run quick fix", new Attachment[]{CoreAttachmentFactory.createAttachment((VirtualFile)element.getContainingFile().getVirtualFile())});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/inspections/GoExportedOwnDeclarationInspection$ExtractDefinitionFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/inspections/GoExportedOwnDeclarationInspection$ExtractDefinitionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

