/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.highlighting.GoStringLiteralLexer;
import com.goide.highlighting.errors.GoStringLiteralSpecChecker;
import com.goide.i18n.GoBundle;
import com.goide.inspections.GoDecodedStringLiteralRangeConverter;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoAnonymousFieldDefinition;
import com.goide.psi.GoFieldDeclaration;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.GoStructType;
import com.goide.psi.GoTag;
import com.goide.psi.GoType;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.manipulator.GoStringManipulator;
import com.goide.quickfix.GoNavigateToQuickFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameElementFix;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class GoVetStructTagInspection
extends GoInspectionBase {
    @NonNls
    private static final String XML_PACKAGE_NAME = "xml";
    @NonNls
    private static final String JSON_PACKAGE_NAME = "json";
    @NonNls
    private static final String XML_FIELD_NAME = "XMLName";
    @NonNls
    private static final String ATTR_PREFIX = "attr";
    @NonNls
    private static final String ATTRIBUTE_SUFFIX = " attribute";
    @NonNls
    private static final String ASN_1_PACKAGE_NAME = "asn1";
    private static final String[] JSON_AND_XML_PACKAGES = new String[]{"json", "xml"};
    private static final Set<String> EXTRA_PACKAGES_TO_CHECK = Set.of("json", "xml", "asn1");

    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoVetStructTagInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoVetStructTagInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            @Override
            public void visitStructType(@NotNull GoStructType struct) {
                if (struct == null) {
                    1.$$$reportNull$$$0(0);
                }
                HashMap<String, GoNamedElement> visitedTags = new HashMap<String, GoNamedElement>();
                for (GoFieldDeclaration fieldDeclaration : struct.getFieldDeclarationList()) {
                    GoAnonymousFieldDefinition anonymousFieldDefinition;
                    boolean isAnonymousField;
                    GoType fieldType;
                    GoTag tag = fieldDeclaration.getTag();
                    if (tag == null || !this.validateTag(tag) || (fieldType = (isAnonymousField = (anonymousFieldDefinition = fieldDeclaration.getAnonymousFieldDefinition()) != null) ? anonymousFieldDefinition.getType() : fieldDeclaration.getType()) == null) continue;
                    List<GoNamedElement> definitions = isAnonymousField ? Collections.singletonList(anonymousFieldDefinition) : fieldDeclaration.getFieldDefinitionList();
                    for (String packageName : JSON_AND_XML_PACKAGES) {
                        String valueText = tag.getValue(packageName);
                        if (valueText == null) continue;
                        for (GoNamedElement fieldDefinition : definitions) {
                            this.checkTagDuplicates(packageName, valueText, fieldDefinition, visitedTags);
                            String fieldName = fieldDefinition.getName();
                            if (isAnonymousField || fieldDefinition.isPublic() || tag.getValue(packageName) == null || "_".equals(fieldName)) continue;
                            GoInspectionMessage message = GoVetStructTagInspection.message("go.inspection.struct.field.has.tag.but.is.not.exported", new Object[]{fieldName, packageName});
                            holder.registerProblem((PsiElement)fieldDefinition, message, 1.createExportFix(fieldDefinition));
                        }
                    }
                }
            }

            private static LocalQuickFix @NotNull [] createExportFix(@NotNull GoNamedElement o) {
                String name;
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                LocalQuickFix[] localQuickFixArray = (name = o.getName()) == null ? LocalQuickFix.EMPTY_ARRAY : GoVetStructTagInspection.fixes(new LocalQuickFix[]{new MyExportFieldFix(o, name)});
                if (localQuickFixArray == null) {
                    1.$$$reportNull$$$0(2);
                }
                return localQuickFixArray;
            }

            private void checkTagDuplicates(@NotNull String packageName, @NotNull String valueText, @NotNull GoNamedElement fieldDefinition, @NotNull Map<String, GoNamedElement> namesSeen) {
                GoNamedElement originalFieldDefinition;
                if (packageName == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (valueText == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (fieldDefinition == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (namesSeen == null) {
                    1.$$$reportNull$$$0(6);
                }
                if ("-".equals(valueText) || valueText.isEmpty() || valueText.charAt(0) == ',' || GoVetStructTagInspection.XML_PACKAGE_NAME.equals(packageName) && GoVetStructTagInspection.XML_FIELD_NAME.equals(fieldDefinition.getName())) {
                    return;
                }
                int firstCommaIndex = valueText.indexOf(44);
                if (firstCommaIndex >= 0) {
                    if (GoVetStructTagInspection.XML_PACKAGE_NAME.equals(packageName)) {
                        String[] commaSeparatedParts;
                        for (String value : commaSeparatedParts = valueText.substring(firstCommaIndex).split(",")) {
                            if (!GoVetStructTagInspection.ATTR_PREFIX.equals(value)) continue;
                            packageName = (String)packageName + GoVetStructTagInspection.ATTRIBUTE_SUFFIX;
                        }
                    }
                    valueText = valueText.substring(0, firstCommaIndex);
                }
                if ((originalFieldDefinition = namesSeen.get((String)packageName + valueText)) != null) {
                    GoFieldDeclaration fieldDeclaration = (GoFieldDeclaration)PsiTreeUtil.getParentOfType((PsiElement)fieldDefinition, GoFieldDeclaration.class);
                    if (fieldDeclaration == null) {
                        return;
                    }
                    GoTag tag = fieldDeclaration.getTag();
                    if (tag == null) {
                        return;
                    }
                    String originalFieldName = originalFieldDefinition.getName();
                    String navigateElementDescription = GoBundle.message((String)"go.fix.field.with.the.same.tag", (Object[])new Object[]{originalFieldName, packageName});
                    GoNavigateToQuickFix navigateToFieldFix = new GoNavigateToQuickFix(originalFieldDefinition, navigateElementDescription);
                    GoInspectionMessage inspectionMessage = GoVetStructTagInspection.message("go.fix.field.repeats.tag.with.value", new Object[]{fieldDefinition.getName(), packageName, valueText, originalFieldName});
                    holder.registerProblem((PsiElement)tag, inspectionMessage, navigateToFieldFix);
                } else {
                    namesSeen.put((String)packageName + valueText, fieldDefinition);
                }
            }

            private boolean validateTag(@NotNull GoTag tag) {
                if (tag == null) {
                    1.$$$reportNull$$$0(7);
                }
                GoStringLiteral tagString = tag.getStringLiteral();
                StringBuilder decodedText = new StringBuilder();
                TextRange tagRange = ElementManipulators.getManipulator((PsiElement)tagString).getRangeInElement((PsiElement)tagString);
                if (!tagString.createLiteralTextEscaper().decode(tagRange, decodedText)) {
                    return false;
                }
                int decodedTextLength = decodedText.length();
                GoDecodedStringLiteralRangeConverter converter2 = new GoDecodedStringLiteralRangeConverter(tagString);
                int currentOffset = 0;
                int pairsNumber = 0;
                while (currentOffset < decodedTextLength) {
                    char currentCharacter;
                    if (pairsNumber > 0 && decodedText.charAt(currentOffset) != ' ') {
                        GoInspectionMessage message = GoVetStructTagInspection.message("go.inspection.key.is.not.separated.by.space.from.previous.pair");
                        this.reportCharacter(tag, converter2, currentOffset, message);
                        return false;
                    }
                    while (currentOffset < decodedTextLength && decodedText.charAt(currentOffset) == ' ') {
                        ++currentOffset;
                    }
                    if (currentOffset >= decodedTextLength) {
                        return true;
                    }
                    int keyStartOffset = currentOffset;
                    while (currentOffset < decodedTextLength && (currentCharacter = decodedText.charAt(currentOffset)) > ' ' && currentCharacter != ':' && currentCharacter != '\"' && currentCharacter != '\u007f') {
                        ++currentOffset;
                    }
                    if (!this.validateKey(tag, converter2, decodedText, decodedTextLength, currentOffset, keyStartOffset)) {
                        return false;
                    }
                    String key = decodedText.substring(keyStartOffset, currentOffset);
                    int valueStartOffset = ++currentOffset;
                    ++currentOffset;
                    while (currentOffset < decodedTextLength && decodedText.charAt(currentOffset) != '\"') {
                        if (decodedText.charAt(currentOffset) == '\\') {
                            ++currentOffset;
                        }
                        ++currentOffset;
                    }
                    if (currentOffset >= decodedTextLength) {
                        GoInspectionMessage message = GoVetStructTagInspection.message("go.inspection.missing.closing.double.quote.character.in.value");
                        this.reportCharacter(tag, converter2, currentOffset - 1, message);
                        return false;
                    }
                    String quotedValue = decodedText.substring(valueStartOffset, currentOffset + 1);
                    if (!this.validateValue(quotedValue, valueStartOffset, tag, converter2)) {
                        return false;
                    }
                    if (EXTRA_PACKAGES_TO_CHECK.contains(key) && !this.validateExtraCases(key, GoStringManipulator.unquote(quotedValue), valueStartOffset + 1, converter2, tag)) {
                        return false;
                    }
                    ++currentOffset;
                    ++pairsNumber;
                }
                return true;
            }

            private boolean validateKey(@NotNull GoTag tag, @NotNull GoDecodedStringLiteralRangeConverter converter2, @NotNull StringBuilder decodedText, int decodedTextLength, int currentOffset, int keyStartOffset) {
                char nextCharacter;
                char currentCharacter;
                if (tag == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (converter2 == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (decodedText == null) {
                    1.$$$reportNull$$$0(10);
                }
                if (currentOffset == keyStartOffset) {
                    GoInspectionMessage message = GoVetStructTagInspection.message("go.inspection.key.is.empty.or.starts.from.incorrect.symbol");
                    this.reportCharacter(tag, converter2, currentOffset, message);
                    return false;
                }
                boolean isLastCharacter = currentOffset > decodedTextLength - 1;
                int characterToCheckOffset = isLastCharacter ? currentOffset - 1 : currentOffset;
                char c = currentCharacter = isLastCharacter ? decodedText.charAt(decodedTextLength - 1) : decodedText.charAt(currentOffset);
                if (currentCharacter != ':') {
                    GoInspectionMessage message = GoVetStructTagInspection.message("go.inspection.expected.colon.after.key");
                    this.reportCharacter(tag, converter2, characterToCheckOffset, message);
                    return false;
                }
                boolean isNextCharacterLast = currentOffset + 1 >= decodedTextLength;
                char c2 = nextCharacter = isNextCharacterLast ? decodedText.charAt(decodedTextLength - 1) : decodedText.charAt(currentOffset + 1);
                if (nextCharacter != '\"') {
                    int expectedQuoteCharacterOffset = isNextCharacterLast ? characterToCheckOffset : characterToCheckOffset + 1;
                    GoInspectionMessage message = GoVetStructTagInspection.message("go.inspection.expected.opening.double.quote.character.after.colon");
                    this.reportCharacter(tag, converter2, expectedQuoteCharacterOffset, message);
                    return false;
                }
                return true;
            }

            private boolean validateExtraCases(@NotNull String key, @NotNull String value, int valueTextOffset, @NotNull GoDecodedStringLiteralRangeConverter converter2, @NotNull GoTag tag) {
                int valueTextOffsetAfterComma;
                if (key == null) {
                    1.$$$reportNull$$$0(11);
                }
                if (value == null) {
                    1.$$$reportNull$$$0(12);
                }
                if (converter2 == null) {
                    1.$$$reportNull$$$0(13);
                }
                if (tag == null) {
                    1.$$$reportNull$$$0(14);
                }
                if (GoVetStructTagInspection.XML_PACKAGE_NAME.equals(key)) {
                    String trimmedCurrentValue = value.trim();
                    if (trimmedCurrentValue.isEmpty() && !value.isEmpty()) {
                        int valueTextEndOffset = valueTextOffset + value.length();
                        TextRange valueTextRange = converter2.computeRange(valueTextOffset, valueTextEndOffset);
                        if (valueTextRange == null) {
                            return false;
                        }
                        holder.registerProblem((PsiElement)tag, valueTextRange, GoVetStructTagInspection.message("go.inspection.struct.tag.value.consists.only.of.spaces"), new LocalQuickFix[0]);
                        return false;
                    }
                    if (!value.startsWith(trimmedCurrentValue)) {
                        TextRange beginningSpaceRange = converter2.computeRange(valueTextOffset, valueTextOffset + 1);
                        GoInspectionMessage message = GoVetStructTagInspection.message("go.inspection.suspicious.space.in.the.beginning.of.the.struct.tag.value");
                        holder.registerProblem((PsiElement)tag, beginningSpaceRange, message, new LocalQuickFix[0]);
                        return false;
                    }
                    if (!value.endsWith(trimmedCurrentValue)) {
                        int lastValueCharacterOffset = valueTextOffset + value.length() - 1;
                        TextRange endingSpaceRange = converter2.computeRange(lastValueCharacterOffset, lastValueCharacterOffset + 1);
                        holder.registerProblem((PsiElement)tag, endingSpaceRange, GoVetStructTagInspection.message("go.inspection.suspicious.space.in.the.end.of.the.struct.tag.value"), new LocalQuickFix[0]);
                        return false;
                    }
                    if (Strings.countChars((CharSequence)value, (char)' ') > 1) {
                        int firstExtraSpaceIndex = valueTextOffset + value.lastIndexOf(32);
                        TextRange extraSpaceRange = converter2.computeRange(firstExtraSpaceIndex, firstExtraSpaceIndex + 1);
                        holder.registerProblem((PsiElement)tag, extraSpaceRange, GoVetStructTagInspection.message("go.inspection.suspicious.extra.space.in.struct.tag.value"), new LocalQuickFix[0]);
                        return false;
                    }
                    int commaIndex = value.indexOf(44);
                    if (commaIndex < 0) {
                        return true;
                    }
                    if (commaIndex > 0 && value.charAt(commaIndex - 1) == ' ') {
                        int spaceOffset = valueTextOffset + commaIndex - 1;
                        TextRange spaceRange = converter2.computeRange(spaceOffset, spaceOffset + 1);
                        holder.registerProblem((PsiElement)tag, spaceRange, GoVetStructTagInspection.message("go.inspection.suspicious.space.in.struct.tag.value"), new LocalQuickFix[0]);
                        return false;
                    }
                    valueTextOffsetAfterComma = valueTextOffset + commaIndex + 1;
                    value = value.substring(commaIndex + 1);
                } else if (GoVetStructTagInspection.JSON_PACKAGE_NAME.equals(key)) {
                    int commaIndex = value.indexOf(44);
                    if (commaIndex < 0) {
                        return true;
                    }
                    valueTextOffsetAfterComma = valueTextOffset + commaIndex + 1;
                    value = value.substring(commaIndex + 1);
                } else {
                    valueTextOffsetAfterComma = valueTextOffset;
                }
                int spaceIndex = value.indexOf(32);
                if (spaceIndex >= 0) {
                    int spaceStartOffset = valueTextOffsetAfterComma + spaceIndex;
                    TextRange spaceRange = converter2.computeRange(spaceStartOffset, spaceStartOffset + 1);
                    holder.registerProblem((PsiElement)tag, spaceRange, GoVetStructTagInspection.message("go.inspection.suspicious.space.in.struct.tag.value"), new LocalQuickFix[0]);
                    return false;
                }
                return true;
            }

            private boolean validateValue(@NotNull String valueText, int valueStartOffsetInTag, @NotNull GoTag tag, @NotNull GoDecodedStringLiteralRangeConverter converter2) {
                if (valueText == null) {
                    1.$$$reportNull$$$0(15);
                }
                if (tag == null) {
                    1.$$$reportNull$$$0(16);
                }
                if (converter2 == null) {
                    1.$$$reportNull$$$0(17);
                }
                if (!valueText.contains("\\")) {
                    return true;
                }
                GoStringLiteralLexer lexer = new GoStringLiteralLexer();
                lexer.start((CharSequence)valueText);
                List<Pair<TextRange, GoInspectionMessage>> problems = GoStringLiteralSpecChecker.findProblems(lexer);
                if (problems.isEmpty()) {
                    return true;
                }
                for (Pair<TextRange, GoInspectionMessage> problem : problems) {
                    TextRange problemRangeInDecodedText = ((TextRange)problem.getFirst()).shiftRight(valueStartOffsetInTag);
                    TextRange problemRange = converter2.computeRange(problemRangeInDecodedText.getStartOffset(), problemRangeInDecodedText.getEndOffset());
                    holder.registerProblem((PsiElement)tag, problemRange, (GoInspectionMessage)problem.getSecond(), new LocalQuickFix[0]);
                }
                return false;
            }

            private void reportCharacter(@NotNull GoTag tag, @NotNull GoDecodedStringLiteralRangeConverter converter2, int characterOffsetInDecodedText, @NotNull GoInspectionMessage message) {
                TextRange currentCharacterTextRangeNew;
                if (tag == null) {
                    1.$$$reportNull$$$0(18);
                }
                if (converter2 == null) {
                    1.$$$reportNull$$$0(19);
                }
                if (message == null) {
                    1.$$$reportNull$$$0(20);
                }
                if ((currentCharacterTextRangeNew = converter2.computeRange(characterOffsetInDecodedText, characterOffsetInDecodedText + 1)) == null) {
                    return;
                }
                holder.registerProblem((PsiElement)tag, currentCharacterTextRangeNew, message, new LocalQuickFix[0]);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "struct";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/goide/inspections/GoVetStructTagInspection$1";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "packageName";
                        break;
                    }
                    case 4: 
                    case 15: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "valueText";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fieldDefinition";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "namesSeen";
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 14: 
                    case 16: 
                    case 18: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tag";
                        break;
                    }
                    case 9: 
                    case 13: 
                    case 17: 
                    case 19: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "converter";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "decodedText";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 20: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/goide/inspections/GoVetStructTagInspection$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createExportFix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitStructType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "createExportFix";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "checkTagDuplicates";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "validateTag";
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: {
                        objectArray = objectArray;
                        objectArray[2] = "validateKey";
                        break;
                    }
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: {
                        objectArray = objectArray;
                        objectArray[2] = "validateExtraCases";
                        break;
                    }
                    case 15: 
                    case 16: 
                    case 17: {
                        objectArray = objectArray;
                        objectArray[2] = "validateValue";
                        break;
                    }
                    case 18: 
                    case 19: 
                    case 20: {
                        objectArray = objectArray;
                        objectArray[2] = "reportCharacter";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/goide/inspections/GoVetStructTagInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyExportFieldFix
    extends RenameElementFix {
        private MyExportFieldFix(@NotNull GoNamedElement o, String name) {
            if (o == null) {
                MyExportFieldFix.$$$reportNull$$$0(0);
            }
            super((PsiNamedElement)o, StringUtil.capitalize((String)name), GoBundle.message((String)"go.fix.export.field.name", (Object[])new Object[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/goide/inspections/GoVetStructTagInspection$MyExportFieldFix", "<init>"));
        }
    }
}

