/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.vet;

import com.goide.GoTypes;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoBinaryExpr;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoPointerType;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeOwner;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.stubs.GoTypeSpecStub;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoVetUnsafePointerInspection
extends GoInspectionBase {
    private static final GoInspectionMessage INSPECTION_MESSAGE = GoVetUnsafePointerInspection.message("go.inspection.possible.misuse.of.unsafe.pointer", GoVetUnsafePointerInspection.code("unsafe.Pointer"));
    @NonNls
    private static final String REFLECT_PACKAGE_NAME = "reflect";
    @NonNls
    private static final String STRING_HEADER_TYPE_NAME = "StringHeader";
    @NonNls
    private static final String SLICE_HEADER_TYPE_NAME = "SliceHeader";
    @NonNls
    private static final String POINTER_METHOD_NAME = "Pointer";
    @NonNls
    private static final String UNSAFE_ADDR_METHOD_NAME = "UnsafeAddr";
    @NonNls
    private static final String VALUE_TYPE_NAME = "Value";
    @NonNls
    private static final String VALUE_FILE_NAME = "value.go";

    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoVetUnsafePointerInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoVetUnsafePointerInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            @Override
            public void visitCallExpr(@NotNull GoCallExpr call) {
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitCallExpr(call);
                GoExpression argumentExpression = (GoExpression)ContainerUtil.getOnlyItem(call.getArgumentList().getExpressionList());
                if (argumentExpression == null) {
                    return;
                }
                GoExpression callExpression = call.getExpression();
                GoType callExpressionType = callExpression.getGoType(null);
                if (callExpressionType == null) {
                    return;
                }
                if (GoTypeUtil.isUnsafePointerType(callExpressionType, call) && GoTypeUtil.isUintptr(argumentExpression.getGoType(null), call) && !this.isSafeUintptrExpression(argumentExpression)) {
                    holder.registerProblem((PsiElement)callExpression, INSPECTION_MESSAGE, new LocalQuickFix[0]);
                }
            }

            private boolean isSafeUintptrExpression(@NotNull GoExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((expression = GoPsiImplUtil.unwrapParentheses(expression)) == null) {
                    return false;
                }
                if (expression instanceof GoReferenceExpression) {
                    return this.checkAccessToDataField((GoReferenceExpression)expression);
                }
                if (expression instanceof GoCallExpr) {
                    return this.checkCallExpression((GoCallExpr)expression);
                }
                if (expression instanceof GoBinaryExpr) {
                    return this.checkBinaryExpression((GoBinaryExpr)expression);
                }
                return false;
            }

            private boolean checkAccessToDataField(@NotNull GoReferenceExpression referenceExpression) {
                GoTypeOwner typeOwner;
                if (referenceExpression == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((typeOwner = (GoTypeOwner)ObjectUtils.tryCast((Object)referenceExpression.getQualifier(), GoTypeOwner.class)) == null || !referenceExpression.getIdentifier().textMatches((CharSequence)"Data")) {
                    return false;
                }
                GoPointerType qualifierType = (GoPointerType)ObjectUtils.tryCast((Object)typeOwner.getGoType(null), GoPointerType.class);
                return qualifierType != null && 1.checkTypeSpecNameAndReflectPackage(qualifierType.getType(), referenceExpression, GoVetUnsafePointerInspection.STRING_HEADER_TYPE_NAME, GoVetUnsafePointerInspection.SLICE_HEADER_TYPE_NAME);
            }

            private boolean checkCallExpression(@NotNull GoCallExpr call) {
                List<GoExpression> argumentExpressions;
                if (call == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ((argumentExpressions = call.getArgumentList().getExpressionList()).isEmpty()) {
                    return this.isCallToPointerOrUnsafeAddrMethod(call);
                }
                if (argumentExpressions.size() == 1) {
                    return 1.isCallConversionOfUintptrToUnsafePointer(call, argumentExpressions.get(0));
                }
                return false;
            }

            private boolean checkBinaryExpression(@NotNull GoBinaryExpr expression) {
                PsiElement operator;
                if (expression == null) {
                    1.$$$reportNull$$$0(4);
                }
                if ((operator = expression.getOperator()) == null) {
                    return false;
                }
                IElementType operatorType = operator.getNode().getElementType();
                if (!(GoTypes.PLUS.equals(operatorType) || GoTypes.MINUS.equals(operatorType) || GoTypes.BIT_CLEAR.equals(operatorType))) {
                    return false;
                }
                GoExpression right = expression.getRight();
                return right != null && this.isSafeUintptrExpression(expression.getLeft()) && !this.isSafeUintptrExpression(right);
            }

            private static boolean isCallConversionOfUintptrToUnsafePointer(@NotNull GoCallExpr call, @NotNull GoExpression argumentExpression) {
                GoType argumentType;
                if (call == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (argumentExpression == null) {
                    1.$$$reportNull$$$0(6);
                }
                return (argumentType = argumentExpression.getGoType(null)) != null && GoTypeUtil.isUintptr(call.getExpression().getGoUnderlyingType(null), call) && GoTypeUtil.isUnsafePointerType(argumentType, call);
            }

            private boolean isCallToPointerOrUnsafeAddrMethod(@NotNull GoCallExpr call) {
                GoReferenceExpression referenceExpression;
                if (call == null) {
                    1.$$$reportNull$$$0(7);
                }
                if ((referenceExpression = (GoReferenceExpression)ObjectUtils.tryCast((Object)call.getExpression(), GoReferenceExpression.class)) == null) {
                    return false;
                }
                String callName = referenceExpression.getIdentifier().getText();
                if (!GoVetUnsafePointerInspection.POINTER_METHOD_NAME.equals(callName) && !GoVetUnsafePointerInspection.UNSAFE_ADDR_METHOD_NAME.equals(callName)) {
                    return false;
                }
                GoTypeOwner typeOwner = (GoTypeOwner)ObjectUtils.tryCast((Object)referenceExpression.getQualifier(), GoTypeOwner.class);
                return typeOwner != null && 1.checkTypeSpecNameAndReflectPackage(typeOwner.getGoType(null), call, GoVetUnsafePointerInspection.VALUE_TYPE_NAME);
            }

            private static boolean checkTypeSpecNameAndReflectPackage(@Nullable GoType type, @NotNull GoExpression contextExpression, String ... names) {
                if (contextExpression == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (names == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (type == null) {
                    return false;
                }
                GoTypeSpec typeSpec = (GoTypeSpec)ObjectUtils.tryCast((Object)type.resolve(contextExpression), GoTypeSpec.class);
                if (typeSpec == null) {
                    return false;
                }
                GoTypeSpecStub typeSpecStub = (GoTypeSpecStub)typeSpec.getStub();
                return GoPsiImplUtil.hasSameNameAndPackage((PsiFile)typeSpec.getContainingFile(), GoVetUnsafePointerInspection.REFLECT_PACKAGE_NAME, GoVetUnsafePointerInspection.VALUE_FILE_NAME) && ArrayUtil.contains((String)(typeSpecStub != null ? typeSpecStub.getName() : typeSpec.getIdentifier().getText()), (String[])names);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "referenceExpression";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "argumentExpression";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "contextExpression";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "names";
                        break;
                    }
                }
                objectArray2[1] = "com/goide/inspections/vet/GoVetUnsafePointerInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCallExpr";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSafeUintptrExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkAccessToDataField";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkCallExpression";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkBinaryExpression";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isCallConversionOfUintptrToUnsafePointer";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isCallToPointerOrUnsafeAddrMethod";
                        break;
                    }
                    case 8: 
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkTypeSpecNameAndReflectPackage";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/goide/inspections/vet/GoVetUnsafePointerInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

