/*
 * Decompiled with CFR 0.152.
 */
package com.goide.intentions;

import com.goide.i18n.GoBundle;
import com.goide.intentions.GoBaseIntentionAction;
import com.goide.intentions.generate.constructor.GoMemberChooser;
import com.goide.intentions.generate.constructor.GoMemberChooserNode;
import com.goide.psi.GoFieldDeclaration;
import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoFile;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoStructType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.refactor.template.GoTemplate;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class GoCreateFieldAccessorIntention
extends GoBaseIntentionAction {
    protected static final String RECEIVER_TYPE_VARIABLE = "RECEIVER_TYPE";
    protected static final String RECEIVER_NAME_VARIABLE = "RECEIVER_NAME";

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            GoCreateFieldAccessorIntention.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GoCreateFieldAccessorIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            GoCreateFieldAccessorIntention.$$$reportNull$$$0(2);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        GoTypeSpec typeSpec = GoCreateFieldAccessorIntention.getTopLevelStructTypeSpec(element);
        if (typeSpec == null) {
            return false;
        }
        GoStructType struct = Objects.requireNonNull((GoStructType)typeSpec.getSpecType().getType());
        Set<String> methods = typeSpec.getAllMethods().stream().map(it -> it.getName()).filter(Objects::nonNull).collect(Collectors.toSet());
        for (GoNamedElement field : struct.getFieldDefinitions()) {
            FieldInfo fieldInfo;
            if (!(field instanceof GoFieldDefinition) || field.isPublic() || field.isBlank() || (fieldInfo = GoCreateFieldAccessorIntention.getFieldInfo((GoFieldDefinition)field)) == null || !this.canGenerateAccessor(methods, fieldInfo)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            GoCreateFieldAccessorIntention.$$$reportNull$$$0(3);
        }
        return currentFile;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected boolean isAvailableInCodeFragment() {
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        Set<String> methods;
        GoTypeSpec typeSpec;
        if (project == null) {
            GoCreateFieldAccessorIntention.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            GoCreateFieldAccessorIntention.$$$reportNull$$$0(5);
        }
        if (element == null) {
            GoCreateFieldAccessorIntention.$$$reportNull$$$0(6);
        }
        if ((typeSpec = GoCreateFieldAccessorIntention.getTopLevelStructTypeSpec(element)) == null) {
            return;
        }
        GoStructType struct = Objects.requireNonNull((GoStructType)typeSpec.getSpecType().getType());
        List<GoFieldDefinition> selectedFields = this.selectFields(editor, element, struct, methods = typeSpec.getAllMethods().stream().map(it -> it.getName()).filter(Objects::nonNull).collect(Collectors.toSet()));
        if (selectedFields.isEmpty()) {
            return;
        }
        boolean primary = true;
        GoTemplate template = new GoTemplate((GoFile)element.getContainingFile());
        for (GoFieldDefinition field : selectedFields) {
            if (!primary) {
                template.addTextSegment("\n\n");
            }
            FieldInfo fieldInfo = Objects.requireNonNull(GoCreateFieldAccessorIntention.getFieldInfo(field));
            this.generateAccessor(template, methods, fieldInfo, typeSpec, primary);
            primary = false;
        }
        GoTypeDeclaration typeDeclaration = Objects.requireNonNull((GoTypeDeclaration)PsiTreeUtil.getParentOfType((PsiElement)typeSpec, GoTypeDeclaration.class));
        WriteAction.run(() -> template.startTemplate(editor, typeDeclaration.getTextRange().getEndOffset(), GoBundle.message((String)"go.intention.create.field.getter.and.setter.command.name", (Object[])new Object[0]), null));
    }

    @NotNull
    private @Unmodifiable List<GoFieldDefinition> selectFields(@NotNull Editor editor, @NotNull PsiElement at, @NotNull GoStructType struct, @NotNull Set<String> methods) {
        GoFieldDeclaration fieldDecl;
        TextRange range;
        if (editor == null) {
            GoCreateFieldAccessorIntention.$$$reportNull$$$0(7);
        }
        if (at == null) {
            GoCreateFieldAccessorIntention.$$$reportNull$$$0(8);
        }
        if (struct == null) {
            GoCreateFieldAccessorIntention.$$$reportNull$$$0(9);
        }
        if (methods == null) {
            GoCreateFieldAccessorIntention.$$$reportNull$$$0(10);
        }
        TextRange textRange = range = editor.getSelectionModel().hasSelection() ? new TextRange(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd()) : null;
        if (range == null && (fieldDecl = (GoFieldDeclaration)PsiTreeUtil.getParentOfType((PsiElement)at, GoFieldDeclaration.class)) != null) {
            range = fieldDecl.getTextRange();
        }
        ArrayList<GoFieldDefinition> fields = new ArrayList<GoFieldDefinition>();
        ArrayList<GoMemberChooserNode> fieldNodes = new ArrayList<GoMemberChooserNode>();
        ArrayList<GoMemberChooserNode> nodesToSelect = new ArrayList<GoMemberChooserNode>();
        for (GoFieldDeclaration fieldDecl2 : struct.getFieldDeclarationList()) {
            boolean select = range != null && (range.contains(fieldDecl2.getTextRange().getStartOffset()) || range.contains(fieldDecl2.getTextRange().getEndOffset()));
            for (GoFieldDefinition field : fieldDecl2.getFieldDefinitionList()) {
                FieldInfo fieldInfo = GoCreateFieldAccessorIntention.getFieldInfo(field);
                if (fieldInfo == null || !this.canGenerateAccessor(methods, fieldInfo)) continue;
                fields.add(field);
                GoMemberChooserNode node = new GoMemberChooserNode(field);
                fieldNodes.add(node);
                if (!select) continue;
                nodesToSelect.add(node);
            }
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            GoFieldDeclaration fieldDecl3 = (GoFieldDeclaration)PsiTreeUtil.getParentOfType((PsiElement)at, GoFieldDeclaration.class);
            if (fieldDecl3 != null) {
                List list = ContainerUtil.filter(fields, it -> fieldDecl3.getFieldDefinitionList().contains(it));
                if (list == null) {
                    GoCreateFieldAccessorIntention.$$$reportNull$$$0(11);
                }
                return list;
            }
            ArrayList<GoFieldDefinition> arrayList = fields;
            if (arrayList == null) {
                GoCreateFieldAccessorIntention.$$$reportNull$$$0(12);
            }
            return arrayList;
        }
        GoMemberChooser chooser = new GoMemberChooser(fieldNodes.toArray(new GoMemberChooserNode[0]), struct.getProject(), new JComponent[0], false);
        chooser.setTitle(GoBundle.message((String)"go.intention.select.fields.dialog.title", (Object[])new Object[0]));
        chooser.selectElements(nodesToSelect.toArray(ClassMember.EMPTY_ARRAY));
        if (!chooser.showAndGet()) {
            List<GoFieldDefinition> list = Collections.emptyList();
            if (list == null) {
                GoCreateFieldAccessorIntention.$$$reportNull$$$0(13);
            }
            return list;
        }
        List list = ContainerUtil.map(chooser.getSelectedElements(), it -> (GoFieldDefinition)it.getPsiElement());
        if (list == null) {
            GoCreateFieldAccessorIntention.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Nullable
    static FieldInfo getFieldInfo(@NotNull GoFieldDefinition fieldDefinition) {
        GoType goType;
        String fieldName;
        if (fieldDefinition == null) {
            GoCreateFieldAccessorIntention.$$$reportNull$$$0(15);
        }
        if (StringUtil.isEmpty((String)(fieldName = fieldDefinition.getName()))) {
            return null;
        }
        PsiElement psiElement = fieldDefinition.getParent();
        if (psiElement instanceof GoFieldDeclaration) {
            GoFieldDeclaration decl = (GoFieldDeclaration)psiElement;
            goType = decl.getType();
        } else {
            goType = null;
        }
        GoType fieldType = goType;
        return fieldType != null ? new FieldInfo(fieldName, fieldType) : null;
    }

    protected abstract boolean canGenerateAccessor(@NotNull Set<String> var1, @NotNull FieldInfo var2);

    protected abstract void generateAccessor(@NotNull GoTemplate var1, @NotNull Set<String> var2, @NotNull FieldInfo var3, @NotNull GoTypeSpec var4, boolean var5);

    @Nullable
    private static GoTypeSpec getTopLevelStructTypeSpec(@Nullable PsiElement element) {
        GoStructType struct = (GoStructType)PsiTreeUtil.getParentOfType((PsiElement)element, GoStructType.class);
        GoSpecType specType = (GoSpecType)ObjectUtils.tryCast((Object)(struct != null ? struct.getParent() : null), GoSpecType.class);
        GoTypeSpec typeSpec = (GoTypeSpec)ObjectUtils.tryCast((Object)(specType != null ? specType.getParent() : null), GoTypeSpec.class);
        GoTypeDeclaration typeDecl = (GoTypeDeclaration)PsiTreeUtil.getParentOfType((PsiElement)typeSpec, GoTypeDeclaration.class);
        return typeDecl != null && GoPsiUtil.isTopLevelDeclaration(typeDecl) ? typeSpec : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "at";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "struct";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/intentions/GoCreateFieldAccessorIntention";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldDefinition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/intentions/GoCreateFieldAccessorIntention";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "selectFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "selectFields";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFieldInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 13, 14 -> new IllegalStateException(string);
        };
    }

    protected static final class FieldInfo {
        private final String fieldName;
        private final String getterName;
        private final String setterName;
        private final GoType fieldType;

        private FieldInfo(@NotNull String fieldName, @NotNull GoType fieldType) {
            if (fieldName == null) {
                FieldInfo.$$$reportNull$$$0(0);
            }
            if (fieldType == null) {
                FieldInfo.$$$reportNull$$$0(1);
            }
            if (fieldName.isEmpty()) {
                throw new IllegalArgumentException("field name cannot be empty");
            }
            this.fieldName = fieldName;
            this.getterName = StringUtil.capitalize((String)fieldName);
            this.setterName = "Set" + this.getterName;
            this.fieldType = fieldType;
        }

        @NotNull
        public String getFieldName() {
            String string = this.fieldName;
            if (string == null) {
                FieldInfo.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getGetterName() {
            String string = this.getterName;
            if (string == null) {
                FieldInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getSetterName() {
            String string = this.setterName;
            if (string == null) {
                FieldInfo.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public GoType getFieldType() {
            GoType goType = this.fieldType;
            if (goType == null) {
                FieldInfo.$$$reportNull$$$0(5);
            }
            return goType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldType";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/intentions/GoCreateFieldAccessorIntention$FieldInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/intentions/GoCreateFieldAccessorIntention$FieldInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGetterName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSetterName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

