/*
 * Decompiled with CFR 0.152.
 */
package com.goide.intentions.ifstatement;

import com.goide.formatter.GoFormatterUtil;
import com.goide.i18n.GoBundle;
import com.goide.intentions.GoBaseIntentionAction;
import com.goide.intentions.negate.GoBooleanExpressionUtil;
import com.goide.psi.GoBlock;
import com.goide.psi.GoElseStatement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoIfStatement;
import com.goide.psi.GoStatement;
import com.goide.psi.impl.GoElementFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoInvertIfIntention
extends GoBaseIntentionAction {
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            GoInvertIfIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = GoBundle.message((String)"go.intention.invert.if.name", (Object[])new Object[0]);
        if (string == null) {
            GoInvertIfIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        GoIfStatement ifStatement;
        if (project == null) {
            GoInvertIfIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            GoInvertIfIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            GoInvertIfIntention.$$$reportNull$$$0(4);
        }
        if ((ifStatement = GoInvertIfIntention.getParentIfStatement(element)) == null) {
            return false;
        }
        GoBlock ifBlock = ifStatement.getBlock();
        GoElseStatement elseStatement = ifStatement.getElseStatement();
        return ifBlock != null && elseStatement != null && (elseStatement.getBlock() != null || elseStatement.getIfStatement() != null) && ifStatement.getCondition() != null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        GoIfStatement ifStatement;
        if (project == null) {
            GoInvertIfIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            GoInvertIfIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            GoInvertIfIntention.$$$reportNull$$$0(7);
        }
        if ((ifStatement = GoInvertIfIntention.getParentIfStatement(element)) == null) {
            return;
        }
        GoBlock ifBlock = ifStatement.getBlock();
        String elseBranch = GoInvertIfIntention.elseBranchText(ifStatement.getElseStatement());
        if (ifBlock == null || elseBranch == null) {
            return;
        }
        GoExpression condition = ifStatement.getCondition();
        if (condition == null) {
            return;
        }
        GoInvertIfIntention.invert(project, ifStatement, condition, ifBlock, elseBranch);
    }

    @Nullable
    private static GoIfStatement getParentIfStatement(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            GoInvertIfIntention.$$$reportNull$$$0(8);
        }
        if ((parent = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GoStatement.class, GoBlock.class})) == null || parent instanceof GoBlock) {
            return null;
        }
        return parent instanceof GoIfStatement ? (GoIfStatement)parent : (GoIfStatement)ObjectUtils.tryCast((Object)parent.getParent(), GoIfStatement.class);
    }

    private static void invert(@NotNull Project project, @NotNull GoIfStatement ifStatement, @NotNull GoExpression condition, @NotNull GoBlock ifBlock, @NotNull String elseBranch) {
        GoStatement simpleStatement;
        if (project == null) {
            GoInvertIfIntention.$$$reportNull$$$0(9);
        }
        if (ifStatement == null) {
            GoInvertIfIntention.$$$reportNull$$$0(10);
        }
        if (condition == null) {
            GoInvertIfIntention.$$$reportNull$$$0(11);
        }
        if (ifBlock == null) {
            GoInvertIfIntention.$$$reportNull$$$0(12);
        }
        if (elseBranch == null) {
            GoInvertIfIntention.$$$reportNull$$$0(13);
        }
        String simpleStatementText = (simpleStatement = ifStatement.getInitStatement()) != null ? simpleStatement.getText() + "; " : "";
        GoExpression negated = GoBooleanExpressionUtil.negate(condition, false);
        String conditionText = simpleStatementText + negated.getText();
        List<GoStatement> ifBlockStatements = ifBlock.getStatementList();
        if (ifBlockStatements.size() == 1 && ifBlockStatements.get(0) instanceof GoIfStatement) {
            String newElseIfBranch = "else " + ifBlockStatements.get(0).getText();
            GoIfStatement inverted = GoElementFactory.createIfElseIfStatement(project, conditionText, elseBranch, newElseIfBranch);
            GoFormatterUtil.reformat(ifStatement.replace(inverted));
        } else {
            String ifBranch = GoInvertIfIntention.blockText(ifBlock);
            GoIfStatement inverted = GoElementFactory.createIfStatement(project, conditionText, elseBranch, ifBranch);
            GoFormatterUtil.reformat(ifStatement.replace(inverted));
        }
    }

    @Nullable
    private static String elseBranchText(@Nullable GoElseStatement elseStatement) {
        if (elseStatement == null) {
            return null;
        }
        if (elseStatement.getIfStatement() != null) {
            return elseStatement.getIfStatement().getText();
        }
        return GoInvertIfIntention.blockText(elseStatement.getBlock());
    }

    @Contract(value="null -> null; !null -> !null")
    private static String blockText(GoBlock block) {
        if (block == null) {
            return null;
        }
        String text = block.getText();
        return StringUtil.trim((String)StringUtil.trimEnd((String)StringUtil.trimStart((String)text, (String)"{"), (String)"}"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/intentions/ifstatement/GoInvertIfIntention";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifBlock";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elseBranch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/intentions/ifstatement/GoInvertIfIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getParentIfStatement";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "invert";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13 -> new IllegalArgumentException(string);
        };
    }
}

