/*
 * Decompiled with CFR 0.152.
 */
package com.goide.microservices.endpoints;

import com.goide.microservices.endpoints.GoEndpointData;
import com.goide.microservices.endpoints.GoEndpointUtilsKt;
import com.goide.psi.GoExpression;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.url.references.UrlPathContextKt;
import com.intellij.microservices.url.references.UrlPksParser;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PartiallyKnownString;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B9\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lcom/goide/microservices/endpoints/GoUrlTargetInfo;", "Lcom/intellij/microservices/url/UrlTargetInfo;", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/goide/psi/GoExpression;", "path", "Lcom/intellij/microservices/url/UrlPath;", "methods", "", "", "authorities", "", "Lcom/intellij/microservices/url/Authority;", "<init>", "(Lcom/intellij/psi/SmartPsiElementPointer;Lcom/intellij/microservices/url/UrlPath;Ljava/util/Set;Ljava/util/List;)V", "getPath", "()Lcom/intellij/microservices/url/UrlPath;", "getMethods", "()Ljava/util/Set;", "getAuthorities", "()Ljava/util/List;", "schemes", "getSchemes", "resolveToPsiElement", "Lcom/intellij/psi/PsiElement;", "Companion", "intellij.go.microservices"})
public final class GoUrlTargetInfo
implements UrlTargetInfo {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final SmartPsiElementPointer<GoExpression> pointer;
    @NotNull
    private final UrlPath path;
    @NotNull
    private final Set<String> methods;
    @NotNull
    private final List<Authority> authorities;
    @NotNull
    private final List<String> schemes;
    @NotNull
    private static final UrlPksParser urlPksParser;

    public GoUrlTargetInfo(@NotNull SmartPsiElementPointer<GoExpression> pointer, @NotNull UrlPath path, @NotNull Set<String> methods, @NotNull List<? extends Authority> authorities) {
        Intrinsics.checkNotNullParameter(pointer, (String)"pointer");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(methods, (String)"methods");
        Intrinsics.checkNotNullParameter(authorities, (String)"authorities");
        this.pointer = pointer;
        this.path = path;
        this.methods = methods;
        this.authorities = authorities;
        this.schemes = UrlConstants.HTTP_SCHEMES;
    }

    @NotNull
    public UrlPath getPath() {
        return this.path;
    }

    @NotNull
    public Set<String> getMethods() {
        return this.methods;
    }

    @NotNull
    public List<Authority> getAuthorities() {
        return this.authorities;
    }

    @NotNull
    public List<String> getSchemes() {
        return this.schemes;
    }

    @Nullable
    public PsiElement resolveToPsiElement() {
        return this.pointer.getElement();
    }

    static {
        UrlPksParser urlPksParser;
        Companion = new Companion(null);
        UrlPksParser $this$urlPksParser_u24lambda_u240 = urlPksParser = new UrlPksParser(null, null, false, 3, null);
        boolean bl = false;
        $this$urlPksParser_u24lambda_u240.setShouldHaveScheme(false);
        GoUrlTargetInfo.urlPksParser = urlPksParser;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/goide/microservices/endpoints/GoUrlTargetInfo$Companion;", "", "<init>", "()V", "urlPksParser", "Lcom/intellij/microservices/url/references/UrlPksParser;", "from", "Lcom/goide/microservices/endpoints/GoUrlTargetInfo;", "endpoint", "Lcom/goide/microservices/endpoints/GoEndpointData;", "parseUrlPath", "Lcom/intellij/microservices/url/UrlPath;", "path", "", "intellij.go.microservices"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GoUrlTargetInfo from(@NotNull GoEndpointData endpoint) {
            Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
            UrlPath urlPath = this.parseUrlPath(endpoint.getUrl());
            GoExpression goExpression = endpoint.getSourcePsi();
            return new GoUrlTargetInfo(endpoint.getPointer(), urlPath, CollectionsKt.toSet((Iterable)endpoint.getHttpMethods()), GoEndpointUtilsKt.getOrComputeAuthorities((PsiFile)(goExpression != null ? goExpression.getContainingFile() : null)));
        }

        private final UrlPath parseUrlPath(String path) {
            String string;
            block3: {
                block2: {
                    string = path;
                    if (string == null) break block2;
                    String $this$parseUrlPath_u24lambda_u240 = string;
                    boolean bl = false;
                    PartiallyKnownString sourceString = new PartiallyKnownString($this$parseUrlPath_u24lambda_u240);
                    UrlPath urlPath = UrlPathContextKt.chopLeadingEmptyBlock((UrlPath)urlPksParser.parseUrlPath(sourceString).getUrlPath());
                    string = urlPath;
                    if (urlPath != null) break block3;
                }
                string = UrlPath.Companion.getEMPTY();
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

