/*
 * Decompiled with CFR 0.152.
 */
package com.goide.microservices.parsing;

import com.goide.microservices.declarations.HttpMethodResolution;
import com.goide.microservices.parsing.GoEndpoint;
import com.goide.microservices.parsing.GoEndpointParserKt;
import com.goide.psi.GoArgumentList;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.impl.GoPsiUtil;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010\u0006\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0006\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u000fH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/goide/microservices/parsing/GoEndpointParser;", "", "<init>", "()V", "parse", "Lcom/goide/microservices/parsing/GoEndpoint;", "declaration", "Lcom/goide/psi/GoStringLiteral;", "httpMethodResolution", "Lcom/goide/microservices/declarations/HttpMethodResolution;", "parseUrlPattern", "parseWithHttpMethodAsArgument", "argumentIndex", "", "extractHttpMethod", "", "Lcom/intellij/psi/PsiElement;", "parseWithChainedHttpMethod", "methodName", "findHttpMethods", "", "httpMethodFunction", "findHttpMethodCallExpr", "Lcom/goide/psi/GoCallExpr;", "intellij.go.microservices"})
@SourceDebugExtension(value={"SMAP\nGoEndpointParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoEndpointParser.kt\ncom/goide/microservices/parsing/GoEndpointParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,122:1\n1#2:123\n1#2:134\n1611#3,9:124\n1863#3:133\n1864#3:135\n1620#3:136\n1557#3:137\n1628#3,3:138\n774#3:141\n865#3,2:142\n19#4:144\n*S KotlinDebug\n*F\n+ 1 GoEndpointParser.kt\ncom/goide/microservices/parsing/GoEndpointParser\n*L\n98#1:134\n98#1:124,9\n98#1:133\n98#1:135\n98#1:136\n99#1:137\n99#1:138,3\n100#1:141\n100#1:142,2\n107#1:144\n*E\n"})
public final class GoEndpointParser {
    @NotNull
    public static final GoEndpointParser INSTANCE = new GoEndpointParser();

    private GoEndpointParser() {
    }

    @NotNull
    public final GoEndpoint parse(@NotNull GoStringLiteral declaration, @NotNull HttpMethodResolution httpMethodResolution) {
        GoEndpoint goEndpoint;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)httpMethodResolution, (String)"httpMethodResolution");
        HttpMethodResolution httpMethodResolution2 = httpMethodResolution;
        if (httpMethodResolution2 instanceof HttpMethodResolution.Unresolved) {
            goEndpoint = new GoEndpoint(null, ElementManipulators.getValueText((PsiElement)declaration), 1, null);
        } else if (httpMethodResolution2 instanceof HttpMethodResolution.Static) {
            goEndpoint = new GoEndpoint(((HttpMethodResolution.Static)httpMethodResolution).getHttpMethod(), ElementManipulators.getValueText((PsiElement)declaration));
        } else if (httpMethodResolution2 instanceof HttpMethodResolution.FromUrlPattern) {
            goEndpoint = this.parseUrlPattern(declaration);
        } else if (httpMethodResolution2 instanceof HttpMethodResolution.FromArgument) {
            goEndpoint = this.parseWithHttpMethodAsArgument(declaration, ((HttpMethodResolution.FromArgument)httpMethodResolution).getIndex());
        } else if (httpMethodResolution2 instanceof HttpMethodResolution.FromChainedMethod) {
            goEndpoint = this.parseWithChainedHttpMethod(declaration, ((HttpMethodResolution.FromChainedMethod)httpMethodResolution).getMethodName());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return goEndpoint;
    }

    private final GoEndpoint parseUrlPattern(GoStringLiteral declaration) {
        String string;
        String string2 = ElementManipulators.getValueText((PsiElement)declaration);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValueText(...)");
        String pattern = string2;
        char[] cArray = new char[]{' ', '\t'};
        int separatorIndex = StringsKt.indexOfAny$default((CharSequence)pattern, (char[])cArray, (int)0, (boolean)false, (int)6, null);
        if (separatorIndex < 0) {
            return new GoEndpoint(null, pattern, 1, null);
        }
        String string3 = StringsKt.take((String)pattern, (int)separatorIndex).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
        String it = string = string3;
        boolean bl = false;
        String httpMethod = UrlConstants.HTTP_METHODS.contains(it) ? string : null;
        String string4 = pattern.substring(separatorIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        char[] cArray2 = new char[]{' ', '\t'};
        String rest = StringsKt.trimStart((String)string4, (char[])cArray2);
        return new GoEndpoint(httpMethod, rest);
    }

    private final GoEndpoint parseWithHttpMethodAsArgument(GoStringLiteral declaration, int argumentIndex) {
        return new GoEndpoint(this.extractHttpMethod(declaration, argumentIndex), ElementManipulators.getValueText((PsiElement)declaration));
    }

    private final String extractHttpMethod(PsiElement declaration, int argumentIndex) {
        String string;
        GoCallExpr callExpr = (GoCallExpr)PsiTreeUtil.getParentOfType((PsiElement)declaration, GoCallExpr.class);
        GoCompositeElement goCompositeElement = callExpr;
        if (goCompositeElement == null || (goCompositeElement = goCompositeElement.getArgumentList()) == null) {
            return null;
        }
        GoCompositeElement argumentList = goCompositeElement;
        List<? extends PsiElement> list = GoPsiUtil.getArguments((GoArgumentList)argumentList);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getArguments(...)");
        List<? extends PsiElement> arguments = list;
        if (!(0 <= argumentIndex ? argumentIndex < ((Collection)arguments).size() : false)) {
            return null;
        }
        PsiElement argument = arguments.get(argumentIndex);
        Intrinsics.checkNotNull((Object)argument);
        String string2 = GoEndpointParserKt.access$resolveTextValue(argument);
        if (string2 == null) {
            return null;
        }
        String method = string2;
        String string3 = method.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
        String it = string = string3;
        boolean bl = false;
        return UrlConstants.HTTP_METHODS.contains(it) ? string : null;
    }

    private final GoEndpoint parseWithChainedHttpMethod(GoStringLiteral declaration, String methodName) {
        return new GoEndpoint(this.findHttpMethods(declaration, methodName), ElementManipulators.getValueText((PsiElement)declaration));
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> findHttpMethods(PsiElement declaration, String httpMethodFunction) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        GoCallExpr httpMethodCall = this.findHttpMethodCallExpr(declaration, httpMethodFunction);
        GoCompositeElement goCompositeElement = httpMethodCall;
        if (goCompositeElement == null || (goCompositeElement = goCompositeElement.getArgumentList()) == null) {
            return CollectionsKt.emptyList();
        }
        GoCompositeElement argumentList = goCompositeElement;
        List<? extends PsiElement> list = GoPsiUtil.getArguments((GoArgumentList)argumentList);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getArguments(...)");
        Iterable iterable = list;
        boolean $i$f$mapNotNull = false;
        void var7_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            PsiElement it2 = (PsiElement)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it2);
            if (GoEndpointParserKt.access$resolveTextValue(it2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            object = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            collection.add(string);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!UrlConstants.HTTP_METHODS.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final GoCallExpr findHttpMethodCallExpr(PsiElement declaration, String httpMethodFunction) {
        PsiElement ref;
        PsiElement psiElement = ref = PsiTreeUtil.findFirstParent((PsiElement)declaration, arg_0 -> GoEndpointParser.findHttpMethodCallExpr$lambda$6(arg_0 -> GoEndpointParser.findHttpMethodCallExpr$lambda$5(httpMethodFunction, arg_0), arg_0));
        PsiElement $this$asSafely$iv = psiElement != null ? psiElement.getParent() : null;
        boolean $i$f$asSafely = false;
        PsiElement psiElement2 = $this$asSafely$iv;
        if (!(psiElement2 instanceof GoCallExpr)) {
            psiElement2 = null;
        }
        return (GoCallExpr)psiElement2;
    }

    private static final boolean findHttpMethodCallExpr$lambda$5(String $httpMethodFunction, PsiElement it) {
        return it instanceof GoReferenceExpression && Intrinsics.areEqual((Object)((GoReferenceExpression)it).getIdentifier().getText(), (Object)$httpMethodFunction);
    }

    private static final boolean findHttpMethodCallExpr$lambda$6(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

