/*
 * Decompiled with CFR 0.152.
 */
package com.goide.profiler;

import com.goide.dlv.DlvFunc;
import com.goide.dlv.DlvPackagePath;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.sdk.GoPackageUtil;
import com.goide.sdk.GoSdkUtil;
import com.goide.stubs.index.GoFunctionIndex;
import com.goide.stubs.index.GoMethodIndex;
import com.goide.vendor.GoVendoringUtil;
import com.google.perftools.profiles.ProfileProto;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profiler.CallTreeBuilder;
import com.intellij.profiler.DummyCallTreeBuilder;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.CallTreeBuildingData;
import com.intellij.profiler.api.DefaultMetric;
import com.intellij.profiler.api.Failure;
import com.intellij.profiler.api.MultipleCallTreesProfilerData;
import com.intellij.profiler.api.ProfilerData;
import com.intellij.profiler.api.ProfilerDumpFileParser;
import com.intellij.profiler.api.ProfilerDumpFileParsingResult;
import com.intellij.profiler.api.ProfilerDumpParserProvider;
import com.intellij.profiler.api.Success;
import com.intellij.profiler.api.ValueMetric;
import com.intellij.profiler.model.NoThreadInfoInProfilerData;
import com.intellij.profiler.model.ThreadInfo;
import com.intellij.profiler.ui.BaseCallStackElementRenderer;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PprofParserProvider
implements ProfilerDumpParserProvider {
    @NotNull
    public String getId() {
        return "pprof";
    }

    @NotNull
    public String getName() {
        return "pprof";
    }

    @Nullable
    public String getRequiredFileExtension() {
        return null;
    }

    @NotNull
    public ProfilerDumpFileParser createParser(@Nullable Project project) {
        return new PprofFileParser();
    }

    @Nullable
    private static GoSymbol parseSymbol(@NotNull String fullName) {
        DlvFunc dlvFunc;
        if (fullName == null) {
            PprofParserProvider.$$$reportNull$$$0(0);
        }
        if ((dlvFunc = DlvFunc.parse(fullName)) == null) {
            return null;
        }
        DlvPackagePath dlvPackagePath = dlvFunc.getDlvPackagePath();
        Object packagePath = dlvPackagePath.isTestPackage() ? dlvPackagePath.getPackagePath() + "_test" : dlvPackagePath.getPackagePath();
        String name = dlvFunc.getName();
        int lastDot = name.lastIndexOf(46);
        return lastDot == -1 ? new GoSymbol((String)packagePath, null, name) : new GoSymbol((String)packagePath, name.substring(0, lastDot), name.substring(lastDot + 1));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullName", "com/goide/profiler/PprofParserProvider", "parseSymbol"));
    }

    private static class PprofFileParser
    implements ProfilerDumpFileParser {
        private PprofFileParser() {
        }

        @Nullable
        public String getHelpId() {
            return null;
        }

        @NotNull
        public ProfilerDumpFileParsingResult parse(@NotNull File file, @NotNull ProgressIndicator indicator) {
            ProfileProto.Profile profile;
            if (file == null) {
                PprofFileParser.$$$reportNull$$$0(0);
            }
            if (indicator == null) {
                PprofFileParser.$$$reportNull$$$0(1);
            }
            try {
                profile = PprofFileParser.parseProfile(file.getAbsolutePath());
            }
            catch (EOFException e) {
                String message = file.length() == 0L ? GoBundle.message((String)"go.profiler.parse.error.empty", (Object[])new Object[0]) : GoBundle.message((String)"go.profiler.parse.error.eof", (Object[])new Object[0]);
                return new Failure(GoBundle.message((String)"go.profiler.parse.error", (Object[])new Object[]{message}));
            }
            catch (IOException e) {
                @NlsSafe String name = e.getClass().getName();
                return new Failure(GoBundle.message((String)"go.profiler.parse.error", (Object[])new Object[]{ObjectUtils.notNull((Object)e.getMessage(), (Object)name)}));
            }
            if (profile == null) {
                return new Failure(GoBundle.message((String)"go.profiler.not.a.pprof.profile.error", (Object[])new Object[0]));
            }
            Long2ObjectOpenHashMap locations = new Long2ObjectOpenHashMap(profile.getLocationCount());
            for (ProfileProto.Location location : profile.getLocationList()) {
                locations.put(location.getId(), (Object)location);
            }
            indicator.checkCanceled();
            Long2ObjectOpenHashMap functions = new Long2ObjectOpenHashMap(profile.getFunctionCount());
            for (ProfileProto.Function function : profile.getFunctionList()) {
                functions.put(function.getId(), (Object)function);
            }
            indicator.checkCanceled();
            ArrayList<DummyCallTreeBuilder> arrayList = new ArrayList<DummyCallTreeBuilder>();
            for (ProfileProto.ValueType valueType : profile.getSampleTypeList()) {
                DummyCallTreeBuilder builder2 = new DummyCallTreeBuilder();
                DefaultMetric metric = PprofFileParser.getMetric(profile, valueType);
                builder2.setMetric((ValueMetric)metric);
                arrayList.add(builder2);
            }
            int n = profile.getSampleTypeCount();
            for (ProfileProto.Sample sample : profile.getSampleList()) {
                ArrayList<PperfCallStackElement> stack = new ArrayList<PperfCallStackElement>(sample.getLocationIdCount());
                for (Long locationId : sample.getLocationIdList()) {
                    ProfileProto.Location location = (ProfileProto.Location)locations.get(locationId.longValue());
                    if (location == null) continue;
                    for (ProfileProto.Line line : location.getLineList()) {
                        ProfileProto.Function function = (ProfileProto.Function)functions.get(line.getFunctionId());
                        if (function == null) continue;
                        String functionName = profile.getStringTable((int)function.getName());
                        stack.add(new PperfCallStackElement(function.getId(), functionName));
                    }
                }
                if (!stack.isEmpty()) {
                    if (sample.getValueCount() != n) {
                        throw new RuntimeException("Number of values in a sample doesn't match number of metrics");
                    }
                    for (int i = 0; i < sample.getValueCount(); ++i) {
                        long sampleValue = sample.getValue(i);
                        if (sampleValue <= 0L) continue;
                        ((DummyCallTreeBuilder)arrayList.get(i)).addStack((ThreadInfo)NoThreadInfoInProfilerData.INSTANCE, ContainerUtil.reverse(stack), sampleValue);
                    }
                }
                indicator.checkCanceled();
            }
            List list = ContainerUtil.map(arrayList, builder -> new CallTreeBuildingData(builder.getMetric().getName(), (BaseCallStackElementRenderer)new PprofRenderer(), (CallTreeBuilder)builder, null));
            return new Success((ProfilerData)new MultipleCallTreesProfilerData(list));
        }

        private static DefaultMetric getMetric(@NotNull ProfileProto.Profile profile, @NotNull ProfileProto.ValueType valueType) {
            String unit;
            TimeUnit timeUnit;
            if (profile == null) {
                PprofFileParser.$$$reportNull$$$0(2);
            }
            if (valueType == null) {
                PprofFileParser.$$$reportNull$$$0(3);
            }
            if ((timeUnit = PprofFileParser.getTimeUnit(unit = profile.getStringTable((int)valueType.getUnit()))) != null) {
                @NlsSafe String timeUnitString = timeUnit.toString();
                return new DefaultMetric(PprofFileParser.getMetricName(profile, valueType), timeUnitString);
            }
            return new DefaultMetric(PprofFileParser.getMetricName(profile, valueType), unit);
        }

        @Nullable
        private static TimeUnit getTimeUnit(@Nullable String unitName) {
            if (unitName == null) {
                return null;
            }
            try {
                return TimeUnit.valueOf(unitName.toUpperCase(Locale.US));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        @NotNull
        @Nls
        private static String getMetricName(@NotNull ProfileProto.Profile profile, @NotNull ProfileProto.ValueType valueType) {
            String name;
            if (profile == null) {
                PprofFileParser.$$$reportNull$$$0(4);
            }
            if (valueType == null) {
                PprofFileParser.$$$reportNull$$$0(5);
            }
            String string = switch (name = profile.getStringTable((int)valueType.getType())) {
                case "cpu" -> GoBundle.message((String)"go.profiler.cpu.time.metric.name", (Object[])new Object[0]);
                case "alloc_objects" -> GoBundle.message((String)"go.profiler.allocated.objects.metric.name", (Object[])new Object[0]);
                case "alloc_space" -> GoBundle.message((String)"go.profiler.allocated.space.metric.name", (Object[])new Object[0]);
                case "inuse_objects" -> GoBundle.message((String)"go.profiler.in.use.objects.metric.name", (Object[])new Object[0]);
                case "inuse_space" -> GoBundle.message((String)"go.profiler.in.use.space.metric.name", (Object[])new Object[0]);
                default -> StringUtil.capitalize((String)name);
            };
            if (string == null) {
                PprofFileParser.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Nullable
        private static ProfileProto.Profile parseProfile(@NotNull String path) throws IOException {
            if (path == null) {
                PprofFileParser.$$$reportNull$$$0(7);
            }
            try (GZIPInputStream stream = new GZIPInputStream(new FileInputStream(path));){
                ProfileProto.Profile profile = ProfileProto.Profile.parseFrom(stream);
                return profile;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profile";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueType";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/profiler/PprofParserProvider$PprofFileParser";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/profiler/PprofParserProvider$PprofFileParser";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetricName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "parse";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getMetric";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getMetricName";
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "parseProfile";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6 -> new IllegalStateException(string);
            };
        }
    }

    private static final class GoSymbol {
        private final String myImportPath;
        private final String myReceiver;
        private final String myFunctionName;

        private GoSymbol(@NotNull String importPath, @Nullable String receiver, @NotNull String functionName) {
            if (importPath == null) {
                GoSymbol.$$$reportNull$$$0(0);
            }
            if (functionName == null) {
                GoSymbol.$$$reportNull$$$0(1);
            }
            this.myImportPath = importPath;
            this.myReceiver = receiver;
            this.myFunctionName = functionName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "importPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "functionName";
                    break;
                }
            }
            objectArray[1] = "com/goide/profiler/PprofParserProvider$GoSymbol";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PperfCallStackElement
    extends BaseCallStackElement {
        private final long myFunctionId;
        private final String myFunctionName;

        /*
         * WARNING - void declaration
         */
        PperfCallStackElement(long functionId, @NotNull String string) {
            void functionName;
            if (string == null) {
                PperfCallStackElement.$$$reportNull$$$0(0);
            }
            this.myFunctionId = functionId;
            this.myFunctionName = functionName;
        }

        @NotNull
        public String fullName() {
            String string = this.myFunctionName;
            if (string == null) {
                PperfCallStackElement.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isNavigatable() {
            return true;
        }

        public NavigatablePsiElement @NotNull [] calcNavigatables(@NotNull Project project) {
            GoSymbol symbol;
            if (project == null) {
                PperfCallStackElement.$$$reportNull$$$0(2);
            }
            if ((symbol = PprofParserProvider.parseSymbol(this.myFunctionName)) == null) {
                if (NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY == null) {
                    PperfCallStackElement.$$$reportNull$$$0(3);
                }
                return NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY;
            }
            Collection<Module> modules = GoSdkUtil.getGoModules(project);
            if (modules.isEmpty()) {
                if (NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY == null) {
                    PperfCallStackElement.$$$reportNull$$$0(4);
                }
                return NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY;
            }
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
            Set vendoring = modules.stream().map(GoVendoringUtil::isVendoringEnabled).collect(Collectors.toSet());
            NavigatablePsiElement[] navigatablePsiElementArray = (NavigatablePsiElement[])ApplicationManager.getApplication().runReadAction(() -> {
                ArrayList<NavigatablePsiElement> result = new ArrayList<NavigatablePsiElement>();
                if (symbol.myReceiver == null) {
                    GoFunctionIndex.process(symbol.myFunctionName, project, scope, null, (Processor<? super GoFunctionDeclaration>)((Processor)function -> {
                        if (PperfCallStackElement.hasImportPath(function, symbol.myImportPath, vendoring)) {
                            GoPackage goPackage;
                            GoFile file = function.getContainingFile();
                            if (GoPsiUtil.isMainFunction(function) && ((goPackage = GoPackage.of(file)) == null || !ContainerUtil.exists(goPackage.getDirectories(), it -> ProjectFileIndex.getInstance((Project)project).isInContent(it)))) {
                                return true;
                            }
                            result.add((NavigatablePsiElement)function);
                        }
                        return true;
                    }));
                } else {
                    String typeName = StringUtil.trimEnd((String)StringUtil.trimStart((String)StringUtil.trimStart((String)symbol.myReceiver, (String)"("), (String)"*"), (String)")");
                    for (String packageName : PperfCallStackElement.getPackageNames(project, symbol.myImportPath)) {
                        Collection<GoMethodDeclaration> declarations = GoMethodIndex.find(packageName + "." + typeName, project, scope, null);
                        for (GoMethodDeclaration declaration : declarations) {
                            if (!symbol.myFunctionName.equals(declaration.getName()) || !PperfCallStackElement.hasImportPath(declaration, symbol.myImportPath, vendoring)) continue;
                            result.add((NavigatablePsiElement)declaration);
                        }
                    }
                }
                return result.toArray(NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY);
            });
            if (navigatablePsiElementArray == null) {
                PperfCallStackElement.$$$reportNull$$$0(5);
            }
            return navigatablePsiElementArray;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static boolean hasImportPath(@NotNull GoFunctionOrMethodDeclaration declaration, @NotNull String importPath, @NotNull Set<Boolean> withVendoring) {
            GoPackage declarationPackage;
            if (declaration == null) {
                PperfCallStackElement.$$$reportNull$$$0(6);
            }
            if (importPath == null) {
                PperfCallStackElement.$$$reportNull$$$0(7);
            }
            if (withVendoring == null) {
                PperfCallStackElement.$$$reportNull$$$0(8);
            }
            GoFile file = declaration.getContainingFile();
            String packageName = file.getPackageName();
            if ("main".equals(importPath) && "main".equals(packageName)) {
                return true;
            }
            Predicate<String> importPathMatcher = importPath::equals;
            if (importPath.endsWith("_test") && packageName != null && packageName.endsWith("_test")) {
                String targetImportPath = PperfCallStackElement.getTargetImportPath(importPath);
                importPathMatcher = targetImportPath::equals;
            }
            if ((declarationPackage = GoPackage.of(file)) == null) return false;
            if (!withVendoring.stream().map(declarationPackage::getImportPath).anyMatch(importPathMatcher)) return false;
            return true;
        }

        @NotNull
        private static Set<String> getPackageNames(@NotNull Project project, @NotNull String packageImportPath) {
            if (project == null) {
                PperfCallStackElement.$$$reportNull$$$0(9);
            }
            if (packageImportPath == null) {
                PperfCallStackElement.$$$reportNull$$$0(10);
            }
            if ("main".equals(packageImportPath)) {
                Set<String> set = Collections.singleton("main");
                if (set == null) {
                    PperfCallStackElement.$$$reportNull$$$0(11);
                }
                return set;
            }
            if (packageImportPath.endsWith("_test")) {
                String targetImportPath = PperfCallStackElement.getTargetImportPath(packageImportPath);
                Set<String> set = GoPackageUtil.findByImportPath(targetImportPath, project, null, ResolveState.initial()).stream().flatMap(it -> PperfCallStackElement.getTestPackageNames(it)).collect(Collectors.toSet());
                if (set == null) {
                    PperfCallStackElement.$$$reportNull$$$0(12);
                }
                return set;
            }
            Set<String> set = GoPackageUtil.findByImportPath(packageImportPath, project, null, ResolveState.initial()).stream().map(GoPackage::getName).collect(Collectors.toSet());
            if (set == null) {
                PperfCallStackElement.$$$reportNull$$$0(13);
            }
            return set;
        }

        @NotNull
        private static String getTargetImportPath(@NotNull String packageImportPath) {
            if (packageImportPath == null) {
                PperfCallStackElement.$$$reportNull$$$0(14);
            }
            String string = StringUtil.trimEnd((String)packageImportPath, (String)"_test");
            if (string == null) {
                PperfCallStackElement.$$$reportNull$$$0(15);
            }
            return string;
        }

        @NotNull
        private static Stream<String> getTestPackageNames(@NotNull GoPackage goPackage) {
            if (goPackage == null) {
                PperfCallStackElement.$$$reportNull$$$0(16);
            }
            StreamEx streamEx = goPackage.getPsiDirectories().flatMap(dir -> GoPackageUtil.getAllPackagesInDirectory(dir, null, false).stream().filter(packageName -> packageName.endsWith("_test")));
            if (streamEx == null) {
                PperfCallStackElement.$$$reportNull$$$0(17);
            }
            return streamEx;
        }

        public boolean equals(Object obj) {
            return obj instanceof PperfCallStackElement && this.myFunctionId == ((PperfCallStackElement)((Object)obj)).myFunctionId;
        }

        public int hashCode() {
            return Long.hashCode(this.myFunctionId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3, 4, 5, 11, 12, 13, 15, 17 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionName";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 11: 
                case 12: 
                case 13: 
                case 15: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/profiler/PprofParserProvider$PperfCallStackElement";
                    break;
                }
                case 2: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaration";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importPath";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "withVendoring";
                    break;
                }
                case 10: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageImportPath";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "goPackage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/profiler/PprofParserProvider$PperfCallStackElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fullName";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calcNavigatables";
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPackageNames";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetImportPath";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTestPackageNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 11: 
                case 12: 
                case 13: 
                case 15: 
                case 17: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "calcNavigatables";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "hasImportPath";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getPackageNames";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "getTargetImportPath";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "getTestPackageNames";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3, 4, 5, 11, 12, 13, 15, 17 -> new IllegalStateException(string);
            };
        }
    }

    private static final class PprofRenderer
    extends BaseCallStackElementRenderer {
        private PprofRenderer() {
        }
    }
}

