/*
 * Decompiled with CFR 0.152.
 */
package com.goide.project;

import com.goide.project.GoModuleSettings;
import com.goide.project.GoProjectLifecycle;
import com.goide.sdk.GoSdkService;
import com.goide.vgo.configuration.VgoProjectSettings;
import com.goide.wizard.GoNewProjectSettings;
import com.goide.wizard.GoProjectGeneratorPeer;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilderListener;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.WebModuleTypeBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import java.awt.Container;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoModuleBuilderBase<T extends GoNewProjectSettings>
extends ModuleBuilder
implements ModuleBuilderListener {
    @NotNull
    private final GoProjectGeneratorPeer<T> myPeer;
    private boolean myIsCreatingNewProject;

    protected GoModuleBuilderBase(@NotNull GoProjectGeneratorPeer<T> peer) {
        if (peer == null) {
            GoModuleBuilderBase.$$$reportNull$$$0(0);
        }
        this.myPeer = peer;
    }

    protected GoModuleBuilderBase(@NotNull GoProjectGeneratorPeer<T> peer, boolean isCreatingNewProject) {
        if (peer == null) {
            GoModuleBuilderBase.$$$reportNull$$$0(1);
        }
        this.myPeer = peer;
        this.myIsCreatingNewProject = isCreatingNewProject;
    }

    public void setupRootModel(@NotNull ModifiableRootModel modifiableRootModel) {
        if (modifiableRootModel == null) {
            GoModuleBuilderBase.$$$reportNull$$$0(2);
        }
        this.doAddContentEntry(modifiableRootModel);
        this.addListener(this);
    }

    public String getParentGroup() {
        return "Go";
    }

    @NotNull
    public ModuleType<?> getModuleType() {
        WebModuleTypeBase webModuleTypeBase = WebModuleTypeBase.getInstance();
        if (webModuleTypeBase == null) {
            GoModuleBuilderBase.$$$reportNull$$$0(3);
        }
        return webModuleTypeBase;
    }

    @Nullable
    public Project createProject(String name, String path) {
        Project project = super.createProject(name, path);
        if (project != null) {
            GoProjectLifecycle.fireProjectSetupStartEvent((UserDataHolder)project);
        }
        return project;
    }

    public void moduleCreated(@NotNull Module module) {
        if (module == null) {
            GoModuleBuilderBase.$$$reportNull$$$0(4);
        }
        this.removeListener(this);
        if (this.myIsCreatingNewProject) {
            VgoProjectSettings.getInstance(module.getProject()).setSettingsMigrated(true);
        }
        if (this.myIsCreatingNewProject || !GoSdkService.getInstance(module.getProject()).getSdk(null).isValid()) {
            GoSdkService.getInstance(module.getProject()).setSdk(((GoNewProjectSettings)this.getSettings()).sdk);
        }
        GoModuleSettings.getInstance(module).setGoSupportEnabled(true);
        this.moduleCreated(module, this.myIsCreatingNewProject);
        if (this.myIsCreatingNewProject) {
            GoProjectLifecycle.fireProjectSetupFinishEvent(module.getProject());
        }
    }

    protected abstract void moduleCreated(@NotNull Module var1, boolean var2);

    @NotNull
    protected T getSettings() {
        GoNewProjectSettings goNewProjectSettings = (GoNewProjectSettings)this.myPeer.getSettings();
        if (goNewProjectSettings == null) {
            GoModuleBuilderBase.$$$reportNull$$$0(5);
        }
        return (T)goNewProjectSettings;
    }

    public ModuleWizardStep modifyProjectTypeStep(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            GoModuleBuilderBase.$$$reportNull$$$0(6);
        }
        WizardContext context = settingsStep.getContext();
        this.myIsCreatingNewProject = context.isCreatingNewProject();
        JPanel panel = this.myPeer.createModuleSettingsPanel(context.getDisposable(), this.myIsCreatingNewProject ? null : context.getProject());
        settingsStep.addSettingsField("", (JComponent)panel);
        GoModuleBuilderBase.removeFirstLabel(panel);
        return super.modifyProjectTypeStep(settingsStep);
    }

    private static void removeFirstLabel(@NotNull JPanel panel) {
        Container parent;
        if (panel == null) {
            GoModuleBuilderBase.$$$reportNull$$$0(7);
        }
        if ((parent = panel.getParent()) != null && parent.getComponent(0) instanceof JBLabel) {
            parent.remove(0);
        }
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    public abstract String getDescription();

    @NotNull
    public static VirtualFile createFile(@NonNls @NotNull String name, @NonNls @NotNull String content2, @NotNull VirtualFile baseDir, @NotNull Object requestor) throws IOException {
        VirtualFile existingFile;
        if (name == null) {
            GoModuleBuilderBase.$$$reportNull$$$0(8);
        }
        if (content2 == null) {
            GoModuleBuilderBase.$$$reportNull$$$0(9);
        }
        if (baseDir == null) {
            GoModuleBuilderBase.$$$reportNull$$$0(10);
        }
        if (requestor == null) {
            GoModuleBuilderBase.$$$reportNull$$$0(11);
        }
        if ((existingFile = baseDir.findChild(name)) != null) {
            VirtualFile virtualFile = existingFile;
            if (virtualFile == null) {
                GoModuleBuilderBase.$$$reportNull$$$0(12);
            }
            return virtualFile;
        }
        VirtualFile file = baseDir.createChildData(requestor, name);
        VfsUtil.saveText((VirtualFile)file, (String)content2);
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            GoModuleBuilderBase.$$$reportNull$$$0(13);
        }
        return virtualFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "peer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableRootModel";
                break;
            }
            case 3: 
            case 5: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/project/GoModuleBuilderBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsStep";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/project/GoModuleBuilderBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setupRootModel";
                break;
            }
            case 3: 
            case 5: 
            case 12: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "moduleCreated";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "modifyProjectTypeStep";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeFirstLabel";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 12, 13 -> new IllegalStateException(string);
        };
    }
}

